/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class TreeReceiver
extends SequenceReceiver {
    private Receiver nextReceiver;
    private int level = 0;
    private boolean[] isDocumentLevel = new boolean[20];
    private boolean inStartTag = false;

    public TreeReceiver(Receiver nextInChain) {
        this.nextReceiver = nextInChain;
        this.previousAtomic = false;
        this.setPipelineConfiguration(nextInChain.getPipelineConfiguration());
    }

    @Override
    public void setSystemId(String systemId) {
        if (systemId != null && !systemId.equals(this.systemId)) {
            this.systemId = systemId;
            if (this.nextReceiver != null) {
                this.nextReceiver.setSystemId(systemId);
            }
        }
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        if (this.pipelineConfiguration != pipe) {
            this.pipelineConfiguration = pipe;
            if (this.nextReceiver != null) {
                this.nextReceiver.setPipelineConfiguration(pipe);
            }
        }
    }

    public Receiver getUnderlyingReceiver() {
        return this.nextReceiver;
    }

    @Override
    public void open() throws XPathException {
        if (this.nextReceiver == null) {
            throw new IllegalStateException("TreeReceiver.open(): no underlying receiver provided");
        }
        this.nextReceiver.open();
        this.previousAtomic = false;
    }

    @Override
    public void close() throws XPathException {
        if (this.nextReceiver != null) {
            this.nextReceiver.close();
        }
        this.previousAtomic = false;
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.level == 0) {
            this.nextReceiver.startDocument(properties);
        }
        if (this.isDocumentLevel.length - 1 < this.level) {
            boolean[] d2 = new boolean[this.level * 2];
            System.arraycopy(this.isDocumentLevel, 0, d2, 0, this.level);
            this.isDocumentLevel = d2;
        }
        this.isDocumentLevel[this.level++] = true;
    }

    @Override
    public void endDocument() throws XPathException {
        --this.level;
        if (this.level == 0) {
            this.nextReceiver.endDocument();
        }
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        this.inStartTag = true;
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        this.previousAtomic = false;
        if (this.isDocumentLevel.length - 1 < this.level) {
            boolean[] d2 = new boolean[this.level * 2];
            System.arraycopy(this.isDocumentLevel, 0, d2, 0, this.level);
            this.isDocumentLevel = d2;
        }
        this.isDocumentLevel[this.level++] = false;
    }

    @Override
    public void namespace(int namespaceCode, int properties) throws XPathException {
        boolean documentLevel;
        boolean bl = documentLevel = this.level == 0 || this.isDocumentLevel[this.level - 1];
        if (documentLevel || !this.inStartTag) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(13, this.getNamePool().getPrefixFromNamespaceCode(namespaceCode), this.getPipelineConfiguration().getHostLanguage(), documentLevel, this.getPipelineConfiguration().isSerializing());
        }
        this.nextReceiver.namespace(namespaceCode, properties);
        this.previousAtomic = false;
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        boolean documentLevel;
        boolean bl = documentLevel = this.level == 0 || this.isDocumentLevel[this.level - 1];
        if (documentLevel || !this.inStartTag) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(2, this.getNamePool().getDisplayName(nameCode), this.getPipelineConfiguration().getHostLanguage(), documentLevel, this.getPipelineConfiguration().isSerializing());
        }
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
        this.previousAtomic = false;
    }

    @Override
    public void startContent() throws XPathException {
        this.inStartTag = false;
        this.nextReceiver.startContent();
        this.previousAtomic = false;
    }

    @Override
    public void endElement() throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        this.nextReceiver.endElement();
        this.previousAtomic = false;
        --this.level;
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (chars.length() > 0) {
            if (this.inStartTag) {
                this.startContent();
            }
            this.nextReceiver.characters(chars, locationId, properties);
        }
        this.previousAtomic = false;
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
        this.previousAtomic = false;
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        this.nextReceiver.comment(chars, locationId, properties);
        this.previousAtomic = false;
    }

    @Override
    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
        this.nextReceiver.setUnparsedEntity(name, uri, publicId);
    }

    @Override
    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        if (item != null) {
            if (item instanceof AtomicValue) {
                if (this.previousAtomic) {
                    this.characters(" ", locationId, 0);
                }
                this.characters(item.getStringValueCS(), locationId, 0);
                this.previousAtomic = true;
            } else {
                if (item instanceof FunctionItem) {
                    throw new XPathException("Cannot add a function item to a tree");
                }
                if (((NodeInfo)item).getNodeKind() == 9) {
                    Item it;
                    this.startDocument(0);
                    AxisIterator iter = ((NodeInfo)item).iterateAxis((byte)3);
                    while ((it = iter.next()) != null) {
                        this.append(it, locationId, copyNamespaces);
                    }
                    this.previousAtomic = false;
                    this.endDocument();
                } else {
                    ((NodeInfo)item).copy(this, copyNamespaces, true, locationId);
                    this.previousAtomic = false;
                }
            }
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return this.nextReceiver.usesTypeAnnotations();
    }
}

