package org.jboss.threads;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.threads.ExecutionTimedOutException;
import java.lang.RuntimeException;
import org.jboss.threads.InterruptHandler;
import org.jboss.logging.BasicLogger;
import java.util.concurrent.ExecutionException;
import java.lang.IllegalArgumentException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Generated;
import org.jboss.threads.ExecutionInterruptedException;
import java.lang.SecurityException;
import org.jboss.threads.StoppedExecutorException;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.threads.ThreadCreationException;
import java.util.concurrent.CancellationException;
import java.lang.Runnable;
import java.lang.Throwable;
import java.util.Arrays;
import java.util.NoSuchElementException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-06-17T09:02:01-0500")
public class Messages_$logger extends DelegatingBasicLogger implements Messages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    public Messages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void version(final String version) {
        super.log.logf(FQCN, INFO, null, version$str(), version);
    }
    private static final String version = "JBoss Threads version %s";
    protected String version$str() {
        return version;
    }
    private static final String noThreadCreated = "JBTHR00001: Thread factory did not produce a thread";
    protected String noThreadCreated$str() {
        return noThreadCreated;
    }
    @Override
    public final org.jboss.threads.ThreadCreationException noThreadCreated() {
        final org.jboss.threads.ThreadCreationException result = new org.jboss.threads.ThreadCreationException(String.format(getLoggingLocale(), noThreadCreated$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String taskLimitReached = "JBTHR00002: Task limit reached";
    protected String taskLimitReached$str() {
        return taskLimitReached;
    }
    @Override
    public final RejectedExecutionException taskLimitReached() {
        final RejectedExecutionException result = new RejectedExecutionException(String.format(getLoggingLocale(), taskLimitReached$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationTimedOut = "JBTHR00003: Operation timed out";
    protected String operationTimedOut$str() {
        return operationTimedOut;
    }
    @Override
    public final TimeoutException operationTimedOut() {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), operationTimedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationCancelled = "JBTHR00004: Operation was cancelled";
    protected String operationCancelled$str() {
        return operationCancelled;
    }
    @Override
    public final CancellationException operationCancelled() {
        final CancellationException result = new CancellationException(String.format(getLoggingLocale(), operationCancelled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationFailed = "JBTHR00005: Operation failed";
    protected String operationFailed$str() {
        return operationFailed;
    }
    @Override
    public final ExecutionException operationFailed(final Throwable cause) {
        final ExecutionException result = new ExecutionException(String.format(getLoggingLocale(), operationFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddThread = "JBTHR00006: Unable to add new thread to the running set";
    protected String cannotAddThread$str() {
        return cannotAddThread;
    }
    @Override
    public final org.jboss.threads.ThreadCreationException cannotAddThread() {
        final org.jboss.threads.ThreadCreationException result = new org.jboss.threads.ThreadCreationException(String.format(getLoggingLocale(), cannotAddThread$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String executionInterrupted = "JBTHR00007: Task execution interrupted";
    protected String executionInterrupted$str() {
        return executionInterrupted;
    }
    @Override
    public final org.jboss.threads.ExecutionInterruptedException executionInterrupted() {
        final org.jboss.threads.ExecutionInterruptedException result = new org.jboss.threads.ExecutionInterruptedException(String.format(getLoggingLocale(), executionInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String executionRejected = "JBTHR00008: Task rejected";
    protected String executionRejected$str() {
        return executionRejected;
    }
    @Override
    public final RejectedExecutionException executionRejected() {
        final RejectedExecutionException result = new RejectedExecutionException(String.format(getLoggingLocale(), executionRejected$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String shutDownInitiated = "JBTHR00009: Executor has been shut down";
    protected String shutDownInitiated$str() {
        return shutDownInitiated;
    }
    @Override
    public final org.jboss.threads.StoppedExecutorException shutDownInitiated() {
        final org.jboss.threads.StoppedExecutorException result = new org.jboss.threads.StoppedExecutorException(String.format(getLoggingLocale(), shutDownInitiated$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String executionTimedOut = "JBTHR00010: Task execution timed out";
    protected String executionTimedOut$str() {
        return executionTimedOut;
    }
    @Override
    public final org.jboss.threads.ExecutionTimedOutException executionTimedOut() {
        final org.jboss.threads.ExecutionTimedOutException result = new org.jboss.threads.ExecutionTimedOutException(String.format(getLoggingLocale(), executionTimedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void executionFailed(final Throwable cause, final Runnable task) {
        super.log.logf(FQCN, ERROR, cause, executionFailed$str(), task);
    }
    private static final String executionFailed = "JBTHR00011: Task execution failed for task %s";
    protected String executionFailed$str() {
        return executionFailed;
    }
    private static final String cannotAwaitWithin = "JBTHR00012: Cannot await termination of a thread pool from one of its own threads";
    protected String cannotAwaitWithin$str() {
        return cannotAwaitWithin;
    }
    @Override
    public final IllegalStateException cannotAwaitWithin() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAwaitWithin$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noExecutorsAvailable = "JBTHR00013: No executors available to run task";
    protected String noExecutorsAvailable$str() {
        return noExecutorsAvailable;
    }
    @Override
    public final RejectedExecutionException noExecutorsAvailable() {
        final RejectedExecutionException result = new RejectedExecutionException(String.format(getLoggingLocale(), noExecutorsAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void taskSubmitFailed(final RejectedExecutionException e, final Runnable task) {
        super.log.logf(FQCN, ERROR, e, taskSubmitFailed$str(), task);
    }
    private static final String taskSubmitFailed = "JBTHR00014: Error submitting task %s to executor";
    protected String taskSubmitFailed$str() {
        return taskSubmitFailed;
    }
    private static final String keepAliveNotZero = "JBTHR00100: Keep-alive may only be set to 0 for this executor type";
    protected String keepAliveNotZero$str() {
        return keepAliveNotZero;
    }
    @Override
    public final IllegalArgumentException keepAliveNotZero() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), keepAliveNotZero$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotReduceMaxBelowCurrent = "JBTHR00101: Cannot reduce maximum threads below current thread number of running threads";
    protected String cannotReduceMaxBelowCurrent$str() {
        return cannotReduceMaxBelowCurrent;
    }
    @Override
    public final IllegalArgumentException cannotReduceMaxBelowCurrent() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotReduceMaxBelowCurrent$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String arrayNotEmpty = "JBTHR00102: Empty array parameter is not empty";
    protected String arrayNotEmpty$str() {
        return arrayNotEmpty;
    }
    @Override
    public final IllegalArgumentException arrayNotEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), arrayNotEmpty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noInterruptHandlers = "JBTHR00103: The current thread does not support interrupt handlers";
    protected String noInterruptHandlers$str() {
        return noInterruptHandlers;
    }
    @Override
    public final IllegalStateException noInterruptHandlers() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noInterruptHandlers$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notShutDown = "JBTHR00104: Executor is not shut down";
    protected String notShutDown$str() {
        return notShutDown;
    }
    @Override
    public final IllegalStateException notShutDown() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notShutDown$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String concurrentModification = "JBTHR00105: Concurrent modification of collection detected";
    protected String concurrentModification$str() {
        return concurrentModification;
    }
    @Override
    public final ConcurrentModificationException concurrentModification() {
        final ConcurrentModificationException result = new ConcurrentModificationException(String.format(getLoggingLocale(), concurrentModification$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchElement = "JBTHR00106: No such element (iteration past end)";
    protected String noSuchElement$str() {
        return noSuchElement;
    }
    @Override
    public final NoSuchElementException noSuchElement() {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), noSuchElement$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownThrowable = "JBTHR00107: Unknown throwable received";
    protected String unknownThrowable$str() {
        return unknownThrowable;
    }
    @Override
    public final RuntimeException unknownThrowable(final Throwable t) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unknownThrowable$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void interruptHandlerThrew(final Throwable cause, final org.jboss.threads.InterruptHandler interruptHandler) {
        super.log.logf(FQCN, ERROR, cause, interruptHandlerThrew$str(), interruptHandler);
    }
    private static final String interruptHandlerThrew = "JBTHR00108: Interrupt handler %s threw an exception";
    protected String interruptHandlerThrew$str() {
        return interruptHandlerThrew;
    }
    private static final String notAllowedContainerManaged = "JBTHR00200: %s() not allowed on container-managed executor";
    protected String notAllowedContainerManaged$str() {
        return notAllowedContainerManaged;
    }
    @Override
    public final SecurityException notAllowedContainerManaged(final String methodName) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), notAllowedContainerManaged$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
