/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.DirectExecutor;
import org.jboss.threads.ExecutionInterruptedException;

class DelegatingDirectBlockingExecutor
implements BlockingExecutor,
DirectExecutor {
    private final DirectExecutor delegate;

    DelegatingDirectBlockingExecutor(DirectExecutor delegate) {
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable task) {
        this.delegate.execute(task);
    }

    @Override
    public void executeNonBlocking(Runnable task) throws RejectedExecutionException {
        this.delegate.execute(task);
    }

    @Override
    public long getNumberOfFreeThreads() {
        return 0L;
    }

    @Override
    public void executeBlocking(Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        try {
            this.delegate.execute(task);
        }
        catch (ExecutionInterruptedException e) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            throw e;
        }
    }

    @Override
    public void executeBlocking(Runnable task) throws RejectedExecutionException, InterruptedException {
        try {
            this.delegate.execute(task);
        }
        catch (ExecutionInterruptedException e) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            throw e;
        }
    }
}

