/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jboss.threads.BlockingExecutor;

class DelegatingBlockingExecutor
implements BlockingExecutor {
    private final BlockingExecutor delegate;

    DelegatingBlockingExecutor(BlockingExecutor delegate) {
        this.delegate = delegate;
    }

    protected BlockingExecutor getDelegate() {
        return this.delegate;
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }

    @Override
    public void executeBlocking(Runnable task) throws RejectedExecutionException, InterruptedException {
        this.delegate.executeBlocking(task);
    }

    @Override
    public void executeBlocking(Runnable task, long timeout, TimeUnit unit) throws RejectedExecutionException, InterruptedException {
        this.delegate.executeBlocking(task, timeout, unit);
    }

    @Override
    public void executeNonBlocking(Runnable task) throws RejectedExecutionException {
        this.delegate.executeNonBlocking(task);
    }

    @Override
    public long getNumberOfFreeThreads() {
        return this.delegate.getNumberOfFreeThreads();
    }

    public String toString() {
        return String.format("%s -> %s", super.toString(), this.delegate);
    }
}

