/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.threads.ArrayQueue;
import org.jboss.threads.ExecutionInterruptedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderedExecutor
implements Executor {
    private final Executor parent;
    private final Runnable runner = new Runner();
    private final Lock lock = new ReentrantLock();
    private final Condition removeCondition = this.lock.newCondition();
    private final Queue<Runnable> queue;
    private boolean running;
    private boolean blocking;
    private Executor handoffExecutor;

    public OrderedExecutor(Executor parent) {
        this(parent, new ArrayDeque<Runnable>());
    }

    public OrderedExecutor(Executor parent, Queue<Runnable> queue) {
        this(parent, queue, true, null);
    }

    public OrderedExecutor(Executor parent, int queueLength) {
        this(parent, new ArrayQueue<Runnable>(queueLength), true, null);
    }

    public OrderedExecutor(Executor parent, int queueLength, Executor handoffExecutor) {
        this(parent, new ArrayQueue<Runnable>(queueLength), false, handoffExecutor);
    }

    public OrderedExecutor(Executor parent, Queue<Runnable> queue, boolean blocking, Executor handoffExecutor) {
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        if (queue == null) {
            throw new NullPointerException("queue is null");
        }
        this.queue = queue;
        this.parent = parent;
        this.blocking = blocking;
        this.handoffExecutor = handoffExecutor;
    }

    public OrderedExecutor(Executor parent, int queueLength, boolean blocking, Executor handoffExecutor) {
        this(parent, new ArrayQueue<Runnable>(queueLength), blocking, handoffExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        Executor executor;
        block11: {
            block12: {
                this.lock.lock();
                try {
                    while (!this.queue.offer(command)) {
                        if (this.blocking) {
                            try {
                                this.removeCondition.await();
                                continue;
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new ExecutionInterruptedException();
                            }
                        }
                        executor = this.handoffExecutor;
                        Object var7_5 = null;
                        this.lock.unlock();
                        break block11;
                    }
                    if (this.running) break block12;
                    this.running = true;
                    boolean ok = false;
                    try {
                        this.parent.execute(this.runner);
                        ok = true;
                        Object var5_8 = null;
                        if (!ok) {
                            this.running = false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        if (!ok) {
                            this.running = false;
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
            Object var7_6 = null;
            this.lock.unlock();
            return;
        }
        if (executor != null) {
            executor.execute(command);
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object var3_4;
                Runnable task;
                OrderedExecutor.this.lock.lock();
                try {
                    task = (Runnable)OrderedExecutor.this.queue.poll();
                    OrderedExecutor.this.removeCondition.signal();
                    if (task == null) {
                        OrderedExecutor.this.running = false;
                        var3_4 = null;
                        OrderedExecutor.this.lock.unlock();
                        return;
                    }
                    var3_4 = null;
                    OrderedExecutor.this.lock.unlock();
                }
                catch (Throwable throwable) {
                    var3_4 = null;
                    OrderedExecutor.this.lock.unlock();
                    throw throwable;
                }
                try {
                    task.run();
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

