/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import org.jboss.logging.Logger;
import org.jboss.threads.InterruptHandler;
import org.jboss.threads.ThreadNameInfo;

public final class JBossThread
extends Thread {
    private static final Logger log = Logger.getLogger((String)"org.jboss.threads");
    private static final Logger ihlog = Logger.getLogger((String)"org.jboss.threads.interrupt-handler");
    private volatile InterruptHandler interruptHandler;
    private ThreadNameInfo threadNameInfo;

    public JBossThread(Runnable target) {
        super(target);
    }

    public JBossThread(Runnable target, String name) {
        super(target, name);
    }

    public JBossThread(ThreadGroup group, Runnable target) throws SecurityException {
        super(group, target);
    }

    public JBossThread(ThreadGroup group, Runnable target, String name) throws SecurityException {
        super(group, target, name);
    }

    public JBossThread(ThreadGroup group, Runnable target, String name, long stackSize) throws SecurityException {
        super(group, target, name, stackSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void interrupt() {
        InterruptHandler interruptHandler2;
        ihlog.tracef("Interrupting thread \"%s\"", new Object[]{this});
        try {
            super.interrupt();
            Object var2_1 = null;
            interruptHandler2 = this.interruptHandler;
            if (interruptHandler2 == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            InterruptHandler interruptHandler2 = this.interruptHandler;
            if (interruptHandler2 == null) throw throwable;
            try {
                interruptHandler2.handleInterrupt(this);
                throw throwable;
            }
            catch (Throwable t) {
                ihlog.errorf(t, "Interrupt handler %s threw an exception", new Object[]{interruptHandler2});
            }
            throw throwable;
        }
        try {
            interruptHandler2.handleInterrupt(this);
            return;
        }
        catch (Throwable t) {
            ihlog.errorf(t, "Interrupt handler %s threw an exception", new Object[]{interruptHandler2});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.tracef("Thread \"%s\" starting execution", new Object[]{this});
        try {
            super.run();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            log.tracef("Thread \"%s\" exiting", new Object[]{this});
            throw throwable;
        }
        log.tracef("Thread \"%s\" exiting", new Object[]{this});
    }

    public static JBossThread currentThread() {
        Thread thread = Thread.currentThread();
        return thread instanceof JBossThread ? (JBossThread)thread : null;
    }

    public void start() {
        super.start();
        log.tracef("Started thread \"%s\"", new Object[]{this});
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
        super.setUncaughtExceptionHandler(eh);
        log.tracef("Changed uncaught exception handler for \"%s\" to %s", new Object[]{this, eh});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InterruptHandler getAndSetInterruptHandler(InterruptHandler newInterruptHandler) {
        JBossThread thread = JBossThread.currentThread();
        if (thread == null) {
            throw new IllegalStateException("The current thread does not support interrupt handlers");
        }
        try {
            InterruptHandler interruptHandler = thread.interruptHandler;
            Object var4_3 = null;
            thread.interruptHandler = newInterruptHandler;
            return interruptHandler;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            thread.interruptHandler = newInterruptHandler;
            throw throwable;
        }
    }

    public ThreadNameInfo getThreadNameInfo() {
        return this.threadNameInfo;
    }

    public void setThreadNameInfo(ThreadNameInfo threadNameInfo) throws SecurityException {
        this.checkAccess();
        this.threadNameInfo = threadNameInfo;
    }
}

