/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.threads.metadata;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "thread-group", propOrder = {})
public final class ThreadGroupMetaData {
    private String name;
    private String groupName;
    private RefMetaData parentThreadGroup;
    private Boolean daemon;
    private Integer maxPriority;

    public String getName() {
        return name;
    }

    @XmlAttribute(required = true)
    public void setName(final String name) {
        this.name = name;
    }

    public String getGroupName() {
        return groupName;
    }

    @XmlAttribute(name = "group-name")
    public void setGroupName(final String groupName) {
        this.groupName = groupName;
    }

    public RefMetaData getParentThreadGroup() {
        return parentThreadGroup;
    }

    @XmlElement(name = "parent-thread-group")
    public void setParentThreadGroup(final RefMetaData parentThreadGroup) {
        this.parentThreadGroup = parentThreadGroup;
    }

    public Boolean isDaemon() {
        return daemon;
    }

    @XmlAttribute
    public void setDaemon(final Boolean daemon) {
        this.daemon = daemon;
    }

    public Integer getMaxPriority() {
        return maxPriority;
    }

    @XmlAttribute(name = "max-priority")
    public void setMaxPriority(final Integer maxPriority) {
        this.maxPriority = maxPriority;
    }
}
