/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.threads.metadata;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 *
 */
@XmlType(name = "thread-factory", propOrder = {})
public final class ThreadFactoryMetaData {
    private String name;
    private Boolean daemon;
    private String threadNamePattern = "pool-%f-thread-%t";
    private Integer priority;

    private RefMetaData threadGroup;
    private RefMetaData exceptionHandler;
    private TaskFilterMetaData taskFilter;

    public String getName() {
        return name;
    }

    @XmlAttribute(required = true)
    public void setName(final String name) {
        this.name = name;
    }

    public Boolean getDaemon() {
        return daemon;
    }

    @XmlAttribute
    public void setDaemon(final Boolean daemon) {
        this.daemon = daemon;
    }

    public String getThreadNamePattern() {
        return threadNamePattern;
    }

    @XmlAttribute(name = "thread-name-pattern")
    public void setThreadNamePattern(final String threadNamePattern) {
        this.threadNamePattern = threadNamePattern;
    }

    public Integer getPriority() {
        return priority;
    }

    @XmlAttribute
    public void setPriority(final Integer priority) {
        this.priority = priority;
    }

    public RefMetaData getThreadGroup() {
        return threadGroup;
    }

    @XmlElement(name = "thread-group")
    public void setThreadGroup(final RefMetaData threadGroup) {
        this.threadGroup = threadGroup;
    }

    public RefMetaData getExceptionHandler() {
        return exceptionHandler;
    }

    @XmlElement(name = "exception-handler")
    public void setExceptionHandler(final RefMetaData exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public TaskFilterMetaData getTaskFilter() {
        return taskFilter;
    }

    @XmlElement(name = "task-filter")
    public void setTaskFilter(final TaskFilterMetaData taskFilter) {
        this.taskFilter = taskFilter;
    }
}
