/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.threads.metadata;

import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "task-filter")
public final class TaskFilterMetaData {
    private List<AbstractTaskFilter> taskFilters;
    private String directExecutorName;

    public List<AbstractTaskFilter> getTaskFilters() {
        return taskFilters;
    }

    @XmlElements({
        @XmlElement(name = "thread-name", type = ThreadNameFilter.class),
        @XmlElement(name = "thread-name-notation", type = ThreadNameNotationFilter.class),
        @XmlElement(name = "log-exceptions", type = LogExceptionsFilter.class),
        @XmlElement(name = "clear-tls", type = ClearTLSFilter.class),
        @XmlElement(name = "clear-context-classloader", type = ClearContextClassLoaderFilter.class),
        @XmlElement(name = "initializer", type = InitializerFilter.class),
        @XmlElement(name = "cleaner", type = CleanerFilter.class)
    })
    public void setTaskFilters(final List<AbstractTaskFilter> taskFilters) {
        this.taskFilters = taskFilters;
    }

    public String getDirectExecutorName() {
        return directExecutorName;
    }

    @XmlAttribute(name = "direct-executor-name")
    public void setDirectExecutorName(final String directExecutorName) {
        this.directExecutorName = directExecutorName;
    }
}
