/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mockgenerator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSource {
    protected final File directory;
    protected final String mockPackage;
    protected String mockClass;
    protected final StringWriter output;

    public JavaSource(File directory, String mockClassName) {
        this.directory = directory;
        int indexOfDot = mockClassName.lastIndexOf(46);
        if (indexOfDot >= 0) {
            this.mockClass = mockClassName.substring(indexOfDot + 1);
            this.mockPackage = mockClassName.substring(0, indexOfDot);
        } else {
            this.mockClass = mockClassName;
            this.mockPackage = "";
        }
        this.output = new StringWriter(2048);
    }

    public void writeClassFile() throws IOException {
        File packageDirectory = new File(this.directory, this.mockPackage.replace('.', File.separatorChar));
        packageDirectory.mkdirs();
        File sourceFile = new File(packageDirectory, this.mockClass + ".java");
        if (sourceFile.exists()) {
            sourceFile.delete();
        }
        sourceFile.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(sourceFile));
        writer.write(this.output.toString());
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    static String classToString(Class<?> returnType) {
        return JavaSource.classToString(returnType, false);
    }

    static String classToString(Class<?> returnType, boolean varargs) {
        if (returnType.isArray()) {
            return JavaSource.classToString(returnType.getComponentType()) + (varargs ? "..." : "[]");
        }
        return returnType.getName().replace('$', '.');
    }

    static String boxingClassName(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (Boolean.TYPE.equals(clazz)) {
                return Boolean.class.getSimpleName();
            }
            if (Integer.TYPE.equals(clazz)) {
                return Integer.class.getSimpleName();
            }
            if (Character.TYPE.equals(clazz)) {
                return Character.class.getSimpleName();
            }
            if (Short.TYPE.equals(clazz)) {
                return Short.class.getSimpleName();
            }
            if (Byte.TYPE.equals(clazz)) {
                return Byte.class.getSimpleName();
            }
            if (Long.TYPE.equals(clazz)) {
                return Long.class.getSimpleName();
            }
            if (Float.TYPE.equals(clazz)) {
                return Float.class.getSimpleName();
            }
            if (Double.TYPE.equals(clazz)) {
                return Double.class.getSimpleName();
            }
        }
        return JavaSource.classToString(clazz);
    }

    static Class<?>[] getMethodParemeters(Method method) {
        Type[] parameterTypes = method.getGenericParameterTypes();
        Class[] parameters = new Class[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type type = parameterTypes[i];
        }
        return parameters;
    }

    public void sprintf(String format, Object ... args) {
        Formatter formatter = new Formatter(this.output);
        formatter.format(format, args);
        formatter.flush();
    }

    public void write(String str) {
        this.output.write(str);
    }

    public String toString() {
        return this.output.toString();
    }
}

