/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.runner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.testharness.impl.runner.BufferedListener;
import org.jboss.testharness.impl.testng.RemoveExpectedExceptionsAnnotationTransformer;
import org.jboss.testharness.properties.PropertiesManager;
import org.testng.IAnnotationTransformer;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunner {
    private Set<String> classNames;
    private List<String> methodNames = new ArrayList<String>();
    private ITestContext context;
    private List<ITestResult> testResults;
    private List<ITestResult> configurationResults;

    public TestRunner() {
        this.classNames = new HashSet<String>();
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    public List<String> getMethodNames() {
        return this.methodNames;
    }

    public void run(boolean ignoreExpectedExceptions) {
        if (this.classNames.size() == 0) {
            PropertiesManager propertiesManager = new PropertiesManager();
            this.classNames = propertiesManager.getPropertyValues("className");
        }
        TestNG testNG = new TestNG(false);
        testNG.setVerbose(0);
        BufferedListener listener = new BufferedListener();
        testNG.addListener((ITestListener)listener);
        ArrayList<XmlSuite> xmlSuites = new ArrayList<XmlSuite>();
        testNG.setXmlSuites(xmlSuites);
        xmlSuites.add(this.createSuite());
        if (ignoreExpectedExceptions) {
            testNG.setAnnotationTransformer((IAnnotationTransformer)new RemoveExpectedExceptionsAnnotationTransformer());
        }
        testNG.run();
        this.context = listener.getContext();
        if (this.context == null) {
            throw new IllegalStateException("No Tests run!");
        }
        this.testResults = listener.getTestResults();
        this.configurationResults = listener.getConfigurationResults();
    }

    private XmlSuite createSuite() {
        XmlSuite suite = new XmlSuite();
        suite.setName("JSR-299 TCK");
        suite.setAnnotations(XmlSuite.JDK5_ANNOTATION_TYPE);
        for (String className : this.classNames) {
            XmlTest test = new XmlTest(suite);
            test.setName("JSR-299 TCK" + className);
            ArrayList<XmlClass> testClasses = new ArrayList<XmlClass>();
            XmlClass testClass = new XmlClass(className);
            for (String methodName : this.getMethodNames()) {
                testClass.getIncludedMethods().add(methodName);
            }
            testClasses.add(testClass);
            test.setXmlClasses(testClasses);
        }
        return suite;
    }

    public ITestContext getContext() {
        return this.context;
    }

    public List<ITestResult> getTestResults() {
        return this.testResults;
    }

    public List<ITestResult> getConfigurationResults() {
        return this.configurationResults;
    }
}

