/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.packaging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Level;
import org.jboss.testharness.impl.ConfigurationFactory;
import org.jboss.testharness.impl.packaging.ArtifactDescriptor;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.TCKArtifact;
import org.jboss.testharness.impl.util.LogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCKArtifactDescriptor
extends ArtifactDescriptor
implements TCKArtifact {
    private boolean unit;
    private boolean runLocally;
    private Class<? extends Throwable> expectedDeploymentException;
    private boolean includeDeploymentProperties = true;

    public TCKArtifactDescriptor(Class<?> declaringClass) {
        super(declaringClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCKArtifactDescriptor initialize() {
        super.initialize();
        if (this.isLibrariesSupported()) {
            this.getLibraries().add(new ResourceDescriptorImpl("testng.jar", "/lib/testng-jdk15.jar"));
            this.getLibraries().add(new ResourceDescriptorImpl("jboss-test-harness-api.jar", "/lib/jboss-test-harness-api.jar"));
            this.getLibraries().add(new ResourceDescriptorImpl("jboss-test-harness.jar", "/lib/jboss-test-harness.jar"));
        }
        if (this.isIncludeDeploymentProperties()) {
            InputStream deploymentProperties = null;
            try {
                deploymentProperties = TCKArtifactDescriptor.getDeploymentProperties(this.getDeclaringClass());
                this.getResources().add(new ResourceDescriptorImpl(this.getClassesRoot() + "META-INF/jboss-test-harness.properties", deploymentProperties));
            }
            catch (IOException e) {
                LogUtil.logger().log(Level.WARNING, "Error generating deployment properties", e);
            }
            finally {
                if (deploymentProperties != null) {
                    try {
                        deploymentProperties.close();
                    }
                    catch (IOException e) {
                        LogUtil.logger().log(Level.WARNING, "Error generating deployment properties", e);
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getDeploymentProperties(Class<?> declaringClass) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            PrintWriter writer = new PrintWriter(os);
            ((Writer)writer).write("className=" + declaringClass.getName() + "\n");
            ((Writer)writer).write("org.jboss.testharness.standalone=false\n");
            for (String line : ConfigurationFactory.get().getExtraDeploymentProperties()) {
                ((Writer)writer).write(line + "\n");
            }
            ((Writer)writer).flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            os.close();
        }
    }

    @Override
    public boolean isUnit() {
        return this.unit;
    }

    @Override
    public void setUnit(boolean unit) {
        this.unit = unit;
    }

    @Override
    public Class<? extends Throwable> getExpectedDeploymentException() {
        return this.expectedDeploymentException;
    }

    @Override
    public void setExpectedDeploymentException(Class<? extends Throwable> expectedDeploymentException) {
        this.expectedDeploymentException = expectedDeploymentException;
    }

    @Override
    public boolean isRunLocally() {
        return this.runLocally;
    }

    @Override
    public void setRunLocally(boolean runLocally) {
        this.runLocally = runLocally;
    }

    @Override
    public boolean isIncludeDeploymentProperties() {
        return this.includeDeploymentProperties;
    }

    @Override
    public void setIncludeDeploymentProperties(boolean include) {
        this.includeDeploymentProperties = include;
    }
}

