/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.api.TestLauncher;
import org.jboss.testharness.spi.Containers;
import org.jboss.testharness.spi.StandaloneContainers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationImpl
implements Configuration {
    private String outputDirectory;
    private boolean standalone;
    private boolean runIntegrationTests;
    private int connectTimeout;
    private String libraryDirectory;
    private TestLauncher testLauncher;
    private Containers containers;
    private StandaloneContainers standaloneContainers;
    private String host;
    private List<String> extraPackages;
    private List<ResourceDescriptor> extraResources;
    private List<String> extraDeploymentProperties;
    private String testPackage;

    protected ConfigurationImpl() {
        this.extraPackages = new ArrayList<String>();
        this.extraResources = new ArrayList<ResourceDescriptor>();
        this.extraDeploymentProperties = new ArrayList<String>();
    }

    public ConfigurationImpl(Configuration configuration) {
        this.outputDirectory = configuration.getOutputDirectory();
        this.standalone = configuration.isStandalone();
        this.runIntegrationTests = configuration.isRunIntegrationTests();
        this.connectTimeout = configuration.getConnectTimeout();
        this.libraryDirectory = configuration.getLibraryDirectory();
        this.testLauncher = configuration.getInContainerTestLauncher();
        this.containers = configuration.getContainers();
        this.standaloneContainers = configuration.getStandaloneContainers();
        this.host = configuration.getHost();
        this.extraPackages = configuration.getExtraPackages();
        this.extraResources = configuration.getExtraResources();
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int deploymentDelay) {
        this.connectTimeout = deploymentDelay;
    }

    public String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    public void setLibraryDirectory(String libraryDir) {
        this.libraryDirectory = libraryDir;
    }

    public TestLauncher getInContainerTestLauncher() {
        return this.testLauncher;
    }

    public void setInContainerTestLauncher(TestLauncher testLauncher) {
        this.testLauncher = testLauncher;
    }

    public Containers getContainers() {
        return this.containers;
    }

    public void setContainers(Containers containers) {
        this.containers = containers;
    }

    public boolean isRunIntegrationTests() {
        return this.runIntegrationTests;
    }

    public void setRunIntegrationTests(boolean runIntegrationTests) {
        this.runIntegrationTests = runIntegrationTests;
    }

    public StandaloneContainers getStandaloneContainers() {
        return this.standaloneContainers;
    }

    public void setStandaloneContainers(StandaloneContainers standaloneContainers) {
        this.standaloneContainers = standaloneContainers;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public TestLauncher getTestLauncher() {
        return this.testLauncher;
    }

    public void setTestLauncher(TestLauncher testLauncher) {
        this.testLauncher = testLauncher;
    }

    public List<String> getExtraPackages() {
        return this.extraPackages;
    }

    public List<ResourceDescriptor> getExtraResources() {
        return this.extraResources;
    }

    public List<String> getExtraDeploymentProperties() {
        return this.extraDeploymentProperties;
    }

    public String getTestPackage() {
        return this.testPackage;
    }

    public void setTestPackage(String testPackage) {
        this.testPackage = testPackage;
    }

    public String toString() {
        StringBuilder configuration = new StringBuilder();
        configuration.append("Test harness configuration\n");
        configuration.append("-----------------\n");
        configuration.append("\tContainers: ").append(this.getContainers()).append("\n");
        configuration.append("\tConnect Timeout: ").append(this.getConnectTimeout()).append("\n");
        configuration.append("\tHost: ").append(this.getHost()).append("\n");
        configuration.append("\tLibrary Directory: ").append(this.getLibraryDirectory()).append("\n");
        configuration.append("\tOutput Directory: ").append(this.getOutputDirectory()).append("\n");
        configuration.append("\tRun Integration Tests: ").append(this.isRunIntegrationTests()).append("\n");
        configuration.append("\tStandalone: ").append(this.isStandalone()).append("\n");
        configuration.append("\tTest Launcher: ").append(this.getTestLauncher()).append("\n");
        return configuration.toString();
    }
}

