package org.jboss.testharness.integration.jbossas;


import java.io.File;
import java.io.IOException;

import org.jboss.testharness.spi.Containers;
import org.jboss.testharness.spi.helpers.AbstractContainerConnector;

/**
 *
 * @author jeffgenender
 * @author Pete Muir
 *
 */
public abstract class JBossASConnector extends AbstractContainerConnector implements Containers
{
   
   private static final String SERVER_HOME_PROPERTY_NAME = "jboss.home";
   
   private String jbossBinDirectory; 

   public JBossASConnector() throws IOException
   {
     
   }

   @Override
   protected String getServerHomePropertyName()
   {
      return SERVER_HOME_PROPERTY_NAME;
   }
   
   protected void shutdownServer() throws IOException
   {
      launch(getJBossBinDirectory(), "shutdown", "-S");
   }
   
   @Override
   protected void startServer() throws IOException
   {
      launch(getJBossBinDirectory(), "run", "--host=" + getHost());
   }
   
   protected String getJBossBinDirectory()
   {
      if (jbossBinDirectory == null)
      {
         jbossBinDirectory = new File(getServerDirectory() + "/bin").getPath();
      }
      return jbossBinDirectory;
   }
   
   @Override
   protected String getLogName()
   {
      return "jboss.log";
   }

}