package org.jboss.testharness.api;



/**
 * Programmatic TCK control
 * 
 * @author Pete Muir
 *
 */
public abstract class TCK
{
   
   public static final String DUMP_ARTIFACTS_PROPERTY_NAME = "dumpArtifacts";
   
   public static final String DUMP_CONFIGURATION_PROPERTY_NAME = "dumpConfiguration";
   
   public static final String RUN_SUITE_PROPERTY_NAME = "runSuite";
   
   /**
    * Obtain an instance of the TCK
    * 
    * @param configuration
    *           the TCK configuration; if null, the TCK should try to load
    *           configuration from system properties and
    *           web-beans-tck.properties
    * @return
    */
   public static final TCK newInstance()
   {
      TCK tCK;
      try
      {
         tCK = (TCK) Class.forName("org.jboss.testharness.impl.TCKImpl").newInstance();
      }
      catch (InstantiationException e)
      {
         throw new IllegalStateException("WebBeansTCK cannot be run unless webbeans-tck-impl.jar is on the classpath", e);
      }
      catch (IllegalAccessException e)
      {
         throw new IllegalStateException("WebBeansTCK cannot be run unless webbeans-tck-impl.jar is on the classpath", e);
      }
      catch (ClassNotFoundException e)
      {
         throw new IllegalStateException("WebBeansTCK cannot be run unless webbeans-tck-impl.jar is on the classpath", e);
      }      
      return tCK;
   }
   
   public static void main(String[] args)
   {
      if (isSystemPropertyTrue(DUMP_ARTIFACTS_PROPERTY_NAME))
      {
         TCK tck = newInstance();
         tck.dumpArtifacts();
      }
      if (isSystemPropertyTrue(DUMP_CONFIGURATION_PROPERTY_NAME))
      {
         System.out.println(newInstance().getConfiguration());
      }
   }

   protected TCK()
   {
   }
   
   /**
    * Initiate a dump of all TCK artifacts
    * 
    */
   public abstract void dumpArtifacts(); 
   
   /**
    * Get the current configuration
    * 
    * @return
    */
   public abstract Configuration getConfiguration();
   
   private static boolean isSystemPropertyTrue(String propertyName)
   {
      String value = System.getProperty(propertyName);
      return value != null && Boolean.valueOf(value);
   }
   
}
