/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.spi.helpers;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;
import org.jboss.testharness.api.Configurable;
import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.api.DeploymentException;
import org.jboss.testharness.api.DeploymentExceptionTransformer;
import org.jboss.testharness.properties.PropertiesManager;

public abstract class AbstractContainerConnector
implements Configurable {
    public static String JAVA_OPTS = " -ea";
    public static final String JAVA_OPTS_PROPERTY_NAME = "org.jboss.testharness.container.javaOpts";
    private static final String BOOT_TIMEOUT_PROPERTY_NAME = "org.jboss.testharness.container.bootTimeout";
    public static final String FORCE_RESTART_PROPERTY_NAME = "org.jboss.testharness.container.forceRestart";
    public static final String HOST_PROPERTY_NAME = "org.jboss.testharness.container.host";
    public static final String PORT_PROPERTY_NAME = "org.jboss.testharness.container.port";
    public static final String SHUTDOWN_DELAY_PROPERTY_NAME = "org.jboss.testharness.container.shutdownDelay";
    private static final String DEPLOYMENT_EXCEPTION_TRANSFORMER_PROPERTY_NAME = "org.jboss.testharness.container.deploymentExceptionTransformer";
    public static final String EXTRA_CONFIGURATION_DIR_PROPERTY_NAME = "org.jboss.testharness.container.extraConfigurationDir";
    private static Logger log = Logger.getLogger(AbstractContainerConnector.class);
    private final PropertiesManager properties = new PropertiesManager();
    private Configuration configuration;
    private boolean wasStarted;
    private String serverDirectory;
    private String httpUrl;
    private Long bootTimeout;
    private String javaOpts;
    private Boolean forceRestart;
    private Integer shutdownDelay;
    private String host;
    private String port;
    private DeploymentExceptionTransformer deploymentExceptionTransformer;
    private String extraConfigurationDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copy(InputStream inputStream, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            AbstractContainerConnector.copy(inputStream, os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static void copy(InputStream source, OutputStream destination) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination cannot be null");
        }
        byte[] readBuffer = new byte[2156];
        int bytesIn = 0;
        while ((bytesIn = source.read(readBuffer)) != -1) {
            destination.write(readBuffer, 0, bytesIn);
        }
    }

    public AbstractContainerConnector() throws IOException {
        File extraConfiguration;
        String extraConfigurationDir = this.getExtraConfigurationDir();
        if (extraConfigurationDir != null && (extraConfiguration = new File(extraConfigurationDir)).isDirectory()) {
            File localBuildProperties;
            File buildProperties = new File(extraConfiguration, "build.properties");
            if (buildProperties.exists()) {
                this.loadProperties(buildProperties);
            }
            if ((localBuildProperties = new File(extraConfiguration, "local.build.properties")).exists()) {
                this.loadProperties(localBuildProperties);
            }
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected boolean isServerUp() {
        try {
            URLConnection connection = new URL(this.getHttpUrl()).openConnection();
            if (!(connection instanceof HttpURLConnection)) {
                throw new IllegalStateException("Not an http connection! " + connection);
            }
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.connect();
            if (httpConnection.getResponseCode() != 200) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        log.info((Object)"Connected to server over http");
        return true;
    }

    public void setup() throws IOException {
        this.configuration.setHost(this.getHost() + ":" + this.getPort());
        log.info((Object)("Using server " + this.getServerDirectory() + " (" + this.getHttpUrl() + ")"));
        this.restartServer();
    }

    protected void restartServer() throws IOException {
        if (this.getForceRestart().booleanValue() && this.isServerUp()) {
            log.info((Object)"Shutting down server as in force-restart mode");
            this.shutdownServer();
            try {
                Thread.sleep(this.getShutdownDelay().intValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!this.isServerUp()) {
            this.wasStarted = true;
            this.startServer();
            log.info((Object)"Starting server");
            long timeoutTime = System.currentTimeMillis() + this.getServerBootTimeout();
            boolean interrupted = false;
            while (timeoutTime > System.currentTimeMillis()) {
                if (this.isServerUp()) {
                    log.info((Object)"Started server");
                    return;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            log.warn((Object)("Unable to connect to server after " + this.getServerBootTimeout() + "ms, giving up!"));
            this.shutdownServer();
            throw new IllegalStateException("Error connecting to server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            System.getProperties().load(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public void cleanup() throws IOException {
        if (this.wasStarted) {
            log.info((Object)"Shutting down server");
            this.shutdownServer();
        }
    }

    protected abstract void shutdownServer() throws IOException;

    protected abstract void startServer() throws IOException;

    protected void launch(String directory, String scriptFileName, String params) throws IOException {
        String osName = System.getProperty("os.name");
        Runtime runtime = Runtime.getRuntime();
        directory = new File(directory).getPath();
        Process p = null;
        if (osName.startsWith("Windows")) {
            String[] command = new String[]{"cmd.exe", "/C", "set JAVA_OPTS=" + this.getJavaOpts() + " & cd /D " + directory + " & " + scriptFileName + ".bat " + params};
            p = runtime.exec(command);
        } else {
            String[] command = new String[]{"sh", "-c", "cd " + directory + ";JAVA_OPTS=\"" + this.getJavaOpts() + "\" ./" + scriptFileName + ".sh " + params};
            p = runtime.exec(command);
        }
        this.dump(p.getErrorStream());
        this.dump(p.getInputStream());
    }

    protected void dump(final InputStream is) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    int c;
                    DataOutputStream out = new DataOutputStream(new FileOutputStream(AbstractContainerConnector.this.configuration.getOutputDirectory() + File.separator + AbstractContainerConnector.this.getLogName()));
                    while ((c = is.read()) != -1) {
                        out.writeByte(c);
                    }
                    is.close();
                    out.close();
                }
                catch (IOException e) {
                    System.err.println("Error Writing/Reading Streams.");
                }
            }
        }).start();
    }

    protected abstract String getServerHomePropertyName();

    protected String getServerDirectory() {
        if (this.serverDirectory == null) {
            this.serverDirectory = new File(this.getProperties().getStringValue(this.getServerHomePropertyName(), null, true)).getPath();
        }
        return this.serverDirectory;
    }

    protected String getServerBootTimeoutPropertyName() {
        return BOOT_TIMEOUT_PROPERTY_NAME;
    }

    protected String getDeploymentExceptionTransformerPropertyName() {
        return DEPLOYMENT_EXCEPTION_TRANSFORMER_PROPERTY_NAME;
    }

    protected DeploymentExceptionTransformer getDeploymentExceptionTransformer() {
        if (this.deploymentExceptionTransformer == null) {
            this.deploymentExceptionTransformer = this.getProperties().getInstanceValue(this.getDeploymentExceptionTransformerPropertyName(), DeploymentExceptionTransformer.class, false);
            if (this.deploymentExceptionTransformer == null) {
                this.deploymentExceptionTransformer = new DeploymentExceptionTransformer(){

                    public DeploymentException transform(DeploymentException exception) {
                        return exception;
                    }
                };
            }
        }
        return this.deploymentExceptionTransformer;
    }

    protected Long getServerBootTimeout() {
        if (this.bootTimeout == null) {
            this.bootTimeout = this.getProperties().getLongValue(this.getServerBootTimeoutPropertyName(), 240000L, false);
        }
        return this.bootTimeout;
    }

    protected String getForceRestartPropertyName() {
        return FORCE_RESTART_PROPERTY_NAME;
    }

    protected Boolean getForceRestart() {
        if (this.forceRestart == null) {
            this.forceRestart = this.forceRestart = Boolean.valueOf(this.getProperties().getBooleanValue(this.getForceRestartPropertyName(), false, false));
        }
        return this.forceRestart;
    }

    protected String getHostPropertyName() {
        return HOST_PROPERTY_NAME;
    }

    protected String getHost() {
        if (this.host == null) {
            this.host = this.getProperties().getStringValue(this.getHostPropertyName(), "localhost", false);
        }
        return this.host;
    }

    protected String getPortPropertyName() {
        return PORT_PROPERTY_NAME;
    }

    protected String getPort() {
        if (this.port == null) {
            this.port = this.getProperties().getStringValue(this.getPortPropertyName(), "8080", false);
        }
        return this.port;
    }

    protected String getShutdownDelayPropertyName() {
        return SHUTDOWN_DELAY_PROPERTY_NAME;
    }

    protected Integer getShutdownDelay() {
        if (this.shutdownDelay == null) {
            this.shutdownDelay = this.getProperties().getIntValue(SHUTDOWN_DELAY_PROPERTY_NAME, 15000, false);
        }
        return this.shutdownDelay;
    }

    protected PropertiesManager getProperties() {
        return this.properties;
    }

    protected String getJavaOpts() {
        if (this.javaOpts == null) {
            this.javaOpts = this.getProperties().getStringValue(JAVA_OPTS_PROPERTY_NAME, "", false);
            this.javaOpts = this.javaOpts + JAVA_OPTS;
        }
        return this.javaOpts;
    }

    protected String getHttpUrl() {
        if (this.httpUrl == null) {
            this.httpUrl = "http://" + this.getHost() + ":" + this.getPort() + "/";
        }
        return this.httpUrl;
    }

    protected String getExtraConfigurationDirPropertyName() {
        return EXTRA_CONFIGURATION_DIR_PROPERTY_NAME;
    }

    protected abstract String getLogName();

    protected String getExtraConfigurationDir() {
        if (this.extraConfigurationDir == null) {
            this.extraConfigurationDir = this.getProperties().getStringValue(EXTRA_CONFIGURATION_DIR_PROPERTY_NAME, null, false);
        }
        return this.extraConfigurationDir;
    }
}

