package org.jboss.as.console.client.plugins;

import com.google.common.collect.HashMultimap;

import java.util.Collections;
import java.util.Set;
import java.util.HashSet;
import javax.annotation.Generated;

import static java.util.Arrays.asList;

/*
* WARNING! This class is generated. Do not modify.
*/
@Generated("org.jboss.hal.processors.NameTokenProcessor")
public class SearchIndexRegistryImpl implements SearchIndexRegistry {

    private final Set<String> standaloneTokens;
    private final Set<String> domainTokens;
    private final HashMultimap<String, String> keywords;
    private final HashMultimap<String, String> resources;

    public SearchIndexRegistryImpl() {
        standaloneTokens = new HashSet<>();
        domainTokens = new HashSet<>();
        keywords = HashMultimap.create();
        resources = HashMultimap.create();

        domainTokens.add("host-vm");
        keywords.putAll("host-vm", asList("jvm", "memory-usage", "threads"));
        standaloneTokens.add("xads");
        domainTokens.add("xads");
        keywords.putAll("xads", asList("xa-data-source", "data-source", "pool", "jpa", "jdbc", "connection-properties"));
        standaloneTokens.add("csp");
        domainTokens.add("csp");
        domainTokens.add("server-groups");
        keywords.putAll("server-groups", asList("jvm", "socket-binding", "profile", "server-group", "group"));
        standaloneTokens.add("webservices");
        domainTokens.add("webservices");
        keywords.putAll("webservices", asList("wsdl", "web", "client-config", "soap", "endpoint-config"));
        standaloneTokens.add("domain-runtime");
        domainTokens.add("domain-runtime");
        standaloneTokens.add("activemq-messaging");
        domainTokens.add("activemq-messaging");
        keywords.putAll("activemq-messaging", asList("jms", "subscribe", "publish", "topic", "queue", "messaging"));
        standaloneTokens.add("mail");
        domainTokens.add("mail");
        keywords.putAll("mail", asList("imap", "smtp", "mail", "channel"));
        standaloneTokens.add("servlet");
        domainTokens.add("servlet");
        standaloneTokens.add("main");
        domainTokens.add("main");
        domainTokens.add("host-interfaces");
        keywords.putAll("host-interfaces", asList("bind-address", "network-interface", "interface"));
        domainTokens.add("host-jvms");
        keywords.putAll("host-jvms", asList("jvm", "xmx", "xss", "heap", "xms"));
        standaloneTokens.add("path");
        domainTokens.add("path");
        keywords.putAll("path", asList("file-system"));
        standaloneTokens.add("socket-bindings");
        domainTokens.add("socket-bindings");
        keywords.putAll("socket-bindings", asList("multi-cast", "bind-address", "port", "network-interface", "socket", "interface"));
        standaloneTokens.add("tx-metrics");
        domainTokens.add("tx-metrics");
        keywords.putAll("tx-metrics", asList("transaction-log", "failure", "commit", "transaction"));
        standaloneTokens.add("deployment-scanner");
        keywords.putAll("deployment-scanner", asList("scanner", "deployment"));
        standaloneTokens.add("jmx");
        domainTokens.add("jmx");
        keywords.putAll("jmx", asList("mbean", "jmx", "connector", "management"));
        standaloneTokens.add("messaging-cluster");
        domainTokens.add("messaging-cluster");
        keywords.putAll("messaging-cluster", asList("broadcast", "jms", "cluster", "discovery", "messaging"));
        standaloneTokens.add("batch-jberet");
        domainTokens.add("batch-jberet");
        standaloneTokens.add("server-overview");
        domainTokens.add("server-overview");
        standaloneTokens.add("security_domain");
        domainTokens.add("security_domain");
        keywords.putAll("security_domain", asList("security-domain", "security", "authorisation", "jaas", "vault", "login-module", "authentication"));
        standaloneTokens.add("undertow-subsystem");
        domainTokens.add("undertow-subsystem");
        keywords.putAll("undertow-subsystem", asList("web", "jsp", "http", "ssl"));
        standaloneTokens.add("tx-logs");
        domainTokens.add("tx-logs");
        keywords.putAll("tx-logs", asList("transaction-log", "durability", "recovery", "transaction"));
        resources.putAll("tx-logs", asList("/{implicit.host}/{selected.server}/subsystem=transactions/log-store=log-store"));
        standaloneTokens.add("jpa-metrics");
        domainTokens.add("jpa-metrics");
        keywords.putAll("jpa-metrics", asList("jpa", "hibernate"));
        standaloneTokens.add("activemq-messaging-connections");
        domainTokens.add("activemq-messaging-connections");
        keywords.putAll("activemq-messaging-connections", asList("jms", "connector", "acceptor", "bridge"));
        standaloneTokens.add("ee");
        domainTokens.add("ee");
        keywords.putAll("ee", asList("ee", "scheduler", "context-service", "executor", "thread-factory", "managed-bean"));
        standaloneTokens.add("settings");
        domainTokens.add("settings");
        standaloneTokens.add("teiid");
        domainTokens.add("teiid");
        keywords.putAll("teiid", asList("teiid", "vdb"));
        standaloneTokens.add("standalone-deployments");
        keywords.putAll("standalone-deployments", asList("application", "ear", "war", "deployment"));
        standaloneTokens.add("hosts");
        domainTokens.add("hosts");
        keywords.putAll("hosts", asList("jvm", "socket-binding", "profile", "host", "server-group", "group"));
        domainTokens.add("topology");
        keywords.putAll("topology", asList("server", "stop", "domain", "domain-overview", "start", "server-group", "status"));
        standaloneTokens.add("io");
        domainTokens.add("io");
        standaloneTokens.add("iiop-openjdk");
        domainTokens.add("iiop-openjdk");
        standaloneTokens.add("profile");
        domainTokens.add("profile");
        standaloneTokens.add("profiles");
        domainTokens.add("profiles");
        standaloneTokens.add("batch");
        domainTokens.add("batch");
        standaloneTokens.add("cache-container");
        domainTokens.add("cache-container");
        keywords.putAll("cache-container", asList("cache", "web", "transport", "ejb", "hibernate"));
        standaloneTokens.add("batch-jberet-metrics");
        domainTokens.add("batch-jberet-metrics");
        standaloneTokens.add("jgroups");
        domainTokens.add("jgroups");
        keywords.putAll("jgroups", asList("cluster", "protocol", "group-communication", "channel"));
        standaloneTokens.add("transactions");
        domainTokens.add("transactions");
        keywords.putAll("transactions", asList("log-store", "transaction"));
        standaloneTokens.add("vdb-runtime");
        domainTokens.add("vdb-runtime");
        domainTokens.add("server-config");
        keywords.putAll("server-config", asList("jvm", "server", "socket-binding", "server-config"));
        standaloneTokens.add("messaging-connections");
        domainTokens.add("messaging-connections");
        keywords.putAll("messaging-connections", asList("jms", "connector", "acceptor", "bridge"));
        standaloneTokens.add("messaging");
        domainTokens.add("messaging");
        keywords.putAll("messaging", asList("jms", "subscribe", "publish", "topic", "queue", "messaging"));
        standaloneTokens.add("datasources");
        domainTokens.add("datasources");
        keywords.putAll("datasources", asList("data-source", "pool", "jpa", "jdbc", "connection-properties"));
        standaloneTokens.add("naming");
        domainTokens.add("naming");
        keywords.putAll("naming", asList("lookup", "jndi-tree", "jndi"));
        resources.putAll("naming", asList("/{implicit.host}/{selected.server}/subsystem=naming"));
        standaloneTokens.add("vm");
        domainTokens.add("vm");
        standaloneTokens.add("activemq-messaging-cluster");
        domainTokens.add("activemq-messaging-cluster");
        keywords.putAll("activemq-messaging-cluster", asList("broadcast", "jms", "cluster", "discovery", "messaging"));
        standaloneTokens.add("logging");
        domainTokens.add("logging");
        standaloneTokens.add("http");
        domainTokens.add("http");
        standaloneTokens.add("audit-log");
        domainTokens.add("audit-log");
        keywords.putAll("audit-log", asList("log", "management", "audit"));
        standaloneTokens.add("ds-finder");
        domainTokens.add("ds-finder");
        keywords.putAll("ds-finder", asList("xa-data-source", "data-source", "pool", "jpa", "jdbc", "connection-properties"));
        standaloneTokens.add("web-metrics");
        domainTokens.add("web-metrics");
        keywords.putAll("web-metrics", asList("web", "http", "connections"));
        standaloneTokens.add("jms-metrics");
        domainTokens.add("jms-metrics");
        keywords.putAll("jms-metrics", asList("jms", "size", "topic", "queue"));
        standaloneTokens.add("caches");
        domainTokens.add("caches");
        keywords.putAll("caches", asList("cache", "web", "transport", "ejb", "hibernate"));
        standaloneTokens.add("undertow");
        domainTokens.add("undertow");
        standaloneTokens.add("jca");
        domainTokens.add("jca");
        keywords.putAll("jca", asList("resource-management", "pool"));
        standaloneTokens.add("ra-finder");
        domainTokens.add("ra-finder");
        keywords.putAll("ra-finder", asList("connector", "resource-adapter", "jca", "workmanager", "bootstrap-context"));
        standaloneTokens.add("no-server");
        domainTokens.add("no-server");
        standaloneTokens.add("login");
        domainTokens.add("login");
        standaloneTokens.add("patching");
        domainTokens.add("patching");
        keywords.putAll("patching", asList("upgrade", "update", "patching"));
        standaloneTokens.add("tools");
        domainTokens.add("tools");
        domainTokens.add("host-properties");
        keywords.putAll("host-properties", asList("system-property", "property"));
        standaloneTokens.add("hornetq");
        domainTokens.add("hornetq");
        keywords.putAll("hornetq", asList("jms", "subscribe", "publish", "topic", "queue", "messaging"));
        standaloneTokens.add("web");
        domainTokens.add("web");
        keywords.putAll("web", asList("filter", "servlet", "jsp", "virtual-host", "http", "ssl"));
        standaloneTokens.add("standalone-runtime");
        domainTokens.add("standalone-runtime");
        standaloneTokens.add("logfiles");
        domainTokens.add("logfiles");
        keywords.putAll("logfiles", asList("server-log", "download", "log-view", "log-file"));
        domainTokens.add("domain-deployments");
        keywords.putAll("domain-deployments", asList("application", "ear", "war", "deployment"));
        standaloneTokens.add("ejb3");
        domainTokens.add("ejb3");
        standaloneTokens.add("modcluster");
        domainTokens.add("modcluster");
        keywords.putAll("modcluster", asList("reverse-proxy", "cluster", "web-frontend", "load-balancing"));
        standaloneTokens.add("mbui");
        domainTokens.add("mbui");
        standaloneTokens.add("jpa");
        domainTokens.add("jpa");
        keywords.putAll("jpa", asList("data-source", "jpa"));
        standaloneTokens.add("mail-sessions");
        domainTokens.add("mail-sessions");
        keywords.putAll("mail-sessions", asList("imap", "smtp", "mail", "channel"));
        standaloneTokens.add("webservice-runtime");
        domainTokens.add("webservice-runtime");
        keywords.putAll("webservice-runtime", asList("webservices", "endpoint", "jbossws", "jaxws"));
        standaloneTokens.add("activemq");
        domainTokens.add("activemq");
        keywords.putAll("activemq", asList("jms", "subscribe", "publish", "topic", "queue", "messaging"));
        standaloneTokens.add("interfaces");
        domainTokens.add("interfaces");
        keywords.putAll("interfaces", asList("ip-address", "network-interface", "ip", "ifconfig"));
        standaloneTokens.add("rbac");
        domainTokens.add("rbac");
        keywords.putAll("rbac", asList("authorization", "security", "rbac", "access-control"));
        standaloneTokens.add("resource-adapters");
        domainTokens.add("resource-adapters");
        keywords.putAll("resource-adapters", asList("connector", "resource-adapter", "jca", "workmanager", "bootstrap-context"));
        standaloneTokens.add("configadmin");
        domainTokens.add("configadmin");
        standaloneTokens.add("remoting");
        domainTokens.add("remoting");
        standaloneTokens.add("security_domains");
        domainTokens.add("security_domains");
        keywords.putAll("security_domains", asList("security-domain", "security", "authorisation", "jaas", "vault", "login-module", "authentication"));
        standaloneTokens.add("home");
        domainTokens.add("home");
        standaloneTokens.add("http-metrics");
        domainTokens.add("http-metrics");
        keywords.putAll("http-metrics", asList("web", "http", "connections"));
        standaloneTokens.add("environment");
        domainTokens.add("environment");
        keywords.putAll("environment", asList("jvm", "environment", "runtime"));
        standaloneTokens.add("mbui-workbench");
        domainTokens.add("mbui-workbench");
        standaloneTokens.add("properties");
        domainTokens.add("properties");
        keywords.putAll("properties", asList("system-property", "property"));
        standaloneTokens.add("ds-metrics");
        domainTokens.add("ds-metrics");
        keywords.putAll("ds-metrics", asList("pool-usage", "data-source", "pool"));
    }

    @Override
    public Set<String> getTokens(boolean standalone) {
        return standalone ? standaloneTokens : domainTokens;
    }

    @Override
    public Set<String> getKeywords(String token) {
        if (keywords.containsKey(token)) {
            return keywords.get(token);
        } else {
            return Collections.<String>emptySet();
        }
    }

    @Override
    public Set<String> getResources(String token) {
        if (resources.containsKey(token)) {
            return resources.get(token);
        } else {
            return Collections.<String>emptySet();
        }
    }
}
