/* Generated By:JavaCC: Do not edit this line. SQLParser.java */
package org.teiid.query.parser;

import java.math.BigInteger;
import java.util.*;
import org.teiid.core.types.*;
import org.teiid.core.util.StringUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.*;
import org.teiid.query.sql.proc.*;
import org.teiid.query.sql.symbol.*;
import org.teiid.metadata.*;
import org.teiid.metadata.BaseColumn.NullType;
import org.teiid.language.Like.MatchMode;
import org.teiid.translator.*;

/** 
 * <p>The SQLParser is a JavaCC-generated parser that reads a SQL string and produces a 
 * Query object.  The SQLParser.java file is generated by JavaCC from the SQLParser.jj
 * file.  <B>WARNING:</B> DO NOT MODIFY the SQLParser.java file as it will be 
 * regenerated from the .jj file and your changes will be lost!</p>
 */
@SuppressWarnings({"nls", "unused"})
public class SQLParser extends SQLParserUtil implements SQLParserConstants {

  private void jj_add_error_token ( int kind, int pos) {
            if (pos >= 100) return;
            if (pos == jj_endpos + 1) {
              jj_lasttokens[jj_endpos++] = kind;
            } else if (jj_endpos != 0) {
              jj_expentry = new int[jj_endpos];
              for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
              }
              boolean exists = false;
              for (java.util.Iterator e = jj_expentries.iterator(); e.hasNext();) {
                int[] oldentry = (int[])(e.next());
                if (oldentry.length == jj_expentry.length) {
                  exists = true;
                  for (int i = 0; i < jj_expentry.length; i++) {
                    if (oldentry[i] != jj_expentry[i]) {
                      exists = false;
                      break;
                    }
                  }
                  if (exists) break;
                }
              }
              if (!exists) jj_expentries.add(jj_expentry);
              if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
            }
          }

/*
name=string
description=A string literal value.  Use '' to escape ' in the string.  
example=[source,sql]\n----\n'a string'\n----\n\n[source,sql]\n----\n'it''s a string'\n----\n
*/
  final public String stringVal() throws ParseException {
        Token t = null;
    t = jj_consume_token(STRINGVAL);
                {if (true) return normalizeStringLiteral(t.image);}
    throw new Error("Missing return statement in function");
  }

/*
name=non-reserved identifier
description=Allows non-reserved keywords to be parsed as identifiers  
example=SELECT *COUNT* FROM ...
*/
  final public Token nonReserved() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSTEAD:
      jj_consume_token(INSTEAD);
      break;
    case VIEW:
      jj_consume_token(VIEW);
      break;
    case ENABLED:
      jj_consume_token(ENABLED);
      break;
    case DISABLED:
      jj_consume_token(DISABLED);
      break;
    case KEY:
      jj_consume_token(KEY);
      break;
    case SERIAL:
      jj_consume_token(SERIAL);
      break;
    case TEXTAGG:
      jj_consume_token(TEXTAGG);
      break;
    case COUNT:
      jj_consume_token(COUNT);
      break;
    case ROW_NUMBER:
      jj_consume_token(ROW_NUMBER);
      break;
    case RANK:
      jj_consume_token(RANK);
      break;
    case DENSE_RANK:
      jj_consume_token(DENSE_RANK);
      break;
    case SUM:
      jj_consume_token(SUM);
      break;
    case AVG:
      jj_consume_token(AVG);
      break;
    case MIN:
      jj_consume_token(MIN);
      break;
    case MAX:
      jj_consume_token(MAX);
      break;
    case EVERY:
      jj_consume_token(EVERY);
      break;
    case STDDEV_POP:
      jj_consume_token(STDDEV_POP);
      break;
    case STDDEV_SAMP:
      jj_consume_token(STDDEV_SAMP);
      break;
    case VAR_SAMP:
      jj_consume_token(VAR_SAMP);
      break;
    case VAR_POP:
      jj_consume_token(VAR_POP);
      break;
    case DOCUMENT:
      jj_consume_token(DOCUMENT);
      break;
    case CONTENT:
      jj_consume_token(CONTENT);
      break;
    case TRIM:
      jj_consume_token(TRIM);
      break;
    case EMPTY:
      jj_consume_token(EMPTY);
      break;
    case ORDINALITY:
      jj_consume_token(ORDINALITY);
      break;
    case PATH:
      jj_consume_token(PATH);
      break;
    case FIRST:
      jj_consume_token(FIRST);
      break;
    case LAST:
      jj_consume_token(LAST);
      break;
    case NEXT:
      jj_consume_token(NEXT);
      break;
    case SUBSTRING:
      jj_consume_token(SUBSTRING);
      break;
    case EXTRACT:
      jj_consume_token(EXTRACT);
      break;
    case TO_CHARS:
      jj_consume_token(TO_CHARS);
      break;
    case TO_BYTES:
      jj_consume_token(TO_BYTES);
      break;
    case TIMESTAMPADD:
      jj_consume_token(TIMESTAMPADD);
      break;
    case TIMESTAMPDIFF:
      jj_consume_token(TIMESTAMPDIFF);
      break;
    case QUERYSTRING:
      jj_consume_token(QUERYSTRING);
      break;
    case NAMESPACE:
      jj_consume_token(NAMESPACE);
      break;
    case RESULT:
      jj_consume_token(RESULT);
      break;
    case INDEX:
      jj_consume_token(INDEX);
      break;
    case ACCESSPATTERN:
      jj_consume_token(ACCESSPATTERN);
      break;
    case AUTO_INCREMENT:
      jj_consume_token(AUTO_INCREMENT);
      break;
    case WELLFORMED:
      jj_consume_token(WELLFORMED);
      break;
    case SQL_TSI_FRAC_SECOND:
      jj_consume_token(SQL_TSI_FRAC_SECOND);
      break;
    case SQL_TSI_SECOND:
      jj_consume_token(SQL_TSI_SECOND);
      break;
    case SQL_TSI_MINUTE:
      jj_consume_token(SQL_TSI_MINUTE);
      break;
    case SQL_TSI_HOUR:
      jj_consume_token(SQL_TSI_HOUR);
      break;
    case SQL_TSI_DAY:
      jj_consume_token(SQL_TSI_DAY);
      break;
    case SQL_TSI_WEEK:
      jj_consume_token(SQL_TSI_WEEK);
      break;
    case SQL_TSI_MONTH:
      jj_consume_token(SQL_TSI_MONTH);
      break;
    case SQL_TSI_QUARTER:
      jj_consume_token(SQL_TSI_QUARTER);
      break;
    case SQL_TSI_YEAR:
      jj_consume_token(SQL_TSI_YEAR);
      break;
    case TEXTTABLE:
      jj_consume_token(TEXTTABLE);
      break;
    case ARRAYTABLE:
      jj_consume_token(ARRAYTABLE);
      break;
    case SELECTOR:
      jj_consume_token(SELECTOR);
      break;
    case SKIP_KEYWORD:
      jj_consume_token(SKIP_KEYWORD);
      break;
    case WIDTH:
      jj_consume_token(WIDTH);
      break;
    case PASSING:
      jj_consume_token(PASSING);
      break;
    case NAME:
      jj_consume_token(NAME);
      break;
    case ENCODING:
      jj_consume_token(ENCODING);
      break;
    case COLUMNS:
      jj_consume_token(COLUMNS);
      break;
    case DELIMITER:
      jj_consume_token(DELIMITER);
      break;
    case QUOTE:
      jj_consume_token(QUOTE);
      break;
    case HEADER:
      jj_consume_token(HEADER);
      break;
    case NULLS:
      jj_consume_token(NULLS);
      break;
    case OBJECTTABLE:
      jj_consume_token(OBJECTTABLE);
      break;
    case VERSION:
      jj_consume_token(VERSION);
      break;
    case INCLUDING:
      jj_consume_token(INCLUDING);
      break;
    case EXCLUDING:
      jj_consume_token(EXCLUDING);
      break;
    case XMLDECLARATION:
      jj_consume_token(XMLDECLARATION);
      break;
    case VARIADIC:
      jj_consume_token(VARIADIC);
      break;
    case RAISE:
      jj_consume_token(RAISE);
      break;
    case EXCEPTION:
      jj_consume_token(EXCEPTION);
      break;
    case CHAIN:
      jj_consume_token(CHAIN);
      break;
    case JSONARRAY_AGG:
      jj_consume_token(JSONARRAY_AGG);
      break;
    case JSONOBJECT:
      jj_consume_token(JSONOBJECT);
      break;
    case PRESERVE:
      jj_consume_token(PRESERVE);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return getToken(0);}
    throw new Error("Missing return statement in function");
  }

/*
name=identifier
description=Partial or full name of a single entity.
example=[source,sql]\n----\ntbl.col\n----\n\n[source,sql]\n----\n"tbl"."col"\n----\n
*/
  final public String id(Boolean nonAlias) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      jj_consume_token(ID);
      break;
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
      nonReserved();
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                String id = normalizeId(getToken(0).image);
                if (nonAlias != null) {
                        {if (true) return validateName(id, nonAlias);}
                }
                {if (true) return id;}
    throw new Error("Missing return statement in function");
  }

/* TODO: createProcedure should not be here, but is due to all of the legacy tests
unused=true
*/
  final public Command command(ParseInfo info) throws ParseException {
        Command command = null;
    if (jj_2_1(2)) {
      command = createProcedure(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case BEGIN:
      case CALL:
      case CREATE:
      case DELETE:
      case DROP:
      case EXEC:
      case EXECUTE:
      case INSERT:
      case MERGE:
      case SELECT:
      case TABLE:
      case UPDATE:
      case VALUES:
      case WITH:
      case LPAREN:
        command = userCommand(info);
        break;
      case LBRACE:
        command = callableStatement(info);
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    jj_consume_token(0);
                {if (true) return command;}
    throw new Error("Missing return statement in function");
  }

/*
unused=true
*/
  final public Command designerCommand(ParseInfo info) throws ParseException {
        Command command = null;
    if (jj_2_2(2)) {
      command = createProcedure(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        command = forEachRowTriggerAction(info);
        break;
      case ALTER:
      case BEGIN:
      case CALL:
      case CREATE:
      case DELETE:
      case DROP:
      case EXEC:
      case EXECUTE:
      case INSERT:
      case MERGE:
      case SELECT:
      case TABLE:
      case UPDATE:
      case VALUES:
      case WITH:
      case LPAREN:
        command = userCommand(info);
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    jj_consume_token(0);
                {if (true) return command;}
    throw new Error("Missing return statement in function");
  }

/*
name=create trigger
description=Creates a trigger action on the given target.
example=[source,sql]\n----\nCREATE TRIGGER ON vw INSTEAD OF INSERT AS FOR EACH ROW BEGIN ATOMIC ... END\n----\n
*/
  final public Command createTrigger(ParseInfo info) throws ParseException {
        String target = null;
        TriggerAction triggerAction = null;
        Token event = null;
    jj_consume_token(CREATE);
    jj_consume_token(TRIGGER);
    jj_consume_token(ON);
    target = id(null);
    jj_consume_token(INSTEAD);
    jj_consume_token(OF);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      event = jj_consume_token(INSERT);
      break;
    case UPDATE:
      event = jj_consume_token(UPDATE);
      break;
    case DELETE:
      event = jj_consume_token(DELETE);
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(AS);
    triggerAction = forEachRowTriggerAction(info);
                AlterTrigger alterTrigger = new AlterTrigger();
                alterTrigger.setTarget(new GroupSymbol(target));
                alterTrigger.setDefinition(triggerAction);
                alterTrigger.setEvent(Table.TriggerEvent.valueOf(event.image.toUpperCase()));
                alterTrigger.setCreate(true);
                {if (true) return alterTrigger;}
    throw new Error("Missing return statement in function");
  }

/*
name=alter
description=Alter the given target.
example=[source,sql]\n----\nALTER VIEW vw AS SELECT col FROM tbl\n----\n
*/
  final public Command alter(ParseInfo info) throws ParseException {
        String target = null;
        QueryCommand command = null;
        Statement stmt = null;
        TriggerAction triggerAction = null;
        Token comment = null;
        Token event = null;
        Boolean enabled = null;
    jj_consume_token(ALTER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VIEW:
      jj_consume_token(VIEW);
      target = id(null);
      jj_consume_token(AS);
                                                 comment = getToken(1).specialToken;
      command = queryExpression(info);
                    if (comment != null) {
                            command.setCacheHint(getQueryCacheOption(comment.image));
                    }
                        AlterView alterView = new AlterView();
                        alterView.setTarget(new GroupSymbol(target));
                        alterView.setDefinition(command);
                        {if (true) return alterView;}
      break;
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
      target = id(null);
      jj_consume_token(AS);
                                                        comment = getToken(1).specialToken;
      stmt = statement(info);
                        CreateProcedureCommand cup = new CreateProcedureCommand(asBlock(stmt));
                        if (comment != null) {
                            cup.setCacheHint(getQueryCacheOption(comment.image));
                    }
                        AlterProcedure alterProc = new AlterProcedure();
                        alterProc.setTarget(new GroupSymbol(target));
                        alterProc.setDefinition(cup);
                        {if (true) return alterProc;}
      break;
    case TRIGGER:
      jj_consume_token(TRIGGER);
      jj_consume_token(ON);
      target = id(null);
      jj_consume_token(INSTEAD);
      jj_consume_token(OF);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSERT:
        event = jj_consume_token(INSERT);
        break;
      case UPDATE:
        event = jj_consume_token(UPDATE);
        break;
      case DELETE:
        event = jj_consume_token(DELETE);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        triggerAction = forEachRowTriggerAction(info);
        break;
      case ENABLED:
        jj_consume_token(ENABLED);
                              enabled=true;
        break;
      case DISABLED:
        jj_consume_token(DISABLED);
                                                          enabled=false;
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        AlterTrigger alterTrigger = new AlterTrigger();
                        alterTrigger.setTarget(new GroupSymbol(target));
                        alterTrigger.setDefinition(triggerAction);
                        alterTrigger.setEvent(Table.TriggerEvent.valueOf(event.image.toUpperCase()));
                        if (enabled != null) {
                                alterTrigger.setEnabled(enabled);
                        }
                        {if (true) return alterTrigger;}
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=for each row trigger action
description=Defines an action to perform on each row.
example=[source,sql]\n----\nFOR EACH ROW BEGIN ATOMIC ... END\n----\n
*/
  final public TriggerAction forEachRowTriggerAction(ParseInfo info) throws ParseException {
        Block b = new Block();
        b.setAtomic(true);
        Statement stmt = null;
    jj_consume_token(FOR);
    jj_consume_token(EACH);
    jj_consume_token(ROW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEGIN:
      jj_consume_token(BEGIN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ATOMIC:
        jj_consume_token(ATOMIC);
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALTER:
        case BEGIN:
        case BREAK:
        case CALL:
        case CONTINUE:
        case CREATE:
        case DECLARE:
        case DELETE:
        case DROP:
        case ERROR:
        case EXEC:
        case EXECUTE:
        case IF:
        case INSERT:
        case LEAVE:
        case LOOP:
        case MERGE:
        case RETURN:
        case SELECT:
        case TABLE:
        case UPDATE:
        case VALUES:
        case WITH:
        case WHILE:
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case PRESERVE:
        case ID:
        case LPAREN:
          ;
          break;
        default:
          jj_la1[11] = jj_gen;
          break label_1;
        }
        stmt = statement(info);
            b.addStatement(stmt);
      }
      jj_consume_token(END);
      break;
    case ALTER:
    case BREAK:
    case CALL:
    case CONTINUE:
    case CREATE:
    case DECLARE:
    case DELETE:
    case DROP:
    case ERROR:
    case EXEC:
    case EXECUTE:
    case IF:
    case INSERT:
    case LEAVE:
    case LOOP:
    case MERGE:
    case RETURN:
    case SELECT:
    case TABLE:
    case UPDATE:
    case VALUES:
    case WITH:
    case WHILE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
    case LPAREN:
      stmt = statement(info);
       b = asBlock(stmt);
       b.setAtomic(true);
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return new TriggerAction(b);}
    throw new Error("Missing return statement in function");
  }

/*
name=directly executable statement
description=A statement that can be executed at runtime.
example=[source,sql]\n----\nSELECT * FROM tbl\n----\n
index=true
*/
  final public Command userCommand(ParseInfo info) throws ParseException {
        Command command = null;
        SourceHint sourceHint = null;
        Block block = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case TABLE:
    case VALUES:
    case WITH:
    case LPAREN:
      command = queryExpression(info);
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      command = storedProcedure(info, 1);
      break;
    case INSERT:
    case MERGE:
          sourceHint = getSourceHint(this);
      command = insert(info);
      break;
    case UPDATE:
          sourceHint = getSourceHint(this);
      command = update(info);
      break;
    case DELETE:
          sourceHint = getSourceHint(this);
      command = delete(info);
      break;
    case DROP:
      command = dropTable(info);
      break;
    default:
      jj_la1[13] = jj_gen;
      if (jj_2_3(2)) {
        command = createTempTable(info);
      } else if (jj_2_4(2)) {
        command = createForeignTempTable(info);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALTER:
          command = alter(info);
          break;
        case CREATE:
          command = createTrigger(info);
          break;
        case BEGIN:
          block = compoundStatement(info);
                                         command = new CreateProcedureCommand(block);
          break;
        default:
          jj_la1[14] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
                setSourceHint(sourceHint, command);
                {if (true) return command;}
    throw new Error("Missing return statement in function");
  }

/*
name=drop table
description=Creates a trigger action on the given target.
example=[source,sql]\n----\nCREATE TRIGGER ON vw INSTEAD OF INSERT AS FOR EACH ROW BEGIN ATOMIC ... END\n----\n
*/
  final public Command dropTable(ParseInfo info) throws ParseException {
        Drop drop = new Drop();
        String table = null;
    jj_consume_token(DROP);
    jj_consume_token(TABLE);
    table = id(null);
                drop.setTable(new GroupSymbol(table));
                {if (true) return drop;}
    throw new Error("Missing return statement in function");
  }

/*
name=create temporary table
description=Creates a temporary table.
example=[source,sql]\n----\nCREATE LOCAL TEMPORARY TABLE tmp (col integer)\n----\n
*/
  final public Command createTempTable(ParseInfo info) throws ParseException {
        Create create = new Create();
        String table = null;
        String pkId = null;
        Column col = null;
        List<ElementSymbol> pk = null;
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCAL:
      jj_consume_token(LOCAL);
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    jj_consume_token(TEMPORARY);
    jj_consume_token(TABLE);
    table = id(null);
    jj_consume_token(LPAREN);
                create.setTable(new GroupSymbol(table));
    col = tableElement(info);
      create.getColumns().add(col);
    label_2:
    while (true) {
      if (jj_2_5(2)) {
        ;
      } else {
        break label_2;
      }
      jj_consume_token(COMMA);
      col = tableElement(info);
        create.getColumns().add(col);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
      pk = columnList(true, true);
                create.getPrimaryKey().addAll(pk);
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ON:
      jj_consume_token(ON);
      jj_consume_token(COMMIT);
      jj_consume_token(PRESERVE);
                         create.setCommitAction(Create.CommitAction.PRESERVE_ROWS);
      jj_consume_token(ROWS);
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
                {if (true) return create;}
    throw new Error("Missing return statement in function");
  }

/*
name=temporary table element
description=Defines a temporary table column.
example=[source,sql]\n----\ncol string NOT NULL\n----\n
*/
  final public Column tableElement(ParseInfo info) throws ParseException {
        String element = null;
        ParsedDataType type = null;
        boolean autoIncrement = false;
        //TODO: once we support udts, then this will need to inherit the nullability from the type
        boolean notNull = false;
    element = id(Boolean.TRUE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
    case VARBINARY:
    case VARCHAR:
    case BOOLEAN:
    case BYTE:
    case TINYINT:
    case SHORT:
    case SMALLINT:
    case CHAR:
    case INTEGER:
    case LONG:
    case BIGINT:
    case BIGINTEGER:
    case FLOAT:
    case REAL:
    case DOUBLE:
    case BIGDECIMAL:
    case DECIMAL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case OBJECT:
    case BLOB:
    case CLOB:
    case XML:
    case GEOMETRY:
      type = parseDataType();
      break;
    case SERIAL:
      jj_consume_token(SERIAL);
            type = new ParsedDataType("INTEGER");
            autoIncrement = true;
            notNull = true;
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                         notNull = true;
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
            Column c = new Column();
            c.setName(element);
            c.setRuntimeType(type.type);
            c.setAutoIncremented(autoIncrement);
            c.setNullType(notNull?NullType.No_Nulls:NullType.Nullable);
            {if (true) return c;}
    throw new Error("Missing return statement in function");
  }

/*
name=raise error statement
description=Raises an error with the given message.
example=[source,sql]\n----\nERROR 'something went wrong'\n----\n
*/
  final public RaiseStatement errorStatement(ParseInfo info) throws ParseException {
    Expression errMsg = null;
    jj_consume_token(ERROR);
    errMsg = expression(info);
        ExceptionExpression ee = new ExceptionExpression();
        ee.setMessage(errMsg);
        {if (true) return new RaiseStatement(ee);}
    throw new Error("Missing return statement in function");
  }

/*
name=raise statement
description=Raises an error or warning with the given message.
example=[source,sql]\n----\nRAISE SQLEXCEPTION 'something went wrong'\n----\n
*/
  final public RaiseStatement raiseStatement(ParseInfo info) throws ParseException {
    Expression err = null;
    boolean warning = false;
    jj_consume_token(RAISE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQLWARNING:
      jj_consume_token(SQLWARNING);
                   warning = true;
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    err = exceptionReference(info);
        {if (true) return new RaiseStatement(err, warning);}
    throw new Error("Missing return statement in function");
  }

/*
name=exception reference
description=a reference to an exception
example=[source,sql]\n----\nSQLEXCEPTION 'something went wrong' SQLSTATE '00X', 2\n----\n
*/
  final public Expression exceptionReference(ParseInfo info) throws ParseException {
        String id = null;
        Expression ex;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
      id = id(null);
                       {if (true) return new ElementSymbol(id);}
      break;
    case SQLEXCEPTION:
      ex = exception(info);
                {if (true) return ex;}
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=sql exception
description=creates a sql exception or warning with the specified message, state, and code
example=[source,sql]\n----\nSQLEXCEPTION 'something went wrong' SQLSTATE '00X', 2\n----\n
*/
  final public Expression exception(ParseInfo info) throws ParseException {
        Expression err = null;
        Expression sqlState = null;
        Expression errCode = null;
        Expression parent = null;
    jj_consume_token(SQLEXCEPTION);
    err = commonValueExpression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQLSTATE:
      jj_consume_token(SQLSTATE);
      sqlState = commonValueExpression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        errCode = commonValueExpression(info);
        break;
      default:
        jj_la1[22] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAIN:
      jj_consume_token(CHAIN);
      parent = exceptionReference(info);
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
                ExceptionExpression ee = new ExceptionExpression();
                ee.setMessage(err);
                ee.setSqlState(sqlState);
                ee.setErrorCode(errCode);
                ee.setParent(parent);
                {if (true) return ee;}
    throw new Error("Missing return statement in function");
  }

/*
name=statement
description=A procedure statement.
example=[source,sql]\n----\nIF (x = 5) BEGIN ... END\n----\n
*/
  final public Statement statement(ParseInfo info) throws ParseException {
    Statement stmt = null;
    String label = null;
    if (jj_2_6(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case PRESERVE:
      case ID:
        label = id(null);
        jj_consume_token(COLON);
        break;
      default:
        jj_la1[25] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOOP:
        stmt = loopStatement(info);
        break;
      case WHILE:
        stmt = whileStatement(info);
        break;
      case BEGIN:
        stmt = compoundStatement(info);
        break;
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                ((Statement.Labeled)stmt).setLabel(label);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case BEGIN:
      case BREAK:
      case CALL:
      case CONTINUE:
      case CREATE:
      case DECLARE:
      case DELETE:
      case DROP:
      case ERROR:
      case EXEC:
      case EXECUTE:
      case IF:
      case INSERT:
      case LEAVE:
      case MERGE:
      case RETURN:
      case SELECT:
      case TABLE:
      case UPDATE:
      case VALUES:
      case WITH:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case PRESERVE:
      case ID:
      case LPAREN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IF:
          stmt = ifStatement(info);
          break;
        case ALTER:
        case BEGIN:
        case BREAK:
        case CALL:
        case CONTINUE:
        case CREATE:
        case DECLARE:
        case DELETE:
        case DROP:
        case ERROR:
        case EXEC:
        case EXECUTE:
        case INSERT:
        case LEAVE:
        case MERGE:
        case RETURN:
        case SELECT:
        case TABLE:
        case UPDATE:
        case VALUES:
        case WITH:
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case PRESERVE:
        case ID:
        case LPAREN:
          stmt = delimitedStatement(info);
          break;
        default:
          jj_la1[27] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/*
name=delimited statement
description=A procedure statement terminated by ;.
example=[source,sql]\n----\nSELECT * FROM tbl;\n----\n
*/
  final public Statement delimitedStatement(ParseInfo info) throws ParseException {
    Statement stmt = null;
    if (jj_2_7(2)) {
      stmt = assignStatement(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case BEGIN:
      case CALL:
      case CREATE:
      case DELETE:
      case DROP:
      case EXEC:
      case EXECUTE:
      case INSERT:
      case MERGE:
      case SELECT:
      case TABLE:
      case UPDATE:
      case VALUES:
      case WITH:
      case LPAREN:
        stmt = sqlStatement(info);
        break;
      case ERROR:
        stmt = errorStatement(info);
        break;
      case RAISE:
        stmt = raiseStatement(info);
        break;
      case DECLARE:
        stmt = declareStatement(info);
        break;
      case BREAK:
      case CONTINUE:
      case LEAVE:
        stmt = branchingStatement(info);
        break;
      case RETURN:
        stmt = returnStatement(info);
        break;
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(SEMICOLON);
             {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/*
name=compound statement
description=A procedure statement block contained in BEGIN END.
example=[source,sql]\n----\nBEGIN NOT ATOMIC ... END\n----\n
*/
  final public Block compoundStatement(ParseInfo info) throws ParseException {
    Statement stmt = null;
    Block block = new Block();
    Boolean atomic = null;
    String eId = null;
    jj_consume_token(BEGIN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ATOMIC:
    case NOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                     atomic = Boolean.FALSE;
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      jj_consume_token(ATOMIC);
                                                         if (atomic == null) {atomic = Boolean.TRUE;}
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    label_3:
    while (true) {
      if (jj_2_8(2)) {
        ;
      } else {
        break label_3;
      }
      stmt = statement(info);
            block.addStatement(stmt, false);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCEPTION:
      jj_consume_token(EXCEPTION);
      eId = id(Boolean.FALSE);
                                              block.setExceptionGroup(eId);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALTER:
        case BEGIN:
        case BREAK:
        case CALL:
        case CONTINUE:
        case CREATE:
        case DECLARE:
        case DELETE:
        case DROP:
        case ERROR:
        case EXEC:
        case EXECUTE:
        case IF:
        case INSERT:
        case LEAVE:
        case LOOP:
        case MERGE:
        case RETURN:
        case SELECT:
        case TABLE:
        case UPDATE:
        case VALUES:
        case WITH:
        case WHILE:
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case PRESERVE:
        case ID:
        case LPAREN:
          ;
          break;
        default:
          jj_la1[32] = jj_gen;
          break label_4;
        }
        stmt = statement(info);
             block.addStatement(stmt, true);
      }
      break;
    default:
      jj_la1[33] = jj_gen;
      ;
    }
    jj_consume_token(END);
        if (atomic != null) {
                block.setAtomic(atomic);
        }
        {if (true) return block;}
    throw new Error("Missing return statement in function");
  }

/*
name=branching statement
description=A procedure branching control statement, which typically specifies a label to return control to.
example=[source,sql]\n----\nBREAK x\n----\n
*/
  final public BranchingStatement branchingStatement(ParseInfo info) throws ParseException {
    BranchingStatement breakStmt = new BranchingStatement();
    Token mode = null;
    String label = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BREAK:
    case CONTINUE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BREAK:
        mode = jj_consume_token(BREAK);
        break;
      case CONTINUE:
        mode = jj_consume_token(CONTINUE);
        break;
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case PRESERVE:
      case ID:
        label = id(null);
        break;
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      break;
    case LEAVE:
      mode = jj_consume_token(LEAVE);
      label = id(null);
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            breakStmt.setMode(BranchingStatement.BranchingMode.valueOf(mode.image.toUpperCase()));
            breakStmt.setLabel(label);
                {if (true) return breakStmt;}
    throw new Error("Missing return statement in function");
  }

/*
name=return statement
description=A return statement.
example=[source,sql]\n----\nRETURN 1\n----\n
*/
  final public ReturnStatement returnStatement(ParseInfo info) throws ParseException {
    Expression ex = null;
    jj_consume_token(RETURN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCAST:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLEXISTS:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case XMLTEXT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      ex = expression(info);
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
            {if (true) return new ReturnStatement(ex);}
    throw new Error("Missing return statement in function");
  }

/*
name=while statement
description=A procedure while statement that executes until its condition is false.
example=[source,sql]\n----\nWHILE (var) BEGIN ... END\n----\n
*/
  final public WhileStatement whileStatement(ParseInfo info) throws ParseException {
    WhileStatement whileStmt = null;
    Criteria criteria = null;
    Statement stmt = null;
    jj_consume_token(WHILE);
    jj_consume_token(LPAREN);
    criteria = criteria(info);
    jj_consume_token(RPAREN);
    stmt = statement(info);
        whileStmt = new WhileStatement(criteria, asBlock(stmt));
        {if (true) return whileStmt;}
    throw new Error("Missing return statement in function");
  }

/*
name=loop statement
description=A procedure loop statement that executes over the given cursor.
example=[source,sql]\n----\nLOOP ON (SELECT * FROM tbl) AS x BEGIN ... END\n----\n
*/
  final public LoopStatement loopStatement(ParseInfo info) throws ParseException {
    LoopStatement loopStmt = null;
    String cursor = null;
    QueryCommand query = null;
    Statement stmt = null;
    jj_consume_token(LOOP);
    jj_consume_token(ON);
    jj_consume_token(LPAREN);
    query = queryExpression(info);
    jj_consume_token(RPAREN);
    jj_consume_token(AS);
    cursor = id(null);
    stmt = statement(info);
        loopStmt = new LoopStatement(asBlock(stmt), query, cursor);
        {if (true) return loopStmt;}
    throw new Error("Missing return statement in function");
  }

/*
name=if statement
description=A procedure loop statement that executes over the given cursor.
example=[source,sql]\n----\nIF (boolVal) BEGIN variables.x = 1 END ELSE BEGIN variables.x = 2 END\n----\n
*/
  final public IfStatement ifStatement(ParseInfo info) throws ParseException {
    IfStatement ifStmt = null;
    Criteria criteria = null;
    Statement ifStatement = null;
    Statement elseStatement = null;
    String groupID = null;
    String groupID2 = null;
    boolean not = false;
    jj_consume_token(IF);
    jj_consume_token(LPAREN);
    if (jj_2_9(4)) {
      groupID = id(null);
      jj_consume_token(IS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                                                   not = true;
        break;
      default:
        jj_la1[38] = jj_gen;
        ;
      }
      jj_consume_token(DISTINCT);
      jj_consume_token(FROM);
      groupID2 = id(null);
        IsDistinctCriteria idc = new IsDistinctCriteria();
        idc.setLeftRowValue(new GroupSymbol(groupID));
        idc.setRightRowValue(new GroupSymbol(groupID2));
        idc.setNegated(not);
        criteria = idc;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case CAST:
      case CONVERT:
      case ANY:
      case ARRAY_AGG:
      case CASE:
      case EXISTS:
      case FALSE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case NOT:
      case NULL:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case TRUE:
      case UNKNOWN:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCAST:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLEXISTS:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case XMLTEXT:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case PRESERVE:
      case ID:
      case ESCAPEDFUNCTION:
      case ESCAPEDTYPE:
      case DECIMALVAL:
      case FLOATVAL:
      case STRINGVAL:
      case UNSIGNEDINTEGER:
      case BINARYSTRINGVAL:
      case LPAREN:
      case PLUS:
      case MINUS:
      case QMARK:
      case DOLLAR:
        criteria = criteria(info);
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
    ifStatement = statement(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      elseStatement = statement(info);
      break;
    default:
      jj_la1[40] = jj_gen;
      ;
    }
        ifStmt = new IfStatement(criteria, asBlock(ifStatement));
        ifStmt.setElseBlock(asBlock(elseStatement));
        {if (true) return ifStmt;}
    throw new Error("Missing return statement in function");
  }

/*
name=declare statement
description=A procedure declaration statement that creates a variable and optionally assigns a value.
example=[source,sql]\n----\nDECLARE STRING x = 'a'\n----\n
*/
  final public DeclareStatement declareStatement(ParseInfo info) throws ParseException {
    DeclareStatement declStmt = null;
    String var = null;
    ParsedDataType type = null;
    ElementSymbol variableID = null;
    LanguageObject value = null;
    jj_consume_token(DECLARE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
    case VARBINARY:
    case VARCHAR:
    case BOOLEAN:
    case BYTE:
    case TINYINT:
    case SHORT:
    case SMALLINT:
    case CHAR:
    case INTEGER:
    case LONG:
    case BIGINT:
    case BIGINTEGER:
    case FLOAT:
    case REAL:
    case DOUBLE:
    case BIGDECIMAL:
    case DECIMAL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case OBJECT:
    case BLOB:
    case CLOB:
    case XML:
    case GEOMETRY:
      type = parseDataType();
      break;
    case EXCEPTION:
      jj_consume_token(EXCEPTION);
                                           type = new ParsedDataType(getToken(0).image);
      break;
    default:
      jj_la1[41] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    var = id(null);
        variableID = new ElementSymbol(var);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      jj_consume_token(EQ);
      value = assignStatementOperand(info);
      break;
    default:
      jj_la1[42] = jj_gen;
      ;
    }
        if (value instanceof Expression) {
                {if (true) return new DeclareStatement(variableID, type.type, (Expression)value);}
        }
        if (value instanceof QueryCommand) {
                {if (true) return new DeclareStatement(variableID, type.type, new ScalarSubquery((QueryCommand)value));}
        }
        {if (true) return new DeclareStatement(variableID, type.type, (Command)value);}
    throw new Error("Missing return statement in function");
  }

/*
name=assignment statement
description=Assigns a variable a value in a procedure.
example=[source,sql]\n----\nx = 'b'\n----\n
*/
  final public Statement assignStatement(ParseInfo info) throws ParseException {
    LanguageObject value = null;
    String var = null;
    ElementSymbol elementID = null;
    boolean returnable=true;
    var = id(null);
        elementID = new ElementSymbol(var);
    jj_consume_token(EQ);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case DELETE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MERGE:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SELECT:
    case SOME:
    case SQLEXCEPTION:
    case TABLE:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case UPDATE:
    case VALUES:
    case WITH:
    case YEAR:
    case XMLAGG:
    case XMLCAST:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLEXISTS:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case XMLTEXT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      value = assignStatementOperand(info);
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      value = storedProcedure(info, 2);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
      case WITHOUT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WITH:
          jj_consume_token(WITH);
          break;
        case WITHOUT:
          jj_consume_token(WITHOUT);
                                                           returnable = false;
          break;
        default:
          jj_la1[43] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RETURN);
        break;
      default:
        jj_la1[44] = jj_gen;
        ;
      }
                StoredProcedure storedProcedure = (StoredProcedure)value;
            SPParameter parameter = new SPParameter(1, SPParameter.RETURN_VALUE, "return"); //$NON-NLS-1$
            parameter.setExpression(elementID);
                storedProcedure.setParameter(parameter);
                storedProcedure.setCalledWithReturn(true);
                CommandStatement cs = new CommandStatement(storedProcedure);
                cs.setReturnable(returnable);
                {if (true) return cs;}
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (value instanceof Expression) {
                {if (true) return new AssignmentStatement(elementID, (Expression)value);}
        }
        if (value instanceof QueryCommand) {
                {if (true) return new AssignmentStatement(elementID, (QueryCommand)value);}
        }
        {if (true) return new AssignmentStatement(elementID, (Command)value);}
    throw new Error("Missing return statement in function");
  }

/*
name=assignment statement operand
description=A value or command that can be used in an assignment.  {note}All assigments except for expression are deprecated.{note}
*/
  final public LanguageObject assignStatementOperand(ParseInfo info) throws ParseException {
    LanguageObject value = null;
    if (jj_2_10(2147483647)) {
      value = insert(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPDATE:
        //deprecated
              value = update(info);
        break;
      case DELETE:
        //deprecated
              value = delete(info);
        break;
      case CHAR:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case CAST:
      case CONVERT:
      case ANY:
      case ARRAY_AGG:
      case CASE:
      case EXISTS:
      case FALSE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case NOT:
      case NULL:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case TRUE:
      case UNKNOWN:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCAST:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLEXISTS:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case XMLTEXT:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case PRESERVE:
      case ID:
      case ESCAPEDFUNCTION:
      case ESCAPEDTYPE:
      case DECIMALVAL:
      case FLOATVAL:
      case STRINGVAL:
      case UNSIGNEDINTEGER:
      case BINARYSTRINGVAL:
      case LPAREN:
      case PLUS:
      case MINUS:
      case QMARK:
      case DOLLAR:
        value = expression(info);
        break;
      case SELECT:
      case TABLE:
      case VALUES:
      case WITH:
        value = queryExpression(info);
        break;
      case SQLEXCEPTION:
        //deprecated should be a scalar subquery
              value = exception(info);
        break;
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/*
name=data statement
description=A procedure statement that executes a SQL statement.  An update statement can have its update count accessed via the ROWCOUNT variable. 
*/
  final public CommandStatement sqlStatement(ParseInfo info) throws ParseException {
    Command cmd = null;
    String var = null;
    ElementSymbol elementID = null;
    StoredProcedure storedProcedure = null;
    boolean returnable = true;
    if (jj_2_11(2)) {
      cmd = userCommand(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXEC:
      case EXECUTE:
        cmd = dynamicCommand(info);
        break;
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
    case WITHOUT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
        break;
      case WITHOUT:
        jj_consume_token(WITHOUT);
                          returnable = false;
        break;
      default:
        jj_la1[48] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RETURN);
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
        CommandStatement cs = new CommandStatement(cmd);
        cs.setReturnable(returnable);
        {if (true) return cs;}
    throw new Error("Missing return statement in function");
  }

/*
unused=true
*/
  final public CreateProcedureCommand createProcedure(ParseInfo info) throws ParseException {
    CreateProcedureCommand procCmd =
        new CreateProcedureCommand();
    Statement stmt = null;
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VIRTUAL:
      jj_consume_token(VIRTUAL);
      break;
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    jj_consume_token(PROCEDURE);
    stmt = statement(info);
        procCmd.setBlock(asBlock(stmt));
        {if (true) return procCmd;}
    throw new Error("Missing return statement in function");
  }

/*
name=procedure body definition
description=Defines a procedure body on a Procedure metadata object.
example=[source,sql]\n----\nBEGIN ... END\n----\n
index=true
*/
  final public CreateProcedureCommand procedureBodyCommand(ParseInfo info) throws ParseException {
    CreateProcedureCommand procCmd =
        new CreateProcedureCommand();
    Statement stmt = null;
    if (jj_2_12(2)) {
      jj_consume_token(CREATE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        break;
      default:
        jj_la1[51] = jj_gen;
        ;
      }
      jj_consume_token(PROCEDURE);
    } else {
      ;
    }
    stmt = statement(info);
        procCmd.setBlock(asBlock(stmt));
        {if (true) return procCmd;}
    throw new Error("Missing return statement in function");
  }

/*
name=dynamic data statement
description=A procedure statement that can execute arbitrary sql.
example=[source,sql]\n----\nEXECUTE IMMEDIATE 'SELECT * FROM tbl' AS x STRING INTO #temp\n----\n
*/
  final public DynamicCommand dynamicCommand(ParseInfo info) throws ParseException {
    Expression sql = null;
    String groupID = null;
        GroupSymbol group = null;
        int updateCount = 0;
        List<TableFunctionReference.ProjectedColumn> elements = null;
        SetClauseList using = null;
        DynamicCommand dcStmt = new DynamicCommand();
        SetClauseList setClauseList = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXECUTE:
      jj_consume_token(EXECUTE);
      break;
    case EXEC:
      jj_consume_token(EXEC);
      break;
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
    case IMMEDIATE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        jj_consume_token(STRING);
        break;
      case IMMEDIATE:
        jj_consume_token(IMMEDIATE);
        break;
      default:
        jj_la1[53] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[54] = jj_gen;
      ;
    }
    sql = expression(info);
        dcStmt.setSql(sql);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      elements = createElementsWithTypes(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTO:
        jj_consume_token(INTO);
        groupID = id(null);
         group = new GroupSymbol(groupID);
        break;
      default:
        jj_la1[55] = jj_gen;
        ;
      }
         dcStmt.setIntoGroup(group);
         List<ElementSymbol> symbols = new ArrayList(elements.size());
         for (TableFunctionReference.ProjectedColumn col : elements) {
                symbols.add(col.getSymbol());
         }
         dcStmt.setAsColumns(symbols);
         dcStmt.setAsClauseSet(true);
      break;
    default:
      jj_la1[56] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USING:
      jj_consume_token(USING);
      using = setClauseList(true, info);
             dcStmt.setUsing(using);
      break;
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UPDATE:
      jj_consume_token(UPDATE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNSIGNEDINTEGER:
        updateCount = intVal();
        break;
      case STAR:
        jj_consume_token(STAR);
        updateCount = 2;
        break;
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[59] = jj_gen;
      ;
    }
        dcStmt.setUpdatingModelCount(updateCount);
        {if (true) return dcStmt;}
    throw new Error("Missing return statement in function");
  }

/*
name=set clause list
description=A list of value assignments.
example=[source,sql]\n----\ncol1 = 'x', col2 = 'y' ...\n----\n
*/
  final public SetClauseList setClauseList(boolean shortName, ParseInfo info) throws ParseException {
        SetClauseList using = new SetClauseList();
        String element = null;
        Expression value = null;
    element = id(shortName?Boolean.TRUE:null);
    jj_consume_token(EQ);
    value = expression(info);
        ElementSymbol symbol = new ElementSymbol(element);
        using.addClause(symbol, value);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[60] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      element = id(null);
      jj_consume_token(EQ);
      value = expression(info);
          symbol = new ElementSymbol(element);
          using.addClause(symbol, value);
    }
                {if (true) return using;}
    throw new Error("Missing return statement in function");
  }

/*
name=typed element list
description=A list of typed elements.
example=[source,sql]\n----\ncol1 string, col2 integer ...\n----\n
*/
  final public List<TableFunctionReference.ProjectedColumn> createElementsWithTypes(ParseInfo info) throws ParseException {
        String element = null;
        ParsedDataType type = null;
        List<TableFunctionReference.ProjectedColumn> elements = new ArrayList<TableFunctionReference.ProjectedColumn>();
    element = id(Boolean.TRUE);
    type = parseDataType();
            TableFunctionReference.ProjectedColumn symbol = new TableFunctionReference.ProjectedColumn(element, type.type);
                elements.add(symbol);
    label_6:
    while (true) {
      if (jj_2_13(2)) {
        ;
      } else {
        break label_6;
      }
      jj_consume_token(COMMA);
      element = id(Boolean.TRUE);
      type = parseDataType();
              symbol = new TableFunctionReference.ProjectedColumn(element, type.type);
                  elements.add(symbol);
    }
                {if (true) return elements;}
    throw new Error("Missing return statement in function");
  }

/*
name=callable statement
description=A callable statement defined using JDBC escape syntax.
example=[source,sql]\n----\n{? = CALL proc}\n----\n
index=true
*/
  final public StoredProcedure callableStatement(ParseInfo info) throws ParseException {
        StoredProcedure storedProcedure = new StoredProcedure();
        storedProcedure.setCallableStatement(true);
        String procName = null;
        Option option = null;
        SPParameter parameter = null;
        int parameterIndex = 1;
        List<Expression> values = null;
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      jj_consume_token(QMARK);
      jj_consume_token(EQ);
           parameter = new SPParameter(parameterIndex++, SPParameter.RETURN_VALUE, "return"); //$NON-NLS-1$
           storedProcedure.setParameter(parameter);
           storedProcedure.setCalledWithReturn(true);
      break;
    default:
      jj_la1[61] = jj_gen;
      ;
    }
    jj_consume_token(CALL);
    procName = id(null);
                storedProcedure.setProcedureName(procName);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      if (jj_2_14(2)) {
        executeNamedParams(info, storedProcedure, parameterIndex);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHAR:
        case DATE:
        case TIME:
        case TIMESTAMP:
        case CAST:
        case CONVERT:
        case ANY:
        case ARRAY_AGG:
        case CASE:
        case EXISTS:
        case FALSE:
        case HOUR:
        case INSERT:
        case LEFT:
        case MINUTE:
        case MONTH:
        case NOT:
        case NULL:
        case RIGHT:
        case SECOND:
        case SOME:
        case TRANSLATE:
        case TRUE:
        case UNKNOWN:
        case USER:
        case YEAR:
        case XMLAGG:
        case XMLCAST:
        case XMLCONCAT:
        case XMLCOMMENT:
        case XMLELEMENT:
        case XMLEXISTS:
        case XMLFOREST:
        case XMLPARSE:
        case XMLPI:
        case XMLQUERY:
        case XMLSERIALIZE:
        case XMLTEXT:
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case PRESERVE:
        case ID:
        case ESCAPEDFUNCTION:
        case ESCAPEDTYPE:
        case DECIMALVAL:
        case FLOATVAL:
        case STRINGVAL:
        case UNSIGNEDINTEGER:
        case BINARYSTRINGVAL:
        case LPAREN:
        case PLUS:
        case MINUS:
        case QMARK:
        case DOLLAR:
          values = expressionList(info);
                                         convertToParameters(values, storedProcedure, parameterIndex);
          break;
        default:
          jj_la1[62] = jj_gen;
          ;
        }
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[63] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option = option(info);
           storedProcedure.setOption(option);
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
                {if (true) return storedProcedure;}
    throw new Error("Missing return statement in function");
  }

/*
name=call statement
description=Executes the procedure with the given parameters.
example=[source,sql]\n----\nCALL proc('a', 1)\n----\n
*/
  final public StoredProcedure storedProcedure(ParseInfo info, int startIndex) throws ParseException {
        String procName = null;
        Option option = null;
        List<Expression> values = null;
        StoredProcedure storedProcedure = new StoredProcedure();
        SourceHint sourceHint = null;
          sourceHint = getSourceHint(this);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXEC:
      jj_consume_token(EXEC);
      break;
    case EXECUTE:
      jj_consume_token(EXECUTE);
      break;
    case CALL:
      jj_consume_token(CALL);
      break;
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    procName = id(null);
                        storedProcedure.setProcedureName(procName);
    jj_consume_token(LPAREN);
    if (jj_2_15(2)) {
      executeNamedParams(info, storedProcedure, startIndex);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAR:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case CAST:
      case CONVERT:
      case ANY:
      case ARRAY_AGG:
      case CASE:
      case EXISTS:
      case FALSE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case NOT:
      case NULL:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case TRUE:
      case UNKNOWN:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCAST:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLEXISTS:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case XMLTEXT:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case PRESERVE:
      case ID:
      case ESCAPEDFUNCTION:
      case ESCAPEDTYPE:
      case DECIMALVAL:
      case FLOATVAL:
      case STRINGVAL:
      case UNSIGNEDINTEGER:
      case BINARYSTRINGVAL:
      case LPAREN:
      case PLUS:
      case MINUS:
      case QMARK:
      case DOLLAR:
        values = expressionList(info);
                                                  convertToParameters(values, storedProcedure, startIndex);
        break;
      default:
        jj_la1[66] = jj_gen;
        ;
      }
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option = option(info);
           storedProcedure.setOption(option);
      break;
    default:
      jj_la1[67] = jj_gen;
      ;
    }
                storedProcedure.setSourceHint(sourceHint);
                {if (true) return storedProcedure;}
    throw new Error("Missing return statement in function");
  }

/*
name=named parameter list
description=A list of named parameters.
example=[source,sql]\n----\nparam1 => 'x', param2 => 1\n----\n
*/
  final public void executeNamedParams(ParseInfo info, StoredProcedure storedProcedure, int parameterIndex) throws ParseException {
        String name = null;
    Expression value = null;
        SPParameter parameter = null;
                storedProcedure.setDisplayNamedParameters(true);
    name = id(null);
    jj_consume_token(EQ);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GT:
      jj_consume_token(GT);
      break;
    default:
      jj_la1[68] = jj_gen;
      ;
    }
    value = expression(info);
                        parameter = new SPParameter(parameterIndex++, value);
                        parameter.setName(name);
                        parameter.setParameterType(SPParameter.IN);
                        storedProcedure.setParameter(parameter);
                        parameter = null;
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[69] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
      name = id(null);
      jj_consume_token(EQ);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
        jj_consume_token(GT);
        break;
      default:
        jj_la1[70] = jj_gen;
        ;
      }
      value = expression(info);
                                parameter = new SPParameter(parameterIndex++, value);
                                parameter.setName(name);
                                parameter.setParameterType(SPParameter.IN);
                                storedProcedure.setParameter(parameter);
                                parameter = null;
    }
  }

/*
name=insert statement
description=Inserts values into the given target.
example=[source,sql]\n----\nINSERT INTO tbl (col1, col2) VALUES ('a', 1)\n----\n
*/
  final public Insert insert(ParseInfo info) throws ParseException {
        Insert insert = new Insert();
        boolean merge = false;
        String group = null;
        List values = null;
        List<ElementSymbol> columns = null;
        Option option = null;
        QueryCommand query = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      jj_consume_token(INSERT);
      break;
    case MERGE:
      jj_consume_token(MERGE);
                          merge=true;
      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(INTO);
    group = id(null);
    if (jj_2_16(2147483647)) {
      columns = columnList(false, true);
          insert.setVariables(columns);
    } else {
      ;
    }
    query = queryExpression(info);
          insert.setQueryExpression(query);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option = option(info);
            insert.setOption(option);
      break;
    default:
      jj_la1[72] = jj_gen;
      ;
    }
                // Store group
                insert.setGroup(new GroupSymbol(group) );
                insert.setMerge(merge);
                {if (true) return insert;}
    throw new Error("Missing return statement in function");
  }

/*
name=expression list
description=A list of expressions.
example=[source,sql]\n----\ncol1, 'a', ...\n----\n
*/
  final public ArrayList<Expression> expressionList(ParseInfo info) throws ParseException {
        ArrayList<Expression> rowVals = new ArrayList<Expression>(4);
        Expression value = null;
    value = expression(info);
        rowVals.add(value);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[73] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      value = expression(info);
            rowVals.add(value);
    }
                {if (true) return rowVals;}
    throw new Error("Missing return statement in function");
  }

/*
name=update statement
description=Update values in the given target.
example=[source,sql]\n----\nUPDATE tbl SET (col1 = 'a') WHERE col2 = 1\n----\n
*/
  final public Update update(ParseInfo info) throws ParseException {
        Update update = new Update();
        String group = null;
        SetClauseList setClauseList = null;
        Criteria criteria = null;
        Option option = null;
    jj_consume_token(UPDATE);
    group = id(null);
    jj_consume_token(SET);
    setClauseList = setClauseList(false, info);
                update.setChangeList(setClauseList);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      criteria = where(info);
      break;
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option = option(info);
           update.setOption(option);
      break;
    default:
      jj_la1[75] = jj_gen;
      ;
    }
                // Store group
                update.setGroup(new GroupSymbol( group) );

                // Store optional criteria
                if(criteria != null) {
                        update.setCriteria(criteria);
                }

                {if (true) return update;}
    throw new Error("Missing return statement in function");
  }

/*
name=delete statement
description=Delete rows from the given target.
example=[source,sql]\n----\nDELETE FROM tbl WHERE col2 = 1\n----\n
*/
  final public Delete delete(ParseInfo info) throws ParseException {
        String group = null;
        Criteria criteria = null;
        Delete delete = new Delete();
        Option option = null;
    jj_consume_token(DELETE);
    jj_consume_token(FROM);
    group = id(null);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      criteria = where(info);
      break;
    default:
      jj_la1[76] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTION:
      option = option(info);
           delete.setOption(option);
      break;
    default:
      jj_la1[77] = jj_gen;
      ;
    }
                delete.setGroup(new GroupSymbol(group));
                delete.setCriteria(criteria);

        {if (true) return delete;}
    throw new Error("Missing return statement in function");
  }

/*
name=query expression
description=A declarative query for data.
example=[source,sql]\n----\nSELECT * FROM tbl WHERE col2 = 1\n----\n
*/
  final public QueryCommand queryExpression(ParseInfo info) throws ParseException {
        QueryCommand query = null;
        List<WithQueryCommand> withList = null;
        WithQueryCommand withQueryCommand = null;
        SourceHint sourceHint = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      withQueryCommand = withListElement(info);
            withList = new LinkedList<WithQueryCommand>();
            withList.add(withQueryCommand);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[78] = jj_gen;
          break label_9;
        }
        jj_consume_token(COMMA);
        withQueryCommand = withListElement(info);
            withList.add(withQueryCommand);
      }
      break;
    default:
      jj_la1[79] = jj_gen;
      ;
    }
          sourceHint = getSourceHint(this);
    query = queryExpressionBody(info);
                query.setWith(withList);
                setSourceHint(sourceHint, query);
                {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

/*
name=with list element
description=A query expression for use in the enclosing query. 
example=[source,sql]\n----\nX (Y, Z) AS (SELECT 1, 2)\n----\n
*/
  final public WithQueryCommand withListElement(ParseInfo info) throws ParseException {
   String name = null;
   List<ElementSymbol> columns = null;
   QueryCommand queryExpression = null;
   Token lparen = null;
    name = id(Boolean.FALSE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      columns = columnList(true, true);
      break;
    default:
      jj_la1[80] = jj_gen;
      ;
    }
    jj_consume_token(AS);
    lparen = jj_consume_token(LPAREN);
    queryExpression = queryExpression(info);
    jj_consume_token(RPAREN);
            WithQueryCommand result = new WithQueryCommand(new GroupSymbol(name), columns, queryExpression);
            result.setNoInline(isNoInline(lparen));
            {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=query expression body
description=The body of a query expression, which can optionally be ordered and limited.
example=[source,sql]\n----\nSELECT * FROM tbl ORDER BY col1 LIMIT 1\n----\n
*/
  final public QueryCommand queryExpressionBody(ParseInfo info) throws ParseException {
    QueryCommand query = null;
    QueryCommand rightQuery = null;
    boolean all = false;
    Option option = null;
        OrderBy orderby = null;
        Limit limit = null;
        SetQuery.Operation type;
    query = queryTerm(info);
    label_10:
    while (true) {
      if (jj_2_17(1)) {
        ;
      } else {
        break label_10;
      }
      if (jj_2_18(2147483647) && (getToken(2).kind != JOIN)) {
        jj_consume_token(UNION);
                                                                              type = SetQuery.Operation.UNION;
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXCEPT:
          jj_consume_token(EXCEPT);
                                                                                                                              type = SetQuery.Operation.EXCEPT;
          break;
        default:
          jj_la1[81] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
                         all = true;
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
          break;
        default:
          jj_la1[82] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[83] = jj_gen;
        ;
      }
      rightQuery = queryTerm(info);
                        query = addQueryToSetOperation(query, rightQuery, type, all);
                all = false;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderby = orderby(info);
                               query.setOrderBy( orderby );
      break;
    default:
      jj_la1[84] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FETCH:
    case LIMIT:
    case OFFSET:
      limit = limit(info);
                             query.setLimit( limit );
      break;
    default:
      jj_la1[85] = jj_gen;
      ;
    }
    if (jj_2_19(2147483647)) {
      option = option(info);
                                                 query.setOption(option);
    } else {
      ;
    }
                {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

/*
name=query term
description=Used to establish INTERSECT precedence.
example=[source,sql]\n----\nSELECT * FROM tbl\n----\n\n[source,sql]\n----\nSELECT * FROM tbl1 INTERSECT SELECT * FROM tbl2\n----\n
*/
  final public QueryCommand queryTerm(ParseInfo info) throws ParseException {
    QueryCommand query = null;
    QueryCommand rightQuery = null;
    boolean all = false;
    query = queryPrimary(info);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERSECT:
        ;
        break;
      default:
        jj_la1[86] = jj_gen;
        break label_11;
      }
      jj_consume_token(INTERSECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
                         all = true;
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
          break;
        default:
          jj_la1[87] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[88] = jj_gen;
        ;
      }
      rightQuery = queryPrimary(info);
                        query = addQueryToSetOperation(query, rightQuery, SetQuery.Operation.INTERSECT, all);
                all = false;
    }
        {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

/*
name=query primary
description=A declarative source of rows.
example=[source,sql]\n----\nTABLE tbl\n----\n\n[source,sql]\n----\nSELECT * FROM tbl1\n----\n
*/
  final public QueryCommand queryPrimary(ParseInfo info) throws ParseException {
    QueryCommand query = null;
    String name = null;
    List<Expression> expr = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      query = query(info);
      break;
    case VALUES:
      jj_consume_token(VALUES);
      jj_consume_token(LPAREN);
      expr = expressionList(info);
           query = Query.rowConstructor(expr);
      jj_consume_token(RPAREN);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[89] = jj_gen;
          break label_12;
        }
        jj_consume_token(COMMA);
        jj_consume_token(LPAREN);
        expr = expressionList(info);
             query = new SetQuery(SetQuery.Operation.UNION, true, query, Query.rowConstructor(expr));
        jj_consume_token(RPAREN);
      }
      break;
    case TABLE:
      jj_consume_token(TABLE);
      name = id(null);
           Query q = new Query();
           q.setSelect(new Select(Arrays.asList(new MultipleElementSymbol())));
           q.setFrom(new From(Arrays.asList(new UnaryFromClause(new GroupSymbol(name)))));
           query = q;
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      query = queryExpressionBody(info);
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[90] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

/*
name=query
description=A SELECT query.
example=[source,sql]\n----\nSELECT col1, max(col2) FROM tbl GROUP BY col1\n----\n
*/
  final public Query query(ParseInfo info) throws ParseException {
        Select   select         = null;
        From     from           = null;
        Into     into                   = null;
        Criteria criteria       = null;
        GroupBy  groupBy        = null;
        Criteria having         = null;
    select = select(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTO:
      into = into(info);
      break;
    default:
      jj_la1[91] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      from = from(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        criteria = where(info);
        break;
      default:
        jj_la1[92] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GROUP:
        groupBy = groupBy(info);
        break;
      default:
        jj_la1[93] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HAVING:
        having = having(info);
        break;
      default:
        jj_la1[94] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[95] = jj_gen;
      ;
    }
                // Build query from parsed pieces
                Query query = new Query();
                query.setSelect( select );
                query.setFrom( from );
                query.setInto( into );
                query.setCriteria(criteria);
                query.setGroupBy(groupBy);
                query.setHaving(having);

                {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

/*
name=into clause
description=Used to direct the query into a table.  {note}This is deprecated.  Use INSERT INTO with a query expression instead.{note}
example=[source,sql]\n----\nINTO tbl\n----\n
*/
  final public Into into(ParseInfo info) throws ParseException {
        String groupID = null;
        Into into = null;
    jj_consume_token(INTO);
    groupID = id(null);
        into = new Into(new GroupSymbol(groupID));
                {if (true) return into;}
    throw new Error("Missing return statement in function");
  }

/*
name=select clause
description=The columns returned by a query.  Can optionally be distinct.
example=[source,sql]\n----\nSELECT *\n----\n\n[source,sql]\n----\nSELECT DISTINCT a, b, c\n----\n
 */
  final public Select select(ParseInfo info) throws ParseException {
        boolean isDistinct = false;             // unless DISTINCT keyword in SELECT
        Expression symbol = null;
        Select select = new Select();
    jj_consume_token(SELECT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                              isDistinct=true;
        break;
      default:
        jj_la1[96] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[97] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
                        select.addSymbol(new MultipleElementSymbol());
      break;
    case CHAR:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCAST:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLEXISTS:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case XMLTEXT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ALL_IN_GROUP:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      symbol = selectSymbol(info);
                                                         select.addSymbol(symbol);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[98] = jj_gen;
          break label_13;
        }
        jj_consume_token(COMMA);
        symbol = selectSymbol(info);
                                                             select.addSymbol(symbol);
      }
      break;
    default:
      jj_la1[99] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                select.setDistinct(isDistinct);
                {if (true) return select;}
    throw new Error("Missing return statement in function");
  }

/*
name=select sublist
description=An element in the select clause
example=[source,sql]\n----\ntbl.*\n----\n\n[source,sql]\n----\ntbl.col AS x\n----\n
*/
  final public Expression selectSymbol(ParseInfo info) throws ParseException {
        Expression symbol = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCAST:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLEXISTS:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case XMLTEXT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      symbol = selectExpression(info);
      break;
    case ALL_IN_GROUP:
      symbol = allInGroupSymbol();
      break;
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return symbol;}
    throw new Error("Missing return statement in function");
  }

/*
name=select derived column
description=A select clause item that selects a single column. {note}This is slightly different than a derived column in that the AS keyword is optional.{note}
example=[source,sql]\n----\ntbl.col AS x\n----\n
*/
  final public Expression selectExpression(ParseInfo info) throws ParseException {
        Expression expression = null;
    String alias = null;
    // Expression
                    expression = expression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[101] = jj_gen;
        ;
      }
      alias = id(Boolean.FALSE);
      break;
    default:
      jj_la1[102] = jj_gen;
      ;
    }
                if(alias != null) {
                        {if (true) return new AliasSymbol(alias, expression);}
                }
                {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

/*
name=derived column
description=An optionally named expression.
example=[source,sql]\n----\ntbl.col AS x\n----\n
*/
  final public DerivedColumn derivedColumn(ParseInfo info) throws ParseException {
        Expression expression = null;
    String alias = null;
    // Expression
                    expression = expression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      alias = id(Boolean.FALSE);
      break;
    default:
      jj_la1[103] = jj_gen;
      ;
    }
                {if (true) return new DerivedColumn(alias, expression);}
    throw new Error("Missing return statement in function");
  }

/*
name=all in group 
description=A select sublist that can select all columns from the given group.
example=[source,sql]\n----\ntbl.*\n----\n
*/
  final public MultipleElementSymbol allInGroupSymbol() throws ParseException {
        Token allInGroupToken = null;
    allInGroupToken = jj_consume_token(ALL_IN_GROUP);
                {if (true) return new MultipleElementSymbol(normalizeId(allInGroupToken.image.substring(0, allInGroupToken.image.length() - 2)));}
    throw new Error("Missing return statement in function");
  }

/*
name=ordered aggregate function
description=An aggregate function that can optionally be ordered.
example=[source,sql]\n----\nXMLAGG(col1) ORDER BY col2\n----\n\n[source,sql]\n----\nARRAY_AGG(col1)\n----\n
*/
  final public AggregateSymbol orderedAgg(ParseInfo info) throws ParseException {
    Token t = null;
        Expression expression = null;
        OrderBy orderBy = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case XMLAGG:
      t = jj_consume_token(XMLAGG);
      break;
    case ARRAY_AGG:
      t = jj_consume_token(ARRAY_AGG);
      break;
    case JSONARRAY_AGG:
      t = jj_consume_token(JSONARRAY_AGG);
      break;
    default:
      jj_la1[104] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LPAREN);
    expression = expression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = orderby(info);
      break;
    default:
      jj_la1[105] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                String aggName = t.image.toUpperCase();
                AggregateSymbol agg = new AggregateSymbol(aggName, false, expression);
                agg.setOrderBy(orderBy);
                {if (true) return agg;}
    throw new Error("Missing return statement in function");
  }

/*
name=text aggreate function
description=An aggregate function for creating separated value clobs.
example=[source,sql]\n----\nTEXTAGG (col1 as t1, col2 as t2 DELIMITER ',' HEADER)\n----\n
*/
  final public AggregateSymbol textAgg(ParseInfo info) throws ParseException {
        DerivedColumn expression = null;
        Character delimiter = null;
        Character quote = null;
        boolean header = false;
        List<DerivedColumn> expressions = new ArrayList<DerivedColumn>();
        OrderBy orderBy = null;
        String encoding = null;
    jj_consume_token(TEXTAGG);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOR:
      jj_consume_token(FOR);
      break;
    default:
      jj_la1[106] = jj_gen;
      ;
    }
    expression = derivedColumn(info);
                expressions.add(expression);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[107] = jj_gen;
        break label_14;
      }
      jj_consume_token(COMMA);
      expression = derivedColumn(info);
                        expressions.add(expression);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DELIMITER:
      jj_consume_token(DELIMITER);
      delimiter = charVal(info, "DELMITER");
      break;
    default:
      jj_la1[108] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NO:
    case QUOTE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case QUOTE:
        jj_consume_token(QUOTE);
        quote = charVal(info, "QUOTE");
        break;
      case NO:
        jj_consume_token(NO);
        jj_consume_token(QUOTE);
                         quote = (char)0;
        break;
      default:
        jj_la1[109] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[110] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HEADER:
      jj_consume_token(HEADER);
            header = true;
      break;
    default:
      jj_la1[111] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENCODING:
      jj_consume_token(ENCODING);
      encoding = id(null);
      break;
    default:
      jj_la1[112] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = orderby(info);
      break;
    default:
      jj_la1[113] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                TextLine tf = new TextLine();
                tf.setDelimiter(delimiter);
                tf.setQuote(quote);
                tf.setIncludeHeader(header);
                tf.setExpressions(expressions);
                tf.setEncoding(encoding);
                AggregateSymbol agg = new AggregateSymbol("TEXTAGG", false, tf);
                agg.setOrderBy(orderBy);
                {if (true) return agg;}
    throw new Error("Missing return statement in function");
  }

/*
name=standard aggregate function
description=A standard aggregate function.
example=[source,sql]\n----\nCOUNT(*)\n----\n
*/
  final public AggregateSymbol aggregateSymbol(ParseInfo info) throws ParseException {
        Token func = null;
        Token starToken = null;
        AggregateSymbol agg = null;
        boolean isDistinct = false;
        Expression expression = null;
    if (jj_2_20(3)) {
      func = jj_consume_token(COUNT);
      jj_consume_token(LPAREN);
      starToken = jj_consume_token(STAR);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ANY:
      case SOME:
      case COUNT:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COUNT:
          jj_consume_token(COUNT);
          break;
        case SUM:
          jj_consume_token(SUM);
          break;
        case AVG:
          jj_consume_token(AVG);
          break;
        case MIN:
          jj_consume_token(MIN);
          break;
        case MAX:
          jj_consume_token(MAX);
          break;
        case EVERY:
          jj_consume_token(EVERY);
          break;
        case STDDEV_POP:
          jj_consume_token(STDDEV_POP);
          break;
        case STDDEV_SAMP:
          jj_consume_token(STDDEV_SAMP);
          break;
        case VAR_SAMP:
          jj_consume_token(VAR_SAMP);
          break;
        case VAR_POP:
          jj_consume_token(VAR_POP);
          break;
        case SOME:
          jj_consume_token(SOME);
          break;
        case ANY:
          jj_consume_token(ANY);
          break;
        default:
          jj_la1[114] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                                                                                                                                      func = getToken(0);
        jj_consume_token(LPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
        case DISTINCT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DISTINCT:
            jj_consume_token(DISTINCT);
                                      isDistinct=true;
            break;
          case ALL:
            jj_consume_token(ALL);
            break;
          default:
            jj_la1[115] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[116] = jj_gen;
          ;
        }
        expression = expression(info);
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[117] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                String name = func.image.toUpperCase();
                if(starToken == null) {
                        // Aggregate
                        agg = new AggregateSymbol(name, isDistinct, expression);
                } else {
                        // COUNT(*)			
                        agg = new AggregateSymbol(name, false, null);
                }
                {if (true) return agg;}
    throw new Error("Missing return statement in function");
  }

/*
name=analytic aggregate function
description=An analytic aggregate function.
example=[source,sql]\n----\nROW_NUMBER()\n----\n
*/
  final public AggregateSymbol analyticAggregateSymbol(ParseInfo info) throws ParseException {
        Token func = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROW_NUMBER:
      jj_consume_token(ROW_NUMBER);
      break;
    case RANK:
      jj_consume_token(RANK);
      break;
    case DENSE_RANK:
      jj_consume_token(DENSE_RANK);
      break;
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                                func = getToken(0);
    jj_consume_token(LPAREN);
    jj_consume_token(RPAREN);
                {if (true) return new AggregateSymbol(func.image.toUpperCase(), false, null);}
    throw new Error("Missing return statement in function");
  }

/*
name=filter clause
description=An aggregate filter clause applied prior to accumulating the value.
example=[source,sql]\n----\nFILTER (WHERE col1='a')\n----\n
*/
  final public Expression filterClause(ParseInfo info) throws ParseException {
        Expression condition = null;
    jj_consume_token(FILTER);
    jj_consume_token(LPAREN);
    jj_consume_token(WHERE);
    condition = booleanPrimary(info);
    jj_consume_token(RPAREN);
                {if (true) return condition;}
    throw new Error("Missing return statement in function");
  }

/*
name=from clause
description=A query from clause containing a list of table references.
example=[source,sql]\n----\nFROM a, b\n----\n\n[source,sql]\n----\nFROM a right outer join b, c, d join e".</p>\n----\n
*/
  final public From from(ParseInfo info) throws ParseException {
        FromClause clause = null;
        List clauseList = new LinkedList();
    jj_consume_token(FROM);
    clause = tableReference(info);
                        clauseList.add(clause);
                        clause = null;
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[119] = jj_gen;
        break label_15;
      }
      jj_consume_token(COMMA);
      clause = tableReference(info);
                                clauseList.add(clause);
                                clause = null;
    }
                {if (true) return new From(clauseList);}
    throw new Error("Missing return statement in function");
  }

/*
name=table reference
description=An optionally escaped joined table.
example=[source,sql]\n----\na\n----\n\n[source,sql]\n----\na inner join b\n----\n
*/
  final public FromClause tableReference(ParseInfo info) throws ParseException {
        FromClause result = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESCAPEDJOIN:
      jj_consume_token(ESCAPEDJOIN);
      result = joinedTable(info);
      jj_consume_token(RBRACE);
      break;
    case TABLE:
    case LATERAL:
    case XMLTABLE:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
    case LPAREN:
      result = joinedTable(info);
      break;
    default:
      jj_la1[120] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=joined table
description=A table or join.
example=[source,sql]\n----\na\n----\n\n[source,sql]\n----\na inner join b\n----\n
*/
  final public FromClause joinedTable(ParseInfo info) throws ParseException {
        FromClause result = null;
        JoinPredicate jp = null;
    result = tablePrimary(info);
    label_16:
    while (true) {
      if (jj_2_21(2)) {
        ;
      } else {
        break label_16;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CROSS:
      case UNION:
        jp = crossJoin(info);
        break;
      case FULL:
      case INNER:
      case JOIN:
      case LEFT:
      case RIGHT:
        jp = qualifiedJoin(info);
        break;
      default:
        jj_la1[121] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        jp.setLeftClause(result);
                        result = jp;
    }
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=cross join
description=A cross join.
example=[source,sql]\n----\na CROSS JOIN b\n----\n
*/
  final public JoinPredicate crossJoin(ParseInfo info) throws ParseException {
        JoinPredicate result = new JoinPredicate();
        FromClause clause = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CROSS:
      jj_consume_token(CROSS);
                          result.setJoinType(JoinType.JOIN_CROSS);
      break;
    case UNION:
      jj_consume_token(UNION);
                                                                             result.setJoinType(JoinType.JOIN_UNION);
      break;
    default:
      jj_la1[122] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(JOIN);
    clause = tablePrimary(info);
                                             result.setRightClause(clause);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=qualified table
description=An INNER or OUTER join.
example=[source,sql]\n----\na inner join b\n----\n
*/
  final public JoinPredicate qualifiedJoin(ParseInfo info) throws ParseException {
        JoinPredicate result = new JoinPredicate();
        FromClause clause = null;
        Criteria onCriteria = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FULL:
    case INNER:
    case LEFT:
    case RIGHT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RIGHT:
        jj_consume_token(RIGHT);
                                  result.setJoinType(JoinType.JOIN_RIGHT_OUTER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[123] = jj_gen;
          ;
        }
        break;
      case LEFT:
        jj_consume_token(LEFT);
                           result.setJoinType(JoinType.JOIN_LEFT_OUTER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[124] = jj_gen;
          ;
        }
        break;
      case FULL:
        jj_consume_token(FULL);
                            result.setJoinType(JoinType.JOIN_FULL_OUTER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[125] = jj_gen;
          ;
        }
        break;
      case INNER:
        jj_consume_token(INNER);
        break;
      default:
        jj_la1[126] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[127] = jj_gen;
      ;
    }
    jj_consume_token(JOIN);
    clause = tableReference(info);
                                               result.setRightClause(clause);
    jj_consume_token(ON);
    onCriteria = criteria(info);
                                             result.setJoinCriteria(Criteria.separateCriteriaByAnd(onCriteria));
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=table primary
description=A single source of rows.
example=[source,sql]\n----\na\n----\n
*/
  final public FromClause tablePrimary(ParseInfo info) throws ParseException {
        FromClause clause = null;
        Token lparen = null;
        Option.MakeDep makedep = null;
    if (jj_2_22(2)) {
      clause = textTable(info);
    } else if (jj_2_23(2)) {
      clause = arrayTable(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XMLTABLE:
        clause = xmlTable(info);
        break;
      default:
        jj_la1[128] = jj_gen;
        if (jj_2_24(2)) {
          clause = objectTable(info);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
          case PRESERVE:
          case ID:
            clause = unaryFromClause(info);
            break;
          default:
            jj_la1[129] = jj_gen;
            if (jj_2_25(2147483647)) {
              clause = subqueryFromClause(info);
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case LPAREN:
                lparen = jj_consume_token(LPAREN);
                clause = joinedTable(info);
                        setFromClauseOptions(lparen, clause);
                jj_consume_token(RPAREN);
                break;
              default:
                jj_la1[130] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MAKEDEP:
    case MAKENOTDEP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAKEDEP:
        jj_consume_token(MAKEDEP);
        makedep = makedepOptions();
                                                        clause.setMakeDep(makedep);
        break;
      case MAKENOTDEP:
        jj_consume_token(MAKENOTDEP);
                                   clause.setMakeNotDep(true);
        break;
      default:
        jj_la1[131] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[132] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MAKEIND:
      jj_consume_token(MAKEIND);
      makedep = makedepOptions();
                                                  clause.setMakeInd(makedep);
      break;
    default:
      jj_la1[133] = jj_gen;
      ;
    }
                {if (true) return clause;}
    throw new Error("Missing return statement in function");
  }

/*
name=make dep options
description=options for the make dep hint
example=[source,sql]\n----\n(min:10000)\n----\n
*/
  final public Option.MakeDep makedepOptions() throws ParseException {
        Integer max = null;
        Boolean join = null;
        boolean no = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAX:
        jj_consume_token(MAX);
        jj_consume_token(COLON);
        max = intVal();
        break;
      default:
        jj_la1[134] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case JOIN:
      case NO:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NO:
          jj_consume_token(NO);
                no = true;
          break;
        default:
          jj_la1[135] = jj_gen;
          ;
        }
        jj_consume_token(JOIN);
                                     join = true;
        break;
      default:
        jj_la1[136] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[137] = jj_gen;
      ;
    }
        Option.MakeDep result = new Option.MakeDep();
        result.setMax(max);
        result.setJoin(no?Boolean.FALSE:join);
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=xml serialize
description=Serializes an XML value.
example=[source,sql]\n----\nXMLSERIALIZE(col1 AS CLOB)\n----\n
*/
  final public XMLSerialize xmlSerialize(ParseInfo info) throws ParseException {
        Expression expr = null;
        Boolean doc = null;
        Token t = null;
        String enc = null;
        Boolean declr = null;
        String ver = null;
    jj_consume_token(XMLSERIALIZE);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOCUMENT:
    case CONTENT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOCUMENT:
        jj_consume_token(DOCUMENT);
                                   doc = true;
        break;
      case CONTENT:
        jj_consume_token(CONTENT);
                                                            doc = false;
        break;
      default:
        jj_la1[138] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[139] = jj_gen;
      ;
    }
    expr = expression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        jj_consume_token(STRING);
        break;
      case VARCHAR:
        jj_consume_token(VARCHAR);
        break;
      case CLOB:
        jj_consume_token(CLOB);
        break;
      case VARBINARY:
        jj_consume_token(VARBINARY);
        break;
      case BLOB:
        jj_consume_token(BLOB);
        break;
      default:
        jj_la1[140] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                                                              t = getToken(0);
      break;
    default:
      jj_la1[141] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENCODING:
      jj_consume_token(ENCODING);
      enc = id(null);
      break;
    default:
      jj_la1[142] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VERSION:
      jj_consume_token(VERSION);
      ver = stringVal();
      break;
    default:
      jj_la1[143] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCLUDING:
    case EXCLUDING:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INCLUDING:
        jj_consume_token(INCLUDING);
                         declr = true;
        break;
      case EXCLUDING:
        jj_consume_token(EXCLUDING);
                                                      declr = false;
        break;
      default:
        jj_la1[144] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(XMLDECLARATION);
      break;
    default:
      jj_la1[145] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                XMLSerialize result = new XMLSerialize();
                result.setEncoding(enc);
                result.setVersion(ver);
                result.setDeclaration(declr);
                result.setExpression(expr);
                if (doc != null) {
                        result.setDocument(doc);
                }
                if (t != null) {
                        result.setTypeString(t.image);
                }
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=array table
description=The ARRAYTABLE table function creates tabular results from arrays.  It can be used as a nested table reference.
example=[source,sql]\n----\nARRAYTABLE (col1 COLUMNS x STRING) AS y\n----\n
*/
  final public ArrayTable arrayTable(ParseInfo info) throws ParseException {
        Expression array = null;
        List<TableFunctionReference.ProjectedColumn> columns;
        String aliasID = null;
    jj_consume_token(ARRAYTABLE);
    jj_consume_token(LPAREN);
    array = valueExpressionPrimary(info);
    jj_consume_token(COLUMNS);
    columns = createElementsWithTypes(info);
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      break;
    default:
      jj_la1[146] = jj_gen;
      ;
    }
    aliasID = id(Boolean.FALSE);
                ArrayTable result = new ArrayTable();
                result.setArrayValue(array);
                result.setColumns(columns);
                result.setName(aliasID);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=text table
description=The TEXTTABLE table function creates tabular results from text.  It can be used as a nested table reference.
example=[source,sql]\n----\nTEXTTABLE (file COLUMNS x STRING) AS y\n----\n
*/
  final public TextTable textTable(ParseInfo info) throws ParseException {
        Expression file = null;
        TextTable.TextColumn column = null;
        List<TextTable.TextColumn> columns = new ArrayList<TextTable.TextColumn>();
        boolean useRowDelimiter = true;
        Character delimiter = null;
        Character rowDelimiter = null;
        boolean escape = false;
        Character quote = null;
        Integer header = null;
        Integer skip = null;
        String selector = null;
        String aliasID = null;
        boolean noTrim = false;
    jj_consume_token(TEXTTABLE);
    jj_consume_token(LPAREN);
    file = commonValueExpression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECTOR:
      jj_consume_token(SELECTOR);
      selector = stringVal();
      break;
    default:
      jj_la1[147] = jj_gen;
      ;
    }
    jj_consume_token(COLUMNS);
    column = textColumn(info);
                columns.add(column);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[148] = jj_gen;
        break label_17;
      }
      jj_consume_token(COMMA);
      column = textColumn(info);
                        columns.add(column);
    }
    if (jj_2_26(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NO:
        jj_consume_token(NO);
        jj_consume_token(ROW);
        jj_consume_token(DELIMITER);
            useRowDelimiter = false;
        break;
      case ROW:
        jj_consume_token(ROW);
        jj_consume_token(DELIMITER);
        rowDelimiter = charVal(info, " ROW DELMITER");
        break;
      default:
        jj_la1[149] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DELIMITER:
      jj_consume_token(DELIMITER);
      delimiter = charVal(info, "DELMITER");
      break;
    default:
      jj_la1[150] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESCAPE:
    case QUOTE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ESCAPE:
        jj_consume_token(ESCAPE);
        quote = charVal(info, "ESCAPE");
                                                        escape = true;
        break;
      case QUOTE:
        jj_consume_token(QUOTE);
        quote = charVal(info, "QUOTE");
        break;
      default:
        jj_la1[151] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[152] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HEADER:
      jj_consume_token(HEADER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNSIGNEDINTEGER:
        header = intVal();
        break;
      default:
        jj_la1[153] = jj_gen;
        ;
      }
                if (header == null) {
                        header = 1;
                }
      break;
    default:
      jj_la1[154] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SKIP_KEYWORD:
      jj_consume_token(SKIP_KEYWORD);
      skip = intVal();
      break;
    default:
      jj_la1[155] = jj_gen;
      ;
    }
    if (jj_2_27(2)) {
      jj_consume_token(NO);
      jj_consume_token(TRIM);
        noTrim = true;
    } else {
      ;
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      break;
    default:
      jj_la1[156] = jj_gen;
      ;
    }
    aliasID = id(Boolean.FALSE);
                TextTable result = new TextTable();
                result.setFile(file);
                result.setColumns(columns);
                result.setDelimiter(delimiter);
                result.setEscape(escape);
                result.setHeader(header);
                result.setSkip(skip);
                result.setName(aliasID);
                result.setQuote(quote);
                result.setUsingRowDelimiter(useRowDelimiter);
                result.setSelector(selector);
                if (noTrim) {
                        result.setNoTrim();
                }
                result.setRowDelimiter(rowDelimiter);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=text table column
description=A text table column.
example=[source,sql]\n----\nx INTEGER WIDTH 6\n----\n
*/
  final public TextTable.TextColumn textColumn(ParseInfo info) throws ParseException {
        String name = null;
        ParsedDataType datatype = null;
        Integer width = null;
        boolean noTrim = false;
        String selector = null;
        Integer position = null;
        String header = null;
    name = id(Boolean.TRUE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOR:
      jj_consume_token(FOR);
      jj_consume_token(ORDINALITY);
        {if (true) return new TextTable.TextColumn(name);}
      break;
    case STRING:
    case VARBINARY:
    case VARCHAR:
    case BOOLEAN:
    case BYTE:
    case TINYINT:
    case SHORT:
    case SMALLINT:
    case CHAR:
    case INTEGER:
    case LONG:
    case BIGINT:
    case BIGINTEGER:
    case FLOAT:
    case REAL:
    case DOUBLE:
    case BIGDECIMAL:
    case DECIMAL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case OBJECT:
    case BLOB:
    case CLOB:
    case XML:
    case HEADER:
    case GEOMETRY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HEADER:
        jj_consume_token(HEADER);
        header = stringVal();
        break;
      default:
        jj_la1[157] = jj_gen;
        ;
      }
      datatype = parseDataType();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WIDTH:
        jj_consume_token(WIDTH);
        width = intVal();
        if (jj_2_28(2)) {
          jj_consume_token(NO);
          jj_consume_token(TRIM);
                                noTrim = true;
        } else {
          ;
        }
        break;
      default:
        jj_la1[158] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SELECTOR:
        jj_consume_token(SELECTOR);
        selector = stringVal();
        position = intVal();
        break;
      default:
        jj_la1[159] = jj_gen;
        ;
      }
                        TextTable.TextColumn result = new TextTable.TextColumn(name, datatype.type, width, noTrim);
                        result.setSelector(selector);
                        result.setPosition(position);
                        result.setHeader(header);
                        {if (true) return result;}
      break;
    default:
      jj_la1[160] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=xml query
description=Executes an XQuery to return an XML result.
example=[source,sql]\n----\nXMLQUERY('<a>...</a>' PASSING doc)\n----\n
*/
  final public Expression xmlExists(ParseInfo info) throws ParseException {
    String xquery = null;
    XMLNamespaces xmlNamespaces = null;
    DerivedColumn passing = null;
    ArrayList<DerivedColumn> passingValues = new ArrayList<DerivedColumn>();
    Boolean content = null;
    Boolean empty = null;
    jj_consume_token(XMLEXISTS);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case XMLNAMESPACES:
      xmlNamespaces = xmlNamespaces(info);
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[161] = jj_gen;
      ;
    }
    xquery = stringVal();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PASSING:
      jj_consume_token(PASSING);
      passing = derivedColumn(info);
        passingValues.add(passing);
        passing.setPropagateName(false);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[162] = jj_gen;
          break label_18;
        }
        jj_consume_token(COMMA);
        passing = derivedColumn(info);
          passingValues.add(passing);
          passing.setPropagateName(false);
      }
      break;
    default:
      jj_la1[163] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        XMLQuery result = new XMLQuery();
        result.setXquery(xquery);
        result.setNamespaces(xmlNamespaces);
        result.setPassing(passingValues);
        result.setEmptyOnEmpty(true);
        {if (true) return new XMLExists(result);}
    throw new Error("Missing return statement in function");
  }

/*
name=xml query
description=Executes an XQuery to return an XML result.
example=[source,sql]\n----\nXMLQUERY('<a>...</a>' PASSING doc)\n----\n
*/
  final public XMLQuery xmlQuery(ParseInfo info) throws ParseException {
        String xquery = null;
        XMLNamespaces xmlNamespaces = null;
        DerivedColumn passing = null;
        ArrayList<DerivedColumn> passingValues = new ArrayList<DerivedColumn>();
        Boolean content = null;
        Boolean empty = null;
    jj_consume_token(XMLQUERY);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case XMLNAMESPACES:
      xmlNamespaces = xmlNamespaces(info);
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[164] = jj_gen;
      ;
    }
    xquery = stringVal();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PASSING:
      jj_consume_token(PASSING);
      passing = derivedColumn(info);
                passingValues.add(passing);
                passing.setPropagateName(false);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[165] = jj_gen;
          break label_19;
        }
        jj_consume_token(COMMA);
        passing = derivedColumn(info);
                  passingValues.add(passing);
                  passing.setPropagateName(false);
      }
      break;
    default:
      jj_la1[166] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
    case EMPTY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NULL:
        jj_consume_token(NULL);
                    empty = false;
        break;
      case EMPTY:
        jj_consume_token(EMPTY);
                     empty = true;
        break;
      default:
        jj_la1[167] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ON);
      jj_consume_token(EMPTY);
      break;
    default:
      jj_la1[168] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                XMLQuery result = new XMLQuery();
                result.setXquery(xquery);
                result.setNamespaces(xmlNamespaces);
                result.setPassing(passingValues);
                result.setEmptyOnEmpty(empty);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=object table
description=Returns table results by processing a script.
example=[source,sql]\n----\nOBJECTTABLE('z' PASSING val AS z COLUMNS col OBJECT 'teiid_row') AS X\n----\n
*/
  final public ObjectTable objectTable(ParseInfo info) throws ParseException {
        String rowScript = null;
        String lang = null;
        DerivedColumn passing = null;
        ArrayList<DerivedColumn> passingValues = new ArrayList<DerivedColumn>();
        ObjectTable.ObjectColumn column = null;
        ArrayList<ObjectTable.ObjectColumn> columns = new ArrayList<ObjectTable.ObjectColumn>();
        String aliasID = null;
    jj_consume_token(OBJECTTABLE);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGUAGE:
      jj_consume_token(LANGUAGE);
      lang = stringVal();
      break;
    default:
      jj_la1[169] = jj_gen;
      ;
    }
    rowScript = stringVal();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PASSING:
      jj_consume_token(PASSING);
      passing = derivedColumn(info);
                passingValues.add(passing);
                passing.setPropagateName(false);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[170] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        passing = derivedColumn(info);
                  passingValues.add(passing);
                  passing.setPropagateName(false);
      }
      break;
    default:
      jj_la1[171] = jj_gen;
      ;
    }
    jj_consume_token(COLUMNS);
    column = objectColumn(info);
      columns.add(column);
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[172] = jj_gen;
        break label_21;
      }
      jj_consume_token(COMMA);
      column = objectColumn(info);
        columns.add(column);
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      break;
    default:
      jj_la1[173] = jj_gen;
      ;
    }
    aliasID = id(Boolean.FALSE);
                ObjectTable result = new ObjectTable();
                result.setScriptingLanguage(lang);
                result.setRowScript(rowScript);
                result.setPassing(passingValues);
                result.setColumns(columns);
                result.setName(aliasID);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=object table column
description=object table column.
example=[source,sql]\n----\ny integer 'teiid_row_number'\n----\n
*/
  final public ObjectTable.ObjectColumn objectColumn(ParseInfo info) throws ParseException {
        String name = null;
        ParsedDataType datatype = null;
        String path = null;
        Expression defaultExpr = null;
    name = id(null);
    datatype = parseDataType();
    path = stringVal();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_KEYWORD:
      jj_consume_token(DEFAULT_KEYWORD);
      defaultExpr = expression(info);
      break;
    default:
      jj_la1[174] = jj_gen;
      ;
    }
          {if (true) return new ObjectTable.ObjectColumn(name, datatype.type, path, defaultExpr);}
    throw new Error("Missing return statement in function");
  }

/*
name=xml table
description=Returns table results by processing an XQuery.
example=[source,sql]\n----\nXMLTABLE('/a/b' PASSING doc COLUMNS col XML PATH '.') AS X\n----\n
*/
  final public XMLTable xmlTable(ParseInfo info) throws ParseException {
        String xquery = null;
        XMLNamespaces xmlNamespaces = null;
        DerivedColumn passing = null;
        ArrayList<DerivedColumn> passingValues = new ArrayList<DerivedColumn>();
        XMLTable.XMLColumn column = null;
        ArrayList<XMLTable.XMLColumn> columns = new ArrayList<XMLTable.XMLColumn>();
        String aliasID = null;
    jj_consume_token(XMLTABLE);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case XMLNAMESPACES:
      xmlNamespaces = xmlNamespaces(info);
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[175] = jj_gen;
      ;
    }
    xquery = stringVal();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PASSING:
      jj_consume_token(PASSING);
      passing = derivedColumn(info);
                passingValues.add(passing);
                passing.setPropagateName(false);
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[176] = jj_gen;
          break label_22;
        }
        jj_consume_token(COMMA);
        passing = derivedColumn(info);
                  passingValues.add(passing);
                  passing.setPropagateName(false);
      }
      break;
    default:
      jj_la1[177] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLUMNS:
      jj_consume_token(COLUMNS);
      column = xmlColumn(info);
            columns.add(column);
      label_23:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[178] = jj_gen;
          break label_23;
        }
        jj_consume_token(COMMA);
        column = xmlColumn(info);
              columns.add(column);
      }
      break;
    default:
      jj_la1[179] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      break;
    default:
      jj_la1[180] = jj_gen;
      ;
    }
    aliasID = id(Boolean.FALSE);
                XMLTable result = new XMLTable();
                result.setXquery(xquery);
                result.setNamespaces(xmlNamespaces);
                result.setPassing(passingValues);
                result.setColumns(columns);
                result.setName(aliasID);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=xml table column
description=XML table column.
example=[source,sql]\n----\ny FOR ORDINALITY\n----\n
*/
  final public XMLTable.XMLColumn xmlColumn(ParseInfo info) throws ParseException {
        String name = null;
        ParsedDataType datatype = null;
        String path = null;
        Expression defaultExpr = null;
    name = id(Boolean.TRUE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOR:
      jj_consume_token(FOR);
      jj_consume_token(ORDINALITY);
            {if (true) return new XMLTable.XMLColumn(name);}
      break;
    case STRING:
    case VARBINARY:
    case VARCHAR:
    case BOOLEAN:
    case BYTE:
    case TINYINT:
    case SHORT:
    case SMALLINT:
    case CHAR:
    case INTEGER:
    case LONG:
    case BIGINT:
    case BIGINTEGER:
    case FLOAT:
    case REAL:
    case DOUBLE:
    case BIGDECIMAL:
    case DECIMAL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case OBJECT:
    case BLOB:
    case CLOB:
    case XML:
    case GEOMETRY:
      datatype = parseDataType();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFAULT_KEYWORD:
        jj_consume_token(DEFAULT_KEYWORD);
        defaultExpr = expression(info);
        break;
      default:
        jj_la1[181] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PATH:
        jj_consume_token(PATH);
        path = stringVal();
        break;
      default:
        jj_la1[182] = jj_gen;
        ;
      }
                {if (true) return new XMLTable.XMLColumn(name, datatype.type, path, defaultExpr);}
      break;
    default:
      jj_la1[183] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=unsigned integer
description=An unsigned interger value.
example=[source,sql]\n----\n12345\n----\n
*/
  final public int intVal() throws ParseException {
        Token t;
    t = jj_consume_token(UNSIGNEDINTEGER);
                try {
                        {if (true) return Integer.valueOf(t.image);}
                } catch(NumberFormatException e1) {
                        {if (true) throw new ParseException(QueryPlugin.Util.getString("SQLParser.Integer_parse", t.image));} //$NON-NLS-1$
                }
    throw new Error("Missing return statement in function");
  }

/*
name=table subquery
description=A table defined by a subquery.
example=[source,sql]\n----\n(SELECT * FROM tbl) AS x\n----\n
*/
  final public SubqueryFromClause subqueryFromClause(ParseInfo info) throws ParseException {
    String aliasID = null;
        Command command = null;
        Token lparen = null;
        boolean table = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLE:
    case LATERAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TABLE:
        jj_consume_token(TABLE);
        break;
      case LATERAL:
        jj_consume_token(LATERAL);
        break;
      default:
        jj_la1[184] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                      table = true;
      break;
    default:
      jj_la1[185] = jj_gen;
      ;
    }
    lparen = jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case TABLE:
    case VALUES:
    case WITH:
    case LPAREN:
      command = queryExpression(info);
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      command = storedProcedure(info, 1);
      break;
    default:
      jj_la1[186] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      break;
    default:
      jj_la1[187] = jj_gen;
      ;
    }
    aliasID = id(Boolean.FALSE);
                SubqueryFromClause clause = new SubqueryFromClause(aliasID, command);
        setFromClauseOptions(lparen, clause);
        clause.setLateral(table);
        {if (true) return clause;}
    throw new Error("Missing return statement in function");
  }

/*
name=table name
description=A table named in the FROM clause.
example=[source,sql]\n----\ntbl AS x\n----\n
*/
  final public UnaryFromClause unaryFromClause(ParseInfo info) throws ParseException {
        GroupSymbol group = null;
        String groupID = null;
        Token groupToken = null;
    String aliasID = null;
        UnaryFromClause clause = null;
    groupID = id(null);
                           groupToken = getToken(0);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[188] = jj_gen;
        ;
      }
      aliasID = id(Boolean.FALSE);
      break;
    default:
      jj_la1[189] = jj_gen;
      ;
    }
        if(aliasID != null) {
            group = new GroupSymbol(aliasID, groupID);
        } else {
                        group = new GroupSymbol(groupID);
        }
        clause = new UnaryFromClause(group);
        setFromClauseOptions(groupToken, clause);
                {if (true) return clause;}
    throw new Error("Missing return statement in function");
  }

/*
name=where clause
description=Specifies a search condition
example=[source,sql]\n----\nWHERE x = 'a'\n----\n
*/
  final public Criteria where(ParseInfo info) throws ParseException {
    Criteria criteria = null;
    jj_consume_token(WHERE);
    criteria = criteria(info);
                {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=condition
description=A boolean expression.
*/
  final public Criteria criteria(ParseInfo info) throws ParseException {
        Criteria criteria = null;
    criteria = compoundCritOr(info);
                {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=boolean value expression
description=An optionally ORed boolean expression.
*/
  final public Criteria compoundCritOr(ParseInfo info) throws ParseException {
    ArrayList logicList = null;
    Criteria logicPart = null;
    Criteria logicPart1 = null;
    logicPart = compoundCritAnd(info);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[190] = jj_gen;
        break label_24;
      }
      jj_consume_token(OR);
      logicPart1 = compoundCritAnd(info);
                                                                  if (logicList == null) { logicList = new ArrayList(2); logicList.add(logicPart); } logicList.add(logicPart1);
    }
                if(logicList == null) {
                        {if (true) return logicPart;}
                } else {
                {if (true) return new CompoundCriteria(CompoundCriteria.OR,logicList);}
                }
    throw new Error("Missing return statement in function");
  }

/*
name=boolean term
description=An optional ANDed boolean factor.
*/
  final public Criteria compoundCritAnd(ParseInfo info) throws ParseException {
    ArrayList logicList = null;
    Criteria logicPart = null;
    Criteria logicPart1 = null;
    logicPart = notCrit(info);
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[191] = jj_gen;
        break label_25;
      }
      jj_consume_token(AND);
      logicPart1 = notCrit(info);
                                                          if (logicList == null) { logicList = new ArrayList(2); logicList.add(logicPart); } logicList.add(logicPart1);
    }
                if(logicList == null) {
                        {if (true) return logicPart;}
                } else {
                {if (true) return new CompoundCriteria(CompoundCriteria.AND,logicList);}
                }
    throw new Error("Missing return statement in function");
  }

/*
name=boolean factor
description=A boolean factor.
example=[source,sql]\n----\nNOT x = 'a'\n----\n
*/
  final public Criteria notCrit(ParseInfo info) throws ParseException {
    Expression ex = null;
        boolean isNot = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                isNot=true;
      break;
    default:
      jj_la1[192] = jj_gen;
      ;
    }
    ex = booleanPrimary(info);
            Criteria crit = null;
            if (ex instanceof Criteria) {
              crit = (Criteria)ex;
            } else {
              crit = new ExpressionCriteria(ex);
            }
                if(isNot) {
                        {if (true) return new NotCriteria(crit);}
                } else {
                        {if (true) return crit;}
                }
    throw new Error("Missing return statement in function");
  }

/*
name=boolean primary
description=A boolean predicate or simple expression.
example=[source,sql]\n----\ncol LIKE 'a%'\n----\n
*/
  final public Expression booleanPrimary(ParseInfo info) throws ParseException {
    Expression ex = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCAST:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case XMLTEXT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      ex = commonValueExpression(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BETWEEN:
      case IN:
      case IS:
      case LIKE:
      case LIKE_REGEX:
      case NOT:
      case SIMILAR:
      case EQ:
      case NE:
      case NE2:
      case LT:
      case LE:
      case GT:
      case GE:
        if (jj_2_29(2)) {
          ex = betweenCrit(info, ex);
        } else if (jj_2_30(2)) {
          ex = matchCrit(info, ex);
        } else if (jj_2_31(2)) {
          ex = regexMatchCrit(info, ex);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IN:
          case NOT:
            ex = setCrit(info, ex);
            break;
          case IS:
            ex = isNullCrit(info, ex);
            break;
          default:
            jj_la1[193] = jj_gen;
            if (jj_2_32(2147483647)) {
              ex = subqueryCompareCriteria(info, ex);
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case EQ:
              case NE:
              case NE2:
              case LT:
              case LE:
              case GT:
              case GE:
                ex = compareCrit(info, ex);
                break;
              default:
                jj_la1[194] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
        break;
      default:
        jj_la1[195] = jj_gen;
        ;
      }
      break;
    case EXISTS:
      ex = existsCriteria(info);
      break;
    case XMLEXISTS:
      ex = xmlExists(info);
      break;
    default:
      jj_la1[196] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return ex;}
    throw new Error("Missing return statement in function");
  }

/*
name=comparison operator
description=A comparison operator.
example=[source,sql]\n----\n=\n----\n
*/
  final public Token operator() throws ParseException {
        Token operator = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      operator = jj_consume_token(EQ);
      break;
    case NE:
      operator = jj_consume_token(NE);
      break;
    case NE2:
      operator = jj_consume_token(NE2);
      break;
    case LT:
      operator = jj_consume_token(LT);
      break;
    case LE:
      operator = jj_consume_token(LE);
      break;
    case GT:
      operator = jj_consume_token(GT);
      break;
    case GE:
      operator = jj_consume_token(GE);
      break;
    default:
      jj_la1[197] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return operator;}
    throw new Error("Missing return statement in function");
  }

/*
name=comparison predicate
description=A value comparison.
example=[source,sql]\n----\n= 'a'\n----\n
*/
  final public CompareCriteria compareCrit(ParseInfo info, Expression expression) throws ParseException {
    Expression value = null;
    Token operator = null;
    operator = operator();
    value = commonValueExpression(info);
                CompareCriteria compareCriteria = new CompareCriteria();

                // Set left expression
                compareCriteria.setLeftExpression(expression);

                compareCriteria.setOperator(getOperator(operator.image));

                // Set value
                compareCriteria.setRightExpression(value);

            {if (true) return compareCriteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=subquery
description=A subquery.
example=[source,sql]\n----\n(SELECT * FROM tbl)\n----\n
*/
  final public QueryCommand subquery(ParseInfo info) throws ParseException {
    QueryCommand subquery = null;
    StoredProcedure proc = null;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case TABLE:
    case VALUES:
    case WITH:
    case LPAREN:
      subquery = queryExpression(info);
      break;
    case CALL:
    case EXEC:
    case EXECUTE:
      proc = storedProcedure(info, 1);
            subquery = new Query(new Select(Arrays.asList(new MultipleElementSymbol())), new From(Arrays.asList(new SubqueryFromClause("x", proc))), null, null, null);
      break;
    default:
      jj_la1[198] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RPAREN);
                {if (true) return subquery;}
    throw new Error("Missing return statement in function");
  }

/*
name=quantified comparison predicate
description=A subquery comparison.
example=[source,sql]\n----\n= ANY (SELECT col FROM tbl)\n----\n
*/
  final public SubqueryCompareCriteria subqueryCompareCriteria(ParseInfo info, Expression expression) throws ParseException {
    SubqueryCompareCriteria subqueryCrit = null;
    QueryCommand subquery = null;
    Token operator = null;
    Token quantifier = null;
    ExistsCriteria.SubqueryHint hint = null;
    Expression expr = null;
    operator = operator();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
      quantifier = jj_consume_token(ANY);
      break;
    case SOME:
      quantifier = jj_consume_token(SOME);
      break;
    case ALL:
      quantifier = jj_consume_token(ALL);
      break;
    default:
      jj_la1[199] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          hint = getSubqueryHint(getToken(1));
    if (jj_2_33(2147483647)) {
      subquery = subquery(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        expr = expression(info);
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[200] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                subqueryCrit = new SubqueryCompareCriteria();
            subqueryCrit.setLeftExpression(expression);
            subqueryCrit.setCommand(subquery);
            subqueryCrit.setArrayExpression(expr);

                // Set operator
                subqueryCrit.setOperator(getOperator(operator.image));

                // Set predicate quantifier
                if(quantifier.image.equalsIgnoreCase("any")) { //$NON-NLS-1$
                        subqueryCrit.setPredicateQuantifier(SubqueryCompareCriteria.ANY);
                } else if(quantifier.image.equalsIgnoreCase("some")) { //$NON-NLS-1$
                        subqueryCrit.setPredicateQuantifier(SubqueryCompareCriteria.SOME);
                } else if(quantifier.image.equalsIgnoreCase("all")) { //$NON-NLS-1$
                        subqueryCrit.setPredicateQuantifier(SubqueryCompareCriteria.ALL);
                }
        subqueryCrit.setSubqueryHint(hint);
            {if (true) return subqueryCrit;}
    throw new Error("Missing return statement in function");
  }

/*
name=match predicate
description=Matches based upon a pattern.
example=[source,sql]\n----\nLIKE 'a_'\n----\n
*/
  final public MatchCriteria matchCrit(ParseInfo info, Expression expression) throws ParseException {
    Character esc = null;
        Expression value = null;
        boolean negated = false;
        boolean similar = false;
        Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                negated = true;
      break;
    default:
      jj_la1[201] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIKE:
      jj_consume_token(LIKE);
      break;
    case SIMILAR:
      jj_consume_token(SIMILAR);
      jj_consume_token(TO);
                             similar = true;
      break;
    default:
      jj_la1[202] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     t = getToken(1);
    value = commonValueExpression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESCAPE:
    case LBRACE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ESCAPE:
        jj_consume_token(ESCAPE);
        esc = charVal(info, "LIKE/SIMILAR TO ESCAPE");
        break;
      case LBRACE:
        jj_consume_token(LBRACE);
        jj_consume_token(ESCAPE);
        esc = charVal(info, "LIKE/SIMILAR TO ESCAPE");
        jj_consume_token(RBRACE);
        break;
      default:
        jj_la1[203] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[204] = jj_gen;
      ;
    }
        MatchCriteria matchcriteria = new MatchCriteria(expression, value);
                matchcriteria.setNegated(negated);
            if(esc != null) {
                        matchcriteria.setEscapeChar(esc.charValue());
                } else if (!similar && value instanceof Constant) {
                        if (t.image != null && t.image.startsWith("E'")) {
                                matchcriteria.setEscapeChar('\u005c\u005c');
                        }
                }
                matchcriteria.setMode(similar?MatchMode.SIMILAR:MatchMode.LIKE);
                {if (true) return matchcriteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=like regex predicate
description=A regular expression match.
example=[source,sql]\n----\nLIKE_REGEX 'a.*b'\n----\n
*/
  final public MatchCriteria regexMatchCrit(ParseInfo info, Expression expression) throws ParseException {
        Expression value = null;
        boolean negated = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                negated = true;
      break;
    default:
      jj_la1[205] = jj_gen;
      ;
    }
    jj_consume_token(LIKE_REGEX);
    value = commonValueExpression(info);
        MatchCriteria matchcriteria = new MatchCriteria(expression, value);
                matchcriteria.setNegated(negated);
                matchcriteria.setMode(MatchMode.REGEX);
                {if (true) return matchcriteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=character
description=A single character.
example=[source,sql]\n----\n'a'\n----\n
*/
  final public Character charVal(ParseInfo info, String type) throws ParseException {
        String escStr = null;
    escStr = stringVal();
                if (escStr.length() != 1) {
                        {if (true) throw new ParseException(QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30398, type, escStr));} //$NON-NLS-1$
                }
                {if (true) return Character.valueOf(escStr.charAt(0));}
    throw new Error("Missing return statement in function");
  }

/*
name=between predicate
description=A comparison between two values.
example=[source,sql]\n----\nBETWEEN 1 AND 5\n----\n
*/
  final public BetweenCriteria betweenCrit(ParseInfo info, Expression expression) throws ParseException {
        Expression lowerExpression = null, upperExpression = null;
        boolean negated = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                negated=true;
      break;
    default:
      jj_la1[206] = jj_gen;
      ;
    }
    jj_consume_token(BETWEEN);
    lowerExpression = commonValueExpression(info);
    jj_consume_token(AND);
    upperExpression = commonValueExpression(info);
                BetweenCriteria criteria = new BetweenCriteria(expression, lowerExpression, upperExpression);
                criteria.setNegated(negated);
                {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=is null predicate
description=A null test.
example=[source,sql]\n----\nIS NOT NULL\n----\n
*/
  final public IsNullCriteria isNullCrit(ParseInfo info, Expression expression) throws ParseException {
        boolean negated = false;
        IsNullCriteria criteria = null;
    jj_consume_token(IS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                negated = true;
      break;
    default:
      jj_la1[207] = jj_gen;
      ;
    }
    jj_consume_token(NULL);
        criteria = new IsNullCriteria(expression);
        criteria.setNegated(negated);
        {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=in predicate
description=A comparison with multiple values.
example=[source,sql]\n----\nIN (1, 5)\n----\n
*/
  final public AbstractSetCriteria setCrit(ParseInfo info, Expression expression) throws ParseException {
        Expression value = null;
        List setList = new ArrayList();
        QueryCommand command = null;
        ExistsCriteria.SubqueryHint hint = null;
        boolean negated = false;
        AbstractSetCriteria criteria = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                negated = true;
      break;
    default:
      jj_la1[208] = jj_gen;
      ;
    }
    jj_consume_token(IN);
    if (jj_2_34(2147483647)) {
                                            hint = getSubqueryHint(getToken(1));
      command = subquery(info);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        value = commonValueExpression(info);
                                setList.add(value);
        label_26:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[209] = jj_gen;
            break label_26;
          }
          jj_consume_token(COMMA);
          value = commonValueExpression(info);
                                        setList.add(value);
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[210] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
            if (command != null) {
                        SubquerySetCriteria ssc = new SubquerySetCriteria(expression, command);
                        ssc.setSubqueryHint(hint);
                        criteria = ssc;
                } else {
                    criteria = new SetCriteria(expression, setList);
                }
            criteria.setNegated(negated);
            {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=exists predicate
description=A test if rows exist.
example=[source,sql]\n----\nEXISTS (SELECT col FROM tbl)\n----\n
*/
  final public ExistsCriteria existsCriteria(ParseInfo info) throws ParseException {
    QueryCommand subquery = null;
    ExistsCriteria.SubqueryHint hint = null;
    jj_consume_token(EXISTS);
                   hint = getSubqueryHint(getToken(1));
    subquery = subquery(info);
                ExistsCriteria existsCrit = new ExistsCriteria(subquery);
                existsCrit.setSubqueryHint(hint);
            {if (true) return existsCrit;}
    throw new Error("Missing return statement in function");
  }

/*
name=group by clause
description=Defines the grouping columns
example=[source,sql]\n----\nGROUP BY col1, col2\n----\n
*/
  final public GroupBy groupBy(ParseInfo info) throws ParseException {
        List<Expression> expressions = null;
        boolean rollup = false;
    jj_consume_token(GROUP);
    jj_consume_token(BY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROLLUP:
      jj_consume_token(ROLLUP);
      jj_consume_token(LPAREN);
      expressions = expressionList(info);
      jj_consume_token(RPAREN);
       rollup = true;
      break;
    case CHAR:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCAST:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLEXISTS:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case XMLTEXT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      expressions = expressionList(info);
      break;
    default:
      jj_la1[211] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                GroupBy result = new GroupBy(expressions);
                result.setRollup(rollup);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=having clause
description=Search condition applied after grouping.
example=[source,sql]\n----\nHAVING max(col1) = 5\n----\n
*/
  final public Criteria having(ParseInfo info) throws ParseException {
    Criteria criteria = null;
    jj_consume_token(HAVING);
    criteria = criteria(info);
                {if (true) return criteria;}
    throw new Error("Missing return statement in function");
  }

/*
name=order by clause
description=Specifices row ordering.
example=[source,sql]\n----\nORDER BY x, y DESC\n----\n
*/
  final public OrderBy orderby(ParseInfo info) throws ParseException {
    OrderBy orderby = new OrderBy();
    OrderByItem item = null;
    jj_consume_token(ORDER);
    jj_consume_token(BY);
    item = sortSpecification(info);
        orderby.getOrderByItems().add(item);
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[212] = jj_gen;
        break label_27;
      }
      jj_consume_token(COMMA);
      item = sortSpecification(info);
                orderby.getOrderByItems().add(item);
    }
            {if (true) return orderby;}
    throw new Error("Missing return statement in function");
  }

/*
name=sort specification
description=Defines how to sort on a particular expression
example=[source,sql]\n----\ncol1 NULLS FIRST\n----\n
*/
  final public OrderByItem sortSpecification(ParseInfo info) throws ParseException {
    Expression ex = null;
    boolean ascending = true;
    org.teiid.language.SortSpecification.NullOrdering nullOrdering = null;
    ex = sortKey(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
    case DESC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
        jj_consume_token(ASC);
        break;
      case DESC:
        jj_consume_token(DESC);
                         ascending=false;
        break;
      default:
        jj_la1[213] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[214] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULLS:
      jj_consume_token(NULLS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FIRST:
        jj_consume_token(FIRST);
                           nullOrdering=org.teiid.language.SortSpecification.NullOrdering.FIRST;
        break;
      case LAST:
        jj_consume_token(LAST);
                                                                                                            nullOrdering=org.teiid.language.SortSpecification.NullOrdering.LAST;
        break;
      default:
        jj_la1[215] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[216] = jj_gen;
      ;
    }
        OrderByItem item = new OrderByItem(ex, ascending);
        if (nullOrdering != null) {
                item.setNullOrdering(nullOrdering);
        }
        {if (true) return item;}
    throw new Error("Missing return statement in function");
  }

/*
name=sort key
description=A sort expression.
example=[source,sql]\n----\ncol1\n----\n
*/
  final public Expression sortKey(ParseInfo info) throws ParseException {
    Expression ex = null;
    ex = expression(info);
        //legacy support check for positional constants
        if (ex instanceof Constant) {
                boolean valid = false;
            Constant c = (Constant)ex;
            if (c.getValue() instanceof Integer) {
                Integer val = (Integer)c.getValue();
                valid = val.intValue() > 0;
            }
            if (!valid) {
                {if (true) throw new ParseException(QueryPlugin.Util.getString("SQLParser.non_position_constant", ex));} //$NON-NLS-1$
            }
        }
        {if (true) return ex;}
    throw new Error("Missing return statement in function");
  }

/*
name=integer parameter
description=A literal integer or parameter reference to an integer.
example=[source,sql]\n----\n?\n----\n
*/
  final public Expression intParam(ParseInfo info) throws ParseException {
   Expression ex = null;
   Integer val = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNEDINTEGER:
      val = intVal();
     {if (true) return new Constant(val, DataTypeManager.DefaultDataClasses.INTEGER);}
      break;
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCAST:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case XMLTEXT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
    case ESCAPEDFUNCTION:
    case LPAREN:
    case QMARK:
    case DOLLAR:
      ex = unsignedValueExpressionPrimary(info);
     {if (true) return ex;}
      break;
    default:
      jj_la1[217] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=limit clause
description=Limits and/or offsets the resultant rows.
example=[source,sql]\n----\nLIMIT 2\n----\n
*/
  final public Limit limit(ParseInfo info) throws ParseException {
        Expression limit = null;
        Expression offset = null;
        Token t = null;
     t = getToken(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMIT:
      jj_consume_token(LIMIT);
      offset = intParam(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        limit = intParam(info);
        break;
      default:
        jj_la1[218] = jj_gen;
        ;
      }
          if (limit == null) {
            limit = offset;
            offset = null;
          }
      break;
    case OFFSET:
      jj_consume_token(OFFSET);
      offset = intParam(info);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
        jj_consume_token(ROW);
        break;
      case ROWS:
        jj_consume_token(ROWS);
        break;
      default:
        jj_la1[219] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FETCH:
        limit = fetchLimit(info);
        break;
      default:
        jj_la1[220] = jj_gen;
        ;
      }
      break;
    case FETCH:
      limit = fetchLimit(info);
      break;
    default:
      jj_la1[221] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                Limit result = new Limit(offset, limit);
                result.setStrict(!isNonStrictHint(t));
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=fetch clause
description=ANSI limit.
example=[source,sql]\n----\nFETCH FIRST 1 ROWS ONLY\n----\n
*/
  final public Expression fetchLimit(ParseInfo info) throws ParseException {
    Expression limit = null;
    jj_consume_token(FETCH);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIRST:
      jj_consume_token(FIRST);
      break;
    case NEXT:
      jj_consume_token(NEXT);
      break;
    default:
      jj_la1[222] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCAST:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case XMLTEXT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
    case ESCAPEDFUNCTION:
    case UNSIGNEDINTEGER:
    case LPAREN:
    case QMARK:
    case DOLLAR:
      limit = intParam(info);
      break;
    default:
      jj_la1[223] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROW:
      jj_consume_token(ROW);
      break;
    case ROWS:
      jj_consume_token(ROWS);
      break;
    default:
      jj_la1[224] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ONLY);
      if (limit == null) {
        {if (true) return new Constant(1, DataTypeManager.DefaultDataClasses.INTEGER);}
      }
      {if (true) return limit;}
    throw new Error("Missing return statement in function");
  }

/*
name=option clause
description=Specifies query options.
example=[source,sql]\n----\nOPTION MAKEDEP tbl\n----\n
*/
  final public Option option(ParseInfo info) throws ParseException {
        String id = null;
        Token nocache = null;
        Option option = new Option();
        Option.MakeDep makedep = null;
    jj_consume_token(OPTION);
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAKEDEP:
      case MAKEIND:
      case MAKENOTDEP:
      case NOCACHE:
        ;
        break;
      default:
        jj_la1[225] = jj_gen;
        break label_28;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAKEDEP:
        jj_consume_token(MAKEDEP);
        id = id(null);
        makedep = makedepOptions();
            option.addDependentGroup(id, makedep);
        label_29:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[226] = jj_gen;
            break label_29;
          }
          jj_consume_token(COMMA);
          id = id(null);
          makedep = makedepOptions();
                option.addDependentGroup(id, makedep);
        }
        break;
      case MAKEIND:
        jj_consume_token(MAKEIND);
        id = id(null);
        makedep = makedepOptions();
            option.addIndependentGroup(id, makedep);
        label_30:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[227] = jj_gen;
            break label_30;
          }
          jj_consume_token(COMMA);
          id = id(null);
          makedep = makedepOptions();
                option.addIndependentGroup(id, makedep);
        }
        break;
      case MAKENOTDEP:
        jj_consume_token(MAKENOTDEP);
        id = id(null);
            option.addNotDependentGroup(id);
        label_31:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[228] = jj_gen;
            break label_31;
          }
          jj_consume_token(COMMA);
          id = id(null);
                option.addNotDependentGroup(id);
        }
        break;
      case NOCACHE:
        nocache = jj_consume_token(NOCACHE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case PRESERVE:
        case ID:
          id = id(null);
            option.addNoCacheGroup(id);
          label_32:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[229] = jj_gen;
              break label_32;
            }
            jj_consume_token(COMMA);
            id = id(null);
                option.addNoCacheGroup(id);
          }
          break;
        default:
          jj_la1[230] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[231] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                option.setNoCache( (nocache != null) );
                {if (true) return option;}
    throw new Error("Missing return statement in function");
  }

/*
name=expression
description=A value.
example=[source,sql]\n----\ncol1\n----\n
*/
  final public Expression expression(ParseInfo info) throws ParseException {
        Expression expression = null;
    expression = criteria(info);
                if (expression instanceof ExpressionCriteria) {
                        {if (true) return ((ExpressionCriteria)expression).getExpression();}
                }
                {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

/*
name=common value expression
description=Establishes the precedence of concat.
example=[source,sql]\n----\n'a' || 'b'\n----\n
*/
  final public Expression commonValueExpression(ParseInfo info) throws ParseException {
        Expression leftExpression = null;
        Expression rightExpression = null;
        Token operator = null;
    leftExpression = plusExpression(info);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONCAT_OP:
      case DOUBLE_AMP_OP:
        ;
        break;
      default:
        jj_la1[232] = jj_gen;
        break label_33;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOUBLE_AMP_OP:
        operator = jj_consume_token(DOUBLE_AMP_OP);
        break;
      case CONCAT_OP:
        operator = jj_consume_token(CONCAT_OP);
        break;
      default:
        jj_la1[233] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = plusExpression(info);
                                leftExpression = new Function(operator.image, new Expression[] {leftExpression, rightExpression}); //$NON-NLS-1$
                                rightExpression = null;
    }
                {if (true) return leftExpression;}
    throw new Error("Missing return statement in function");
  }

/*
name=numeric value expression
example=[source,sql]\n----\n1 + 2\n----\n
*/
  final public Expression plusExpression(ParseInfo info) throws ParseException {
        Expression leftExpression = null;
        Expression rightExpression = null;
        String operator = null;
    leftExpression = timesExpression(info);
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[234] = jj_gen;
        break label_34;
      }
      operator = plusMinus();
      rightExpression = timesExpression(info);
                                leftExpression = new Function(operator, new Expression[] { leftExpression, rightExpression });
                                rightExpression = null;
                                operator = null;
    }
                {if (true) return leftExpression;}
    throw new Error("Missing return statement in function");
  }

/*
name=plus or minus
description=The + or - operator.
example=[source,sql]\n----\n+\n----\n
*/
  final public String plusMinus() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
      break;
    case MINUS:
      jj_consume_token(MINUS);
      break;
    default:
      jj_la1[235] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

/*
name=term
description=A numeric term
example=[source,sql]\n----\n1 * 2\n----\n
*/
  final public Expression timesExpression(ParseInfo info) throws ParseException {
        Expression leftExpression = null;
        Expression rightExpression = null;
        String operator = null;
    leftExpression = valueExpressionPrimary(info);
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
        ;
        break;
      default:
        jj_la1[236] = jj_gen;
        break label_35;
      }
      operator = timesOperator();
      rightExpression = valueExpressionPrimary(info);
                                leftExpression = new Function(operator, new Expression[] {leftExpression, rightExpression});
                                rightExpression = null;
                                operator = null;
    }
                {if (true) return leftExpression;}
    throw new Error("Missing return statement in function");
  }

/*
name=star or slash
description=The * or / operator.
example=[source,sql]\n----\n/\n----\n
*/
  final public String timesOperator() throws ParseException {
        Token operator = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      operator = jj_consume_token(STAR);
      break;
    case SLASH:
      operator = jj_consume_token(SLASH);
      break;
    default:
      jj_la1[237] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return operator.image;}
    throw new Error("Missing return statement in function");
  }

/*
name=value expression primary
description=A simple value expression.
example=[source,sql]\n----\n+col1\n----\n
*/
  final public Expression valueExpressionPrimary(ParseInfo info) throws ParseException {
        String strVal = null;
        Expression ex = null;
        Expression indexExpr = null;
    List<Expression> indexExprs = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
    case TIME:
    case TIMESTAMP:
    case FALSE:
    case NULL:
    case TRUE:
    case UNKNOWN:
    case ESCAPEDTYPE:
    case STRINGVAL:
    case BINARYSTRINGVAL:
      ex = nonNumericLiteral();
      break;
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCAST:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case XMLTEXT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
    case ESCAPEDFUNCTION:
    case DECIMALVAL:
    case FLOATVAL:
    case UNSIGNEDINTEGER:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        strVal = plusMinus();
        break;
      default:
        jj_la1[238] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECIMALVAL:
      case FLOATVAL:
      case UNSIGNEDINTEGER:
        ex = unsignedNumericLiteral(strVal);
        break;
      case CHAR:
      case CAST:
      case CONVERT:
      case ANY:
      case ARRAY_AGG:
      case CASE:
      case HOUR:
      case INSERT:
      case LEFT:
      case MINUTE:
      case MONTH:
      case RIGHT:
      case SECOND:
      case SOME:
      case TRANSLATE:
      case USER:
      case YEAR:
      case XMLAGG:
      case XMLCAST:
      case XMLCONCAT:
      case XMLCOMMENT:
      case XMLELEMENT:
      case XMLFOREST:
      case XMLPARSE:
      case XMLPI:
      case XMLQUERY:
      case XMLSERIALIZE:
      case XMLTEXT:
      case INSTEAD:
      case ENABLED:
      case DISABLED:
      case VIEW:
      case KEY:
      case SERIAL:
      case TEXTAGG:
      case COUNT:
      case ROW_NUMBER:
      case RANK:
      case DENSE_RANK:
      case SUM:
      case AVG:
      case MIN:
      case MAX:
      case EVERY:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case VAR_SAMP:
      case VAR_POP:
      case DOCUMENT:
      case CONTENT:
      case TRIM:
      case EMPTY:
      case ORDINALITY:
      case PATH:
      case FIRST:
      case LAST:
      case NEXT:
      case SUBSTRING:
      case EXTRACT:
      case TO_CHARS:
      case TO_BYTES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case QUERYSTRING:
      case NAMESPACE:
      case RESULT:
      case INDEX:
      case ACCESSPATTERN:
      case AUTO_INCREMENT:
      case WELLFORMED:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_SECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_HOUR:
      case SQL_TSI_DAY:
      case SQL_TSI_WEEK:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_YEAR:
      case TEXTTABLE:
      case ARRAYTABLE:
      case SELECTOR:
      case SKIP_KEYWORD:
      case WIDTH:
      case PASSING:
      case NAME:
      case ENCODING:
      case COLUMNS:
      case DELIMITER:
      case QUOTE:
      case HEADER:
      case NULLS:
      case OBJECTTABLE:
      case VERSION:
      case INCLUDING:
      case EXCLUDING:
      case XMLDECLARATION:
      case VARIADIC:
      case EXCEPTION:
      case RAISE:
      case CHAIN:
      case JSONARRAY_AGG:
      case JSONOBJECT:
      case PRESERVE:
      case ID:
      case ESCAPEDFUNCTION:
      case LPAREN:
      case QMARK:
      case DOLLAR:
        ex = unsignedValueExpressionPrimary(info);
        label_36:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LSBRACE:
            ;
            break;
          default:
            jj_la1[239] = jj_gen;
            break label_36;
          }
          jj_consume_token(LSBRACE);
          indexExpr = plusExpression(info);
          jj_consume_token(RSBRACE);
           indexExprs = arrayExpressions(indexExprs, indexExpr);
        }
          if (indexExprs != null) {
            for (Expression expr : indexExprs) {
                ex = new Function("array_get", new Expression[] {ex, expr});
            }
          }
         if (strVal != null && strVal.charAt(0) == '-') {
            ex = new Function("*", new Expression[] { new Constant(-1), ex });
         }
        break;
      default:
        jj_la1[240] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[241] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return ex;}
    throw new Error("Missing return statement in function");
  }

/*
name=parameter reference
description=A parameter reference to be bound later.
example=[source,sql]\n----\n?\n----\n
*/
  final public Reference parameterReference(ParseInfo info) throws ParseException {
    Integer index = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
      jj_consume_token(QMARK);
             {if (true) return new Reference(info.referenceCount++);}
      break;
    case DOLLAR:
      jj_consume_token(DOLLAR);
      index = intVal();
                                {if (true) return new Reference(index -1);}
      break;
    default:
      jj_la1[242] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression unescapedFunction(ParseInfo info) throws ParseException {
    Expression expression = null;
    Expression condition = null;
    ParsedDataType type = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case XMLTEXT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
      if (jj_2_35(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TEXTAGG:
          expression = textAgg(info);
          break;
        case ANY:
        case SOME:
        case COUNT:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
          expression = aggregateSymbol(info);
          break;
        case ARRAY_AGG:
        case XMLAGG:
        case JSONARRAY_AGG:
          expression = orderedAgg(info);
          break;
        default:
          jj_la1[243] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FILTER:
          condition = filterClause(info);
          break;
        default:
          jj_la1[244] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OVER:
          expression = windowSpecification(expression, info);
          break;
        default:
          jj_la1[245] = jj_gen;
          ;
        }
      } else if (jj_2_36(2)) {
        expression = analyticAggregateSymbol(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FILTER:
          condition = filterClause(info);
          break;
        default:
          jj_la1[246] = jj_gen;
          ;
        }
        expression = windowSpecification(expression, info);
      } else if (jj_2_37(2)) {
        expression = function(info);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OVER:
          expression = windowSpecification(expression, info);
          break;
        default:
          jj_la1[247] = jj_gen;
          ;
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
        if (condition != null) {
            if (expression instanceof WindowFunction) {
                ((WindowFunction)expression).getFunction().setCondition(condition);
            } else {
                ((AggregateSymbol)expression).setCondition(condition);
            }
        }
        {if (true) return expression;}
      break;
    case XMLCAST:
      jj_consume_token(XMLCAST);
      jj_consume_token(LPAREN);
      expression = expression(info);
      jj_consume_token(AS);
      type = parseDataType();
      jj_consume_token(RPAREN);
        {if (true) return new XMLCast(expression, DataTypeManager.getDataTypeClass(type.type));}
      break;
    default:
      jj_la1[248] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=nested expression
description=An expression nested in parens
example=[source,sql]\n----\n(1)\n----\n
*/
  final public Expression nestedExpression(ParseInfo info) throws ParseException {
    Expression expression = null;
    Expression arrayExpression = null;
    List<Expression> arrayExpressions = null;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case CAST:
    case CONVERT:
    case ANY:
    case ARRAY_AGG:
    case CASE:
    case EXISTS:
    case FALSE:
    case HOUR:
    case INSERT:
    case LEFT:
    case MINUTE:
    case MONTH:
    case NOT:
    case NULL:
    case RIGHT:
    case SECOND:
    case SOME:
    case TRANSLATE:
    case TRUE:
    case UNKNOWN:
    case USER:
    case YEAR:
    case XMLAGG:
    case XMLCAST:
    case XMLCONCAT:
    case XMLCOMMENT:
    case XMLELEMENT:
    case XMLEXISTS:
    case XMLFOREST:
    case XMLPARSE:
    case XMLPI:
    case XMLQUERY:
    case XMLSERIALIZE:
    case XMLTEXT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
    case ESCAPEDFUNCTION:
    case ESCAPEDTYPE:
    case DECIMALVAL:
    case FLOATVAL:
    case STRINGVAL:
    case UNSIGNEDINTEGER:
    case BINARYSTRINGVAL:
    case LPAREN:
    case PLUS:
    case MINUS:
    case QMARK:
    case DOLLAR:
      expression = expression(info);
      label_37:
      while (true) {
        if (jj_2_38(2)) {
          ;
        } else {
          break label_37;
        }
        jj_consume_token(COMMA);
        arrayExpression = expression(info);
          if (expression != null) {
             arrayExpressions = arrayExpressions(arrayExpressions, expression);
             expression = null;
          }
          arrayExpressions = arrayExpressions(arrayExpressions, arrayExpression);
      }
      break;
    default:
      jj_la1[249] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
                  arrayExpressions = arrayExpressions(arrayExpressions, expression);
      break;
    default:
      jj_la1[250] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        if (arrayExpressions != null) {
            expression = new Array(arrayExpressions);
        } else if (expression == null) {
            expression = new Array(new ArrayList<Expression>(0));
        }
        {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

/*
name=unsigned value expression primary
description=An unsigned simple value expression.
example=[source,sql]\n----\ncol1\n----\n
*/
  final public Expression unsignedValueExpressionPrimary(ParseInfo info) throws ParseException {
        Expression expression = null;
        Token symbol = null;
        QueryCommand subquery = null;
        ExistsCriteria.SubqueryHint hint = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QMARK:
    case DOLLAR:
      // Reference
                      expression = parameterReference(info);
      break;
    case ESCAPEDFUNCTION:
      jj_consume_token(ESCAPEDFUNCTION);
      expression = function(info);
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[252] = jj_gen;
      if (jj_2_39(2)) {
        expression = unescapedFunction(info);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INSTEAD:
        case ENABLED:
        case DISABLED:
        case VIEW:
        case KEY:
        case SERIAL:
        case TEXTAGG:
        case COUNT:
        case ROW_NUMBER:
        case RANK:
        case DENSE_RANK:
        case SUM:
        case AVG:
        case MIN:
        case MAX:
        case EVERY:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case VAR_SAMP:
        case VAR_POP:
        case DOCUMENT:
        case CONTENT:
        case TRIM:
        case EMPTY:
        case ORDINALITY:
        case PATH:
        case FIRST:
        case LAST:
        case NEXT:
        case SUBSTRING:
        case EXTRACT:
        case TO_CHARS:
        case TO_BYTES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case QUERYSTRING:
        case NAMESPACE:
        case RESULT:
        case INDEX:
        case ACCESSPATTERN:
        case AUTO_INCREMENT:
        case WELLFORMED:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_SECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_HOUR:
        case SQL_TSI_DAY:
        case SQL_TSI_WEEK:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_YEAR:
        case TEXTTABLE:
        case ARRAYTABLE:
        case SELECTOR:
        case SKIP_KEYWORD:
        case WIDTH:
        case PASSING:
        case NAME:
        case ENCODING:
        case COLUMNS:
        case DELIMITER:
        case QUOTE:
        case HEADER:
        case NULLS:
        case OBJECTTABLE:
        case VERSION:
        case INCLUDING:
        case EXCLUDING:
        case XMLDECLARATION:
        case VARIADIC:
        case EXCEPTION:
        case RAISE:
        case CHAIN:
        case JSONARRAY_AGG:
        case JSONOBJECT:
        case PRESERVE:
        case ID:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ID:
            symbol = jj_consume_token(ID);
                                String symbolImage = symbol.image;
                                if(isStringLiteral(symbolImage, info)) {
                                    {if (true) return new Constant(normalizeStringLiteral(symbolImage));}
                                }
            break;
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
          case PRESERVE:
            symbol = nonReserved();
            break;
          default:
            jj_la1[251] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
                                                   expression = new ElementSymbol(normalizeId(symbol.image));
          break;
        default:
          jj_la1[253] = jj_gen;
          if (jj_2_40(2147483647)) {
                                             hint = getSubqueryHint(getToken(1));
            subquery = subquery(info);
                   ScalarSubquery ss = new ScalarSubquery(subquery);
                   ss.setSubqueryHint(hint);
                   expression = ss;
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LPAREN:
              expression = nestedExpression(info);
              break;
            default:
              jj_la1[254] = jj_gen;
              if (jj_2_41(2)) {
                expression = searchedCaseExpression(info);
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case CASE:
                  // Non-searched CASE expressions
                                  expression = caseExpression(info);
                  break;
                default:
                  jj_la1[255] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
                {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

/*
name=window specification
description=The window specification for an analytical or windowed aggregate function.
example=[source,sql]\n----\nOVER (PARTION BY col1)\n----\n
*/
  final public Expression windowSpecification(Expression agg, ParseInfo info) throws ParseException {
        List<Expression> partitionList = null;
        OrderBy orderBy = null;
    jj_consume_token(OVER);
          if (!(agg instanceof AggregateSymbol)) {
            if (!(agg instanceof Function)) {
              {if (true) throw new ParseException(QueryPlugin.Util.getString("SQLParser.invalid_window", agg));} //$NON-NLS-1$
            }
            Function f = (Function)agg;
            agg = new AggregateSymbol(f.getName(), false, f.getArgs(), null);
          }
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
      jj_consume_token(BY);
      partitionList = expressionList(info);
      break;
    default:
      jj_la1[256] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = orderby(info);
      break;
    default:
      jj_la1[257] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        WindowFunction result = new WindowFunction();
        WindowSpecification ws = new WindowSpecification();
        result.setFunction((AggregateSymbol)agg);
        ws.setPartition(partitionList);
        ws.setOrderBy(orderBy);
        result.setWindowSpecification(ws);
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=case expression
description=If/then/else chain using a common search predicand.
example=[source,sql]\n----\nCASE col1 WHEN 'a' THEN 1 ELSE 2\n----\n
*/
  final public CaseExpression caseExpression(ParseInfo info) throws ParseException {
        Expression expression = null, whenExpression = null, thenExpression = null, elseExpression = null;
        ArrayList whenExpressions = new ArrayList(2);
        ArrayList thenExpressions = new ArrayList(2);
    jj_consume_token(CASE);
    expression = expression(info);
    label_38:
    while (true) {
      jj_consume_token(WHEN);
      whenExpression = expression(info);
      jj_consume_token(THEN);
      thenExpression = expression(info);
                        whenExpressions.add(whenExpression);
                        thenExpressions.add(thenExpression);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        jj_la1[258] = jj_gen;
        break label_38;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      elseExpression = expression(info);
      break;
    default:
      jj_la1[259] = jj_gen;
      ;
    }
    jj_consume_token(END);
                CaseExpression caseExpr = new CaseExpression(expression, whenExpressions, thenExpressions);
                caseExpr.setElseExpression(elseExpression);
                {if (true) return caseExpr;}
    throw new Error("Missing return statement in function");
  }

/*
name=searched case expression
description=If/then/else chain using multiple search conditions.
example=[source,sql]\n----\nCASE WHEN x = 'a' THEN 1 WHEN y = 'b' THEN 2\n----\n
*/
  final public SearchedCaseExpression searchedCaseExpression(ParseInfo info) throws ParseException {
        Expression thenExpression = null, elseExpression = null;
        Criteria whenCriteria = null;
        ArrayList whenCriteriaList = new ArrayList(2);
        ArrayList thenExpressions = new ArrayList(2);
    jj_consume_token(CASE);
    label_39:
    while (true) {
      jj_consume_token(WHEN);
      whenCriteria = criteria(info);
      jj_consume_token(THEN);
      thenExpression = expression(info);
                        whenCriteriaList.add(whenCriteria);
                        thenExpressions.add(thenExpression);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        jj_la1[260] = jj_gen;
        break label_39;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      elseExpression = expression(info);
      break;
    default:
      jj_la1[261] = jj_gen;
      ;
    }
    jj_consume_token(END);
                SearchedCaseExpression caseExpr = new SearchedCaseExpression(whenCriteriaList, thenExpressions);
                caseExpr.setElseExpression(elseExpression);
                {if (true) return caseExpr;}
    throw new Error("Missing return statement in function");
  }

/*
name=function
description=Calls a scalar function.
example=[source,sql]\n----\nfunc('1', col1)\n----\n
*/
  final public Expression function(ParseInfo info) throws ParseException {
        String funcName = null;

        Expression expression = null;
        ArrayList args = new ArrayList(2);
        ArrayList otherArgs = null;
        Token funcToken = null;
        Boolean distinct = null;
        OrderBy orderBy = null;
        Expression condition = null;
        String literal = null;
        ParsedDataType type = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONVERT:
      funcToken = jj_consume_token(CONVERT);
      jj_consume_token(LPAREN);
      expression = expression(info);
                        args.add(expression);
      jj_consume_token(COMMA);
      type = parseDataType();
                        args.add(new Constant(type.type));
      jj_consume_token(RPAREN);
      break;
    case CAST:
      funcToken = jj_consume_token(CAST);
      jj_consume_token(LPAREN);
      expression = expression(info);
                        args.add(expression);
      jj_consume_token(AS);
      type = parseDataType();
                        args.add(new Constant(type.type));
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[282] = jj_gen;
      if (jj_2_43(2)) {
        funcToken = jj_consume_token(SUBSTRING);
        jj_consume_token(LPAREN);
        expression = expression(info);
              args.add(expression);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FROM:
          jj_consume_token(FROM);
          expression = expression(info);
              args.add(expression);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case FOR:
            jj_consume_token(FOR);
            expression = expression(info);
              args.add(expression);
            break;
          default:
            jj_la1[262] = jj_gen;
            ;
          }
          break;
        case COMMA:
          jj_consume_token(COMMA);
          otherArgs = expressionList(info);
                                                          args.addAll(otherArgs);
          break;
        default:
          jj_la1[263] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(RPAREN);
      } else if (jj_2_44(2)) {
        funcToken = jj_consume_token(EXTRACT);
        jj_consume_token(LPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case YEAR:
          funcToken = jj_consume_token(YEAR);
          break;
        case MONTH:
          funcToken = jj_consume_token(MONTH);
          break;
        case DAY:
          funcToken = jj_consume_token(DAY);
          break;
        case HOUR:
          funcToken = jj_consume_token(HOUR);
          break;
        case MINUTE:
          funcToken = jj_consume_token(MINUTE);
          break;
        case SECOND:
          funcToken = jj_consume_token(SECOND);
          break;
        default:
          jj_la1[264] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(FROM);
        expression = expression(info);
                  if (funcToken.image.equalsIgnoreCase("DAY")) {
                 funcName = "DAYOFMONTH";
              }
              args.add(expression);
        jj_consume_token(RPAREN);
      } else if (jj_2_45(2)) {
        funcToken = jj_consume_token(TRIM);
        jj_consume_token(LPAREN);
             funcName = funcToken.image; funcToken = null; expression = null;
        if (jj_2_42(2147483647)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BOTH:
          case LEADING:
          case TRAILING:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LEADING:
              funcToken = jj_consume_token(LEADING);
              break;
            case TRAILING:
              funcToken = jj_consume_token(TRAILING);
              break;
            case BOTH:
              funcToken = jj_consume_token(BOTH);
              break;
            default:
              jj_la1[265] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case CHAR:
            case DATE:
            case TIME:
            case TIMESTAMP:
            case CAST:
            case CONVERT:
            case ANY:
            case ARRAY_AGG:
            case CASE:
            case EXISTS:
            case FALSE:
            case HOUR:
            case INSERT:
            case LEFT:
            case MINUTE:
            case MONTH:
            case NOT:
            case NULL:
            case RIGHT:
            case SECOND:
            case SOME:
            case TRANSLATE:
            case TRUE:
            case UNKNOWN:
            case USER:
            case YEAR:
            case XMLAGG:
            case XMLCAST:
            case XMLCONCAT:
            case XMLCOMMENT:
            case XMLELEMENT:
            case XMLEXISTS:
            case XMLFOREST:
            case XMLPARSE:
            case XMLPI:
            case XMLQUERY:
            case XMLSERIALIZE:
            case XMLTEXT:
            case INSTEAD:
            case ENABLED:
            case DISABLED:
            case VIEW:
            case KEY:
            case SERIAL:
            case TEXTAGG:
            case COUNT:
            case ROW_NUMBER:
            case RANK:
            case DENSE_RANK:
            case SUM:
            case AVG:
            case MIN:
            case MAX:
            case EVERY:
            case STDDEV_POP:
            case STDDEV_SAMP:
            case VAR_SAMP:
            case VAR_POP:
            case DOCUMENT:
            case CONTENT:
            case TRIM:
            case EMPTY:
            case ORDINALITY:
            case PATH:
            case FIRST:
            case LAST:
            case NEXT:
            case SUBSTRING:
            case EXTRACT:
            case TO_CHARS:
            case TO_BYTES:
            case TIMESTAMPADD:
            case TIMESTAMPDIFF:
            case QUERYSTRING:
            case NAMESPACE:
            case RESULT:
            case INDEX:
            case ACCESSPATTERN:
            case AUTO_INCREMENT:
            case WELLFORMED:
            case SQL_TSI_FRAC_SECOND:
            case SQL_TSI_SECOND:
            case SQL_TSI_MINUTE:
            case SQL_TSI_HOUR:
            case SQL_TSI_DAY:
            case SQL_TSI_WEEK:
            case SQL_TSI_MONTH:
            case SQL_TSI_QUARTER:
            case SQL_TSI_YEAR:
            case TEXTTABLE:
            case ARRAYTABLE:
            case SELECTOR:
            case SKIP_KEYWORD:
            case WIDTH:
            case PASSING:
            case NAME:
            case ENCODING:
            case COLUMNS:
            case DELIMITER:
            case QUOTE:
            case HEADER:
            case NULLS:
            case OBJECTTABLE:
            case VERSION:
            case INCLUDING:
            case EXCLUDING:
            case XMLDECLARATION:
            case VARIADIC:
            case EXCEPTION:
            case RAISE:
            case CHAIN:
            case JSONARRAY_AGG:
            case JSONOBJECT:
            case PRESERVE:
            case ID:
            case ESCAPEDFUNCTION:
            case ESCAPEDTYPE:
            case DECIMALVAL:
            case FLOATVAL:
            case STRINGVAL:
            case UNSIGNEDINTEGER:
            case BINARYSTRINGVAL:
            case LPAREN:
            case PLUS:
            case MINUS:
            case QMARK:
            case DOLLAR:
              expression = expression(info);
              break;
            default:
              jj_la1[266] = jj_gen;
              ;
            }
            break;
          case CHAR:
          case DATE:
          case TIME:
          case TIMESTAMP:
          case CAST:
          case CONVERT:
          case ANY:
          case ARRAY_AGG:
          case CASE:
          case EXISTS:
          case FALSE:
          case HOUR:
          case INSERT:
          case LEFT:
          case MINUTE:
          case MONTH:
          case NOT:
          case NULL:
          case RIGHT:
          case SECOND:
          case SOME:
          case TRANSLATE:
          case TRUE:
          case UNKNOWN:
          case USER:
          case YEAR:
          case XMLAGG:
          case XMLCAST:
          case XMLCONCAT:
          case XMLCOMMENT:
          case XMLELEMENT:
          case XMLEXISTS:
          case XMLFOREST:
          case XMLPARSE:
          case XMLPI:
          case XMLQUERY:
          case XMLSERIALIZE:
          case XMLTEXT:
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
          case PRESERVE:
          case ID:
          case ESCAPEDFUNCTION:
          case ESCAPEDTYPE:
          case DECIMALVAL:
          case FLOATVAL:
          case STRINGVAL:
          case UNSIGNEDINTEGER:
          case BINARYSTRINGVAL:
          case LPAREN:
          case PLUS:
          case MINUS:
          case QMARK:
          case DOLLAR:
            expression = expression(info);
            break;
          default:
            jj_la1[267] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(FROM);
        } else {
          ;
        }
              if (funcToken == null) {
                  args.add(new Constant("BOTH"));
              } else {
                  args.add(new Constant(funcToken.image));
              }
              if (expression == null) {
                  args.add(new Constant(" "));
              } else {
                  if (expression instanceof Constant) {
                      Object value = ((Constant)expression).getValue();
                      if (value instanceof String && ((String)value).length() != 1) {
                                      {if (true) throw new ParseException(QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30398, "TRIM CHAR", value));} //$NON-NLS-1$
                      }
                  }
                  args.add(expression);
              }
        expression = expression(info);
              args.add(expression);
        jj_consume_token(RPAREN);
      } else if (jj_2_46(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TO_CHARS:
          funcToken = jj_consume_token(TO_CHARS);
          break;
        case TO_BYTES:
          funcToken = jj_consume_token(TO_BYTES);
          break;
        default:
          jj_la1[268] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
        expression = expression(info);
                        args.add(expression);
        jj_consume_token(COMMA);
        literal = stringVal();
                        args.add(new Constant(literal));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          expression = expression(info);
                                                         args.add(expression);
          break;
        default:
          jj_la1[269] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
      } else if (jj_2_47(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TIMESTAMPADD:
          funcToken = jj_consume_token(TIMESTAMPADD);
          break;
        case TIMESTAMPDIFF:
          funcToken = jj_consume_token(TIMESTAMPDIFF);
          break;
        default:
          jj_la1[270] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
        expression = intervalType();
                        args.add(expression);
        jj_consume_token(COMMA);
        expression = expression(info);
                        args.add(expression);
        jj_consume_token(COMMA);
        expression = expression(info);
                        args.add(expression);
        jj_consume_token(RPAREN);
      } else if (jj_2_48(2)) {
        expression = queryString(info);
                {if (true) return expression;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHAR:
        case HOUR:
        case LEFT:
        case MINUTE:
        case MONTH:
        case RIGHT:
        case SECOND:
        case USER:
        case YEAR:
        case XMLCONCAT:
        case XMLCOMMENT:
        case XMLTEXT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LEFT:
            funcToken = jj_consume_token(LEFT);
            break;
          case RIGHT:
            funcToken = jj_consume_token(RIGHT);
            break;
          case CHAR:
            funcToken = jj_consume_token(CHAR);
            break;
          case USER:
            funcToken = jj_consume_token(USER);
            break;
          case YEAR:
            funcToken = jj_consume_token(YEAR);
            break;
          case MONTH:
            funcToken = jj_consume_token(MONTH);
            break;
          case HOUR:
            funcToken = jj_consume_token(HOUR);
            break;
          case MINUTE:
            funcToken = jj_consume_token(MINUTE);
            break;
          case SECOND:
            funcToken = jj_consume_token(SECOND);
            break;
          case XMLCONCAT:
            funcToken = jj_consume_token(XMLCONCAT);
            break;
          case XMLCOMMENT:
            funcToken = jj_consume_token(XMLCOMMENT);
            break;
          case XMLTEXT:
            funcToken = jj_consume_token(XMLTEXT);
            break;
          default:
            jj_la1[271] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(LPAREN);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CHAR:
          case DATE:
          case TIME:
          case TIMESTAMP:
          case CAST:
          case CONVERT:
          case ANY:
          case ARRAY_AGG:
          case CASE:
          case EXISTS:
          case FALSE:
          case HOUR:
          case INSERT:
          case LEFT:
          case MINUTE:
          case MONTH:
          case NOT:
          case NULL:
          case RIGHT:
          case SECOND:
          case SOME:
          case TRANSLATE:
          case TRUE:
          case UNKNOWN:
          case USER:
          case YEAR:
          case XMLAGG:
          case XMLCAST:
          case XMLCONCAT:
          case XMLCOMMENT:
          case XMLELEMENT:
          case XMLEXISTS:
          case XMLFOREST:
          case XMLPARSE:
          case XMLPI:
          case XMLQUERY:
          case XMLSERIALIZE:
          case XMLTEXT:
          case INSTEAD:
          case ENABLED:
          case DISABLED:
          case VIEW:
          case KEY:
          case SERIAL:
          case TEXTAGG:
          case COUNT:
          case ROW_NUMBER:
          case RANK:
          case DENSE_RANK:
          case SUM:
          case AVG:
          case MIN:
          case MAX:
          case EVERY:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case VAR_SAMP:
          case VAR_POP:
          case DOCUMENT:
          case CONTENT:
          case TRIM:
          case EMPTY:
          case ORDINALITY:
          case PATH:
          case FIRST:
          case LAST:
          case NEXT:
          case SUBSTRING:
          case EXTRACT:
          case TO_CHARS:
          case TO_BYTES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case QUERYSTRING:
          case NAMESPACE:
          case RESULT:
          case INDEX:
          case ACCESSPATTERN:
          case AUTO_INCREMENT:
          case WELLFORMED:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_SECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_HOUR:
          case SQL_TSI_DAY:
          case SQL_TSI_WEEK:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_YEAR:
          case TEXTTABLE:
          case ARRAYTABLE:
          case SELECTOR:
          case SKIP_KEYWORD:
          case WIDTH:
          case PASSING:
          case NAME:
          case ENCODING:
          case COLUMNS:
          case DELIMITER:
          case QUOTE:
          case HEADER:
          case NULLS:
          case OBJECTTABLE:
          case VERSION:
          case INCLUDING:
          case EXCLUDING:
          case XMLDECLARATION:
          case VARIADIC:
          case EXCEPTION:
          case RAISE:
          case CHAIN:
          case JSONARRAY_AGG:
          case JSONOBJECT:
          case PRESERVE:
          case ID:
          case ESCAPEDFUNCTION:
          case ESCAPEDTYPE:
          case DECIMALVAL:
          case FLOATVAL:
          case STRINGVAL:
          case UNSIGNEDINTEGER:
          case BINARYSTRINGVAL:
          case LPAREN:
          case PLUS:
          case MINUS:
          case QMARK:
          case DOLLAR:
            args = expressionList(info);
            break;
          default:
            jj_la1[272] = jj_gen;
            ;
          }
          jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[283] = jj_gen;
          if (jj_2_49(2147483647)) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case TRANSLATE:
              funcToken = jj_consume_token(TRANSLATE);
              break;
            case INSERT:
              funcToken = jj_consume_token(INSERT);
              break;
            default:
              jj_la1[273] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            jj_consume_token(LPAREN);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case CHAR:
            case DATE:
            case TIME:
            case TIMESTAMP:
            case CAST:
            case CONVERT:
            case ANY:
            case ARRAY_AGG:
            case CASE:
            case EXISTS:
            case FALSE:
            case HOUR:
            case INSERT:
            case LEFT:
            case MINUTE:
            case MONTH:
            case NOT:
            case NULL:
            case RIGHT:
            case SECOND:
            case SOME:
            case TRANSLATE:
            case TRUE:
            case UNKNOWN:
            case USER:
            case YEAR:
            case XMLAGG:
            case XMLCAST:
            case XMLCONCAT:
            case XMLCOMMENT:
            case XMLELEMENT:
            case XMLEXISTS:
            case XMLFOREST:
            case XMLPARSE:
            case XMLPI:
            case XMLQUERY:
            case XMLSERIALIZE:
            case XMLTEXT:
            case INSTEAD:
            case ENABLED:
            case DISABLED:
            case VIEW:
            case KEY:
            case SERIAL:
            case TEXTAGG:
            case COUNT:
            case ROW_NUMBER:
            case RANK:
            case DENSE_RANK:
            case SUM:
            case AVG:
            case MIN:
            case MAX:
            case EVERY:
            case STDDEV_POP:
            case STDDEV_SAMP:
            case VAR_SAMP:
            case VAR_POP:
            case DOCUMENT:
            case CONTENT:
            case TRIM:
            case EMPTY:
            case ORDINALITY:
            case PATH:
            case FIRST:
            case LAST:
            case NEXT:
            case SUBSTRING:
            case EXTRACT:
            case TO_CHARS:
            case TO_BYTES:
            case TIMESTAMPADD:
            case TIMESTAMPDIFF:
            case QUERYSTRING:
            case NAMESPACE:
            case RESULT:
            case INDEX:
            case ACCESSPATTERN:
            case AUTO_INCREMENT:
            case WELLFORMED:
            case SQL_TSI_FRAC_SECOND:
            case SQL_TSI_SECOND:
            case SQL_TSI_MINUTE:
            case SQL_TSI_HOUR:
            case SQL_TSI_DAY:
            case SQL_TSI_WEEK:
            case SQL_TSI_MONTH:
            case SQL_TSI_QUARTER:
            case SQL_TSI_YEAR:
            case TEXTTABLE:
            case ARRAYTABLE:
            case SELECTOR:
            case SKIP_KEYWORD:
            case WIDTH:
            case PASSING:
            case NAME:
            case ENCODING:
            case COLUMNS:
            case DELIMITER:
            case QUOTE:
            case HEADER:
            case NULLS:
            case OBJECTTABLE:
            case VERSION:
            case INCLUDING:
            case EXCLUDING:
            case XMLDECLARATION:
            case VARIADIC:
            case EXCEPTION:
            case RAISE:
            case CHAIN:
            case JSONARRAY_AGG:
            case JSONOBJECT:
            case PRESERVE:
            case ID:
            case ESCAPEDFUNCTION:
            case ESCAPEDTYPE:
            case DECIMALVAL:
            case FLOATVAL:
            case STRINGVAL:
            case UNSIGNEDINTEGER:
            case BINARYSTRINGVAL:
            case LPAREN:
            case PLUS:
            case MINUS:
            case QMARK:
            case DOLLAR:
              args = expressionList(info);
              break;
            default:
              jj_la1[274] = jj_gen;
              ;
            }
            jj_consume_token(RPAREN);
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case XMLPARSE:
              expression = xmlParse(info);
                {if (true) return expression;}
              break;
            case XMLELEMENT:
              expression = xmlElement(info);
                {if (true) return expression;}
              break;
            case XMLPI:
              funcToken = jj_consume_token(XMLPI);
              jj_consume_token(LPAREN);
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case NAME:
                jj_consume_token(NAME);
                break;
              default:
                jj_la1[275] = jj_gen;
                ;
              }
              literal = id(null);
                        args.add(new Constant(literal));
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case COMMA:
                jj_consume_token(COMMA);
                expression = expression(info);
                                args.add(expression);
                break;
              default:
                jj_la1[276] = jj_gen;
                ;
              }
              jj_consume_token(RPAREN);
              break;
            case XMLFOREST:
              expression = xmlForest(info);
                        {if (true) return expression;}
              break;
            default:
              jj_la1[284] = jj_gen;
              if (jj_2_50(2147483647)) {
                expression = jsonObject(info);
                        {if (true) return expression;}
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case XMLSERIALIZE:
                  expression = xmlSerialize(info);
                        {if (true) return expression;}
                  break;
                case XMLQUERY:
                  expression = xmlQuery(info);
                        {if (true) return expression;}
                  break;
                case INSTEAD:
                case ENABLED:
                case DISABLED:
                case VIEW:
                case KEY:
                case SERIAL:
                case TEXTAGG:
                case COUNT:
                case ROW_NUMBER:
                case RANK:
                case DENSE_RANK:
                case SUM:
                case AVG:
                case MIN:
                case MAX:
                case EVERY:
                case STDDEV_POP:
                case STDDEV_SAMP:
                case VAR_SAMP:
                case VAR_POP:
                case DOCUMENT:
                case CONTENT:
                case TRIM:
                case EMPTY:
                case ORDINALITY:
                case PATH:
                case FIRST:
                case LAST:
                case NEXT:
                case SUBSTRING:
                case EXTRACT:
                case TO_CHARS:
                case TO_BYTES:
                case TIMESTAMPADD:
                case TIMESTAMPDIFF:
                case QUERYSTRING:
                case NAMESPACE:
                case RESULT:
                case INDEX:
                case ACCESSPATTERN:
                case AUTO_INCREMENT:
                case WELLFORMED:
                case SQL_TSI_FRAC_SECOND:
                case SQL_TSI_SECOND:
                case SQL_TSI_MINUTE:
                case SQL_TSI_HOUR:
                case SQL_TSI_DAY:
                case SQL_TSI_WEEK:
                case SQL_TSI_MONTH:
                case SQL_TSI_QUARTER:
                case SQL_TSI_YEAR:
                case TEXTTABLE:
                case ARRAYTABLE:
                case SELECTOR:
                case SKIP_KEYWORD:
                case WIDTH:
                case PASSING:
                case NAME:
                case ENCODING:
                case COLUMNS:
                case DELIMITER:
                case QUOTE:
                case HEADER:
                case NULLS:
                case OBJECTTABLE:
                case VERSION:
                case INCLUDING:
                case EXCLUDING:
                case XMLDECLARATION:
                case VARIADIC:
                case EXCEPTION:
                case RAISE:
                case CHAIN:
                case JSONARRAY_AGG:
                case JSONOBJECT:
                case PRESERVE:
                case ID:
                  funcName = id(null);
                  jj_consume_token(LPAREN);
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case ALL:
                  case DISTINCT:
                    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                    case ALL:
                      jj_consume_token(ALL);
                         distinct = false;
                      break;
                    case DISTINCT:
                      jj_consume_token(DISTINCT);
                                                           distinct = true;
                      break;
                    default:
                      jj_la1[277] = jj_gen;
                      jj_consume_token(-1);
                      throw new ParseException();
                    }
                    break;
                  default:
                    jj_la1[278] = jj_gen;
                    ;
                  }
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case CHAR:
                  case DATE:
                  case TIME:
                  case TIMESTAMP:
                  case CAST:
                  case CONVERT:
                  case ANY:
                  case ARRAY_AGG:
                  case CASE:
                  case EXISTS:
                  case FALSE:
                  case HOUR:
                  case INSERT:
                  case LEFT:
                  case MINUTE:
                  case MONTH:
                  case NOT:
                  case NULL:
                  case RIGHT:
                  case SECOND:
                  case SOME:
                  case TRANSLATE:
                  case TRUE:
                  case UNKNOWN:
                  case USER:
                  case YEAR:
                  case XMLAGG:
                  case XMLCAST:
                  case XMLCONCAT:
                  case XMLCOMMENT:
                  case XMLELEMENT:
                  case XMLEXISTS:
                  case XMLFOREST:
                  case XMLPARSE:
                  case XMLPI:
                  case XMLQUERY:
                  case XMLSERIALIZE:
                  case XMLTEXT:
                  case INSTEAD:
                  case ENABLED:
                  case DISABLED:
                  case VIEW:
                  case KEY:
                  case SERIAL:
                  case TEXTAGG:
                  case COUNT:
                  case ROW_NUMBER:
                  case RANK:
                  case DENSE_RANK:
                  case SUM:
                  case AVG:
                  case MIN:
                  case MAX:
                  case EVERY:
                  case STDDEV_POP:
                  case STDDEV_SAMP:
                  case VAR_SAMP:
                  case VAR_POP:
                  case DOCUMENT:
                  case CONTENT:
                  case TRIM:
                  case EMPTY:
                  case ORDINALITY:
                  case PATH:
                  case FIRST:
                  case LAST:
                  case NEXT:
                  case SUBSTRING:
                  case EXTRACT:
                  case TO_CHARS:
                  case TO_BYTES:
                  case TIMESTAMPADD:
                  case TIMESTAMPDIFF:
                  case QUERYSTRING:
                  case NAMESPACE:
                  case RESULT:
                  case INDEX:
                  case ACCESSPATTERN:
                  case AUTO_INCREMENT:
                  case WELLFORMED:
                  case SQL_TSI_FRAC_SECOND:
                  case SQL_TSI_SECOND:
                  case SQL_TSI_MINUTE:
                  case SQL_TSI_HOUR:
                  case SQL_TSI_DAY:
                  case SQL_TSI_WEEK:
                  case SQL_TSI_MONTH:
                  case SQL_TSI_QUARTER:
                  case SQL_TSI_YEAR:
                  case TEXTTABLE:
                  case ARRAYTABLE:
                  case SELECTOR:
                  case SKIP_KEYWORD:
                  case WIDTH:
                  case PASSING:
                  case NAME:
                  case ENCODING:
                  case COLUMNS:
                  case DELIMITER:
                  case QUOTE:
                  case HEADER:
                  case NULLS:
                  case OBJECTTABLE:
                  case VERSION:
                  case INCLUDING:
                  case EXCLUDING:
                  case XMLDECLARATION:
                  case VARIADIC:
                  case EXCEPTION:
                  case RAISE:
                  case CHAIN:
                  case JSONARRAY_AGG:
                  case JSONOBJECT:
                  case PRESERVE:
                  case ID:
                  case ESCAPEDFUNCTION:
                  case ESCAPEDTYPE:
                  case DECIMALVAL:
                  case FLOATVAL:
                  case STRINGVAL:
                  case UNSIGNEDINTEGER:
                  case BINARYSTRINGVAL:
                  case LPAREN:
                  case PLUS:
                  case MINUS:
                  case QMARK:
                  case DOLLAR:
                    args = expressionList(info);
                    break;
                  default:
                    jj_la1[279] = jj_gen;
                    ;
                  }
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case ORDER:
                    orderBy = orderby(info);
                    break;
                  default:
                    jj_la1[280] = jj_gen;
                    ;
                  }
                  jj_consume_token(RPAREN);
                  switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                  case FILTER:
                    condition = filterClause(info);
                    break;
                  default:
                    jj_la1[281] = jj_gen;
                    ;
                  }
                  break;
                default:
                  jj_la1[285] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
                if(funcName == null) {
                        funcName = funcToken.image;
                }
                if (distinct != null || orderBy != null || condition != null || "string_agg".equalsIgnoreCase(funcName)) {
                        AggregateSymbol as = new AggregateSymbol(funcName, distinct!=null?distinct:false, (Expression[])args.toArray(new Expression[args.size()]), orderBy);
                        as.setCondition(condition);
                        {if (true) return as;}
                }
                {if (true) return new Function(funcName, (Expression[])args.toArray(new Expression[args.size()]));}
    throw new Error("Missing return statement in function");
  }

/*
name=xml parse
description=Parses the given value as XML.
example=[source,sql]\n----\nXMLPARSE(DOCUMENT doc WELLFORMED)\n----\n
*/
  final public XMLParse xmlParse(ParseInfo info) throws ParseException {
        Expression expr = null;
        boolean doc = false;
        boolean wellformed = false;
    jj_consume_token(XMLPARSE);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOCUMENT:
      jj_consume_token(DOCUMENT);
                     doc = true;
      break;
    case CONTENT:
      jj_consume_token(CONTENT);
                                              doc = false;
      break;
    default:
      jj_la1[286] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    expr = expression(info);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WELLFORMED:
      jj_consume_token(WELLFORMED);
           wellformed = true;
      break;
    default:
      jj_la1[287] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
                XMLParse result = new XMLParse();
                result.setDocument(doc);
                result.setExpression(expr);
                result.setWellFormed(wellformed);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=querystring function
description=Produces a URL query string from the given arguments.
example=[source,sql]\n----\nQUERYSTRING('path', col1 AS opt, col2 AS val)\n----\n
*/
  final public QueryString queryString(ParseInfo info) throws ParseException {
        Expression path = null;
        DerivedColumn arg = null;
        ArrayList<DerivedColumn> args = new ArrayList<DerivedColumn>(2);
    jj_consume_token(QUERYSTRING);
    jj_consume_token(LPAREN);
    path = expression(info);
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[288] = jj_gen;
        break label_40;
      }
      jj_consume_token(COMMA);
      arg = derivedColumn(info);
                args.add(arg);
                arg = null;
    }
    jj_consume_token(RPAREN);
                {if (true) return new QueryString(path, args);}
    throw new Error("Missing return statement in function");
  }

/*
name=xml element
description=Creates an XML element.
example=[source,sql]\n----\nXMLELEMENT(NAME "root", child)\n----\n
*/
  final public XMLElement xmlElement(ParseInfo info) throws ParseException {
        String name = null;
        ArrayList content = new ArrayList(2);
        XMLNamespaces xmlNamespaces = null;
        XMLAttributes xmlAttributes = null;
        Expression expression = null;
    jj_consume_token(XMLELEMENT);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAME:
      jj_consume_token(NAME);
      break;
    default:
      jj_la1[289] = jj_gen;
      ;
    }
    name = id(null);
    if (jj_2_51(2)) {
      jj_consume_token(COMMA);
      xmlNamespaces = xmlNamespaces(info);
    } else {
      ;
    }
    if (jj_2_52(2)) {
      jj_consume_token(COMMA);
      xmlAttributes = xmlAttributes(info);
    } else {
      ;
    }
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[290] = jj_gen;
        break label_41;
      }
      jj_consume_token(COMMA);
      expression = expression(info);
                content.add(expression);
    }
    jj_consume_token(RPAREN);
                XMLElement result = new XMLElement(name, content);
                result.setNamespaces(xmlNamespaces);
                result.setAttributes(xmlAttributes);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=xml attributes
description=Creates attributes for the containing element.
example=[source,sql]\n----\nXMLATTRIBUTES(col1 AS attr1, col2 AS attr2)\n----\n
*/
  final public XMLAttributes xmlAttributes(ParseInfo info) throws ParseException {
        DerivedColumn expression = null;
        ArrayList<DerivedColumn> args = new ArrayList<DerivedColumn>(2);
    jj_consume_token(XMLATTRIBUTES);
    jj_consume_token(LPAREN);
    expression = derivedColumn(info);
                args.add(expression);
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[291] = jj_gen;
        break label_42;
      }
      jj_consume_token(COMMA);
      expression = derivedColumn(info);
                args.add(expression);
    }
    jj_consume_token(RPAREN);
                {if (true) return new XMLAttributes(args);}
    throw new Error("Missing return statement in function");
  }

/*
name=json object
description=Produces a JSON object containing name value pairs.
example=[source,sql]\n----\nJSONOBJECT(col1 AS val1, col2 AS val2)\n----\n
*/
  final public JSONObject jsonObject(ParseInfo info) throws ParseException {
        ArrayList<DerivedColumn> args = null;
    jj_consume_token(JSONOBJECT);
    jj_consume_token(LPAREN);
    args = derivedColumnList(info);
    jj_consume_token(RPAREN);
                JSONObject result = new JSONObject(args);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=derived column list
description=a list of name value pairs
example=[source,sql]\n----\ncol1 AS val1, col2 AS val2\n----\n
*/
  final public ArrayList<DerivedColumn> derivedColumnList(ParseInfo info) throws ParseException {
        DerivedColumn expression = null;
        ArrayList<DerivedColumn> args = new ArrayList<DerivedColumn>(2);
    expression = derivedColumn(info);
                args.add(expression);
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[292] = jj_gen;
        break label_43;
      }
      jj_consume_token(COMMA);
      expression = derivedColumn(info);
                args.add(expression);
    }
                {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

/*
name=xml forest
description=Produces an element for each derived column.
example=[source,sql]\n----\nXMLFOREST(col1 AS ELEM1, col2 AS ELEM2)\n----\n
*/
  final public XMLForest xmlForest(ParseInfo info) throws ParseException {
        DerivedColumn expression = null;
        XMLNamespaces xmlNamespaces = null;
        ArrayList<DerivedColumn> args = null;
    jj_consume_token(XMLFOREST);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case XMLNAMESPACES:
      xmlNamespaces = xmlNamespaces(info);
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[293] = jj_gen;
      ;
    }
    args = derivedColumnList(info);
    jj_consume_token(RPAREN);
                XMLForest result = new XMLForest(args);
                result.setNamespaces(xmlNamespaces);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/*
name=xml namespaces
description=Defines XML namespace URI/prefix combinations
example=[source,sql]\n----\nXMLNAMESPACES('http://foo' AS foo)\n----\n
*/
  final public XMLNamespaces xmlNamespaces(ParseInfo info) throws ParseException {
        ArrayList namespaces = new ArrayList(2);
        XMLNamespaces.NamespaceItem item = null;
    jj_consume_token(XMLNAMESPACES);
    jj_consume_token(LPAREN);
    item = namespaceItem();
                namespaces.add(item);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[294] = jj_gen;
        break label_44;
      }
      jj_consume_token(COMMA);
      item = namespaceItem();
                 namespaces.add(item);
    }
    jj_consume_token(RPAREN);
                {if (true) return new XMLNamespaces(namespaces);}
    throw new Error("Missing return statement in function");
  }

/*
name=xml namespace element
description=An xml namespace
example=[source,sql]\n----\nNO DEFAULT\n----\n
*/
  final public XMLNamespaces.NamespaceItem namespaceItem() throws ParseException {
        String uri = null;
        String prefix = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRINGVAL:
      uri = stringVal();
      jj_consume_token(AS);
      prefix = id(null);
                        {if (true) return new XMLNamespaces.NamespaceItem(uri, prefix);}
      break;
    case NO:
      jj_consume_token(NO);
      jj_consume_token(DEFAULT_KEYWORD);
                        {if (true) return new XMLNamespaces.NamespaceItem();}
      break;
    case DEFAULT_KEYWORD:
      jj_consume_token(DEFAULT_KEYWORD);
      uri = stringVal();
                        {if (true) return new XMLNamespaces.NamespaceItem(uri);}
      break;
    default:
      jj_la1[295] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=simple data type
description=A non-collection data type.
example=[source,sql]\n----\nSTRING\n----\n
*/
  final public ParsedDataType parseDataTypePrimary() throws ParseException {
        Token typeToken = null;
        Integer length = null;
        Integer scale = null;
        boolean precision = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      typeToken = jj_consume_token(STRING);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[296] = jj_gen;
        ;
      }
                                                                           precision = false;
      break;
    case VARCHAR:
      typeToken = jj_consume_token(VARCHAR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[297] = jj_gen;
        ;
      }
                                                                            precision = false;
      break;
    case BOOLEAN:
      typeToken = jj_consume_token(BOOLEAN);
      break;
    case BYTE:
      typeToken = jj_consume_token(BYTE);
      break;
    case TINYINT:
      typeToken = jj_consume_token(TINYINT);
      break;
    case SHORT:
      typeToken = jj_consume_token(SHORT);
      break;
    case SMALLINT:
      typeToken = jj_consume_token(SMALLINT);
      break;
    case CHAR:
      typeToken = jj_consume_token(CHAR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[298] = jj_gen;
        ;
      }
                                                                         precision = false;
      break;
    case INTEGER:
      typeToken = jj_consume_token(INTEGER);
      break;
    case LONG:
      typeToken = jj_consume_token(LONG);
      break;
    case BIGINT:
      typeToken = jj_consume_token(BIGINT);
      break;
    case BIGINTEGER:
      typeToken = jj_consume_token(BIGINTEGER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[299] = jj_gen;
        ;
      }
      break;
    case FLOAT:
      typeToken = jj_consume_token(FLOAT);
      break;
    case REAL:
      typeToken = jj_consume_token(REAL);
      break;
    case DOUBLE:
      typeToken = jj_consume_token(DOUBLE);
      break;
    case BIGDECIMAL:
      typeToken = jj_consume_token(BIGDECIMAL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          scale = intVal();
          break;
        default:
          jj_la1[300] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[301] = jj_gen;
        ;
      }
      break;
    case DECIMAL:
      typeToken = jj_consume_token(DECIMAL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          scale = intVal();
          break;
        default:
          jj_la1[302] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[303] = jj_gen;
        ;
      }
      break;
    case DATE:
      typeToken = jj_consume_token(DATE);
      break;
    case TIME:
      typeToken = jj_consume_token(TIME);
      break;
    case TIMESTAMP:
      typeToken = jj_consume_token(TIMESTAMP);
      break;
    case OBJECT:
      typeToken = jj_consume_token(OBJECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[304] = jj_gen;
        ;
      }
                                                                           precision = false;
      break;
    case BLOB:
      typeToken = jj_consume_token(BLOB);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[305] = jj_gen;
        ;
      }
                                                                         precision = false;
      break;
    case CLOB:
      typeToken = jj_consume_token(CLOB);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[306] = jj_gen;
        ;
      }
                                                                         precision = false;
      break;
    case VARBINARY:
      typeToken = jj_consume_token(VARBINARY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        length = intVal();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[307] = jj_gen;
        ;
      }
                                                                              precision = false;
      break;
    case GEOMETRY:
      typeToken = jj_consume_token(GEOMETRY);
      break;
    case XML:
      typeToken = jj_consume_token(XML);
      break;
    default:
      jj_la1[308] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            String typeName = typeToken.image;
                if (scale != null){
                        {if (true) return new ParsedDataType(typeName, length, scale, precision);}
                }
                else if (length != null){
                        {if (true) return new ParsedDataType(typeName, length, precision);}
                }
                {if (true) return new ParsedDataType(typeName);}
    throw new Error("Missing return statement in function");
  }

/*
name=data type
description=A data type.
example=[source,sql]\n----\nSTRING[]\n----\n
*/
  final public ParsedDataType parseDataType() throws ParseException {
    int arraySuffixes = 0;
    ParsedDataType type = null;
    type = parseDataTypePrimary();
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSBRACE:
        ;
        break;
      default:
        jj_la1[309] = jj_gen;
        break label_45;
      }
      jj_consume_token(LSBRACE);
      jj_consume_token(RSBRACE);
                         arraySuffixes++;
    }
        if (arraySuffixes > 0) {
           type.type += StringUtil.join(Collections.nCopies(arraySuffixes, "[]"), "");
        }
        {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

/*
name=time interval
description=A time interval keyword.
example=[source,sql]\n----\nSQL_TSI_HOUR\n----\n
*/
  final public Constant intervalType() throws ParseException {
        Token type = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQL_TSI_FRAC_SECOND:
      type = jj_consume_token(SQL_TSI_FRAC_SECOND);
      break;
    case SQL_TSI_SECOND:
      type = jj_consume_token(SQL_TSI_SECOND);
      break;
    case SQL_TSI_MINUTE:
      type = jj_consume_token(SQL_TSI_MINUTE);
      break;
    case SQL_TSI_HOUR:
      type = jj_consume_token(SQL_TSI_HOUR);
      break;
    case SQL_TSI_DAY:
      type = jj_consume_token(SQL_TSI_DAY);
      break;
    case SQL_TSI_WEEK:
      type = jj_consume_token(SQL_TSI_WEEK);
      break;
    case SQL_TSI_MONTH:
      type = jj_consume_token(SQL_TSI_MONTH);
      break;
    case SQL_TSI_QUARTER:
      type = jj_consume_token(SQL_TSI_QUARTER);
      break;
    case SQL_TSI_YEAR:
      type = jj_consume_token(SQL_TSI_YEAR);
      break;
    default:
      jj_la1[310] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return new Constant(type.image);}
    throw new Error("Missing return statement in function");
  }

/*
name=non numeric literal
description=An escaped or simple non numeric literal.
example=[source,sql]\n----\n'a'\n----\n
*/
  final public Constant nonNumericLiteral() throws ParseException {
    Token t = null;
    String strVal = "";
    Class escapeType = null;
    Constant constant = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRINGVAL:
      strVal = stringVal();
                        constant = new Constant(strVal, DataTypeManager.DefaultDataClasses.STRING);
      break;
    case BINARYSTRINGVAL:
      t = jj_consume_token(BINARYSTRINGVAL);
                                      constant = new Constant(new BinaryType(javax.xml.bind.DatatypeConverter.parseHexBinary(t.image.substring(2, t.image.length() - 1))), DataTypeManager.DefaultDataClasses.VARBINARY);
      break;
    case FALSE:
      t = jj_consume_token(FALSE);
                               constant = new Constant(Boolean.FALSE, DataTypeManager.DefaultDataClasses.BOOLEAN);
      break;
    case TRUE:
      t = jj_consume_token(TRUE);
                               constant = new Constant(Boolean.TRUE, DataTypeManager.DefaultDataClasses.BOOLEAN);
      break;
    case UNKNOWN:
      t = jj_consume_token(UNKNOWN);
                       constant = new Constant(null, DataTypeManager.DefaultDataClasses.BOOLEAN);
      break;
    case NULL:
      t = jj_consume_token(NULL);
                       constant = new Constant(null);
      break;
    case ESCAPEDTYPE:
      jj_consume_token(ESCAPEDTYPE);
            String image = getToken(0).image;
                if (StringUtil.endsWithIgnoreCase(image, "b")) {
                        escapeType=DataTypeManager.DefaultDataClasses.BOOLEAN;
                } else if (StringUtil.endsWithIgnoreCase(image, "ts")) {
                        escapeType=DataTypeManager.DefaultDataClasses.TIMESTAMP;
                } else if (StringUtil.endsWithIgnoreCase(image, "d")) {
                        escapeType=DataTypeManager.DefaultDataClasses.DATE;
                } else {
                        escapeType=DataTypeManager.DefaultDataClasses.TIME;
                }
      strVal = stringVal();
                        try {
                                constant = new Constant(DataTypeManager.transformValue(strVal, escapeType), escapeType);
                        } catch (TransformationException e) {
                                {if (true) throw new ParseException(e.getMessage());} //$NON-NLS-1$
                        }
      jj_consume_token(RBRACE);
      break;
    case DATE:
    case TIME:
    case TIMESTAMP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DATE:
        jj_consume_token(DATE);
                       escapeType = DataTypeManager.DefaultDataClasses.DATE;
        break;
      case TIME:
        jj_consume_token(TIME);
                         escapeType = DataTypeManager.DefaultDataClasses.TIME;
        break;
      case TIMESTAMP:
        jj_consume_token(TIMESTAMP);
                              escapeType = DataTypeManager.DefaultDataClasses.TIMESTAMP;
        break;
      default:
        jj_la1[311] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      strVal = stringVal();
                try {
                    constant = new Constant(DataTypeManager.transformValue(strVal, escapeType), escapeType);
                } catch (TransformationException e) {
                    {if (true) throw new ParseException(e.getMessage());} //$NON-NLS-1$
                }
      break;
    default:
      jj_la1[312] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return constant;}
    throw new Error("Missing return statement in function");
  }

/*
name=unsigned numeric literal
description=An unsigned numeric literal value.
example=[source,sql]\n----\n1.234\n----\n
*/
  final public Constant unsignedNumericLiteral(String strVal) throws ParseException {
    Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNEDINTEGER:
      t = jj_consume_token(UNSIGNEDINTEGER);
                        try {
                            strVal = prependSign(strVal, t.image);
                                // First try as integer - this should nearly always work
                                {if (true) return new Constant(Integer.valueOf(strVal), DataTypeManager.DefaultDataClasses.INTEGER);}
                        } catch(NumberFormatException e1) {
                                try {
                                        // Second try as a long
                                        {if (true) return new Constant(Long.valueOf(strVal), DataTypeManager.DefaultDataClasses.LONG);}
                                } catch(NumberFormatException e2) {
                                        try {
                                                // Third try as a biginteger
                                                {if (true) return new Constant(new BigInteger(strVal), DataTypeManager.DefaultDataClasses.BIG_INTEGER);}
                                        } catch(NumberFormatException e3) {
                                                Object[] params = new Object[] { strVal };
                                                {if (true) throw new ParseException(QueryPlugin.Util.getString("SQLParser.Integer_parse", params));} //$NON-NLS-1$
                                        }
                                }
                        }
      break;
    case FLOATVAL:
      t = jj_consume_token(FLOATVAL);
                    strVal = prependSign(strVal, t.image);
                        try {
                                {if (true) return new Constant(Double.valueOf(strVal), DataTypeManager.DefaultDataClasses.DOUBLE);}
                        } catch(NumberFormatException e) {
                                Object[] params = new Object[] { strVal };
                                {if (true) throw new ParseException(QueryPlugin.Util.getString("SQLParser.Float_parse", params));} //$NON-NLS-1$
                        }
      break;
    case DECIMALVAL:
      t = jj_consume_token(DECIMALVAL);
                strVal = prependSign(strVal, t.image);
                        try {
                            if (DECIMAL_AS_DOUBLE) {
                                {if (true) return new Constant(Double.valueOf(strVal), DataTypeManager.DefaultDataClasses.DOUBLE);}
                                } else {
                                {if (true) return new Constant(new java.math.BigDecimal(strVal), DataTypeManager.DefaultDataClasses.BIG_DECIMAL);}
                                }
                        } catch(NumberFormatException e) {
                                Object[] params = new Object[] { t.image };
                                {if (true) throw new ParseException(QueryPlugin.Util.getString("SQLParser.decimal_parse", params));} //$NON-NLS-1$
                        }
      break;
    default:
      jj_la1[313] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
unused=true
*/
  final public void parseMetadata(MetadataFactory factory) throws ParseException {
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALTER:
      case CREATE:
      case SET:
        ;
        break;
      default:
        jj_la1[314] = jj_gen;
        break label_46;
      }
      ddlStmt(factory);
    }
    jj_consume_token(0);
  }

/*
name=ddl statement
description=A data definition statement.
example=[source,sql]\n----\nCREATE FOREIGN TABLE X (Y STRING)\n----\n
index=true
*/
  final public void ddlStmt(MetadataFactory factory) throws ParseException {
        Command command = null;
    if (jj_2_53(3)) {
      createTable(factory);
    } else if (jj_2_54(4)) {
      createDDLProcedure(factory, ParseInfo.DEFAULT_INSTANCE);
    } else if (jj_2_55(2)) {
      createNameSpace(factory);
    } else if (jj_2_56(4)) {
      alterStatement(factory);
    } else if (jj_2_57(4)) {
      command = createTrigger(ParseInfo.DEFAULT_INSTANCE);
                createDDLTrigger(factory, (AlterTrigger)command);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[315] = jj_gen;
      ;
    }
  }

/*
name=option namespace
description=A namespace used to shorten the full name of an option key.
example=[source,sql]\n----\nSET NAMESPACE 'http://foo' AS foo\n----\n
*/
  final public void createNameSpace(MetadataFactory factory) throws ParseException {
        String uri = null;
        String prefix = null;
    jj_consume_token(SET);
    jj_consume_token(NAMESPACE);
    uri = stringVal();
    jj_consume_token(AS);
    prefix = id(Boolean.FALSE);
                factory.addNamespace(prefix, uri);
  }

/*
name=create procedure
description=Defines a procedure or function invocation.
example=[source,sql]\n----\nCREATE FOREIGN PROCEDURE proc (param STRING) RETURNS STRING\n----\n
*/
  final public CreateProcedureCommand createDDLProcedure(MetadataFactory factory, ParseInfo info) throws ParseException {
        boolean virtual = true;
        boolean function = false;
        Procedure proc = null;
        String procName = null;
    CreateProcedureCommand procCmd = new CreateProcedureCommand();
    Statement stmt = null;
    ParsedDataType returnDataType = null;
    Token comment = null;
    Column c = new Column();
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOREIGN:
    case VIRTUAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        break;
      case FOREIGN:
        jj_consume_token(FOREIGN);
                                         virtual = false;
        break;
      default:
        jj_la1[316] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[317] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
      break;
    case FUNCTION:
      jj_consume_token(FUNCTION);
                                                                                       function = true;
      break;
    default:
      jj_la1[318] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    procName = id(null);
                        proc = factory.addProcedure(procName);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IN:
    case INOUT:
    case OUT:
    case INSTEAD:
    case ENABLED:
    case DISABLED:
    case VIEW:
    case KEY:
    case SERIAL:
    case TEXTAGG:
    case COUNT:
    case ROW_NUMBER:
    case RANK:
    case DENSE_RANK:
    case SUM:
    case AVG:
    case MIN:
    case MAX:
    case EVERY:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case VAR_SAMP:
    case VAR_POP:
    case DOCUMENT:
    case CONTENT:
    case TRIM:
    case EMPTY:
    case ORDINALITY:
    case PATH:
    case FIRST:
    case LAST:
    case NEXT:
    case SUBSTRING:
    case EXTRACT:
    case TO_CHARS:
    case TO_BYTES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case QUERYSTRING:
    case NAMESPACE:
    case RESULT:
    case INDEX:
    case ACCESSPATTERN:
    case AUTO_INCREMENT:
    case WELLFORMED:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_SECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_HOUR:
    case SQL_TSI_DAY:
    case SQL_TSI_WEEK:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_YEAR:
    case TEXTTABLE:
    case ARRAYTABLE:
    case SELECTOR:
    case SKIP_KEYWORD:
    case WIDTH:
    case PASSING:
    case NAME:
    case ENCODING:
    case COLUMNS:
    case DELIMITER:
    case QUOTE:
    case HEADER:
    case NULLS:
    case OBJECTTABLE:
    case VERSION:
    case INCLUDING:
    case EXCLUDING:
    case XMLDECLARATION:
    case VARIADIC:
    case EXCEPTION:
    case RAISE:
    case CHAIN:
    case JSONARRAY_AGG:
    case JSONOBJECT:
    case PRESERVE:
    case ID:
      procedureParameter(factory, proc);
      label_47:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[319] = jj_gen;
          break label_47;
        }
        jj_consume_token(COMMA);
        procedureParameter(factory, proc);
      }
      break;
    default:
      jj_la1[320] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RETURNS:
      jj_consume_token(RETURNS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTIONS:
        optionsClause(c, factory);
        break;
      default:
        jj_la1[321] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TABLE:
      case LPAREN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TABLE:
          jj_consume_token(TABLE);
          break;
        default:
          jj_la1[322] = jj_gen;
          ;
        }
        jj_consume_token(LPAREN);
        procedureRsColumn(factory, proc);
        label_48:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[323] = jj_gen;
            break label_48;
          }
          jj_consume_token(COMMA);
          procedureRsColumn(factory, proc);
        }
        jj_consume_token(RPAREN);
        break;
      case STRING:
      case VARBINARY:
      case VARCHAR:
      case BOOLEAN:
      case BYTE:
      case TINYINT:
      case SHORT:
      case SMALLINT:
      case CHAR:
      case INTEGER:
      case LONG:
      case BIGINT:
      case BIGINTEGER:
      case FLOAT:
      case REAL:
      case DOUBLE:
      case BIGDECIMAL:
      case DECIMAL:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case OBJECT:
      case BLOB:
      case CLOB:
      case XML:
      case GEOMETRY:
        returnDataType = parseDataType();
        break;
      default:
        jj_la1[324] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[325] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      optionsClause(proc, factory);
                      setProcedureOptions(proc);
      break;
    default:
      jj_la1[326] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                        comment = getToken(1).specialToken;
      stmt = statement(info);
      break;
    default:
      jj_la1[327] = jj_gen;
      ;
    }
                        proc.setVirtual(virtual);
                        proc.setFunction(function);
                        if (stmt != null){
                            if (!virtual) {
                                 {if (true) throw new MetadataException(QueryPlugin.Util.getString("SQLParser.function_def", procName));}
                            }
                                proc.setQueryPlan((comment != null?comment.image+" ":"") + stmt.toString());
                        }

                if (returnDataType != null){
                                BaseColumn result = addProcColumn(factory, proc, "return", returnDataType, false);
                                result.setProperties(c.getProperties());
                } else if (proc.getResultSet() != null) {
                    proc.getResultSet().setProperties(c.getProperties());
                }
                if (function) {
                        replaceProcedureWithFunction(factory, proc);
                }
                {if (true) return procCmd;}
    throw new Error("Missing return statement in function");
  }

/*
name=procedure parameter
description=A procedure or function parameter
example=[source,sql]\n----\nOUT x INTEGER\n----\n
*/
  final public void procedureParameter(MetadataFactory factory, Procedure proc) throws ParseException {
        String name = null;
        ParsedDataType type = null;
        ProcedureParameter.Type ppType = ProcedureParameter.Type.In;
        ProcedureParameter param = null;
        Expression defaultValue = null;
        boolean notNull = false;
        boolean vararg = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IN:
    case INOUT:
    case OUT:
    case VARIADIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IN:
        jj_consume_token(IN);
                              ppType = ProcedureParameter.Type.In ;
        break;
      case OUT:
        jj_consume_token(OUT);
                  ppType = ProcedureParameter.Type.Out;
        break;
      case INOUT:
        jj_consume_token(INOUT);
                    ppType = ProcedureParameter.Type.InOut;
        break;
      case VARIADIC:
        jj_consume_token(VARIADIC);
                       ppType = ProcedureParameter.Type.In ; vararg = true;
        break;
      default:
        jj_la1[328] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[329] = jj_gen;
      ;
    }
    name = id(Boolean.TRUE);
    type = parseDataType();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                       notNull = true;
      break;
    default:
      jj_la1[330] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RESULT:
      jj_consume_token(RESULT);
            if (ppType != ProcedureParameter.Type.Out) {
                {if (true) throw new ParseException(QueryPlugin.Util.getString("SQLParser.param_out", proc.getName(), name));}
            }
            ppType = ProcedureParameter.Type.ReturnValue;
      break;
    default:
      jj_la1[331] = jj_gen;
      ;
    }
                param = factory.addProcedureParameter(name, type.type, ppType, proc);
                setTypeInfo(type, param);
                if (notNull) {
                        param.setNullType(Column.NullType.No_Nulls);
                }
                if (vararg) {
                        param.setVarArg(vararg);
                }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_KEYWORD:
      jj_consume_token(DEFAULT_KEYWORD);
      defaultValue = expression(ParseInfo.DEFAULT_INSTANCE);
                                                                                  setDefault(param, defaultValue);
      break;
    default:
      jj_la1[332] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      optionsClause(param, factory);
              setColumnOptions(param);
      break;
    default:
      jj_la1[333] = jj_gen;
      ;
    }
  }

/*
name=procedure result column
description=A procedure result column.
example=[source,sql]\n----\nx INTEGER\n----\n
*/
  final public void procedureRsColumn(MetadataFactory factory, Procedure proc) throws ParseException {
        String name = null;
        ParsedDataType type = null;
        boolean notNull = false;
        BaseColumn column = null;
    name = id(Boolean.TRUE);
    type = parseDataType();
                column = addProcColumn(factory, proc, name, type, true);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                         column.setNullType(Column.NullType.No_Nulls);
      break;
    default:
      jj_la1[334] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      optionsClause(column, factory);
              setColumnOptions(column);
      break;
    default:
      jj_la1[335] = jj_gen;
      ;
    }
  }

/*
name=create table
description=Defines a table or view.
example=[source,sql]\n----\nCREATE VIEW vw AS SELECT 1\n----\n
*/
  final public void createTable(MetadataFactory factory) throws ParseException {
        boolean view = false;
        boolean globalTemp = false;
        String tableName = null;
        Table table = null;
        Token comment = null;
        Command query = null;
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOREIGN:
      jj_consume_token(FOREIGN);
      jj_consume_token(TABLE);
      break;
    case VIRTUAL:
    case VIEW:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        break;
      default:
        jj_la1[336] = jj_gen;
        ;
      }
      jj_consume_token(VIEW);
                                     view = true;
      break;
    case GLOBAL:
      jj_consume_token(GLOBAL);
      jj_consume_token(TEMPORARY);
      jj_consume_token(TABLE);
                                               globalTemp = true; view = true;
      break;
    default:
      jj_la1[337] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    tableName = id(null);
            table = factory.addTable(tableName);
            table.setVirtual(view);
            if (globalTemp) {
                table.setTableType(Table.Type.TemporaryTable);
            }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      createTableBody(table, factory);
      break;
    default:
      jj_la1[339] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTIONS:
        optionsClause(table, factory);
              setTableOptions(table);
        break;
      default:
        jj_la1[338] = jj_gen;
        ;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
                comment = getToken(1).specialToken;
      query = queryExpression(ParseInfo.DEFAULT_INSTANCE);
                   if (!view || globalTemp) {
                   {if (true) throw new MetadataException(QueryPlugin.Util.getString("SQLParser.view_def", table.getName()));}
                   }
                   table.setSelectTransformation((comment != null?comment.image+" ":"") + query.toString());
      break;
    default:
      jj_la1[340] = jj_gen;
      ;
    }
  }

/*
name=create foreign temp table
description=Defines a foreign temp table
example=[source,sql]\n----\nCREATE FOREIGN TEMPORARY TABLE t (x string) ON z\n----\n
*/
  final public Create createForeignTempTable(ParseInfo info) throws ParseException {
        Table table = null;
        String tableName = null;
        String model = null;
        MetadataFactory factory = getTempMetadataFactory();
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCAL:
      jj_consume_token(LOCAL);
      break;
    default:
      jj_la1[341] = jj_gen;
      ;
    }
    jj_consume_token(FOREIGN);
    jj_consume_token(TEMPORARY);
    jj_consume_token(TABLE);
    tableName = id(null);
                table = new Table();
                //need to set a dummy/stable uuid
                table.setUUID("tid:0");
                table.setTableType(Table.Type.TemporaryTable);
                table.setName(tableName);
    createTableBody(table, factory);
    jj_consume_token(ON);
    model = id(null);
                Create create = new Create();
                create.setTableMetadata(table);
                create.setOn(model);
                {if (true) return create;}
    throw new Error("Missing return statement in function");
  }

/*
name=create table body
description=Defines a table.
example=[source,sql]\n----\n(x string) OPTIONS (CARDINALITY 100)\n----\n
*/
  final public void createTableBody(Table table, MetadataFactory factory) throws ParseException {
        String name = null;
        AbstractMetadataRecord constraint = null;
    jj_consume_token(LPAREN);
    createColumn(factory, table);
    label_49:
    while (true) {
      if (jj_2_58(3)) {
        ;
      } else {
        break label_49;
      }
      jj_consume_token(COMMA);
      createColumn(factory, table);
    }
    label_50:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[342] = jj_gen;
        break label_50;
      }
      jj_consume_token(COMMA);
             name=null;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONSTRAINT:
        jj_consume_token(CONSTRAINT);
        name = id(null);
        break;
      default:
        jj_la1[343] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRIMARY:
        constraint = primaryKey(factory, table, name);
        break;
      case UNIQUE:
      case INDEX:
      case ACCESSPATTERN:
        constraint = constraint(factory, table, name, ParseInfo.DEFAULT_INSTANCE);
        break;
      case FOREIGN:
        constraint = foreignKey(factory, table, name);
        break;
      default:
        jj_la1[344] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTIONS:
        optionsClause(constraint, factory);
              setCommonProperties(constraint, constraint.getProperties());
        break;
      default:
        jj_la1[345] = jj_gen;
        ;
      }
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      optionsClause(table, factory);
              setTableOptions(table);
      break;
    default:
      jj_la1[346] = jj_gen;
      ;
    }
                if (table.getColumns() != null && !table.supportsUpdate()) {
                        for (Column c : table.getColumns()) {
                                c.setUpdatable(false);
                        }
                }
  }

/*
name=foreign key
description=Defines the foreign key referential constraint.
example=[source,sql]\n----\nFOREIGN KEY (a, b) REFERENCES tbl (x, y)\n----\n
*/
  final public AbstractMetadataRecord foreignKey(MetadataFactory factory, Table table, String name) throws ParseException {
        List<String> columnNames = null;
        String viewName = null;
        Table reference = null;
        KeyRecord pk = null;
        Column column = null;
        List<String> pkColumnNames = null;
        KeyRecord key = null;
    jj_consume_token(FOREIGN);
    jj_consume_token(KEY);
    columnNames = columnList(true, false);
    jj_consume_token(REFERENCES);
    viewName = id(null);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      pkColumnNames = columnList(true, false);
      break;
    default:
      jj_la1[347] = jj_gen;
      ;
    }
            {if (true) return factory.addForiegnKey(name != null?name:("FK"+table.getForeignKeys().size()), columnNames, pkColumnNames, viewName, table);}
    throw new Error("Missing return statement in function");
  }

/*
name=primary key
description=Defines the primary key.
example=[source,sql]\n----\nPRIMARY KEY (a, b)\n----\n
*/
  final public AbstractMetadataRecord primaryKey(MetadataFactory factory, Table table, String name) throws ParseException {
        List<String> columnNames = null;
        Column column = null;
        KeyRecord key = null;
    jj_consume_token(PRIMARY);
    jj_consume_token(KEY);
    columnNames = columnList(true, false);
            if (table.getPrimaryKey() != null){
                {if (true) throw new MetadataException(QueryPlugin.Util.getString("SQLParser.pk_exists", table.getName()));}
                }
                {if (true) return factory.addPrimaryKey(name!=null?name:"PK", columnNames, table);}
    throw new Error("Missing return statement in function");
  }

/*
name=other constraints
description=Defines ACCESSPATTERN and UNIQUE constraints and INDEXes. 
example=[source,sql]\n----\nUNIQUE (a)\n----\n
*/
  final public AbstractMetadataRecord constraint(MetadataFactory factory, Table table, String name, ParseInfo info) throws ParseException {
        KeyRecord keyrecord = null;
        Column column = null;
        List<String> columnNames = null;
        Token type = null;
        KeyRecord key = null;
        List<Expression> expressions = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNIQUE:
    case ACCESSPATTERN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNIQUE:
        type = jj_consume_token(UNIQUE);
        break;
      case ACCESSPATTERN:
        type = jj_consume_token(ACCESSPATTERN);
        break;
      default:
        jj_la1[348] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      columnNames = columnList(true, false);
                if (type.image.equalsIgnoreCase("UNIQUE")) {
                {if (true) return factory.addIndex(name != null?name:("UNIQUE"+table.getUniqueKeys().size()), false, columnNames, table);}
        } else if (type.image.equalsIgnoreCase("ACCESSPATTERN")) {
                {if (true) return factory.addAccessPattern(name != null?name:("AP"+table.getAccessPatterns().size()), columnNames, table);}
        }
      break;
    case INDEX:
      type = jj_consume_token(INDEX);
      jj_consume_token(LPAREN);
      expressions = expressionList(info);
      jj_consume_token(RPAREN);
                {if (true) return addFBI(factory, expressions, table, name);}
      break;
    default:
      jj_la1[349] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
name=column list
description=A list of column names.
example=[source,sql]\n----\n(a, b)\n----\n
*/
  final public List columnList(boolean validate, boolean asElementSymbols) throws ParseException {
        ArrayList list = new ArrayList();
        String id = null;
    jj_consume_token(LPAREN);
    id = id(validate?Boolean.TRUE:null);
                if (asElementSymbols) {
                        list.add(new ElementSymbol(id));
                } else {
                        list.add(id);
                }
    label_51:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[350] = jj_gen;
        break label_51;
      }
      jj_consume_token(COMMA);
      id = id(validate?Boolean.TRUE:null);
                if (asElementSymbols) {
                        list.add(new ElementSymbol(id));
                } else {
                        list.add(id);
                }
    }
    jj_consume_token(RPAREN);
                {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

/*
name=table element
description=Defines a table column.
example=[source,sql]\n----\nx INTEGER NOT NULL\n----\n
*/
  final public void createColumn(MetadataFactory factory, Table table) throws ParseException {
        String element = null;
        ParsedDataType type = null;
        boolean autoIncrement = false;
        boolean notNull = false;
        Expression defaultValue = null;
        Column column = null;
        List<String> columnName = new ArrayList<String>();
        boolean index = false;
        boolean unique = false;
        boolean pk = false;
        Token word = null;
    element = id(Boolean.TRUE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SERIAL:
      jj_consume_token(SERIAL);
        type = new ParsedDataType("INTEGER");
        autoIncrement = true;
        notNull = true;
      break;
    case STRING:
    case VARBINARY:
    case VARCHAR:
    case BOOLEAN:
    case BYTE:
    case TINYINT:
    case SHORT:
    case SMALLINT:
    case CHAR:
    case INTEGER:
    case LONG:
    case BIGINT:
    case BIGINTEGER:
    case FLOAT:
    case REAL:
    case DOUBLE:
    case BIGDECIMAL:
    case DECIMAL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case OBJECT:
    case BLOB:
    case CLOB:
    case XML:
    case GEOMETRY:
      type = parseDataType();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
        jj_consume_token(NULL);
                            notNull = true;
        break;
      default:
        jj_la1[351] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AUTO_INCREMENT:
        jj_consume_token(AUTO_INCREMENT);
                             autoIncrement = true;
        break;
      default:
        jj_la1[352] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[353] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
       column = factory.addColumn(element, type.type, table);
       column.setUpdatable(true);
       setTypeInfo(type, column);
       columnName.add(element);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIMARY:
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
                             pk = true;
      break;
    default:
      jj_la1[356] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNIQUE:
        jj_consume_token(UNIQUE);
                                                          unique = true;
        break;
      default:
        jj_la1[354] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INDEX:
        jj_consume_token(INDEX);
                                                                                        index = true;
        break;
      default:
        jj_la1[355] = jj_gen;
        ;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_KEYWORD:
      jj_consume_token(DEFAULT_KEYWORD);
      defaultValue = expression(ParseInfo.DEFAULT_INSTANCE);
                                                                                   setDefault(column, defaultValue);
      break;
    default:
      jj_la1[357] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      optionsClause(column, factory);
              setColumnOptions(column);
      break;
    default:
      jj_la1[358] = jj_gen;
      ;
    }
            if (index){
                        factory.addIndex("INDEX"+table.getIndexes().size(), true, columnName, table);
                } else if (unique){
                        factory.addIndex("UNIQUE"+table.getIndexes().size(), false, columnName, table);
                } else if (pk) {
                if (table.getPrimaryKey() != null) {
                        {if (true) throw new MetadataException(QueryPlugin.Util.getString("SQLParser.pk_exists", table.getName()));}
                }
                        factory.addPrimaryKey("PK", columnName, table);
                }
                if (notNull) {
               column.setNullType(Column.NullType.No_Nulls);
            }
            column.setAutoIncremented(autoIncrement);
  }

/*
name=options clause
description=A list of statement options.
example=[source,sql]\n----\nOPTIONS ('x' 'y', 'a' 'b')\n----\n
*/
  final public void optionsClause(AbstractMetadataRecord record, MetadataFactory factory) throws ParseException {
    jj_consume_token(OPTIONS);
    jj_consume_token(LPAREN);
    optionPair(record, factory);
    label_52:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[359] = jj_gen;
        break label_52;
      }
      jj_consume_token(COMMA);
      optionPair(record, factory);
    }
    jj_consume_token(RPAREN);
  }

/*
name=option pair
description=An option key/value pair.
example=[source,sql]\n----\n'key' 'value'\n----\n
*/
  final public void optionPair(AbstractMetadataRecord record, MetadataFactory factory) throws ParseException {
        Constant value = null;
        String key = null;
        Token t = null;
        String strVal = null;
    key = id(null);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
    case TIME:
    case TIMESTAMP:
    case FALSE:
    case NULL:
    case TRUE:
    case UNKNOWN:
    case ESCAPEDTYPE:
    case STRINGVAL:
    case BINARYSTRINGVAL:
      value = nonNumericLiteral();
      break;
    case DECIMALVAL:
    case FLOATVAL:
    case UNSIGNEDINTEGER:
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        strVal = plusMinus();
        break;
      default:
        jj_la1[360] = jj_gen;
        ;
      }
      value = unsignedNumericLiteral(strVal);
      break;
    default:
      jj_la1[361] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                key = MetadataFactory.resolvePropertyKey(factory, key);
                String val = null;
                if (!value.isNull()) {
                        val = value.getValue().toString();
                }
                record.setProperty(key, val);
  }

/*
name=alter options
description=alters options of tables/procedure
example=[source,sql]\n----\nALTER FOREIGN TABLE foo OPTIONS (ADD cardinality 100)\n----\n
*/
  final public void alterStatement(MetadataFactory factory) throws ParseException {
        boolean table = false;
        boolean proc = false;
        boolean func = false;
        String objectName = null;
        AbstractMetadataRecord record = null;
    jj_consume_token(ALTER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOREIGN:
    case VIRTUAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        break;
      case FOREIGN:
        jj_consume_token(FOREIGN);
        break;
      default:
        jj_la1[362] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[363] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLE:
      jj_consume_token(TABLE);
                                                  table = true;
      break;
    case VIEW:
      jj_consume_token(VIEW);
                                                                           table = true;
      break;
    case PROCEDURE:
      jj_consume_token(PROCEDURE);
                                                                                                         proc=true;
      break;
    default:
      jj_la1[364] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    objectName = id(null);
                if (table){
                        record = factory.getSchema().getTable(objectName);
                        if (record == null){
                                {if (true) throw new MetadataException(QueryPlugin.Util.getString("SQLParser.alter_table_doesnot_exist", objectName));}
                        }
                }
                if (proc){
                        record = factory.getSchema().getProcedure(objectName);
                        if (record == null){
                                {if (true) throw new MetadataException(QueryPlugin.Util.getString("SQLParser.alter_procedure_doesnot_exist", objectName));}
                        }
                }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIONS:
      alterOptionsList(record, factory);
      break;
    case ALTER:
      alterColumn(record, factory);
      break;
    default:
      jj_la1[365] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
name=alter options list
description=a list of alterations to options
example=[source,sql]\n----\nOPTIONS (ADD updatable true)\n----\n
*/
  final public void alterOptionsList(AbstractMetadataRecord record, MetadataFactory factory) throws ParseException {
    jj_consume_token(OPTIONS);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ADD:
    case SET:
      addSetOption(record, factory);
      break;
    case DROP:
      dropOption(record);
      break;
    default:
      jj_la1[366] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[367] = jj_gen;
        break label_53;
      }
      jj_consume_token(COMMA);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ADD:
      case SET:
        addSetOption(record, factory);
        break;
      case DROP:
        dropOption(record);
        break;
      default:
        jj_la1[368] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
                setOptions(record);
  }

/*
name=drop option
description=drop option
example=[source,sql]\n----\nDROP updatable\n----\n
*/
  final public void dropOption(AbstractMetadataRecord record) throws ParseException {
        String key = null;
    jj_consume_token(DROP);
    key = id(null);
                removeOption(key, record);
  }

/*
name=add set option
description=add or set an option pair
example=[source,sql]\n----\nADD updatable true\n----\n
*/
  final public void addSetOption(AbstractMetadataRecord record, MetadataFactory factory) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ADD:
      jj_consume_token(ADD);
      break;
    case SET:
      jj_consume_token(SET);
      break;
    default:
      jj_la1[369] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    optionPair(record, factory);
  }

/*
name=alter column options
description=alters a set of column options
example=[source,sql]\n----\nALTER COLUMN bar OPTIONS (ADD updatable true)\n----\n
*/
  final public void alterColumn(AbstractMetadataRecord parent, MetadataFactory factory) throws ParseException {
        boolean param = false;
        String objectName = null;
        AbstractMetadataRecord record = null;
        String key = null;
    jj_consume_token(ALTER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLUMN:
    case PARAMETER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLUMN:
        jj_consume_token(COLUMN);
        break;
      case PARAMETER:
        jj_consume_token(PARAMETER);
                                      param=true;
        break;
      default:
        jj_la1[370] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[371] = jj_gen;
      ;
    }
    objectName = id(null);
                record = getChild(objectName, parent, param);
    alterOptionsList(record, factory);
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_3R_472() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_383() {
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_451() {
    if (jj_3R_394()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_472()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_13() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_64()) return true;
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_489() {
    if (jj_3R_64()) return true;
    if (jj_3R_189()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_13()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_300() {
    if (jj_3R_64()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_497()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_182() {
    if (jj_scan_token(JSONOBJECT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_451()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_119() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(209)) {
    jj_scanpos = xsp;
    if (jj_scan_token(248)) return true;
    }
    return false;
  }

  private boolean jj_3R_508() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_3R_166()) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_3R_167()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_119()) jj_scanpos = xsp;
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(44)) jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_scan_token(XMLATTRIBUTES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_394()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_508()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_52() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3_51() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_364() {
    if (jj_scan_token(UNSIGNEDINTEGER)) return true;
    return false;
  }

  private boolean jj_3R_449() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_scan_token(XMLELEMENT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(353)) jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    xsp = jj_scanpos;
    if (jj_3_51()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_52()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_449()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_538() {
    if (jj_scan_token(PATH)) return true;
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3R_537() {
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_329() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) return true;
    }
    return false;
  }

  private boolean jj_3R_535() {
    if (jj_3R_189()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_537()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_538()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_534() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(ORDINALITY)) return true;
    return false;
  }

  private boolean jj_3R_522() {
    if (jj_3R_64()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_534()) {
    jj_scanpos = xsp;
    if (jj_3R_535()) return true;
    }
    return false;
  }

  private boolean jj_3R_445() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_294() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_329()) jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_scan_token(QUERYSTRING)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_445()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_447() {
    if (jj_scan_token(CONTENT)) return true;
    return false;
  }

  private boolean jj_3R_523() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_522()) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(227)) jj_scanpos = xsp;
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_461() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_448() {
    if (jj_scan_token(WELLFORMED)) return true;
    return false;
  }

  private boolean jj_3R_492() {
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_522()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_523()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_446() {
    if (jj_scan_token(DOCUMENT)) return true;
    return false;
  }

  private boolean jj_3R_179() {
    if (jj_scan_token(XMLPARSE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_446()) {
    jj_scanpos = xsp;
    if (jj_3R_447()) return true;
    }
    if (jj_3R_88()) return true;
    xsp = jj_scanpos;
    if (jj_3R_448()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_521() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_491() {
    if (jj_scan_token(PASSING)) return true;
    if (jj_3R_394()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_521()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(227)) jj_scanpos = xsp;
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_490() {
    if (jj_3R_95()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_299() {
    if (jj_scan_token(XMLTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_490()) jj_scanpos = xsp;
    if (jj_3R_342()) return true;
    xsp = jj_scanpos;
    if (jj_3R_491()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_492()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(44)) jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_437() {
    if (jj_3R_462()) return true;
    return false;
  }

  private boolean jj_3R_436() {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_435() {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_434() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_460()) {
    jj_scanpos = xsp;
    if (jj_3R_461()) return true;
    }
    return false;
  }

  private boolean jj_3R_460() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3_50() {
    if (jj_scan_token(JSONOBJECT)) return true;
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_3R_294()) return true;
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_3R_64()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_434()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_435()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_436()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_437()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_141() {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_237() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) return true;
    }
    return false;
  }

  private boolean jj_3R_140() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_525() {
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_433() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_3R_181()) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_scan_token(INSERT)) return true;
    if (jj_scan_token(INTO)) return true;
    return false;
  }

  private boolean jj_3R_495() {
    if (jj_3R_64()) return true;
    if (jj_3R_189()) return true;
    if (jj_3R_342()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_525()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_scan_token(INSERT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_scan_token(XMLPI)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(353)) jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    xsp = jj_scanpos;
    if (jj_3R_433()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_137() {
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_432() {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_3R_94()) return true;
    }
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_431() {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_432()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_496() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_495()) return true;
    return false;
  }

  private boolean jj_3R_524() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(185)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(236)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(193)) {
    jj_scanpos = xsp;
    if (jj_scan_token(268)) {
    jj_scanpos = xsp;
    if (jj_scan_token(269)) {
    jj_scanpos = xsp;
    if (jj_scan_token(281)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_431()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_443() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(215)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_471()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_494() {
    if (jj_scan_token(PASSING)) return true;
    if (jj_3R_394()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_524()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_48() {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_493() {
    if (jj_scan_token(LANGUAGE)) return true;
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_64()) return true;
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(OBJECTTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_493()) jj_scanpos = xsp;
    if (jj_3R_342()) return true;
    xsp = jj_scanpos;
    if (jj_3R_494()) jj_scanpos = xsp;
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_495()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_496()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(44)) jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_scan_token(EXCEPTION)) return true;
    return false;
  }

  private boolean jj_3R_429() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(329)) {
    jj_scanpos = xsp;
    if (jj_scan_token(330)) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_430()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_88()) return true;
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_479() {
    if (jj_scan_token(EMPTY)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_478() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(327)) {
    jj_scanpos = xsp;
    if (jj_scan_token(328)) return true;
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_342()) return true;
    xsp = jj_scanpos;
    if (jj_3R_429()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_459() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_478()) {
    jj_scanpos = xsp;
    if (jj_3R_479()) return true;
    }
    if (jj_scan_token(ON)) return true;
    if (jj_scan_token(EMPTY)) return true;
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_scan_token(DECLARE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) return true;
    }
    return false;
  }

  private boolean jj_3R_477() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3_42() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) return true;
    }
    return false;
  }

  private boolean jj_3R_91() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(215)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_458() {
    if (jj_scan_token(PASSING)) return true;
    if (jj_3R_394()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_477()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_444() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_471() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_457() {
    if (jj_3R_95()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_428() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_443()) {
    jj_scanpos = xsp;
    if (jj_3R_444()) return true;
    }
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_scan_token(XMLQUERY)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_457()) jj_scanpos = xsp;
    if (jj_3R_342()) return true;
    xsp = jj_scanpos;
    if (jj_3R_458()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_459()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_64()) return true;
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) jj_scanpos = xsp;
    if (jj_scan_token(DISTINCT)) return true;
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3_45() {
    if (jj_scan_token(TRIM)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_428()) jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_427() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3_44() {
    if (jj_scan_token(EXTRACT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(236)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(193)) return true;
    }
    }
    }
    }
    }
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_442() {
    if (jj_scan_token(FOR)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_395() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_426() {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_88()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_442()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_scan_token(LOOP)) return true;
    if (jj_scan_token(ON)) return true;
    return false;
  }

  private boolean jj_3R_378() {
    if (jj_scan_token(PASSING)) return true;
    if (jj_3R_394()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_395()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_377() {
    if (jj_3R_95()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3_43() {
    if (jj_scan_token(SUBSTRING)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_426()) {
    jj_scanpos = xsp;
    if (jj_3R_427()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_328() {
    if (jj_scan_token(XMLEXISTS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_377()) jj_scanpos = xsp;
    if (jj_3R_342()) return true;
    xsp = jj_scanpos;
    if (jj_3R_378()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_533() {
    if (jj_scan_token(SELECTOR)) return true;
    if (jj_3R_342()) return true;
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_scan_token(CAST)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(AS)) return true;
    if (jj_3R_189()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3_28() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(TRIM)) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_scan_token(CONVERT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_189()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3_45()) {
    jj_scanpos = xsp;
    if (jj_3_46()) {
    jj_scanpos = xsp;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) {
    jj_scanpos = xsp;
    if (jj_3R_143()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_532() {
    if (jj_scan_token(WIDTH)) return true;
    if (jj_3R_364()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_28()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_242() {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_265()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_531() {
    if (jj_scan_token(HEADER)) return true;
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3R_517() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_531()) jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    xsp = jj_scanpos;
    if (jj_3R_532()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_533()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_516() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(ORDINALITY)) return true;
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_scan_token(LEAVE)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_483() {
    if (jj_3R_64()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_516()) {
    jj_scanpos = xsp;
    if (jj_3R_517()) return true;
    }
    return false;
  }

  private boolean jj_3R_263() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_297()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_241() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) return true;
    }
    return false;
  }

  private boolean jj_3R_415() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_144()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_scan_token(CASE)) return true;
    Token xsp;
    if (jj_3R_147()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_147()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_415()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_162() {
    if (jj_scan_token(EXCEPTION)) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_161() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_190()) jj_scanpos = xsp;
    if (jj_scan_token(ATOMIC)) return true;
    return false;
  }

  private boolean jj_3R_417() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_416() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3_27() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(TRIM)) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(BEGIN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_161()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_8()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_162()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_488() {
    if (jj_scan_token(SKIP_KEYWORD)) return true;
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_520() {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_371() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_88()) return true;
    Token xsp;
    if (jj_3R_416()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_416()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_417()) jj_scanpos = xsp;
    if (jj_scan_token(END)) return true;
    return false;
  }

  private boolean jj_3R_487() {
    if (jj_scan_token(HEADER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_520()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_519() {
    if (jj_scan_token(QUOTE)) return true;
    if (jj_3R_438()) return true;
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_3R_242()) return true;
    return false;
  }

  private boolean jj_3R_213() {
    if (jj_3R_241()) return true;
    return false;
  }

  private boolean jj_3R_518() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_438()) return true;
    return false;
  }

  private boolean jj_3R_486() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_518()) {
    jj_scanpos = xsp;
    if (jj_3R_519()) return true;
    }
    return false;
  }

  private boolean jj_3R_212() {
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(ROW)) return true;
    if (jj_scan_token(DELIMITER)) return true;
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_485() {
    if (jj_scan_token(DELIMITER)) return true;
    if (jj_3R_438()) return true;
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_3R_239()) return true;
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3R_192() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3R_210()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) {
    jj_scanpos = xsp;
    if (jj_3R_213()) {
    jj_scanpos = xsp;
    if (jj_3R_214()) return true;
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_scan_token(ROW)) return true;
    if (jj_scan_token(DELIMITER)) return true;
    if (jj_3R_438()) return true;
    return false;
  }

  private boolean jj_3_26() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) return true;
    }
    return false;
  }

  private boolean jj_3R_464() {
    if (jj_3R_466()) return true;
    return false;
  }

  private boolean jj_3R_481() {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_480() {
    if (jj_scan_token(PARTITION)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_484() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_483()) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_3R_64()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_106() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) return true;
    }
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_3R_192()) return true;
    return false;
  }

  private boolean jj_3R_466() {
    if (jj_scan_token(OVER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_480()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_481()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_3R_191()) return true;
    return false;
  }

  private boolean jj_3R_482() {
    if (jj_scan_token(SELECTOR)) return true;
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(TEXTTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_123()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_482()) jj_scanpos = xsp;
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_483()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_484()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_26()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_485()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_486()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_487()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_488()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_27()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(44)) jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_58()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_369() {
    if (jj_3R_165()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) return true;
    }
    return false;
  }

  private boolean jj_3R_353() {
    if (jj_3R_370()) return true;
    return false;
  }

  private boolean jj_3R_463() {
    if (jj_3R_462()) return true;
    return false;
  }

  private boolean jj_3R_352() {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_368() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_351() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_368()) {
    jj_scanpos = xsp;
    if (jj_3R_369()) return true;
    }
    return false;
  }

  private boolean jj_3_39() {
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_474() {
    if (jj_scan_token(CONTENT)) return true;
    return false;
  }

  private boolean jj_3R_350() {
    if (jj_scan_token(ESCAPEDFUNCTION)) return true;
    if (jj_3R_87()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_476() {
    if (jj_scan_token(EXCLUDING)) return true;
    return false;
  }

  private boolean jj_3R_349() {
    if (jj_3R_367()) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(ARRAYTABLE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_224()) return true;
    if (jj_scan_token(COLUMNS)) return true;
    if (jj_3R_489()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(44)) jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_330() {
    if (jj_scan_token(SQLEXCEPTION)) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_326() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_349()) {
    jj_scanpos = xsp;
    if (jj_3R_350()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) {
    jj_scanpos = xsp;
    if (jj_3R_353()) {
    jj_scanpos = xsp;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3R_354()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_3R_330()) return true;
    return false;
  }

  private boolean jj_3R_260() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) return true;
    }
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_473() {
    if (jj_scan_token(DOCUMENT)) return true;
    return false;
  }

  private boolean jj_3R_475() {
    if (jj_scan_token(INCLUDING)) return true;
    return false;
  }

  private boolean jj_3R_453() {
    if (jj_scan_token(AS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_456() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_475()) {
    jj_scanpos = xsp;
    if (jj_3R_476()) return true;
    }
    if (jj_scan_token(XMLDECLARATION)) return true;
    return false;
  }

  private boolean jj_3R_465() {
    if (jj_3R_462()) return true;
    return false;
  }

  private boolean jj_3R_455() {
    if (jj_scan_token(VERSION)) return true;
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3R_454() {
    if (jj_scan_token(ENCODING)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_414() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_452() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_473()) {
    jj_scanpos = xsp;
    if (jj_3R_474()) return true;
    }
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(XMLSERIALIZE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_452()) jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    xsp = jj_scanpos;
    if (jj_3R_453()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_454()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_455()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_456()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_scan_token(SQLWARNING)) return true;
    return false;
  }

  private boolean jj_3_38() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_467() {
    if (jj_3R_466()) return true;
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_scan_token(RAISE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_259()) jj_scanpos = xsp;
    if (jj_3R_260()) return true;
    return false;
  }

  private boolean jj_3R_413() {
    if (jj_3R_88()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_38()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_370() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_413()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_414()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_386() {
    if (jj_scan_token(NO)) return true;
    return false;
  }

  private boolean jj_3R_238() {
    if (jj_scan_token(ERROR)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_366() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_386()) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  private boolean jj_3R_365() {
    if (jj_scan_token(MAX)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_146() {
    if (jj_scan_token(XMLCAST)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(AS)) return true;
    if (jj_3R_189()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_340() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_365()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_366()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_311() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_340()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_156() {
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_scan_token(ALTER)) return true;
    return false;
  }

  private boolean jj_3R_470() {
    if (jj_scan_token(MAKENOTDEP)) return true;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_469() {
    if (jj_scan_token(MAKEDEP)) return true;
    if (jj_3R_311()) return true;
    return false;
  }

  private boolean jj_3R_439() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_469()) {
    jj_scanpos = xsp;
    if (jj_3R_470()) return true;
    }
    return false;
  }

  private boolean jj_3R_440() {
    if (jj_scan_token(MAKEIND)) return true;
    if (jj_3R_311()) return true;
    return false;
  }

  private boolean jj_3_37() {
    if (jj_3R_87()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_467()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_36() {
    if (jj_3R_86()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_465()) jj_scanpos = xsp;
    if (jj_3R_466()) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_217()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_35() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_463()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_464()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_145() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3_36()) {
    jj_scanpos = xsp;
    if (jj_3_37()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_89() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_145()) {
    jj_scanpos = xsp;
    if (jj_3R_146()) return true;
    }
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_3R_300()) return true;
    return false;
  }

  private boolean jj_3_24() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_270() {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_388() {
    if (jj_scan_token(DOLLAR)) return true;
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_scan_token(VIEW)) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_367() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_387()) {
    jj_scanpos = xsp;
    if (jj_3R_388()) return true;
    }
    return false;
  }

  private boolean jj_3R_387() {
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  private boolean jj_3R_244() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) {
    jj_scanpos = xsp;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3R_271()) {
    jj_scanpos = xsp;
    if (jj_3R_272()) {
    jj_scanpos = xsp;
    if (jj_3R_273()) return true;
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_439()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_440()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_scan_token(RIGHT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(167)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_175() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_scan_token(FULL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(167)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_scan_token(LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(167)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_290() {
    if (jj_3R_326()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_468()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_468() {
    if (jj_scan_token(LSBRACE)) return true;
    if (jj_3R_177()) return true;
    if (jj_scan_token(RSBRACE)) return true;
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_3R_325()) return true;
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_3R_324()) return true;
    return false;
  }

  private boolean jj_3R_118() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_175()) jj_scanpos = xsp;
    if (jj_scan_token(JOIN)) return true;
    if (jj_3R_176()) return true;
    if (jj_scan_token(ON)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_254() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_288()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) return true;
    }
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_scan_token(OPTIONS)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(137)) jj_scanpos = xsp;
    if (jj_scan_token(TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_253() {
    if (jj_3R_287()) return true;
    return false;
  }

  private boolean jj_3R_224() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) return true;
    }
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_3R_188()) return true;
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_scan_token(CROSS)) return true;
    return false;
  }

  private boolean jj_3R_153() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) return true;
    }
    return false;
  }

  private boolean jj_3R_117() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) return true;
    }
    if (jj_scan_token(JOIN)) return true;
    if (jj_3R_244()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_scan_token(DROP)) return true;
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(ALTER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) return true;
    }
    }
    if (jj_3R_64()) return true;
    xsp = jj_scanpos;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) return true;
    }
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_418() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(403)) {
    jj_scanpos = xsp;
    if (jj_scan_token(404)) return true;
    }
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_400() {
    if (jj_3R_418()) return true;
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    }
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_217() {
    if (jj_3R_244()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_21()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_3R_171()) return true;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_3R_166()) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_3R_167()) return true;
    return false;
  }

  private boolean jj_3R_66() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_3R_224()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_400()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_3R_217()) return true;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_scan_token(ESCAPEDJOIN)) return true;
    if (jj_3R_217()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_324() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(405)) {
    jj_scanpos = xsp;
    if (jj_scan_token(406)) return true;
    }
    return false;
  }

  private boolean jj_3R_176() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) return true;
    }
    return false;
  }

  private boolean jj_3R_389() {
    if (jj_3R_324()) return true;
    if (jj_3R_206()) return true;
    return false;
  }

  private boolean jj_3R_382() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_176()) return true;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_3R_206()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_389()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_176()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_382()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_372() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(412)) {
    jj_scanpos = xsp;
    if (jj_scan_token(411)) return true;
    }
    if (jj_3R_177()) return true;
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_scan_token(TRIGGER)) return true;
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_462() {
    if (jj_scan_token(FILTER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(WHERE)) return true;
    if (jj_3R_256()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_177()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_372()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_3R_64()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) return true;
    }
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_scan_token(SERIAL)) return true;
    return false;
  }

  private boolean jj_3R_196() {
    if (jj_scan_token(VIEW)) return true;
    return false;
  }

  private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(304)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) {
    jj_scanpos = xsp;
    if (jj_scan_token(306)) return true;
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_scan_token(ALTER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_196()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_536() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_530() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_536()) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) return true;
    }
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_301() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_178() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(308)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) {
    jj_scanpos = xsp;
    if (jj_scan_token(310)) {
    jj_scanpos = xsp;
    if (jj_scan_token(311)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(314)) {
    jj_scanpos = xsp;
    if (jj_scan_token(315)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_530()) jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_341() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3_20() {
    if (jj_scan_token(COUNT)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(STAR)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_315() {
    if (jj_3R_64()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_341()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_scan_token(NOCACHE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_315()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_274() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_64()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_301()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(TRIGGER)) return true;
    if (jj_scan_token(ON)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_314() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_130() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) return true;
    }
    return false;
  }

  private boolean jj_3R_285() {
    if (jj_scan_token(MAKENOTDEP)) return true;
    if (jj_3R_64()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_314()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_313() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_64()) return true;
    if (jj_3R_311()) return true;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_scan_token(MAKEIND)) return true;
    if (jj_3R_64()) return true;
    if (jj_3R_311()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_313()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_312() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_64()) return true;
    if (jj_3R_311()) return true;
    return false;
  }

  private boolean jj_3R_514() {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_252() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) {
    jj_scanpos = xsp;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_scan_token(MAKEDEP)) return true;
    if (jj_3R_64()) return true;
    if (jj_3R_311()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_312()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_513() {
    if (jj_scan_token(ENCODING)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_339() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_512() {
    if (jj_scan_token(HEADER)) return true;
    return false;
  }

  private boolean jj_3R_223() {
    if (jj_scan_token(OPTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_252()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_529() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(QUOTE)) return true;
    return false;
  }

  private boolean jj_3R_528() {
    if (jj_scan_token(QUOTE)) return true;
    if (jj_3R_438()) return true;
    return false;
  }

  private boolean jj_3R_511() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_528()) {
    jj_scanpos = xsp;
    if (jj_3R_529()) return true;
    }
    return false;
  }

  private boolean jj_3R_510() {
    if (jj_scan_token(DELIMITER)) return true;
    if (jj_3R_438()) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_3R_165()) return true;
    return false;
  }

  private boolean jj_3R_509() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(374)) {
    jj_scanpos = xsp;
    if (jj_3R_107()) return true;
    }
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_scan_token(TEXTAGG)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(100)) jj_scanpos = xsp;
    if (jj_3R_394()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_509()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_510()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_511()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_512()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_513()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_514()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_310() {
    if (jj_scan_token(FETCH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(324)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_339()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) return true;
    }
    if (jj_scan_token(ONLY)) return true;
    return false;
  }

  private boolean jj_3R_336() {
    if (jj_scan_token(LAST)) return true;
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_scan_token(OFFSET)) return true;
    if (jj_3R_307()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_309()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_281() {
    if (jj_3R_310()) return true;
    return false;
  }

  private boolean jj_3R_165() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(296)) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_scan_token(297)) {
    jj_scanpos = xsp;
    if (jj_scan_token(298)) {
    jj_scanpos = xsp;
    if (jj_scan_token(300)) {
    jj_scanpos = xsp;
    if (jj_scan_token(301)) {
    jj_scanpos = xsp;
    if (jj_scan_token(302)) {
    jj_scanpos = xsp;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_scan_token(304)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) {
    jj_scanpos = xsp;
    if (jj_scan_token(306)) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(308)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) {
    jj_scanpos = xsp;
    if (jj_scan_token(310)) {
    jj_scanpos = xsp;
    if (jj_scan_token(311)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(314)) {
    jj_scanpos = xsp;
    if (jj_scan_token(315)) {
    jj_scanpos = xsp;
    if (jj_scan_token(316)) {
    jj_scanpos = xsp;
    if (jj_scan_token(317)) {
    jj_scanpos = xsp;
    if (jj_scan_token(318)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(320)) {
    jj_scanpos = xsp;
    if (jj_scan_token(321)) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) {
    jj_scanpos = xsp;
    if (jj_scan_token(324)) {
    jj_scanpos = xsp;
    if (jj_scan_token(325)) {
    jj_scanpos = xsp;
    if (jj_scan_token(326)) {
    jj_scanpos = xsp;
    if (jj_scan_token(327)) {
    jj_scanpos = xsp;
    if (jj_scan_token(328)) {
    jj_scanpos = xsp;
    if (jj_scan_token(329)) {
    jj_scanpos = xsp;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_scan_token(331)) {
    jj_scanpos = xsp;
    if (jj_scan_token(332)) {
    jj_scanpos = xsp;
    if (jj_scan_token(333)) {
    jj_scanpos = xsp;
    if (jj_scan_token(334)) {
    jj_scanpos = xsp;
    if (jj_scan_token(335)) {
    jj_scanpos = xsp;
    if (jj_scan_token(336)) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) {
    jj_scanpos = xsp;
    if (jj_scan_token(338)) {
    jj_scanpos = xsp;
    if (jj_scan_token(339)) {
    jj_scanpos = xsp;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(341)) {
    jj_scanpos = xsp;
    if (jj_scan_token(342)) {
    jj_scanpos = xsp;
    if (jj_scan_token(343)) {
    jj_scanpos = xsp;
    if (jj_scan_token(344)) {
    jj_scanpos = xsp;
    if (jj_scan_token(345)) {
    jj_scanpos = xsp;
    if (jj_scan_token(346)) {
    jj_scanpos = xsp;
    if (jj_scan_token(347)) {
    jj_scanpos = xsp;
    if (jj_scan_token(348)) {
    jj_scanpos = xsp;
    if (jj_scan_token(349)) {
    jj_scanpos = xsp;
    if (jj_scan_token(350)) {
    jj_scanpos = xsp;
    if (jj_scan_token(351)) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(353)) {
    jj_scanpos = xsp;
    if (jj_scan_token(354)) {
    jj_scanpos = xsp;
    if (jj_scan_token(355)) {
    jj_scanpos = xsp;
    if (jj_scan_token(356)) {
    jj_scanpos = xsp;
    if (jj_scan_token(357)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(359)) {
    jj_scanpos = xsp;
    if (jj_scan_token(360)) {
    jj_scanpos = xsp;
    if (jj_scan_token(361)) {
    jj_scanpos = xsp;
    if (jj_scan_token(362)) {
    jj_scanpos = xsp;
    if (jj_scan_token(363)) {
    jj_scanpos = xsp;
    if (jj_scan_token(364)) {
    jj_scanpos = xsp;
    if (jj_scan_token(365)) {
    jj_scanpos = xsp;
    if (jj_scan_token(367)) {
    jj_scanpos = xsp;
    if (jj_scan_token(366)) {
    jj_scanpos = xsp;
    if (jj_scan_token(368)) {
    jj_scanpos = xsp;
    if (jj_scan_token(369)) {
    jj_scanpos = xsp;
    if (jj_scan_token(370)) {
    jj_scanpos = xsp;
    if (jj_scan_token(371)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_309() {
    if (jj_3R_310()) return true;
    return false;
  }

  private boolean jj_3R_515() {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_308() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_131() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(264)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(369)) return true;
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    xsp = jj_scanpos;
    if (jj_3R_515()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_scan_token(LIMIT)) return true;
    if (jj_3R_307()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_308()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_scan_token(STRINGVAL)) return true;
    return false;
  }

  private boolean jj_3R_249() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_279()) {
    jj_scanpos = xsp;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_412() {
    if (jj_scan_token(ALL_IN_GROUP)) return true;
    return false;
  }

  private boolean jj_3R_338() {
    if (jj_3R_326()) return true;
    return false;
  }

  private boolean jj_3R_410() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3_58() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_307() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_337()) {
    jj_scanpos = xsp;
    if (jj_3R_338()) return true;
    }
    return false;
  }

  private boolean jj_3R_337() {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_394() {
    if (jj_3R_88()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_410()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_425() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(44)) jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(137)) jj_scanpos = xsp;
    if (jj_scan_token(FOREIGN)) return true;
    return false;
  }

  private boolean jj_3R_411() {
    if (jj_3R_88()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_425()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_335() {
    if (jj_scan_token(FIRST)) return true;
    return false;
  }

  private boolean jj_3R_334() {
    if (jj_scan_token(DESC)) return true;
    return false;
  }

  private boolean jj_3R_306() {
    if (jj_scan_token(NULLS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_335()) {
    jj_scanpos = xsp;
    if (jj_3R_336()) return true;
    }
    return false;
  }

  private boolean jj_3R_397() {
    if (jj_3R_412()) return true;
    return false;
  }

  private boolean jj_3R_305() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_3R_334()) return true;
    }
    return false;
  }

  private boolean jj_3R_396() {
    if (jj_3R_411()) return true;
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_3R_304()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_305()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_306()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_380() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_396()) {
    jj_scanpos = xsp;
    if (jj_3R_397()) return true;
    }
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_scan_token(GLOBAL)) return true;
    if (jj_scan_token(TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_149() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(227)) jj_scanpos = xsp;
    if (jj_scan_token(VIEW)) return true;
    return false;
  }

  private boolean jj_3R_381() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_380()) return true;
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_scan_token(FOREIGN)) return true;
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_277()) return true;
    return false;
  }

  private boolean jj_3R_358() {
    if (jj_3R_380()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_381()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    }
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_379() {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_scan_token(ORDER)) return true;
    if (jj_scan_token(BY)) return true;
    if (jj_3R_277()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_278()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_357() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_356() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_3R_379()) return true;
    }
    return false;
  }

  private boolean jj_3R_331() {
    if (jj_scan_token(SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_356()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) return true;
    }
    return false;
  }

  private boolean jj_3R_385() {
    if (jj_scan_token(HAVING)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_359() {
    if (jj_scan_token(INTO)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_399() {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_398() {
    if (jj_scan_token(ROLLUP)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_251()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_384() {
    if (jj_scan_token(GROUP)) return true;
    if (jj_scan_token(BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_398()) {
    jj_scanpos = xsp;
    if (jj_3R_399()) return true;
    }
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_scan_token(EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_333() {
    if (jj_3R_360()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_361()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_362()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_363()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_363() {
    if (jj_3R_385()) return true;
    return false;
  }

  private boolean jj_3R_362() {
    if (jj_3R_384()) return true;
    return false;
  }

  private boolean jj_3R_361() {
    if (jj_3R_383()) return true;
    return false;
  }

  private boolean jj_3R_332() {
    if (jj_3R_359()) return true;
    return false;
  }

  private boolean jj_3R_327() {
    if (jj_scan_token(EXISTS)) return true;
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_298() {
    if (jj_3R_331()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_332()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_333()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_scan_token(FUNCTION)) return true;
    return false;
  }

  private boolean jj_3R_421() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_194()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_34() {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_scan_token(TABLE)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_302() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_251()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_404() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_123()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_421()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_403() {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_scan_token(VALUES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_251()) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_302()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_3R_298()) return true;
    return false;
  }

  private boolean jj_3R_243() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_402() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_390() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_402()) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_403()) {
    jj_scanpos = xsp;
    if (jj_3R_404()) return true;
    }
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_scan_token(FOREIGN)) return true;
    return false;
  }

  private boolean jj_3R_275() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_303()) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) return true;
    }
    return false;
  }

  private boolean jj_3R_303() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_246() {
    if (jj_scan_token(INTERSECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_275()) jj_scanpos = xsp;
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_151() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_3R_186()) return true;
    }
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_3R_243()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_246()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_405() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_3R_152()) return true;
    }
    if (jj_3R_64()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_391() {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_405()) jj_scanpos = xsp;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_scan_token(OPTION)) return true;
    return false;
  }

  private boolean jj_3R_247() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) return true;
    }
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(UNION)) return true;
    return false;
  }

  private boolean jj_3_17() {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind != JOIN;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_247()) jj_scanpos = xsp;
    if (jj_3R_216()) return true;
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_220() {
    if (jj_3R_249()) return true;
    return false;
  }

  private boolean jj_3R_219() {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_3R_216()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_17()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_219()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_220()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_221()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(NAMESPACE)) return true;
    return false;
  }

  private boolean jj_3R_78() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_122()) jj_scanpos = xsp;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_123()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3_57() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3_56() {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3_55() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_438() {
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3_54() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_53() {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_3R_274()) return true;
    return false;
  }

  private boolean jj_3R_215() {
    if (jj_3R_64()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_245()) jj_scanpos = xsp;
    if (jj_scan_token(AS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_166()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_80() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_126()) jj_scanpos = xsp;
    if (jj_scan_token(LIKE_REGEX)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_348() {
    if (jj_scan_token(DECIMALVAL)) return true;
    return false;
  }

  private boolean jj_3R_347() {
    if (jj_scan_token(FLOATVAL)) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_scan_token(WITH)) return true;
    if (jj_3R_215()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_218()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_166() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_193()) jj_scanpos = xsp;
    if (jj_3R_194()) return true;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_scan_token(SIMILAR)) return true;
    if (jj_scan_token(TO)) return true;
    return false;
  }

  private boolean jj_3R_420() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_438()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_401() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_419()) {
    jj_scanpos = xsp;
    if (jj_3R_420()) return true;
    }
    return false;
  }

  private boolean jj_3R_419() {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_438()) return true;
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_79() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_3R_125()) return true;
    }
    if (jj_3R_123()) return true;
    xsp = jj_scanpos;
    if (jj_3R_401()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_346() {
    if (jj_scan_token(UNSIGNEDINTEGER)) return true;
    return false;
  }

  private boolean jj_3R_325() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_346()) {
    jj_scanpos = xsp;
    if (jj_3R_347()) {
    jj_scanpos = xsp;
    if (jj_3R_348()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_345() {
    if (jj_scan_token(TIMESTAMP)) return true;
    return false;
  }

  private boolean jj_3R_344() {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3R_343() {
    if (jj_scan_token(DATE)) return true;
    return false;
  }

  private boolean jj_3R_323() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) {
    jj_scanpos = xsp;
    if (jj_3R_345()) return true;
    }
    }
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3R_406() {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_407() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_392() {
    if (jj_3R_81()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_406()) {
    jj_scanpos = xsp;
    if (jj_3R_407()) return true;
    }
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_scan_token(UPDATE)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_319() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_318() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_scan_token(BINARYSTRINGVAL)) return true;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_scan_token(ESCAPEDTYPE)) return true;
    if (jj_3R_342()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_316() {
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3R_321() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_320() {
    if (jj_scan_token(UNKNOWN)) return true;
    return false;
  }

  private boolean jj_3R_287() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_316()) {
    jj_scanpos = xsp;
    if (jj_3R_317()) {
    jj_scanpos = xsp;
    if (jj_3R_318()) {
    jj_scanpos = xsp;
    if (jj_3R_319()) {
    jj_scanpos = xsp;
    if (jj_3R_320()) {
    jj_scanpos = xsp;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_3R_322()) {
    jj_scanpos = xsp;
    if (jj_3R_323()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_3R_166()) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_3R_167()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_251() {
    if (jj_3R_88()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_282()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_526() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_527() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_430() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(338)) {
    jj_scanpos = xsp;
    if (jj_scan_token(339)) {
    jj_scanpos = xsp;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(341)) {
    jj_scanpos = xsp;
    if (jj_scan_token(342)) {
    jj_scanpos = xsp;
    if (jj_scan_token(343)) {
    jj_scanpos = xsp;
    if (jj_scan_token(344)) {
    jj_scanpos = xsp;
    if (jj_scan_token(345)) {
    jj_scanpos = xsp;
    if (jj_scan_token(346)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_16() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_393() {
    if (jj_3R_81()) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_scan_token(MERGE)) return true;
    return false;
  }

  private boolean jj_3R_507() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_364()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_506() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_364()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_504() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_364()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_505() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_364()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_502() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_364()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_526()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_168() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_3R_195()) return true;
    }
    if (jj_scan_token(INTO)) return true;
    return false;
  }

  private boolean jj_3R_503() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_364()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_527()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_441() {
    if (jj_scan_token(LSBRACE)) return true;
    if (jj_scan_token(RSBRACE)) return true;
    return false;
  }

  private boolean jj_3R_501() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_364()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_189() {
    if (jj_3R_208()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_441()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_32() {
    if (jj_3R_81()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(396)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) {
    jj_scanpos = xsp;
    if (jj_scan_token(398)) {
    jj_scanpos = xsp;
    if (jj_scan_token(399)) {
    jj_scanpos = xsp;
    if (jj_scan_token(400)) {
    jj_scanpos = xsp;
    if (jj_scan_token(401)) {
    jj_scanpos = xsp;
    if (jj_scan_token(402)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_500() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_364()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_499() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_364()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_64()) return true;
    if (jj_scan_token(EQ)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(401)) jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_376() {
    if (jj_3R_393()) return true;
    return false;
  }

  private boolean jj_3R_375() {
    if (jj_3R_392()) return true;
    return false;
  }

  private boolean jj_3R_498() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_364()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_374() {
    if (jj_3R_391()) return true;
    return false;
  }

  private boolean jj_3R_373() {
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3R_236() {
    if (jj_scan_token(VARBINARY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_507()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_31() {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_scan_token(CLOB)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_506()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_30() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_234() {
    if (jj_scan_token(BLOB)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_505()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_3R_328()) return true;
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_scan_token(OBJECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_504()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_3R_327()) return true;
    return false;
  }

  private boolean jj_3R_232() {
    if (jj_scan_token(DECIMAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_503()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_231() {
    if (jj_scan_token(BIGDECIMAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_502()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_scan_token(BIGINTEGER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_501()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_355() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3R_373()) {
    jj_scanpos = xsp;
    if (jj_3R_374()) {
    jj_scanpos = xsp;
    if (jj_3R_375()) {
    jj_scanpos = xsp;
    if (jj_3R_376()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_scan_token(CHAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_500()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_3R_123()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_355()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_228() {
    if (jj_scan_token(VARCHAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_499()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_scan_token(STRING)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_498()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_3R_64()) return true;
    if (jj_scan_token(EQ)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(401)) jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_250()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_256() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_3R_292()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_208() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_3R_228()) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) {
    jj_scanpos = xsp;
    if (jj_3R_236()) {
    jj_scanpos = xsp;
    if (jj_scan_token(372)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_222() {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_204() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_222()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_424() {
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3R_225() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_255()) jj_scanpos = xsp;
    if (jj_3R_256()) return true;
    return false;
  }

  private boolean jj_3R_423() {
    if (jj_scan_token(NO)) return true;
    if (jj_scan_token(DEFAULT_KEYWORD)) return true;
    return false;
  }

  private boolean jj_3R_408() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_422()) {
    jj_scanpos = xsp;
    if (jj_3R_423()) {
    jj_scanpos = xsp;
    if (jj_3R_424()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_422() {
    if (jj_3R_342()) return true;
    if (jj_scan_token(AS)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_167() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) return true;
    }
    }
    if (jj_3R_64()) return true;
    if (jj_scan_token(LPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    xsp = jj_scanpos;
    if (jj_3R_205()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_3R_225()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_257()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_409() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_408()) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_scan_token(XMLNAMESPACES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_408()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_409()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_226() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_207()) return true;
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_3R_207()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_226()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_14() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_450() {
    if (jj_3R_95()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_497() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(44)) jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_144() {
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3R_181() {
    if (jj_scan_token(XMLFOREST)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_450()) jj_scanpos = xsp;
    if (jj_3R_451()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public SQLParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[372];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static private int[] jj_la1_11;
  static private int[] jj_la1_12;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
      jj_la1_init_6();
      jj_la1_init_7();
      jj_la1_init_8();
      jj_la1_init_9();
      jj_la1_init_10();
      jj_la1_init_11();
      jj_la1_init_12();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70040000,0x0,0x70040000,0x0,0xfffffc00,0x0,0x0,0x0,0x70040000,0x70040000,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70040000,0x0,0x0,0x0,0x70040000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70040000,0x70040000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70040000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70040000,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x70040000,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x70040000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70040000,0x70040000,0x0,0x0,0x0,0x40000,0x70040000,0x0,0x70040000,0x0,0x0,0x0,0x0,0x70040000,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffc00,0x0,0x0,0x70000000,0x70000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffffc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x410080,0x0,0x410080,0x0,0x0,0x0,0x1000,0x0,0x4000,0x510080,0x510080,0x400000,0x10080,0x0,0x0,0x0,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x510080,0x510080,0x510080,0x0,0x4000,0x510080,0x0,0x100000,0x0,0x100000,0x2000a18,0x0,0x2000a18,0x0,0x7,0x0,0x0,0x0,0x2400a18,0x2000a18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x2000a18,0x0,0x0,0x400000,0x2000a18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x2000a18,0x2000a18,0x1000,0x1000,0x1000,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x40,0x40,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x1000,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x7,0x0,0x0,0x400000,0x1000,0x1000,0x1000,0x0,0x100,0x0,0x0,0x0,0x20000,0x2000a18,0x0,0x400000,0x240,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000a18,0x0,0x2000,0x2000,0x0,0x0,0x2000a18,0x0,0x0,0x0,0x0,0x0,0x2000a18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000a18,0x2000a18,0x0,0xa00,0x0,0x0,0x0,0x0,0xa18,0x2000a18,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x2000a18,0x2080a18,0x0,0x0,0x0,0x0,0x2000a18,0x0,0x2000a18,0x0,0x0,0x40,0x40,0x2000a18,0x0,0x0,0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x20,0x0,0x20,0x20,0x40000000,0x40000000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x60410100,0x0,0x60410100,0x0,0x10000,0x10000,0x0,0x0,0x0,0x64418104,0x64418104,0x60410000,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x64418104,0x64418104,0x64418104,0x0,0x0,0x64418104,0x0,0x4,0x0,0x4,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x60010000,0x10000,0x60000000,0x0,0x0,0x0,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x200000,0x200000,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x1000000,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x400000,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x4000000,0x0,0x4000010,0x0,0x4000000,0x4000000,0x0,0x0,0x0,0x4020000,0x4020000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4020000,0x4020000,0x4000000,0x0,0x0,0x4020000,0x0,0x0,0x0,0x0,0x4010003,0x0,0x4010003,0x0,0x0,0x0,0x0,0x0,0x4010003,0x4010003,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x4010003,0x0,0x0,0x0,0x4010003,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x8000000,0x0,0x0,0x0,0x0,0x20000000,0x0,0x1000,0x4000,0x40,0x0,0x0,0x0,0x4010003,0x4010003,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400080,0x0,0x0,0x0,0x0,0x400080,0x400080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40100000,0x0,0x40100000,0x4010003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4010003,0x0,0x0,0x0,0x0,0x0,0x4010000,0x0,0x0,0x4,0x4,0x0,0x4010000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4010000,0x4010002,0x0,0x0,0x8,0x0,0x8,0x0,0x4010000,0x4010003,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x40,0x10000,0x0,0x4010003,0x4010003,0x0,0x0,0x0,0x10000,0x4010003,0x4000000,0x4010003,0x0,0x0,0x0,0x0,0x4010003,0x0,0x8,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x20,0x20,0x100,0x0,0x1100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1100000,0x1100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x420,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x8000,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x8420,0x8420,0x8000,0x0,0x200,0x0,0x80000000,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x8020,0x8020,0x8020,0x4000000,0x4000000,0x8420,0x0,0x0,0x0,0x20,0xc120002,0x4000000,0xc120002,0x0,0x0,0x0,0x0,0x0,0xc128002,0xc120002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc120002,0x0,0x0,0x0,0xc120002,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc120002,0xc120002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x2800,0x2800,0x1000,0x0,0x1000000,0x1000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x40000c0,0x8120002,0x0,0x0,0x0,0x0,0x4000000,0x40,0x0,0x0,0x4000000,0x4000000,0x4000000,0x4000000,0x0,0x0,0xc120002,0x0,0x0,0x0,0x0,0x0,0x120002,0x0,0x0,0x0,0x20000100,0x0,0x120002,0x0,0x803800,0x0,0x0,0x0,0x0,0x0,0x803800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x120002,0x8120002,0x0,0x0,0x0,0x0,0x0,0x0,0x120002,0xc120002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x120000,0x10,0xc120002,0xc120012,0x0,0x0,0x0,0x120002,0xc120002,0x0,0xc120002,0x0,0x0,0x0,0x0,0xc120002,0x0,0x0,0x0,0x120002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x400000,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x400000,0x400000,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x2000000,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x4,0x0,0x2000000,0x4,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x4,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x80,0x80,0x80,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa000000,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x30000000,0x0,0x0,0x0,0x2000000,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x200,0x0,0x200,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x2000000,0x0,0x0,0x0,0x0,0x2000000,0x20,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x40,0x8,0x0,0x0,0x0,0x800000,0x8,0x0,0x40,0x40,0x0,0x0,0x0,0x8,0x0,0x8,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x8000,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x10000,0x8,0x0,0x0,0x0,0x0,0x800,0x800,};
   }
   private static void jj_la1_init_6() {
      jj_la1_6 = new int[] {0x0,0x0,0x80020004,0x0,0x80020004,0x0,0x80000000,0x80000000,0x0,0x2000000,0x0,0x80020004,0x80020004,0x80020004,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x400,0x0,0x800,0x0,0x0,0x0,0x80020004,0x80020004,0x80020004,0x0,0x0,0x80020004,0x0,0x0,0x0,0x0,0x65000102,0x0,0x65000102,0x0,0x0,0x0,0x0,0x0,0xe5020506,0xe5020506,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x65000102,0x0,0x0,0x0,0x65000102,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x65000102,0x65000102,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x0,0x0,0x20000,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x20004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x65000102,0x0,0x20004,0x100,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x65000102,0x0,0x0,0x0,0x0,0x0,0x41000102,0x0,0x0,0x0,0x0,0x0,0x41000102,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x41000102,0x65000102,0x0,0x100,0x0,0x0,0x0,0x0,0x41000102,0x65000102,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x800000,0x65000102,0x65800102,0x0,0x0,0x0,0x40000002,0x65000102,0x1000000,0x65000102,0x0,0x0,0x0,0x0,0x65000102,0x0,0x0,0x0,0x40000002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x24000000,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x24000000,0x0,0x0,0x20000,0x0,0x20,0x0,0x20,0x20,0x0,0x0,};
   }
   private static void jj_la1_init_7() {
      jj_la1_7 = new int[] {0x0,0x0,0x84,0x0,0x84,0x0,0x0,0x0,0x0,0x0,0x0,0x184,0x184,0x84,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x84,0x84,0x84,0x0,0x0,0x184,0x0,0x0,0x0,0x0,0x1000,0x0,0x1000,0x0,0x0,0x0,0x880,0x880,0x1084,0x1084,0x0,0x880,0x880,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x40,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x84,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x84,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x10,0x0,0x0,0x0,0x1000,0x0,0x1000,0x1000,0x0,0x0,0x0,0x1000,0x1000,0x0,0x1000,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_8() {
      jj_la1_8 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f3b900,0x0,0x2f3b900,0x0,0x0,0x0,0x0,0x0,0x2f3b900,0x2f3b900,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f3b900,0x0,0x0,0x0,0x2f3b900,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f3b900,0x2f3b900,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f3b900,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f3b900,0x0,0x0,0x0,0x0,0x0,0x2f2b900,0x0,0x0,0x0,0x0,0x0,0x2f2b900,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f2b900,0x2f2b900,0x0,0x100,0x0,0x0,0x0,0x0,0x2f2b900,0x2f3b900,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2f3b900,0x2f3b900,0x0,0x0,0x0,0x2003000,0x2f3b900,0x0,0x2f3b900,0x0,0x0,0x0,0x0,0x2f3b900,0x0,0x0,0x0,0x2003000,0x328000,0xc00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_9() {
      jj_la1_9 = new int[] {0xffffff00,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x0,0x600,0x800,0x0,0xffffff00,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0xffffff00,0x0,0x0,0x0,0xffffff00,0x0,0xffffff00,0xffffff00,0x0,0x0,0x0,0xffffff00,0x0,0x0,0xffffff00,0x0,0xffffff00,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0xffffff00,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff00,0x0,0x0,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff00,0xffffff00,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff88000,0x0,0x0,0xff88000,0x70000,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x30000000,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff00,0xffffff00,0x0,0xff8c000,0x0,0x0,0x0,0x0,0xffffff00,0xffffff00,0x0,0xffffff00,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff00,0xffffff00,0x0,0x0,0x0,0x0,0xffffff00,0x0,0xffffff00,0x0,0x0,0x0,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0xffffff00,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffff00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_10() {
      jj_la1_10 = new int[] {0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x80000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0xc,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x14,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x180,0x0,0x600,0x0,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000,0x0,0x0,0x0,0x8000,0xc000,0x0,0x0,0x10000,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_11() {
      jj_la1_11 = new int[] {0xfffff,0x4fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4fffff,0x4fffff,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x4fffff,0x0,0x0,0x10000,0x4fffff,0x0,0x4fffff,0x4fffff,0x8000,0x0,0x0,0x4fffff,0x4000,0x0,0x4fffff,0x0,0x7a4fffff,0x0,0x7a4fffff,0x0,0x104000,0x0,0x0,0x0,0x7a4fffff,0x7a4fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7a4fffff,0x0,0x0,0x0,0x7a4fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7a6fffff,0x7a6fffff,0x0,0x4fffff,0x0,0x20000,0x0,0x0,0x0,0x10,0x20,0x20,0x40,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x44fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x200,0xc00,0xc00,0x0,0x0,0x0,0x0,0x10,0x20,0x20,0x0,0x40,0x0,0x0,0x40,0x0,0x0,0x100040,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x8,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x4fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x7a4fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7a4fffff,0x0,0x0,0x0,0x0,0x80,0x24fffff,0x0,0x0,0x0,0x0,0x0,0x24fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x4fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x324fffff,0x7a4fffff,0x0,0x20000,0x0,0x0,0x0,0x0,0x4fffff,0x7a4fffff,0x0,0x4fffff,0x2000000,0x4fffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7a4fffff,0x7a4fffff,0x0,0x0,0x0,0x0,0x7a4fffff,0x0,0x7a4fffff,0x2,0x0,0x0,0x0,0x7a4fffff,0x0,0x0,0x0,0x0,0x0,0x4fffff,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x48000000,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x4fffff,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x2000,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x78000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_12() {
      jj_la1_12 = new int[] {0x0,0x0,0x140,0x2000000,0x40,0x2000000,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x40,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x40,0x40,0x40,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x1e00046,0x0,0x1e00046,0x0,0x0,0x1000,0x0,0x0,0x1e00046,0x1e00046,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80002,0x0,0x10,0x800000,0x1e00046,0x40,0x0,0x0,0x1e00046,0x0,0x20000,0x10,0x20000,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x10,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x1e80046,0x1e00046,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x10,0x0,0x10,0x0,0x0,0x0,0x10,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f000,0x7f000,0x1e00046,0x7f000,0x40,0x0,0x40,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x10,0x40,0x1e00046,0x10,0x0,0x0,0x0,0x0,0x1800042,0x10,0x0,0x0,0x0,0x0,0x1800042,0x0,0x0,0x10,0x10,0x10,0x10,0x0,0x0,0x18000000,0x18000000,0x600000,0x600000,0x180000,0x180000,0x600000,0x400,0x1800042,0x1e00046,0x1800000,0x0,0x0,0x0,0x0,0x0,0x0,0x1e00046,0x10,0x0,0x1800000,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x1e00046,0x1e00046,0x0,0x10,0x0,0x0,0x1e00046,0x0,0x1e00046,0x0,0x10,0x0,0x0,0x1e00046,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x10,0x10,0x10,0x0,0x10,0x0,0x40,0x40,0x40,0x40,0x10,0x40,0x10,0x40,0x40,0x40,0x40,0x40,0x0,0x400,0x0,0x0,0x4,0x2,0x0,0x2000000,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x10,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x600000,0x600006,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[58];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public SQLParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public SQLParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new SQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 372; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 372; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public SQLParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new SQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 372; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 372; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public SQLParser(SQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 372; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(SQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 372; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token_broken(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[413];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 372; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
          if ((jj_la1_8[i] & (1<<j)) != 0) {
            la1tokens[256+j] = true;
          }
          if ((jj_la1_9[i] & (1<<j)) != 0) {
            la1tokens[288+j] = true;
          }
          if ((jj_la1_10[i] & (1<<j)) != 0) {
            la1tokens[320+j] = true;
          }
          if ((jj_la1_11[i] & (1<<j)) != 0) {
            la1tokens[352+j] = true;
          }
          if ((jj_la1_12[i] & (1<<j)) != 0) {
            la1tokens[384+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 413; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 58; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
