/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class XMLSerialize
implements Expression {
    private Boolean document;
    private Boolean declaration;
    private Expression expression;
    private String typeString;
    private Class<?> type;
    private String version;
    private String encoding;

    @Override
    public Class<?> getType() {
        if (this.type == null) {
            this.type = this.typeString == null ? DataTypeManager.DefaultDataClasses.CLOB : DataTypeManager.getDataTypeClass(this.typeString);
        }
        return this.type;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Boolean getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(Boolean declaration) {
        this.declaration = declaration;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Boolean getDocument() {
        return this.document;
    }

    public void setDocument(Boolean document) {
        this.document = document;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setTypeString(String typeString) {
        this.typeString = typeString;
    }

    public String getTypeString() {
        return this.typeString;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public XMLSerialize clone() {
        XMLSerialize clone = new XMLSerialize();
        clone.document = this.document;
        clone.expression = (Expression)this.expression.clone();
        clone.typeString = this.typeString;
        clone.type = this.type;
        clone.declaration = this.declaration;
        clone.version = this.version;
        clone.encoding = this.encoding;
        return clone;
    }

    public boolean isDocument() {
        return this.document != null && this.document != false;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(this.expression.hashCode(), this.getType());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XMLSerialize)) {
            return false;
        }
        XMLSerialize other = (XMLSerialize)obj;
        return EquivalenceUtil.areEqual(this.document, other.document) && this.expression.equals(other.expression) && this.getType() == other.getType() && EquivalenceUtil.areEqual(this.declaration, other.declaration) && EquivalenceUtil.areEqual(this.version, other.version) && EquivalenceUtil.areEqual(this.encoding, other.encoding);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

