/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.List;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.query.processor.relational.RelationalNode;

public class RelationalNodeStatistics {
    static final int BATCHCOMPLETE_STOP = 0;
    static final int BLOCKEDEXCEPTION_STOP = 1;
    private boolean setNodeStartTime = false;
    private int nodeOutputRows;
    private long nodeStartTime;
    private long nodeEndTime;
    private long batchStartTime;
    private long batchEndTime;
    private long nodeNextBatchProcessingTime;
    private long nodeCumulativeProcessingTime;
    private long nodeCumulativeNextBatchProcessingTime;
    private int nodeNextBatchCalls;
    private int nodeBlocks;

    public void startBatchTimer() {
        this.batchStartTime = System.currentTimeMillis();
    }

    void setBatchStartTime(long batchStartTime) {
        this.batchStartTime = batchStartTime;
    }

    public void stopBatchTimer() {
        this.batchEndTime = System.currentTimeMillis();
    }

    void setBatchEndTime(long batchEndTime) {
        this.batchEndTime = batchEndTime;
    }

    public void collectCumulativeNodeStats(TupleBatch batch, int stopType) {
        ++this.nodeNextBatchCalls;
        if (!this.setNodeStartTime) {
            this.nodeStartTime = this.batchStartTime;
            this.setNodeStartTime = true;
        }
        this.nodeCumulativeNextBatchProcessingTime += this.batchEndTime - this.batchStartTime;
        switch (stopType) {
            case 0: {
                this.nodeOutputRows += batch.getRowCount();
                break;
            }
            case 1: {
                ++this.nodeBlocks;
            }
        }
    }

    public void collectNodeStats(RelationalNode[] relationalNodes) {
        this.nodeEndTime = this.batchEndTime;
        this.nodeNextBatchProcessingTime = this.nodeCumulativeProcessingTime = this.nodeEndTime - this.nodeStartTime;
        for (int i = 0; i < relationalNodes.length && relationalNodes[i] != null; ++i) {
            this.nodeNextBatchProcessingTime -= relationalNodes[i].getNodeStatistics().getNodeCumulativeNextBatchProcessingTime();
        }
    }

    public List<String> getStatisticsList() {
        ArrayList<String> statisticsList = new ArrayList<String>(6);
        statisticsList.add("Node Output Rows: " + this.nodeOutputRows);
        statisticsList.add("Node Next Batch Process Time: " + this.nodeNextBatchProcessingTime);
        statisticsList.add("Node Cumulative Next Batch Process Time: " + this.nodeCumulativeNextBatchProcessingTime);
        statisticsList.add("Node Cumulative Process Time: " + this.nodeCumulativeProcessingTime);
        statisticsList.add("Node Next Batch Calls: " + this.nodeNextBatchCalls);
        statisticsList.add("Node Blocks: " + this.nodeBlocks);
        return statisticsList;
    }

    public int getNodeBlocks() {
        return this.nodeBlocks;
    }

    public long getNodeCumulativeNextBatchProcessingTime() {
        return this.nodeCumulativeNextBatchProcessingTime;
    }

    public long getNodeCumulativeProcessingTime() {
        return this.nodeCumulativeProcessingTime;
    }

    public long getNodeEndTime() {
        return this.nodeEndTime;
    }

    public int getNodeNextBatchCalls() {
        return this.nodeNextBatchCalls;
    }

    public int getNodeOutputRows() {
        return this.nodeOutputRows;
    }

    public long getNodeNextBatchProcessingTime() {
        return this.nodeNextBatchProcessingTime;
    }

    public long getNodeStartTime() {
        return this.nodeStartTime;
    }

    public long getBatchEndTime() {
        return this.batchEndTime;
    }

    public long getBatchStartTime() {
        return this.batchStartTime;
    }
}

