/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.AbstractTupleSource;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.BatchIterator;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.sql.lang.OrderByItem;

public class SortNode
extends RelationalNode {
    private List<OrderByItem> items;
    private SortUtility.Mode mode = SortUtility.Mode.SORT;
    private SortUtility sortUtility;
    private int phase = 2;
    private TupleBuffer output;
    private TupleSource outputTs;
    private boolean usingOutput;
    private int rowLimit = -1;
    private static final int SORT = 2;
    private static final int OUTPUT = 3;

    public SortNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.sortUtility = null;
        this.phase = 2;
        this.output = null;
        this.outputTs = null;
        this.usingOutput = false;
        this.rowLimit = -1;
    }

    public void setSortElements(List<OrderByItem> items) {
        this.items = items;
    }

    public List<OrderByItem> getSortElements() {
        return this.items;
    }

    public SortUtility.Mode getMode() {
        return this.mode;
    }

    public void setMode(SortUtility.Mode mode) {
        this.mode = mode;
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.phase == 2) {
            this.sortPhase();
        }
        return this.outputPhase();
    }

    private void sortPhase() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.sortUtility == null) {
            AbstractTupleSource ts = null;
            ts = this.getChildren()[0].hasFinalBuffer() ? this.getChildren()[0].getFinalBuffer(-1).createIndexedTupleSource(true) : new BatchIterator(this.getChildren()[0]);
            this.sortUtility = new SortUtility(ts, this.items, this.mode, this.getBufferManager(), this.getConnectionID(), this.getChildren()[0].getElements());
        }
        this.output = this.sortUtility.sort();
        if (this.outputTs == null) {
            this.outputTs = this.output.createIndexedTupleSource();
        }
        if (this.rowLimit >= 0) {
            this.output.truncateTo(this.rowLimit);
            if (!this.output.isFinal() && this.output.getRowCount() == this.rowLimit) {
                this.output.close();
            }
        }
        this.phase = 3;
    }

    private TupleBatch outputPhase() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (!this.output.isFinal()) {
            this.phase = 2;
        } else if (!this.usingOutput) {
            this.output.setForwardOnly(true);
        }
        List<?> tuple = null;
        try {
            while ((tuple = this.outputTs.nextTuple()) != null) {
                if (this.getElements().size() < tuple.size()) {
                    tuple = new ArrayList(tuple.subList(0, this.getElements().size()));
                }
                this.addBatchRow(tuple);
                if (!this.isBatchFull()) continue;
                return this.pullBatch();
            }
        }
        catch (BlockedException e) {
            if (this.hasPendingRows()) {
                return this.pullBatch();
            }
            throw e;
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    @Override
    public void closeDirect() {
        if (this.output != null) {
            if (!this.usingOutput) {
                this.output.remove();
            }
            this.output = null;
        }
        if (this.sortUtility != null) {
            this.sortUtility.remove();
            this.sortUtility = null;
        }
        this.outputTs = null;
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append("[").append((Object)this.mode).append("] ");
        if (this.mode != SortUtility.Mode.DUP_REMOVE) {
            str.append(this.items);
        }
    }

    protected void copyTo(SortNode target) {
        super.copyTo(target);
        target.items = this.items;
        target.mode = this.mode;
    }

    @Override
    public Object clone() {
        SortNode clonedNode = new SortNode(super.getID());
        this.copyTo(clonedNode);
        return clonedNode;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        if (this.mode != SortUtility.Mode.DUP_REMOVE && this.items != null) {
            props.addProperty("Sort Columns", this.items.toString());
        }
        props.addProperty("Sort Mode", this.mode.toString());
        return props;
    }

    @Override
    public TupleBuffer getFinalBuffer(int maxRows) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        this.rowLimit = maxRows;
        if (this.output == null) {
            this.sortPhase();
        }
        this.usingOutput = true;
        TupleBuffer result = this.output;
        if (this.output.isFinal()) {
            this.output = null;
            this.close();
        }
        return result;
    }

    @Override
    public boolean hasFinalBuffer() {
        return this.getElements().size() == this.getChildren()[0].getElements().size();
    }
}

