/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.metadata.BasicQueryMetadata;
import org.teiid.query.metadata.BasicQueryMetadataWrapper;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.symbol.Expression;

public class TempMetadataAdapter
extends BasicQueryMetadataWrapper {
    private static final String SEPARATOR = ".";
    public static final TempMetadataID TEMP_MODEL = new TempMetadataID("__TEMP__", Collections.EMPTY_LIST);
    private TempMetadataStore tempStore;
    private Map<Object, Object> materializationTables;
    private Map<Object, QueryNode> queryNodes;
    private boolean session;

    public TempMetadataAdapter(QueryMetadataInterface metadata, TempMetadataStore tempStore) {
        super(metadata);
        this.tempStore = tempStore;
    }

    public TempMetadataAdapter(QueryMetadataInterface metadata, TempMetadataStore tempStore, Map<Object, Object> materializationTables, Map<Object, QueryNode> queryNodes) {
        super(metadata);
        this.tempStore = tempStore;
        this.materializationTables = materializationTables;
        this.queryNodes = queryNodes;
    }

    public boolean isSession() {
        return this.session;
    }

    public void setSession(boolean session) {
        this.session = session;
    }

    @Override
    public QueryMetadataInterface getSessionMetadata() {
        if (this.isSession()) {
            TempMetadataAdapter tma = new TempMetadataAdapter(new BasicQueryMetadata(), this.tempStore);
            tma.session = true;
            return tma;
        }
        return this.actualMetadata.getSessionMetadata();
    }

    @Override
    protected QueryMetadataInterface createDesignTimeMetadata() {
        if (this.isSession()) {
            return new TempMetadataAdapter(this.actualMetadata.getDesignTimeMetadata(), new TempMetadataStore());
        }
        return new TempMetadataAdapter(this.actualMetadata.getDesignTimeMetadata(), this.tempStore, this.materializationTables, this.queryNodes);
    }

    public TempMetadataStore getMetadataStore() {
        return this.tempStore;
    }

    public QueryMetadataInterface getMetadata() {
        return this.actualMetadata;
    }

    @Override
    public Object getElementID(String elementName) throws TeiidComponentException, QueryMetadataException {
        Object tempID = null;
        try {
            tempID = this.actualMetadata.getElementID(elementName);
        }
        catch (QueryMetadataException queryMetadataException) {
            // empty catch block
        }
        if (tempID == null) {
            tempID = this.tempStore.getTempElementID(elementName);
        }
        if (tempID != null) {
            return tempID;
        }
        throw new QueryMetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30350, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30350, new Object[]{elementName}));
    }

    @Override
    public Object getGroupID(String groupName) throws TeiidComponentException, QueryMetadataException {
        Object tempID = null;
        try {
            tempID = this.actualMetadata.getGroupID(groupName);
        }
        catch (QueryMetadataException queryMetadataException) {
            // empty catch block
        }
        if (tempID == null) {
            tempID = this.tempStore.getTempGroupID(groupName);
        }
        if (tempID != null) {
            return tempID;
        }
        throw new QueryMetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID30351, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30351, new Object[]{groupName}));
    }

    @Override
    public Collection getGroupsForPartialName(String partialGroupName) throws TeiidComponentException, QueryMetadataException {
        Collection groups = super.getGroupsForPartialName(partialGroupName);
        ArrayList<String> allGroups = new ArrayList<String>(groups);
        for (Map.Entry entry : this.tempStore.getData().entrySet()) {
            String name = (String)entry.getKey();
            if (!StringUtil.endsWithIgnoreCase((String)name, (String)partialGroupName) || name.length() != partialGroupName.length() && (((TempMetadataID)entry.getValue()).getMetadataType() == TempMetadataID.Type.TEMP || name.length() <= partialGroupName.length() || name.charAt(name.length() - partialGroupName.length() - 1) != '.')) continue;
            allGroups.add(name);
        }
        return allGroups;
    }

    @Override
    public Object getModelID(Object groupOrElementID) throws TeiidComponentException, QueryMetadataException {
        Table t;
        if ((groupOrElementID = TempMetadataAdapter.getActualMetadataId(groupOrElementID)) instanceof TempMetadataID) {
            TempMetadataID tid = (TempMetadataID)groupOrElementID;
            Object oid = tid.getOriginalMetadataID();
            if (oid instanceof Procedure) {
                return this.actualMetadata.getModelID(oid);
            }
            return TEMP_MODEL;
        }
        Object id = groupOrElementID;
        if (groupOrElementID instanceof Column) {
            id = ((Column)id).getParent();
        }
        if (id instanceof Table && (t = (Table)id).getTableType() == Table.Type.TemporaryTable && t.isVirtual()) {
            return TEMP_MODEL;
        }
        return this.actualMetadata.getModelID(groupOrElementID);
    }

    @Override
    public String getFullName(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof TempMetadataID) {
            return ((TempMetadataID)metadataID).getID();
        }
        return this.actualMetadata.getFullName(metadataID);
    }

    @Override
    public String getName(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof TempMetadataID) {
            TempMetadataID tid = (TempMetadataID)metadataID;
            return tid.getName();
        }
        return this.actualMetadata.getName(metadataID);
    }

    @Override
    public List getElementIDsInGroupID(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if ((groupID = TempMetadataAdapter.getActualMetadataId(groupID)) instanceof TempMetadataID) {
            return new ArrayList<TempMetadataID>(((TempMetadataID)groupID).getElements());
        }
        return this.actualMetadata.getElementIDsInGroupID(groupID);
    }

    @Override
    public Object getGroupIDForElementID(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            String elementName = ((TempMetadataID)elementID).getID();
            String groupName = elementName.substring(0, elementName.lastIndexOf(SEPARATOR));
            return this.tempStore.getTempGroupID(groupName);
        }
        return this.actualMetadata.getGroupIDForElementID(elementID);
    }

    @Override
    public String getElementType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            TempMetadataID tempID = (TempMetadataID)elementID;
            if (tempID.getType() != null) {
                return DataTypeManager.getDataTypeName(tempID.getType());
            }
            throw new AssertionError((Object)("No type set for element " + elementID));
        }
        return this.actualMetadata.getElementType(elementID);
    }

    @Override
    public Object getDefaultValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            return null;
        }
        return this.actualMetadata.getDefaultValue(elementID);
    }

    @Override
    public Object getMaximumValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.actualMetadata.getMaximumValue(elementID);
    }

    @Override
    public Object getMinimumValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return null;
        }
        return this.actualMetadata.getMinimumValue(elementID);
    }

    @Override
    public float getDistinctValues(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            return -1.0f;
        }
        return this.actualMetadata.getDistinctValues(elementID);
    }

    @Override
    public float getNullValues(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return -1.0f;
        }
        return this.actualMetadata.getNullValues(elementID);
    }

    @Override
    public QueryNode getVirtualPlan(Object groupID) throws TeiidComponentException, QueryMetadataException {
        QueryNode node;
        if (this.queryNodes != null && (node = this.queryNodes.get(groupID)) != null) {
            return node;
        }
        if (groupID instanceof TempMetadataID && !(this.actualMetadata instanceof TempMetadataAdapter)) {
            return ((TempMetadataID)groupID).getQueryNode();
        }
        return this.actualMetadata.getVirtualPlan(groupID);
    }

    @Override
    public boolean isVirtualGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return ((TempMetadataID)groupID).isVirtual();
        }
        return this.actualMetadata.isVirtualGroup(groupID);
    }

    @Override
    public boolean hasMaterialization(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (this.materializationTables != null && this.materializationTables.containsKey(groupID)) {
            return true;
        }
        if (groupID instanceof TempMetadataID && !(this.actualMetadata instanceof TempMetadataAdapter)) {
            return false;
        }
        return this.actualMetadata.hasMaterialization(groupID);
    }

    @Override
    public Object getMaterialization(Object groupID) throws TeiidComponentException, QueryMetadataException {
        Object result;
        if (this.materializationTables != null && (result = this.materializationTables.get(groupID)) != null) {
            return result;
        }
        if (groupID instanceof TempMetadataID && !(this.actualMetadata instanceof TempMetadataAdapter)) {
            return null;
        }
        return this.actualMetadata.getMaterialization(groupID);
    }

    @Override
    public Object getMaterializationStage(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return null;
        }
        return this.actualMetadata.getMaterializationStage(groupID);
    }

    @Override
    public boolean isVirtualModel(Object modelID) throws TeiidComponentException, QueryMetadataException {
        if (modelID.equals(TEMP_MODEL)) {
            return false;
        }
        return this.actualMetadata.isVirtualModel(modelID);
    }

    @Override
    public boolean elementSupports(Object elementID, int supportConstant) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)elementID;
            switch (supportConstant) {
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 0: {
                    return true;
                }
                case 4: {
                    if (id.isNotNull()) {
                        return false;
                    }
                    if (!id.isTempTable()) break;
                    return true;
                }
                case 8: {
                    return id.isAutoIncrement();
                }
                case 5: {
                    return id.isTempTable() || id.isUpdatable();
                }
            }
            elementID = id.getOriginalMetadataID();
            if (elementID == null || id.isTempTable()) {
                switch (supportConstant) {
                    case 4: {
                        return true;
                    }
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
        }
        return this.actualMetadata.elementSupports(elementID, supportConstant);
    }

    @Override
    public Collection getIndexesInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if ((groupID = TempMetadataAdapter.getActualMetadataId(groupID)) instanceof TempMetadataID) {
            List<TempMetadataID> result = ((TempMetadataID)groupID).getIndexes();
            if (result == null) {
                return Collections.emptyList();
            }
            return result;
        }
        return this.actualMetadata.getIndexesInGroup(groupID);
    }

    @Override
    public Collection getUniqueKeysInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if ((groupID = TempMetadataAdapter.getActualMetadataId(groupID)) instanceof TempMetadataID) {
            LinkedList<List<TempMetadataID>> result = new LinkedList<List<TempMetadataID>>();
            TempMetadataID id = (TempMetadataID)groupID;
            if (id.getPrimaryKey() != null) {
                result.add(id.getPrimaryKey());
            }
            if (id.getUniqueKeys() != null) {
                result.addAll(id.getUniqueKeys());
            }
            return result;
        }
        return this.actualMetadata.getUniqueKeysInGroup(groupID);
    }

    @Override
    public Collection getForeignKeysInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if ((groupID = TempMetadataAdapter.getActualMetadataId(groupID)) instanceof TempMetadataID) {
            return Collections.EMPTY_LIST;
        }
        return this.actualMetadata.getForeignKeysInGroup(groupID);
    }

    @Override
    public List getElementIDsInIndex(Object index) throws TeiidComponentException, QueryMetadataException {
        return this.actualMetadata.getElementIDsInIndex(index);
    }

    @Override
    public List getElementIDsInKey(Object keyID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (keyID instanceof List) {
            return (List)keyID;
        }
        if (keyID instanceof TempMetadataID && (id = (TempMetadataID)keyID).getMetadataType() == TempMetadataID.Type.INDEX) {
            return id.getElements();
        }
        return this.actualMetadata.getElementIDsInKey(keyID);
    }

    @Override
    public boolean groupSupports(Object groupID, int groupConstant) throws TeiidComponentException, QueryMetadataException {
        if ((groupID = TempMetadataAdapter.getActualMetadataId(groupID)) instanceof TempMetadataID) {
            return true;
        }
        return this.actualMetadata.groupSupports(groupID, groupConstant);
    }

    @Override
    public MappingNode getMappingNode(Object groupID) throws TeiidComponentException, QueryMetadataException {
        return this.actualMetadata.getMappingNode(groupID);
    }

    @Override
    public boolean isXMLGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return ((TempMetadataID)groupID).getMetadataType() == TempMetadataID.Type.XML;
        }
        return this.actualMetadata.isXMLGroup(groupID);
    }

    @Override
    public String getVirtualDatabaseName() throws TeiidComponentException, QueryMetadataException {
        return this.actualMetadata.getVirtualDatabaseName();
    }

    @Override
    public Collection getAccessPatternsInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if ((groupID = TempMetadataAdapter.getActualMetadataId(groupID)) instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)groupID;
            return id.getAccessPatterns();
        }
        return this.actualMetadata.getAccessPatternsInGroup(groupID);
    }

    @Override
    public List getElementIDsInAccessPattern(Object accessPattern) throws TeiidComponentException, QueryMetadataException {
        if (accessPattern instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)accessPattern;
            if (id.getElements() != null) {
                return id.getElements();
            }
            return Collections.EMPTY_LIST;
        }
        return this.actualMetadata.getElementIDsInAccessPattern(accessPattern);
    }

    @Override
    public Collection getXMLTempGroups(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_SET;
        }
        return this.actualMetadata.getXMLTempGroups(groupID);
    }

    @Override
    public float getCardinality(Object groupID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        Table t;
        if ((groupID = TempMetadataAdapter.getActualMetadataId(groupID)) instanceof TempMetadataID) {
            return ((TempMetadataID)groupID).getCardinality();
        }
        if (this.isSession() && groupID instanceof Table && (t = (Table)groupID).getTableType() == Table.Type.TemporaryTable && t.isVirtual() && (id = this.tempStore.getTempGroupID(t.getName())) != null) {
            return id.getCardinality();
        }
        return this.actualMetadata.getCardinality(groupID);
    }

    @Override
    public List getXMLSchemas(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            return Collections.EMPTY_LIST;
        }
        return this.actualMetadata.getXMLSchemas(groupID);
    }

    @Override
    public Properties getExtensionProperties(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        if ((metadataID = TempMetadataAdapter.getActualMetadataId(metadataID)) instanceof TempMetadataID) {
            return TransformationMetadata.EMPTY_PROPS;
        }
        return this.actualMetadata.getExtensionProperties(metadataID);
    }

    @Override
    public int getElementLength(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            TempMetadataID id = (TempMetadataID)elementID;
            Object origElementID = id.getOriginalMetadataID();
            if (origElementID == null) {
                String type = this.getElementType(elementID);
                if (type.equals("string")) {
                    return 255;
                }
                return 10;
            }
            elementID = origElementID;
        }
        return this.actualMetadata.getElementLength(elementID);
    }

    @Override
    public int getPosition(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            return ((TempMetadataID)elementID).getPosition();
        }
        return this.actualMetadata.getPosition(elementID);
    }

    @Override
    public int getPrecision(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return 0;
        }
        return this.actualMetadata.getPrecision(elementID);
    }

    @Override
    public int getRadix(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return 0;
        }
        return this.actualMetadata.getRadix(elementID);
    }

    @Override
    public int getScale(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return 0;
        }
        return this.actualMetadata.getScale(elementID);
    }

    @Override
    public String getNativeType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        TempMetadataID id;
        if (elementID instanceof TempMetadataID && (elementID = (id = (TempMetadataID)elementID).getOriginalMetadataID()) == null) {
            return "";
        }
        return this.actualMetadata.getNativeType(elementID);
    }

    @Override
    public boolean isProcedure(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof TempMetadataID) {
            Object oid = ((TempMetadataID)elementID).getOriginalMetadataID();
            if (oid != null) {
                return this.actualMetadata.isProcedure(oid);
            }
            return false;
        }
        return this.actualMetadata.isProcedure(elementID);
    }

    @Override
    public boolean isTemporaryTable(Object groupID) throws TeiidComponentException, QueryMetadataException {
        Table t;
        if (groupID instanceof TempMetadataID) {
            return ((TempMetadataID)groupID).isTempTable();
        }
        return groupID instanceof Table && (t = (Table)groupID).getTableType() == Table.Type.TemporaryTable;
    }

    @Override
    public Object addToMetadataCache(Object metadataID, String key, Object value) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof TempMetadataID) {
            TempMetadataID tid = (TempMetadataID)metadataID;
            return tid.setProperty(key, value);
        }
        return this.actualMetadata.addToMetadataCache(metadataID, key, value);
    }

    @Override
    public Object getFromMetadataCache(Object metadataID, String key) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof TempMetadataID) {
            TempMetadataID tid = (TempMetadataID)metadataID;
            return tid.getProperty(key);
        }
        return this.actualMetadata.getFromMetadataCache(metadataID, key);
    }

    @Override
    public boolean isScalarGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        if (groupID instanceof TempMetadataID) {
            TempMetadataID tid = (TempMetadataID)groupID;
            return tid.isScalarGroup();
        }
        return this.actualMetadata.isScalarGroup(groupID);
    }

    @Override
    public Object getPrimaryKey(Object metadataID) {
        if ((metadataID = TempMetadataAdapter.getActualMetadataId(metadataID)) instanceof TempMetadataID) {
            return ((TempMetadataID)metadataID).getPrimaryKey();
        }
        return this.actualMetadata.getPrimaryKey(metadataID);
    }

    @Override
    public boolean isMultiSource(Object modelId) throws QueryMetadataException, TeiidComponentException {
        if (modelId instanceof TempMetadataID) {
            return false;
        }
        return this.actualMetadata.isMultiSource(modelId);
    }

    @Override
    public boolean isMultiSourceElement(Object elementId) throws QueryMetadataException, TeiidComponentException {
        if (elementId instanceof TempMetadataID) {
            return false;
        }
        return this.actualMetadata.isMultiSourceElement(elementId);
    }

    @Override
    public Map<Expression, Integer> getFunctionBasedExpressions(Object metadataID) {
        if (metadataID instanceof TempMetadataID) {
            return ((TempMetadataID)metadataID).getTableData().getFunctionBasedExpressions();
        }
        return super.getFunctionBasedExpressions(metadataID);
    }

    public static Object getActualMetadataId(Object id) {
        if (!(id instanceof TempMetadataID)) {
            return id;
        }
        TempMetadataID tid = (TempMetadataID)id;
        Object oid = tid.getOriginalMetadataID();
        if (oid != null && tid.getTableData().getModel() != null) {
            return tid.getOriginalMetadataID();
        }
        return tid;
    }

    @Override
    public String getExtensionProperty(Object metadataID, String key, boolean checkUnqualified) {
        return super.getExtensionProperty(metadataID, key, checkUnqualified);
    }
}

