/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.ElementSymbol;

public class ResultSetInfo {
    private String resultSetName;
    private Command rsCommand;
    private ProcessorPlan rsPlan;
    private int userRowLimit = -1;
    private boolean exceptionOnRowLimit = false;
    private OrderBy orderBy;
    private Criteria criteria;
    private Set<MappingSourceNode> criteriaResultSets = new HashSet<MappingSourceNode>();
    private boolean criteriaRaised = false;
    private ElementSymbol mappingClassSymbol;
    private boolean inputSet;
    private boolean isCritNullDependent;
    private String stagingRoot;
    private String tempTable;
    private Command tempSelect;
    private Insert tempInsert;
    private Command tempDrop;
    private boolean isAutoStaged;
    private Set<List<ElementSymbol>> fkColumns;

    public ResultSetInfo(String resultName) {
        this.resultSetName = resultName;
    }

    public String getResultSetName() {
        return this.resultSetName;
    }

    public Command getCommand() {
        return this.rsCommand;
    }

    public void setCommand(Command cmd) {
        this.rsCommand = cmd;
    }

    public ProcessorPlan getPlan() {
        return this.rsPlan;
    }

    public void setPlan(ProcessorPlan plan) {
        this.rsPlan = plan;
    }

    public int getUserRowLimit() {
        return this.userRowLimit;
    }

    public void setUserRowLimit(int limit, boolean throwException) {
        this.userRowLimit = limit;
        this.exceptionOnRowLimit = throwException;
    }

    public boolean exceptionOnRowlimit() {
        return this.exceptionOnRowLimit;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public Set<MappingSourceNode> getCriteriaResultSets() {
        return this.criteriaResultSets;
    }

    public void addToCriteriaResultSets(Set<MappingSourceNode> criteriaResultSets) {
        this.criteriaResultSets.addAll(criteriaResultSets);
    }

    public boolean isCriteriaRaised() {
        return this.criteriaRaised;
    }

    public void setCriteriaRaised(boolean criteriaRaised) {
        this.criteriaRaised = criteriaRaised;
    }

    public Object clone() {
        ResultSetInfo clone = new ResultSetInfo(this.resultSetName);
        clone.rsPlan = this.rsPlan;
        clone.userRowLimit = this.userRowLimit;
        clone.exceptionOnRowLimit = this.exceptionOnRowLimit;
        clone.rsCommand = (Command)this.rsCommand.clone();
        clone.criteriaRaised = this.criteriaRaised;
        clone.mappingClassSymbol = this.mappingClassSymbol;
        clone.tempInsert = this.tempInsert;
        clone.tempSelect = this.tempSelect;
        clone.tempTable = this.tempTable;
        clone.tempDrop = this.tempDrop;
        clone.isAutoStaged = this.isAutoStaged;
        clone.fkColumns = this.fkColumns;
        return clone;
    }

    public String toString() {
        return this.resultSetName + ", resultSetObject " + this.rsCommand;
    }

    public ElementSymbol getMappingClassSymbol() {
        return this.mappingClassSymbol;
    }

    public void setMappingClassSymbol(ElementSymbol mappingClassSymbol) {
        this.mappingClassSymbol = mappingClassSymbol;
    }

    public boolean hasInputSet() {
        return this.inputSet;
    }

    public void setInputSet(boolean inputSet) {
        this.inputSet = inputSet;
    }

    public void setCritNullDependent(boolean isCritNullDependent) {
        this.isCritNullDependent = isCritNullDependent;
    }

    public boolean isCritNullDependent() {
        return this.isCritNullDependent;
    }

    public String getStagingRoot() {
        return this.stagingRoot;
    }

    public void setStagingRoot(String stagingRoot) {
        this.stagingRoot = stagingRoot;
    }

    public void setTempSelect(Command tempSelect) {
        this.tempSelect = tempSelect;
    }

    public Command getTempSelect() {
        return this.tempSelect;
    }

    public void setTempInsert(Insert tempInsert) {
        this.tempInsert = tempInsert;
    }

    public Insert getTempInsert() {
        return this.tempInsert;
    }

    public Command getTempDrop() {
        return this.tempDrop;
    }

    public void setTempDrop(Command tempDrop) {
        this.tempDrop = tempDrop;
    }

    public String getTempTable() {
        return this.tempTable;
    }

    public void setTempTable(String rsTempTable) {
        this.tempTable = rsTempTable;
    }

    public boolean isAutoStaged() {
        return this.isAutoStaged;
    }

    public void setAutoStaged(boolean isAutoStaged) {
        this.isAutoStaged = isAutoStaged;
    }

    public void addFkColumns(List<ElementSymbol> cols) {
        if (this.fkColumns == null) {
            this.fkColumns = new HashSet<List<ElementSymbol>>();
        }
        this.fkColumns.add(cols);
    }

    public Set<List<ElementSymbol>> getFkColumns() {
        return this.fkColumns;
    }
}

