/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.relational.PartitionAnalyzer;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.validator.ValidatorReport;

public class UpdateValidator {
    private QueryMetadataInterface metadata;
    private UpdateInfo updateInfo = new UpdateInfo();
    private ValidatorReport report = new ValidatorReport();
    private ValidatorReport insertReport = new ValidatorReport();
    private ValidatorReport updateReport = new ValidatorReport();
    private ValidatorReport deleteReport = new ValidatorReport();

    public UpdateValidator(QueryMetadataInterface qmi, UpdateType insertType, UpdateType updateType, UpdateType deleteType) {
        this.metadata = qmi;
        this.updateInfo.deleteType = deleteType;
        this.updateInfo.insertType = insertType;
        this.updateInfo.updateType = updateType;
    }

    public UpdateInfo getUpdateInfo() {
        return this.updateInfo;
    }

    public ValidatorReport getReport() {
        return this.report;
    }

    public ValidatorReport getDeleteReport() {
        return this.deleteReport;
    }

    public ValidatorReport getInsertReport() {
        return this.insertReport;
    }

    public ValidatorReport getUpdateReport() {
        return this.updateReport;
    }

    private void handleValidationError(String error, boolean update, boolean insert, boolean delete) {
        if (update && insert && delete) {
            this.report.handleValidationError(error);
        } else {
            if (update) {
                this.updateReport.handleValidationError(error);
            }
            if (insert) {
                this.insertReport.handleValidationError(error);
            }
            if (delete) {
                this.deleteReport.handleValidationError(error);
            }
        }
        this.updateInfo.updateValidationError = (byte)(this.updateInfo.updateValidationError | (update ? 1 : 0));
        this.updateInfo.insertValidationError = (byte)(this.updateInfo.insertValidationError | (insert ? 1 : 0));
        this.updateInfo.deleteValidationError = (byte)(this.updateInfo.deleteValidationError | (delete ? 1 : 0));
    }

    public void validate(Command command, List<ElementSymbol> viewSymbols) throws QueryMetadataException, TeiidComponentException {
        if (this.updateInfo.deleteType != UpdateType.INHERENT && this.updateInfo.updateType != UpdateType.INHERENT && this.updateInfo.insertType != UpdateType.INHERENT) {
            return;
        }
        if (command instanceof SetQuery) {
            SetQuery setQuery = (SetQuery)command;
            if (setQuery.getLimit() != null) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0013"), true, true, true);
                return;
            }
            LinkedList<Query> queries = new LinkedList<Query>();
            if (!PartitionAnalyzer.extractQueries((SetQuery)command, queries)) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0001"), true, true, true);
                return;
            }
            Map<ElementSymbol, List<Set<Constant>>> partitions = PartitionAnalyzer.extractPartionInfo((SetQuery)command, viewSymbols);
            this.updateInfo.partitionInfo = partitions;
            if (partitions.isEmpty()) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0018"), false, true, false);
            }
            boolean first = true;
            for (Query query : queries) {
                UpdateInfo ui = this.updateInfo;
                if (!first) {
                    this.updateInfo = new UpdateInfo();
                    this.updateInfo.deleteType = ui.deleteType;
                    this.updateInfo.insertType = ui.insertType;
                    this.updateInfo.updateType = ui.updateType;
                }
                this.internalValidate(query, viewSymbols);
                ui.deleteValidationError = (byte)(ui.deleteValidationError | (this.updateInfo.deleteValidationError ? 1 : 0));
                ui.updateValidationError = (byte)(ui.updateValidationError | (this.updateInfo.updateValidationError ? 1 : 0));
                ui.insertValidationError = (byte)(ui.insertValidationError | (this.updateInfo.insertValidationError ? 1 : 0));
                if (!first) {
                    ui.unionBranches.add(this.updateInfo);
                    this.updateInfo = ui;
                    continue;
                }
                first = false;
            }
            return;
        }
        this.internalValidate(command, viewSymbols);
        if (this.updateInfo.deleteType != UpdateType.INHERENT) {
            this.deleteReport.getItems().clear();
        }
        if (this.updateInfo.updateType != UpdateType.INHERENT) {
            this.updateReport.getItems().clear();
        }
        if (this.updateInfo.insertType != UpdateType.INHERENT) {
            this.insertReport.getItems().clear();
        }
    }

    private void internalValidate(Command command, List<ElementSymbol> viewSymbols) throws QueryMetadataException, TeiidComponentException {
        if (!(command instanceof Query)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0001"), true, true, true);
            return;
        }
        Query query = (Query)command;
        if (query.getFrom() == null || query.getInto() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0001"), true, true, true);
            return;
        }
        if (query.getWith() != null) {
            String warning = QueryPlugin.Util.getString("ERR.015.012.0002");
            this.updateReport.handleValidationWarning(warning);
            this.deleteReport.handleValidationWarning(warning);
            this.updateInfo.isSimple = false;
        }
        if (query.hasAggregates()) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0006"), true, true, true);
            return;
        }
        if (query.getLimit() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0013"), true, true, true);
            return;
        }
        if (query.getSelect().isDistinct()) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0008"), true, true, true);
            return;
        }
        this.updateInfo.view = query;
        List<Expression> projectedSymbols = query.getSelect().getProjectedSymbols();
        for (int i = 0; i < projectedSymbols.size(); ++i) {
            Expression symbol = projectedSymbols.get(i);
            Expression ex = SymbolMap.getExpression(symbol);
            if (!this.metadata.elementSupports(viewSymbols.get(i).getMetadataID(), 5)) continue;
            if (ex instanceof ElementSymbol) {
                ElementSymbol es = (ElementSymbol)ex;
                String groupName = es.getGroupSymbol().getName();
                UpdateMapping info = (UpdateMapping)this.updateInfo.updatableGroups.get(groupName);
                if (es.getGroupSymbol().getDefinition() != null) {
                    ElementSymbol clone = es.clone();
                    clone.setOutputName(null);
                    clone.getGroupSymbol().setName(clone.getGroupSymbol().getNonCorrelationName());
                    clone.getGroupSymbol().setDefinition(null);
                    es = clone;
                }
                if (info == null) {
                    info = new UpdateMapping();
                    info.group = es.getGroupSymbol();
                    info.correlatedName = ((ElementSymbol)ex).getGroupSymbol();
                    this.updateInfo.updatableGroups.put(groupName, info);
                }
                info.updatableViewSymbols.put(viewSymbols.get(i), es);
                continue;
            }
            this.report.handleValidationWarning(QueryPlugin.Util.getString("ERR.015.012.0007", new Object[]{viewSymbols.get(i), symbol}));
        }
        if (query.getFrom().getClauses().size() > 1 || !(query.getFrom().getClauses().get(0) instanceof UnaryFromClause)) {
            String warning = QueryPlugin.Util.getString("ERR.015.012.0009", new Object[]{query.getFrom()});
            this.updateReport.handleValidationWarning(warning);
            this.deleteReport.handleValidationWarning(warning);
            this.updateInfo.isSimple = false;
        }
        List<GroupSymbol> allGroups = query.getFrom().getGroups();
        HashSet<GroupSymbol> keyPreservingGroups = new HashSet<GroupSymbol>();
        ResolverUtil.findKeyPreserved(query, keyPreservingGroups, this.metadata);
        for (GroupSymbol groupSymbol : keyPreservingGroups) {
            this.setUpdateFlags(groupSymbol);
        }
        allGroups.removeAll(keyPreservingGroups);
        if (this.updateInfo.isSimple) {
            if (!allGroups.isEmpty()) {
                this.setUpdateFlags(allGroups.iterator().next());
            }
        } else {
            for (GroupSymbol groupSymbol : allGroups) {
                UpdateMapping info = (UpdateMapping)this.updateInfo.updatableGroups.get(groupSymbol.getName());
                if (info == null) continue;
                String warning = QueryPlugin.Util.getString("ERR.015.012.0004", new Object[]{info.correlatedName});
                this.report.handleValidationWarning(warning);
            }
        }
        boolean updatable = false;
        boolean insertable = false;
        for (UpdateMapping info : this.updateInfo.updatableGroups.values()) {
            if (info.updateAllowed) {
                if (!updatable) {
                    this.updateInfo.deleteTarget = info;
                } else if (!info.getGroup().equals(this.updateInfo.deleteTarget.getGroup())) {
                    this.updateInfo.deleteTarget = null;
                }
            }
            updatable |= info.updateAllowed;
            insertable |= info.insertAllowed;
        }
        if (this.updateInfo.insertType == UpdateType.INHERENT && !insertable) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0015"), false, true, false);
        }
        if (this.updateInfo.updateType == UpdateType.INHERENT && !updatable) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0005"), true, false, false);
        }
        if (this.updateInfo.deleteType == UpdateType.INHERENT && this.updateInfo.deleteTarget == null) {
            if (this.updateInfo.isSimple && updatable) {
                this.updateInfo.deleteTarget = (UpdateMapping)this.updateInfo.updatableGroups.values().iterator().next();
            } else {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0014"), false, false, true);
            }
        }
    }

    private void setUpdateFlags(GroupSymbol groupSymbol) throws QueryMetadataException, TeiidComponentException {
        UpdateMapping info = (UpdateMapping)this.updateInfo.updatableGroups.get(groupSymbol.getName());
        if (info == null) {
            return;
        }
        if (!this.metadata.groupSupports(groupSymbol.getMetadataID(), 0)) {
            this.report.handleValidationWarning(QueryPlugin.Util.getString("ERR.015.012.0003", new Object[]{groupSymbol}));
            return;
        }
        info.insertAllowed = true;
        for (ElementSymbol es : ResolverUtil.resolveElementsInGroup(info.group, this.metadata)) {
            if (info.updatableViewSymbols.values().contains(es) || this.validateInsertElement(es)) continue;
            info.insertAllowed = false;
        }
        info.updateAllowed = true;
    }

    private boolean validateInsertElement(ElementSymbol element) throws QueryMetadataException, TeiidComponentException {
        if (this.metadata.elementSupports(element.getMetadataID(), 4) || this.metadata.elementSupports(element.getMetadataID(), 7) || this.metadata.elementSupports(element.getMetadataID(), 8)) {
            return true;
        }
        if (this.updateInfo.insertType == UpdateType.INHERENT) {
            this.insertReport.handleValidationWarning(QueryPlugin.Util.getString("ERR.015.012.0010", new Object[]{element, element.getGroupSymbol()}));
        }
        return false;
    }

    public static class UpdateInfo {
        private Map<String, UpdateMapping> updatableGroups = new HashMap<String, UpdateMapping>();
        private boolean isSimple = true;
        private UpdateMapping deleteTarget;
        private UpdateType updateType;
        private boolean updateValidationError;
        private UpdateType deleteType;
        private boolean deleteValidationError;
        private UpdateType insertType;
        private boolean insertValidationError;
        private Query view;
        private Map<ElementSymbol, List<Set<Constant>>> partitionInfo;
        private List<UpdateInfo> unionBranches = new LinkedList<UpdateInfo>();

        public Map<ElementSymbol, List<Set<Constant>>> getPartitionInfo() {
            return this.partitionInfo;
        }

        public boolean isSimple() {
            return this.isSimple;
        }

        public UpdateMapping getDeleteTarget() {
            return this.deleteTarget;
        }

        public boolean isInherentDelete() {
            return this.deleteType == UpdateType.INHERENT;
        }

        public boolean isInherentInsert() {
            return this.insertType == UpdateType.INHERENT;
        }

        public boolean isInherentUpdate() {
            return this.updateType == UpdateType.INHERENT;
        }

        public UpdateType getUpdateType() {
            return this.updateType;
        }

        public UpdateType getDeleteType() {
            return this.deleteType;
        }

        public boolean hasValidUpdateMapping(Collection<ElementSymbol> updateCols) {
            if (this.findUpdateMapping(updateCols, false) == null) {
                return false;
            }
            for (UpdateInfo info : this.unionBranches) {
                if (info.findUpdateMapping(updateCols, false) != null) continue;
                return false;
            }
            return true;
        }

        public UpdateMapping findUpdateMapping(Collection<ElementSymbol> updateCols, boolean insert) {
            if (updateCols.isEmpty() && this.updatableGroups.size() > 1) {
                return null;
            }
            for (UpdateMapping entry : this.updatableGroups.values()) {
                if ((!insert || !entry.insertAllowed) && (insert || !entry.updateAllowed) || !entry.updatableViewSymbols.keySet().containsAll(updateCols)) continue;
                return entry;
            }
            return null;
        }

        public UpdateMapping findInsertUpdateMapping(Insert insert, boolean rewrite) throws QueryValidatorException {
            if (this.getUnionBranches().isEmpty()) {
                return this.findUpdateMapping(insert.getVariables(), true);
            }
            if (insert.getQueryExpression() != null) {
                throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30239, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30239, new Object[]{insert.getGroup()}));
            }
            int partition = -1;
            LinkedList<ElementSymbol> filteredColumns = new LinkedList<ElementSymbol>();
            for (Map.Entry<ElementSymbol, List<Set<Constant>>> entry : this.partitionInfo.entrySet()) {
                Expression value;
                int index = insert.getVariables().indexOf(entry.getKey());
                if (index == -1 || !((value = (Expression)insert.getValues().get(index)) instanceof Constant)) continue;
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    if (!entry.getValue().get(i).contains(value)) continue;
                    if (entry.getValue().get(i).size() == 1) {
                        filteredColumns.add(entry.getKey());
                    }
                    if (partition == -1) {
                        partition = i;
                        continue;
                    }
                    if (partition == i) continue;
                    throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30240, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30240, new Object[]{insert.getGroup(), insert.getVariables()}));
                }
            }
            if (partition == -1) {
                throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30241, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30241, new Object[]{insert.getGroup(), insert.getVariables()}));
            }
            UpdateInfo info = this;
            if (partition > 0) {
                info = info.getUnionBranches().get(partition - 1);
            }
            ArrayList<ElementSymbol> variables = rewrite ? insert.getVariables() : new ArrayList<ElementSymbol>(insert.getVariables());
            for (ElementSymbol elementSymbol : filteredColumns) {
                int index = insert.getVariables().indexOf(elementSymbol);
                variables.remove(index);
                if (!rewrite) continue;
                insert.getValues().remove(index);
            }
            return info.findUpdateMapping(variables, true);
        }

        public Query getViewDefinition() {
            return this.view;
        }

        public boolean isDeleteValidationError() {
            return this.deleteValidationError;
        }

        public boolean isInsertValidationError() {
            return this.insertValidationError;
        }

        public boolean isUpdateValidationError() {
            return this.updateValidationError;
        }

        public List<UpdateInfo> getUnionBranches() {
            return this.unionBranches;
        }
    }

    public static class UpdateMapping {
        private GroupSymbol group;
        private GroupSymbol correlatedName;
        private Map<ElementSymbol, ElementSymbol> updatableViewSymbols = new HashMap<ElementSymbol, ElementSymbol>();
        private boolean insertAllowed = false;
        private boolean updateAllowed = false;

        public Map<ElementSymbol, ElementSymbol> getUpdatableViewSymbols() {
            return this.updatableViewSymbols;
        }

        public boolean isInsertAllowed() {
            return this.insertAllowed;
        }

        public boolean isUpdateAllowed() {
            return this.updateAllowed;
        }

        public GroupSymbol getGroup() {
            return this.group;
        }

        public GroupSymbol getCorrelatedName() {
            return this.correlatedName;
        }
    }

    public static enum UpdateType {
        INHERENT,
        INSTEAD_OF;

    }
}

