/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RuleDecomposeJoin;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public class RulePushAggregates
implements OptimizerRule {
    private IDGenerator idGenerator;

    public RulePushAggregates(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (PlanNode groupNode : NodeEditor.findAllNodes(plan, 128, 1)) {
            PlanNode child = groupNode.getFirstChild();
            List<Expression> groupingExpressions = (List<Expression>)groupNode.getProperty(NodeConstants.Info.GROUP_COLS);
            if (groupingExpressions == null) {
                groupingExpressions = Collections.emptyList();
            }
            if (child.getType() == 64) {
                PlanNode setOp = child.getFirstChild();
                try {
                    this.pushGroupNodeOverUnion(metadata, capFinder, groupNode, child, groupingExpressions, setOp, context, analysisRecord);
                    continue;
                }
                catch (QueryResolverException e) {
                    throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30264, (Throwable)((Object)e));
                }
            }
            if (child.getType() != 4) continue;
            LinkedHashSet<AggregateSymbol> aggregates = RulePushAggregates.collectAggregates(groupNode);
            this.pushGroupNode(groupNode, groupingExpressions, aggregates, metadata, capFinder, context);
        }
        return plan;
    }

    private void pushGroupNodeOverUnion(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode groupNode, PlanNode unionSourceParent, List<Expression> groupingExpressions, PlanNode setOp, CommandContext context, AnalysisRecord record) throws TeiidComponentException, QueryMetadataException, QueryPlannerException, QueryResolverException {
        if (setOp == null || setOp.getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION) {
            return;
        }
        LinkedHashSet<AggregateSymbol> aggregates = RulePushAggregates.collectAggregates(groupNode);
        Map partitionInfo = (Map)unionSourceParent.getProperty(NodeConstants.Info.PARTITION_INFO);
        boolean cardinalityDependent = AggregateSymbol.areAggregatesCardinalityDependent(aggregates);
        LinkedList<PlanNode> unionChildren = new LinkedList<PlanNode>();
        RulePushAggregates.findUnionChildren(unionChildren, cardinalityDependent, setOp);
        SymbolMap parentMap = (SymbolMap)unionSourceParent.getProperty(NodeConstants.Info.SYMBOL_MAP);
        if (partitionInfo != null && !Collections.disjoint(partitionInfo.keySet(), groupingExpressions)) {
            this.decomposeGroupBy(groupNode, unionSourceParent, groupingExpressions, aggregates, unionChildren, parentMap, metadata, capFinder, context);
            return;
        }
        if (aggregates.isEmpty()) {
            if (!groupingExpressions.isEmpty()) {
                setOp.setProperty(NodeConstants.Info.USE_ALL, Boolean.FALSE);
            }
            return;
        }
        for (AggregateSymbol agg : aggregates) {
            if (agg.canStage()) continue;
            return;
        }
        if (unionChildren.size() < 2) {
            return;
        }
        ArrayList<AggregateSymbol> copy = new ArrayList<AggregateSymbol>(aggregates);
        aggregates.clear();
        Map<AggregateSymbol, Expression> aggMap = RulePushAggregates.buildAggregateMap(copy, metadata, aggregates);
        boolean shouldPushdown = false;
        ArrayList<Boolean> pushdownList = new ArrayList<Boolean>(unionChildren.size());
        for (PlanNode planNode : unionChildren) {
            boolean pushdown = this.canPushGroupByToUnionChild(metadata, capFinder, groupingExpressions, aggregates, planNode, record);
            pushdownList.add(pushdown);
            shouldPushdown |= pushdown;
        }
        if (!shouldPushdown) {
            return;
        }
        GroupSymbol group = unionSourceParent.getGroups().iterator().next().clone();
        Iterator pushdownIterator = pushdownList.iterator();
        boolean first = true;
        for (PlanNode planNode : unionChildren) {
            this.addUnionGroupBy(groupingExpressions, aggregates, parentMap, metadata, capFinder, context, group, first, planNode, (Boolean)pushdownIterator.next() == false);
            first = false;
        }
        this.updateParentAggs(groupNode, context, aggMap, metadata);
        List symbols = (List)NodeEditor.findNodePreOrder(unionSourceParent, 8).getProperty(NodeConstants.Info.PROJECT_COLS);
        GroupSymbol modifiedGroup = group.clone();
        SymbolMap symbolMap = RulePushAggregates.createSymbolMap(modifiedGroup, symbols, unionSourceParent, metadata);
        unionSourceParent.setProperty(NodeConstants.Info.SYMBOL_MAP, symbolMap);
        HashMap<Expression, ElementSymbol> mapping = new HashMap<Expression, ElementSymbol>();
        Iterator<ElementSymbol> elemIter = symbolMap.getKeys().iterator();
        for (Expression expr : groupingExpressions) {
            mapping.put(expr, elemIter.next());
        }
        for (AggregateSymbol agg : aggregates) {
            mapping.put(agg, elemIter.next());
        }
        for (PlanNode node = unionSourceParent; node != groupNode.getParent(); node = node.getParent()) {
            FrameUtil.convertNode(node, null, null, mapping, metadata, false);
        }
    }

    private void updateParentAggs(PlanNode groupNode, CommandContext context, Map<AggregateSymbol, Expression> aggMap, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        LinkedHashSet<AggregateSymbol> compositeAggs = new LinkedHashSet<AggregateSymbol>();
        boolean hasExpressionMapping = false;
        for (Expression ex : aggMap.values()) {
            if (ex instanceof AggregateSymbol) {
                compositeAggs.add((AggregateSymbol)ex);
                continue;
            }
            compositeAggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(ex, false));
            hasExpressionMapping = true;
        }
        if (!hasExpressionMapping) {
            FrameUtil.correctSymbolMap(aggMap, groupNode);
        } else {
            groupNode.getGroups().clear();
            SymbolMap oldGroupingMap = (SymbolMap)groupNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
            GroupSymbol oldGroup = oldGroupingMap.asMap().keySet().iterator().next().getGroupSymbol();
            SymbolMap groupingMap = RelationalPlanner.buildGroupingNode(compositeAggs, (List)groupNode.getProperty(NodeConstants.Info.GROUP_COLS), groupNode, context, this.idGenerator);
            ArrayList<AliasSymbol> projectCols = new ArrayList<AliasSymbol>(oldGroupingMap.asMap().size());
            SymbolMap correctedMap = new SymbolMap();
            Map<Expression, ElementSymbol> inverseMap = groupingMap.inserseMapping();
            for (Map.Entry<ElementSymbol, Expression> entry : oldGroupingMap.asMap().entrySet()) {
                Expression ses = null;
                if (entry.getValue() instanceof AggregateSymbol) {
                    Expression ex = aggMap.get(entry.getValue());
                    if (ex instanceof AggregateSymbol) {
                        ses = inverseMap.get(ex);
                    } else {
                        ExpressionMappingVisitor.mapExpressions(ex, inverseMap);
                        ses = new ExpressionSymbol("expr", ex);
                    }
                } else {
                    ses = inverseMap.get(entry.getValue());
                }
                ses = (Expression)ses.clone();
                projectCols.add(new AliasSymbol(Symbol.getShortName(entry.getKey()), ses));
                correctedMap.addMapping(entry.getKey(), SymbolMap.getExpression(ses));
            }
            PlanNode projectNode = groupNode.getParent();
            if (projectNode.getType() != 8) {
                projectNode = NodeFactory.getNewNode(8);
                groupNode.addAsParent(projectNode);
                projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, projectCols);
                RuleDecomposeJoin.createSource(oldGroup, projectNode, correctedMap);
            } else {
                FrameUtil.convertFrame(projectNode, oldGroup, null, correctedMap.asMap(), metadata);
            }
        }
    }

    private void decomposeGroupBy(PlanNode groupNode, PlanNode sourceNode, List<Expression> groupingExpressions, LinkedHashSet<AggregateSymbol> aggregates, LinkedList<PlanNode> unionChildren, SymbolMap parentMap, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext cc) throws QueryPlannerException, QueryMetadataException, TeiidComponentException, QueryResolverException {
        groupNode.getParent().replaceChild(groupNode, groupNode.getFirstChild());
        GroupSymbol group = sourceNode.getGroups().iterator().next().clone();
        boolean first = true;
        for (PlanNode planNode : unionChildren) {
            this.addUnionGroupBy(groupingExpressions, aggregates, parentMap, metadata, capFinder, cc, group, first, planNode, false);
            first = false;
        }
        List symbols = (List)NodeEditor.findNodePreOrder(sourceNode, 8).getProperty(NodeConstants.Info.PROJECT_COLS);
        GroupSymbol modifiedGroup = group.clone();
        SymbolMap symbolMap = RulePushAggregates.createSymbolMap(modifiedGroup, symbols, sourceNode, metadata);
        sourceNode.setProperty(NodeConstants.Info.SYMBOL_MAP, symbolMap);
        SymbolMap map = (SymbolMap)groupNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        Map<Expression, ElementSymbol> inverse = map.inserseMapping();
        SymbolMap newMapping = (SymbolMap)NodeEditor.findNodePreOrder(sourceNode, 128).getProperty(NodeConstants.Info.SYMBOL_MAP);
        GroupSymbol oldGroup = null;
        HashMap<ElementSymbol, ElementSymbol> updatedMapping = new HashMap<ElementSymbol, ElementSymbol>();
        for (Map.Entry<ElementSymbol, Expression> entry : symbolMap.asMap().entrySet()) {
            Expression ex = newMapping.getMappedExpression((ElementSymbol)entry.getValue());
            ElementSymbol orig = inverse.get(ex);
            oldGroup = orig.getGroupSymbol();
            updatedMapping.put(orig, entry.getKey());
        }
        FrameUtil.convertFrame(sourceNode, oldGroup, Collections.singleton(modifiedGroup), updatedMapping, metadata);
    }

    private void addUnionGroupBy(List<Expression> groupingExpressions, LinkedHashSet<AggregateSymbol> aggregates, SymbolMap parentMap, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext cc, GroupSymbol group, boolean first, PlanNode planNode, boolean viewOnly) throws QueryMetadataException, TeiidComponentException, QueryPlannerException, QueryResolverException {
        ArrayList<Expression> groupingColumns = LanguageObject.Util.deepClone(groupingExpressions, Expression.class);
        if (!first) {
            PlanNode sortNode = NodeEditor.findNodePreOrder(planNode, 32, 64);
            List<Expression> sortOrder = null;
            OrderBy orderBy = null;
            if (sortNode != null) {
                orderBy = (OrderBy)sortNode.getProperty(NodeConstants.Info.SORT_ORDER);
                sortOrder = orderBy.getSortKeys();
            }
            List<Expression> projectCols = FrameUtil.findTopCols(planNode);
            List<ElementSymbol> virtualElements = parentMap.getKeys();
            for (int i = 0; i < virtualElements.size(); ++i) {
                int sortIndex;
                ElementSymbol virtualElem = virtualElements.get(i);
                Expression projectedSymbol = projectCols.get(i);
                if (Symbol.getShortName(projectedSymbol).equals(Symbol.getShortName(virtualElem))) continue;
                if (sortOrder != null && (sortIndex = sortOrder.indexOf(projectedSymbol)) > -1) {
                    this.updateSymbolName(sortOrder, sortIndex, virtualElem, sortOrder.get(sortIndex));
                    orderBy.getOrderByItems().get(sortIndex).setSymbol(sortOrder.get(sortIndex));
                }
                this.updateSymbolName(projectCols, i, virtualElem, projectedSymbol);
            }
        }
        PlanNode view = RuleDecomposeJoin.createSource(group, planNode, parentMap);
        PlanNode projectPlanNode = NodeFactory.getNewNode(8);
        Select allSymbols = new Select();
        for (Expression expr : groupingColumns) {
            allSymbols.addSymbol(new ExpressionSymbol("expr", expr));
        }
        if (viewOnly) {
            for (AggregateSymbol agg : aggregates) {
                if ((agg = (AggregateSymbol)agg.clone()).getAggregateFunction() == AggregateSymbol.Type.COUNT) {
                    if (agg.getArgs().length == 0) {
                        allSymbols.addSymbol(new ExpressionSymbol("stagedAgg", new Constant(1)));
                        continue;
                    }
                    SearchedCaseExpression count = new SearchedCaseExpression(Arrays.asList(new IsNullCriteria(agg.getArg(0))), Arrays.asList(new Constant(0)));
                    count.setElseExpression(new Constant(1));
                    count.setType(DataTypeManager.DefaultDataClasses.INTEGER);
                    allSymbols.addSymbol(new ExpressionSymbol("stagedAgg", count));
                    continue;
                }
                assert (agg.getArgs().length == 1);
                Expression ex = agg.getArg(0);
                ex = ResolverUtil.convertExpression(ex, DataTypeManager.getDataTypeName(agg.getType()), metadata);
                allSymbols.addSymbol(new ExpressionSymbol("stagedAgg", ex));
            }
        } else {
            allSymbols.addSymbols(aggregates);
        }
        if (first) {
            QueryRewriter.makeSelectUnique(allSymbols, false);
        }
        projectPlanNode.setProperty(NodeConstants.Info.PROJECT_COLS, allSymbols.getSymbols());
        projectPlanNode.addGroups(view.getGroups());
        view.addAsParent(projectPlanNode);
        if (!viewOnly) {
            this.addGroupBy(cc, view, groupingColumns, aggregates, metadata, projectPlanNode.getParent());
        }
        if (planNode.getType() == 1) {
            while (RuleRaiseAccess.raiseAccessNode(planNode, planNode, metadata, capFinder, true, null) != null) {
            }
        }
    }

    private void updateSymbolName(List<Expression> projectCols, int i, ElementSymbol virtualElem, Expression projectedSymbol) {
        if (projectedSymbol instanceof AliasSymbol) {
            ((AliasSymbol)projectedSymbol).setShortName(Symbol.getShortName(virtualElem));
        } else {
            projectCols.set(i, new AliasSymbol(Symbol.getShortName(virtualElem), projectedSymbol));
        }
    }

    private boolean canPushGroupByToUnionChild(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, List<Expression> groupingExpressions, LinkedHashSet<AggregateSymbol> aggregates, PlanNode planNode, AnalysisRecord record) throws QueryMetadataException, TeiidComponentException {
        if (planNode.getType() != 1) {
            return false;
        }
        Object modelId = RuleRaiseAccess.getModelIDFromAccess(planNode, metadata);
        if (!CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, modelId, metadata, capFinder) || !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_GROUP_BY, modelId, metadata, capFinder)) {
            return false;
        }
        for (AggregateSymbol aggregate : aggregates) {
            if (CriteriaCapabilityValidatorVisitor.canPushLanguageObject(aggregate, modelId, metadata, capFinder, record)) continue;
            return false;
        }
        if (groupingExpressions.isEmpty()) {
            if (!CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, modelId, metadata, capFinder)) {
                return false;
            }
        } else {
            for (Expression ses : groupingExpressions) {
                if (CriteriaCapabilityValidatorVisitor.canPushLanguageObject(ses, modelId, metadata, capFinder, record)) continue;
                return false;
            }
        }
        return true;
    }

    static PlanNode findUnionChildren(List<PlanNode> unionChildren, boolean carinalityDependent, PlanNode setOp) {
        if (setOp.getType() != 256 || setOp.getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION) {
            return setOp;
        }
        if (!setOp.hasBooleanProperty(NodeConstants.Info.USE_ALL)) {
            if (carinalityDependent) {
                return setOp;
            }
            setOp.setProperty(NodeConstants.Info.USE_ALL, Boolean.TRUE);
        }
        for (PlanNode planNode : setOp.getChildren()) {
            PlanNode child = RulePushAggregates.findUnionChildren(unionChildren, carinalityDependent, planNode);
            if (child == null) continue;
            unionChildren.add(child);
        }
        return null;
    }

    static SymbolMap createSymbolMap(GroupSymbol group, List<? extends Expression> virtualElements, PlanNode child, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        TempMetadataStore store = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(metadata, store);
        try {
            group.setMetadataID(ResolverUtil.addTempGroup(tma, group, virtualElements, false));
        }
        catch (QueryResolverException e) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30265, (Throwable)((Object)e));
        }
        List<ElementSymbol> projectedSymbols = ResolverUtil.resolveElementsInGroup(group, metadata);
        SymbolMap symbolMap = SymbolMap.createSymbolMap(projectedSymbols, (List)NodeEditor.findNodePreOrder(child, 8).getProperty(NodeConstants.Info.PROJECT_COLS));
        return symbolMap;
    }

    static LinkedHashSet<AggregateSymbol> collectAggregates(PlanNode groupNode) {
        LinkedHashSet<AggregateSymbol> aggregates = new LinkedHashSet<AggregateSymbol>();
        SymbolMap symbolMap = (SymbolMap)groupNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        for (PlanNode currentNode = groupNode.getParent(); currentNode != null; currentNode = currentNode.getParent()) {
            if (currentNode.getType() == 8) {
                List projectedSymbols = (List)currentNode.getProperty(NodeConstants.Info.PROJECT_COLS);
                for (Expression symbol : projectedSymbols) {
                    RulePushAggregates.mapAggregates(ElementCollectorVisitor.getAggregates(symbol, true), symbolMap, aggregates);
                }
                break;
            }
            if (currentNode.getType() != 16) continue;
            Criteria crit = (Criteria)currentNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
            RulePushAggregates.mapAggregates(ElementCollectorVisitor.getAggregates(crit, true), symbolMap, aggregates);
        }
        return aggregates;
    }

    static void mapAggregates(Collection<ElementSymbol> symbols, SymbolMap map, Collection<? super AggregateSymbol> aggs) {
        for (ElementSymbol es : symbols) {
            Expression ex = map.getMappedExpression(es);
            if (!(ex instanceof AggregateSymbol)) continue;
            aggs.add((AggregateSymbol)ex);
        }
    }

    private void pushGroupNode(PlanNode groupNode, List<Expression> groupingExpressions, Set<AggregateSymbol> allAggregates, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext cc) throws TeiidComponentException, QueryMetadataException, QueryPlannerException {
        Map<PlanNode, List<AggregateSymbol>> aggregateMap = this.createNodeMapping(groupNode, allAggregates, true);
        if (aggregateMap == null) {
            return;
        }
        Map<PlanNode, List<Expression>> groupingMap = this.createNodeMapping(groupNode, groupingExpressions, false);
        LinkedHashSet<PlanNode> possibleTargetNodes = new LinkedHashSet<PlanNode>(aggregateMap.keySet());
        possibleTargetNodes.addAll(groupingMap.keySet());
        for (Map.Entry<PlanNode, List<AggregateSymbol>> entry : aggregateMap.entrySet()) {
            if (!AggregateSymbol.areAggregatesCardinalityDependent((Collection<AggregateSymbol>)entry.getValue())) continue;
            possibleTargetNodes.clear();
            possibleTargetNodes.add(entry.getKey());
            break;
        }
        for (PlanNode planNode : possibleTargetNodes) {
            PlanNode stageGroup;
            PlanNode accessNode;
            LinkedHashSet<Expression> stagedGroupingSymbols = new LinkedHashSet<Expression>();
            Collection<AggregateSymbol> aggregates = (ArrayList<AggregateSymbol>)aggregateMap.get(planNode);
            if (!this.canPush(groupNode, stagedGroupingSymbols, planNode)) continue;
            this.filterJoinColumns(stagedGroupingSymbols, planNode.getGroups(), groupingExpressions);
            this.collectSymbolsFromOtherAggregates(allAggregates, aggregates, planNode, stagedGroupingSymbols);
            float cardinality = NewCalculateCostUtil.computeCostForTree(planNode, metadata);
            float ndv = NewCalculateCostUtil.getNDVEstimate(planNode, metadata, cardinality, stagedGroupingSymbols, false);
            if (ndv != -1.0f && cardinality / ndv < 4.0f || (aggregates = aggregates != null ? this.stageAggregates(groupNode, metadata, stagedGroupingSymbols, aggregates, cc) : new ArrayList<AggregateSymbol>(1)).isEmpty() && stagedGroupingSymbols.isEmpty() || (accessNode = (stageGroup = this.addGroupBy(cc, planNode, new ArrayList<Expression>(stagedGroupingSymbols), aggregates, metadata, groupNode.getParent())).getFirstChild()).getType() != 1 || !RuleRaiseAccess.canRaiseOverGroupBy(stageGroup, accessNode, aggregates, metadata, capFinder, null)) continue;
            accessNode.getGroups().clear();
            accessNode.getGroups().addAll(stageGroup.getGroups());
            RuleRaiseAccess.performRaise(null, accessNode, stageGroup);
            if (!stagedGroupingSymbols.isEmpty()) continue;
            RuleRaiseAccess.performRaise(null, stageGroup.getParent(), stageGroup.getParent().getParent());
        }
    }

    private PlanNode addGroupBy(CommandContext cc, PlanNode child, List<Expression> stagedGroupingSymbols, Collection<AggregateSymbol> aggregates, QueryMetadataInterface metadata, PlanNode endNode) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        PlanNode stageGroup = NodeFactory.getNewNode(128);
        child.addAsParent(stageGroup);
        aggregates = new LinkedHashSet<AggregateSymbol>(aggregates);
        if (stagedGroupingSymbols.isEmpty()) {
            PlanNode selectNode = NodeFactory.getNewNode(16);
            AggregateSymbol count = new AggregateSymbol("COUNT", false, null);
            aggregates.add(count);
            selectNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, new CompareCriteria(count, 4, new Constant(new Integer(0))));
            selectNode.setProperty(NodeConstants.Info.IS_HAVING, Boolean.TRUE);
            stageGroup.addAsParent(selectNode);
        }
        Map<Expression, ElementSymbol> reverseMapping = RelationalPlanner.buildGroupingNode(aggregates, stagedGroupingSymbols, stageGroup, cc, this.idGenerator).inserseMapping();
        GroupSymbol newGroup = reverseMapping.values().iterator().next().getGroupSymbol();
        for (PlanNode node = stageGroup.getParent(); node != endNode; node = node.getParent()) {
            if (node.getType() == 4) {
                node.getGroups().removeAll(FrameUtil.findJoinSourceNode(stageGroup.getFirstChild()).getGroups());
                node.getGroups().add(newGroup);
            }
            FrameUtil.convertNode(node, null, null, reverseMapping, metadata, false);
            if (node.getType() != 4) continue;
            RuleChooseJoinStrategy.chooseJoinStrategy(node, metadata);
        }
        return stageGroup;
    }

    Set<AggregateSymbol> stageAggregates(PlanNode groupNode, QueryMetadataInterface metadata, Set<Expression> stagedGroupingSymbols, Collection<AggregateSymbol> aggregates, CommandContext context) throws TeiidComponentException, QueryPlannerException {
        Map<AggregateSymbol, Expression> aggMap;
        Iterator<AggregateSymbol> iterator = aggregates.iterator();
        while (iterator.hasNext()) {
            Expression expr;
            AggregateSymbol symbol = iterator.next();
            if (symbol.getArgs().length != 1 || !stagedGroupingSymbols.contains(expr = symbol.getArg(0))) continue;
            iterator.remove();
        }
        if (aggregates.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AggregateSymbol> newAggs = new HashSet<AggregateSymbol>();
        try {
            aggMap = RulePushAggregates.buildAggregateMap(aggregates, metadata, newAggs);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30266, (Throwable)((Object)e));
        }
        this.updateParentAggs(groupNode, context, aggMap, metadata);
        return newAggs;
    }

    private void collectSymbolsFromOtherAggregates(Collection<AggregateSymbol> allAggregates, Collection<AggregateSymbol> aggregates, PlanNode current, Set<Expression> stagedGroupingSymbols) {
        HashSet<AggregateSymbol> otherAggs = new HashSet<AggregateSymbol>(allAggregates);
        if (aggregates != null) {
            otherAggs.removeAll(aggregates);
        }
        PlanNode source = FrameUtil.findJoinSourceNode(current);
        for (AggregateSymbol aggregateSymbol : otherAggs) {
            for (ElementSymbol symbol : ElementCollectorVisitor.getElements((LanguageObject)aggregateSymbol, true)) {
                if (!source.getGroups().contains(symbol.getGroupSymbol())) continue;
                stagedGroupingSymbols.add(symbol);
            }
        }
    }

    private boolean canPush(PlanNode groupNode, Set<Expression> stagedGroupingSymbols, PlanNode planNode) {
        Set<GroupSymbol> groups = FrameUtil.findJoinSourceNode(planNode).getGroups();
        for (PlanNode parentJoin = planNode.getParent(); parentJoin != groupNode; parentJoin = parentJoin.getParent()) {
            if (parentJoin.getType() != 4 || parentJoin.hasCollectionProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA) || ((JoinType)parentJoin.getProperty(NodeConstants.Info.JOIN_TYPE)).isOuter()) {
                return false;
            }
            if (planNode == parentJoin.getFirstChild()) {
                if (parentJoin.hasCollectionProperty(NodeConstants.Info.LEFT_EXPRESSIONS)) {
                    this.filterJoinColumns(stagedGroupingSymbols, groups, (List)parentJoin.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS));
                }
            } else if (parentJoin.hasCollectionProperty(NodeConstants.Info.RIGHT_EXPRESSIONS)) {
                this.filterJoinColumns(stagedGroupingSymbols, groups, (List)parentJoin.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS));
            }
            planNode = parentJoin;
        }
        return true;
    }

    private void filterJoinColumns(Set<Expression> stagedGroupingSymbols, Set<GroupSymbol> groups, List<? extends Expression> symbols) {
        for (Expression expression : symbols) {
            if (!groups.containsAll(GroupsUsedByElementsVisitor.getGroups(expression))) continue;
            stagedGroupingSymbols.add(SymbolMap.getExpression(expression));
        }
    }

    private <T extends Expression> Map<PlanNode, List<T>> createNodeMapping(PlanNode groupNode, Collection<T> expressions, boolean aggs) {
        LinkedHashMap<PlanNode, List<T>> result = new LinkedHashMap<PlanNode, List<T>>();
        if (expressions == null) {
            return result;
        }
        for (Expression aggregateSymbol : expressions) {
            AggregateSymbol as;
            if (aggs && (!(as = (AggregateSymbol)aggregateSymbol).canStage() && as.isCardinalityDependent() || as.getAggregateFunction() == AggregateSymbol.Type.COUNT && as.getArgs().length == 0)) {
                return null;
            }
            Set<GroupSymbol> groups = GroupsUsedByElementsVisitor.getGroups(aggregateSymbol);
            if (groups.isEmpty()) continue;
            PlanNode originatingNode = FrameUtil.findOriginatingNode(groupNode.getFirstChild(), groups);
            if (originatingNode == null) {
                if (!aggs) continue;
                return null;
            }
            PlanNode parentAccess = NodeEditor.findParent(originatingNode, 1, 128);
            if (parentAccess != null) {
                while (parentAccess.getType() == 16) {
                    parentAccess = parentAccess.getParent();
                }
                originatingNode = parentAccess;
            }
            if (originatingNode.getParent() == groupNode) {
                if (!aggs || !((AggregateSymbol)aggregateSymbol).isCardinalityDependent()) continue;
                return null;
            }
            if (originatingNode.getType() != 1 || aggs && ((AggregateSymbol)aggregateSymbol).isDistinct()) continue;
            LinkedList<Expression> symbols = (LinkedList<Expression>)result.get(originatingNode);
            if (symbols == null) {
                symbols = new LinkedList<Expression>();
                result.put(originatingNode, symbols);
            }
            symbols.add(aggregateSymbol);
        }
        return result;
    }

    private static Map<AggregateSymbol, Expression> buildAggregateMap(Collection<? extends AggregateSymbol> aggregateExpressions, QueryMetadataInterface metadata, Set<AggregateSymbol> nestedAggregates) throws QueryResolverException, TeiidComponentException {
        LinkedHashMap<AggregateSymbol, Expression> aggMap = new LinkedHashMap<AggregateSymbol, Expression>();
        for (AggregateSymbol aggregateSymbol : aggregateExpressions) {
            AggregateSymbol sumAgg;
            AggregateSymbol countAgg;
            Expression newExpression = null;
            AggregateSymbol.Type aggFunction = aggregateSymbol.getAggregateFunction();
            if (aggFunction == AggregateSymbol.Type.COUNT) {
                AggregateSymbol newAgg = new AggregateSymbol("SUM", false, aggregateSymbol);
                Function convertFunc = new Function("convert", new Expression[]{newAgg, new Constant(DataTypeManager.getDataTypeName(aggregateSymbol.getType()))});
                ResolverVisitor.resolveLanguageObject(convertFunc, metadata);
                newExpression = convertFunc;
                nestedAggregates.add(aggregateSymbol);
            } else if (aggFunction == AggregateSymbol.Type.AVG) {
                countAgg = new AggregateSymbol("COUNT", false, aggregateSymbol.getArg(0));
                sumAgg = new AggregateSymbol("SUM", false, aggregateSymbol.getArg(0));
                AggregateSymbol sumSumAgg = new AggregateSymbol("SUM", false, sumAgg);
                AggregateSymbol sumCountAgg = new AggregateSymbol("SUM", false, countAgg);
                Function convertedSum = new Function("convert", new Expression[]{sumSumAgg, new Constant(DataTypeManager.getDataTypeName(aggregateSymbol.getType()))});
                Function convertCount = new Function("convert", new Expression[]{sumCountAgg, new Constant(DataTypeManager.getDataTypeName(aggregateSymbol.getType()))});
                Function divideFunc = new Function("/", new Expression[]{convertedSum, convertCount});
                ResolverVisitor.resolveLanguageObject(divideFunc, metadata);
                newExpression = divideFunc;
                nestedAggregates.add(countAgg);
                nestedAggregates.add(sumAgg);
            } else if (aggregateSymbol.isEnhancedNumeric()) {
                countAgg = new AggregateSymbol("COUNT", false, aggregateSymbol.getArg(0));
                sumAgg = new AggregateSymbol("SUM", false, aggregateSymbol.getArg(0));
                AggregateSymbol sumSqAgg = new AggregateSymbol("SUM", false, new Function("power", new Expression[]{aggregateSymbol.getArg(0), new Constant(2)}));
                AggregateSymbol sumSumAgg = new AggregateSymbol("SUM", false, sumAgg);
                AggregateSymbol sumCountAgg = new AggregateSymbol("SUM", false, countAgg);
                AggregateSymbol sumSumSqAgg = new AggregateSymbol("SUM", false, sumSqAgg);
                Function convertedSum = new Function("convert", new Expression[]{sumSumAgg, new Constant("double")});
                Function divideFunc = new Function("/", new Expression[]{new Function("power", new Expression[]{convertedSum, new Constant(2)}), sumCountAgg});
                Function minusFunc = new Function("-", new Expression[]{sumSumSqAgg, divideFunc});
                Function divisor = null;
                divisor = aggFunction == AggregateSymbol.Type.STDDEV_SAMP || aggFunction == AggregateSymbol.Type.VAR_SAMP ? new Function("-", new Expression[]{sumCountAgg, new Constant(1)}) : sumCountAgg;
                Expression result = new Function("/", new Expression[]{minusFunc, divisor});
                result = aggFunction == AggregateSymbol.Type.STDDEV_POP || aggFunction == AggregateSymbol.Type.STDDEV_SAMP ? new Function("sqrt", new Expression[]{result}) : new Function("convert", new Expression[]{result, new Constant("double")});
                Constant n = new Constant(0);
                if (aggFunction == AggregateSymbol.Type.STDDEV_SAMP || aggFunction == AggregateSymbol.Type.VAR_SAMP) {
                    n = new Constant(1);
                }
                result = new SearchedCaseExpression(Arrays.asList(new CompareCriteria(sumCountAgg, 4, n)), Arrays.asList(result));
                ResolverVisitor.resolveLanguageObject(result, metadata);
                newExpression = result;
                nestedAggregates.add(countAgg);
                nestedAggregates.add(sumAgg);
                nestedAggregates.add(sumSqAgg);
            } else {
                newExpression = new AggregateSymbol(aggFunction.name(), false, aggregateSymbol);
                nestedAggregates.add(aggregateSymbol);
            }
            aggMap.put(aggregateSymbol, newExpression);
        }
        return aggMap;
    }

    public String toString() {
        return "PushAggregates";
    }
}

