/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.LinkedList;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.id.IDGenerator;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.Procedure;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempCapabilitiesFinder;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.BatchedUpdatePlanner;
import org.teiid.query.optimizer.CommandPlanner;
import org.teiid.query.optimizer.DdlPlanner;
import org.teiid.query.optimizer.ProcedurePlanner;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.xml.XMLPlanner;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.util.CommandContext;

public class QueryOptimizer {
    private static final CommandPlanner XML_PLANNER = new XMLPlanner();
    private static final CommandPlanner PROCEDURE_PLANNER = new ProcedurePlanner();
    private static final CommandPlanner BATCHED_UPDATE_PLANNER = new BatchedUpdatePlanner();
    private static final CommandPlanner DDL_PLANNER = new DdlPlanner();

    private QueryOptimizer() {
    }

    public static ProcessorPlan optimizePlan(Command command, QueryMetadataInterface metadata, IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        if (analysisRecord == null) {
            analysisRecord = new AnalysisRecord(false, false);
        }
        if (context == null) {
            context = new CommandContext();
        }
        if (!(capFinder instanceof TempCapabilitiesFinder)) {
            capFinder = new TempCapabilitiesFinder(capFinder);
        }
        boolean debug = analysisRecord.recordDebug();
        TempMetadataStore tempMetadata = command.getTemporaryMetadata();
        if (tempMetadata != null) {
            metadata = new TempMetadataAdapter(metadata, tempMetadata);
        } else if (!(metadata instanceof TempMetadataAdapter)) {
            metadata = new TempMetadataAdapter(metadata, new TempMetadataStore());
        }
        if (idGenerator == null) {
            idGenerator = new IDGenerator();
        }
        if (debug) {
            analysisRecord.println("\n----------------------------------------------------------------------------");
            analysisRecord.println("OPTIMIZE: \n" + command);
        }
        ProcessorPlan result = null;
        switch (command.getType()) {
            case 7: {
                CreateProcedureCommand cupc = (CreateProcedureCommand)command;
                if (cupc.getUserCommand() == null) {
                    result = QueryOptimizer.planProcedure(command, metadata, idGenerator, capFinder, analysisRecord, context);
                } else {
                    StoredProcedure c = (StoredProcedure)cupc.getUserCommand();
                    Object pid = cupc.getVirtualGroup().getMetadataID();
                    if (c != null) {
                        pid = c.getProcedureID();
                    }
                    String fullName = metadata.getFullName(pid);
                    fullName = "procedure cache:" + fullName;
                    PreparedPlan pp = context.getPlan(fullName);
                    if (pp == null) {
                        FunctionMethod.Determinism determinismLevel = context.resetDeterminismLevel();
                        CommandContext clone = context.clone();
                        ProcessorPlan plan = QueryOptimizer.planProcedure(command, metadata, idGenerator, capFinder, analysisRecord, clone);
                        if (pid instanceof Procedure) {
                            clone.accessedPlanningObject(pid);
                        }
                        pp = new PreparedPlan();
                        pp.setPlan(plan, clone);
                        context.putPlan(fullName, pp, context.getDeterminismLevel());
                        context.setDeterminismLevel(determinismLevel);
                    }
                    result = pp.getPlan().clone();
                    for (Object id : pp.getAccessInfo().getObjectsAccessed()) {
                        context.accessedPlanningObject(id);
                    }
                }
                ProcedureContainer container = (ProcedureContainer)cupc.getUserCommand();
                ProcedurePlan plan = (ProcedurePlan)result;
                if (container == null) break;
                if (container instanceof StoredProcedure) {
                    plan.setRequiresTransaction(container.getUpdateCount() > 0);
                    StoredProcedure sp = (StoredProcedure)container;
                    if (sp.returnParameters()) {
                        LinkedList<ElementSymbol> outParams = new LinkedList<ElementSymbol>();
                        for (SPParameter param : sp.getParameters()) {
                            if (param.getParameterType() != 4) continue;
                            outParams.add(param.getParameterSymbol());
                        }
                        for (SPParameter param : sp.getParameters()) {
                            if (param.getParameterType() != 3 && param.getParameterType() != 2) continue;
                            outParams.add(param.getParameterSymbol());
                        }
                        if (outParams.size() > 0) {
                            plan.setOutParams(outParams);
                        }
                    }
                    plan.setParams(sp.getProcedureParameters());
                }
                plan.setMetadata(metadata);
                break;
            }
            case 9: {
                result = BATCHED_UPDATE_PLANNER.optimize(command, idGenerator, metadata, capFinder, analysisRecord, context);
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                result = DDL_PLANNER.optimize(command, idGenerator, metadata, capFinder, analysisRecord, context);
                break;
            }
            default: {
                try {
                    if (command.getType() == 1 && command instanceof Query && QueryResolver.isXMLQuery((Query)command, metadata)) {
                        result = XML_PLANNER.optimize(command, idGenerator, metadata, capFinder, analysisRecord, context);
                        break;
                    }
                    RelationalPlanner planner = new RelationalPlanner();
                    planner.initialize(command, idGenerator, metadata, capFinder, analysisRecord, context);
                    result = planner.optimize(command);
                    break;
                }
                catch (QueryResolverException e) {
                    throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30245, (Throwable)((Object)e));
                }
            }
        }
        if (debug) {
            analysisRecord.println("\n----------------------------------------------------------------------------");
            analysisRecord.println("OPTIMIZATION COMPLETE:");
            analysisRecord.println("PROCESSOR PLAN:\n" + result);
            analysisRecord.println("============================================================================");
        }
        return result;
    }

    private static ProcessorPlan planProcedure(Command command, QueryMetadataInterface metadata, IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws TeiidComponentException, QueryPlannerException, QueryMetadataException {
        try {
            command = QueryRewriter.rewrite(command, metadata, context);
        }
        catch (TeiidProcessingException e) {
            throw new QueryPlannerException(QueryPlugin.Event.TEIID30246, e, e.getMessage());
        }
        ProcessorPlan result = PROCEDURE_PLANNER.optimize(command, idGenerator, metadata, capFinder, analysisRecord, context);
        return result;
    }
}

