/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.NamedThreadFactory;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;

public class ThreadReuseExecutor
implements Executor {
    private final ThreadPoolExecutor tpe;
    private ScheduledThreadPoolExecutor stpe = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("Scheduler"));
    private volatile int activeCount;
    private volatile int highestActiveCount;
    private volatile int highestQueueSize;
    private volatile boolean terminated;
    private volatile int submittedCount;
    private volatile int completedCount;
    private Object poolLock = new Object();
    private AtomicInteger threadCounter = new AtomicInteger();
    private Set<Thread> threads = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private Set<ScheduledFutureTask> scheduledTasks = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private String poolName;
    private int maximumPoolSize;
    private Queue<PrioritizedRunnable> queue = new PriorityQueue<PrioritizedRunnable>(11, new Comparator<PrioritizedRunnable>(){

        @Override
        public int compare(PrioritizedRunnable pr1, PrioritizedRunnable pr2) {
            int result = pr1.getPriority() - pr2.getPriority();
            if (result == 0) {
                return Long.signum(pr1.getCreationTime() - pr2.getCreationTime());
            }
            return result;
        }
    });
    private long warnWaitTime = 500L;

    public ThreadReuseExecutor(String name, int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
        this.poolName = name;
        this.tpe = new ThreadPoolExecutor(0, maximumPoolSize, 2L, TimeUnit.MINUTES, new SynchronousQueue(), (ThreadFactory)new NamedThreadFactory("Worker")){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                if (t != null) {
                    LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)t, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30021, new Object[0]));
                }
            }
        };
    }

    @Override
    public void execute(Runnable command) {
        this.executeDirect(new RunnableWrapper(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDirect(final PrioritizedRunnable command) {
        boolean atMaxThreads = false;
        Object object = this.poolLock;
        synchronized (object) {
            this.checkForTermination();
            ++this.submittedCount;
            boolean bl = atMaxThreads = this.activeCount == this.maximumPoolSize;
            if (atMaxThreads) {
                this.queue.add(command);
                int queueSize = this.queue.size();
                if (queueSize > this.highestQueueSize) {
                    this.highestQueueSize = queueSize;
                }
            } else {
                ++this.activeCount;
                this.highestActiveCount = Math.max(this.activeCount, this.highestActiveCount);
            }
        }
        if (atMaxThreads) {
            return;
        }
        this.tpe.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread t = Thread.currentThread();
                ThreadReuseExecutor.this.threads.add(t);
                String name = t.getName();
                t.setName(name + "_" + ThreadReuseExecutor.this.poolName + ThreadReuseExecutor.this.threadCounter.getAndIncrement());
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.RUNTIME", (int)6)) {
                    LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Beginning work with virtual worker", t.getName()});
                }
                PrioritizedRunnable r = command;
                while (r != null) {
                    boolean success = false;
                    try {
                        r.run();
                        success = true;
                    }
                    catch (Throwable throwable) {
                        Object object = ThreadReuseExecutor.this.poolLock;
                        synchronized (object) {
                            if (success) {
                                ThreadReuseExecutor.this.completedCount++;
                                r = (PrioritizedRunnable)ThreadReuseExecutor.this.queue.poll();
                            }
                            if (!success || r == null) {
                                ThreadReuseExecutor.this.threads.remove(t);
                                ThreadReuseExecutor.this.activeCount--;
                                if (ThreadReuseExecutor.this.activeCount == 0 && ThreadReuseExecutor.this.terminated) {
                                    ThreadReuseExecutor.this.poolLock.notifyAll();
                                }
                            }
                        }
                        if (success) {
                            long warnTime = ThreadReuseExecutor.this.warnWaitTime;
                            if (r != null && System.currentTimeMillis() - r.getCreationTime() > warnTime) {
                                LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30009, new Object[]{ThreadReuseExecutor.this.maximumPoolSize, ThreadReuseExecutor.this.poolName, ThreadReuseExecutor.this.highestQueueSize, warnTime}));
                                ThreadReuseExecutor.this.warnWaitTime *= 2L;
                            }
                        }
                        t.setName(name);
                        throw throwable;
                    }
                    Object object = ThreadReuseExecutor.this.poolLock;
                    synchronized (object) {
                        if (success) {
                            ThreadReuseExecutor.this.completedCount++;
                            r = (PrioritizedRunnable)ThreadReuseExecutor.this.queue.poll();
                        }
                        if (!success || r == null) {
                            ThreadReuseExecutor.this.threads.remove(t);
                            ThreadReuseExecutor.this.activeCount--;
                            if (ThreadReuseExecutor.this.activeCount == 0 && ThreadReuseExecutor.this.terminated) {
                                ThreadReuseExecutor.this.poolLock.notifyAll();
                            }
                        }
                    }
                    if (success) {
                        long warnTime = ThreadReuseExecutor.this.warnWaitTime;
                        if (r != null && System.currentTimeMillis() - r.getCreationTime() > warnTime) {
                            LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30009, new Object[]{ThreadReuseExecutor.this.maximumPoolSize, ThreadReuseExecutor.this.poolName, ThreadReuseExecutor.this.highestQueueSize, warnTime}));
                            ThreadReuseExecutor.this.warnWaitTime *= 2L;
                        }
                    }
                    t.setName(name);
                }
            }
        });
    }

    private void checkForTermination() {
        if (this.terminated) {
            throw new RejectedExecutionException();
        }
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public int getSubmittedCount() {
        return this.submittedCount;
    }

    public int getCompletedCount() {
        return this.completedCount;
    }

    public int getPoolSize() {
        return this.activeCount;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.terminated = true;
        Set<ScheduledFutureTask> set = this.scheduledTasks;
        synchronized (set) {
            for (ScheduledFuture scheduledFuture : new ArrayList<ScheduledFutureTask>(this.scheduledTasks)) {
                scheduledFuture.cancel(false);
            }
            this.scheduledTasks.clear();
        }
    }

    public int getLargestPoolSize() {
        return this.highestActiveCount;
    }

    public WorkerPoolStatisticsMetadata getStats() {
        WorkerPoolStatisticsMetadata stats = new WorkerPoolStatisticsMetadata();
        stats.setName(this.poolName);
        stats.setQueued(this.queue.size());
        stats.setHighestQueued(this.highestQueueSize);
        stats.setActiveThreads(this.getActiveCount());
        stats.setMaxThreads(this.maximumPoolSize);
        stats.setTotalSubmitted((long)this.getSubmittedCount());
        stats.setHighestActiveThreads(this.getLargestPoolSize());
        stats.setTotalCompleted((long)this.getCompletedCount());
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWork() {
        Object object = this.poolLock;
        synchronized (object) {
            return this.getSubmittedCount() - this.getCompletedCount() > 0 && !this.isTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Runnable> shutdownNow() {
        this.shutdown();
        Object object = this.poolLock;
        synchronized (object) {
            Set<Thread> set = this.threads;
            synchronized (set) {
                for (Thread t : this.threads) {
                    t.interrupt();
                }
            }
            ArrayList<Runnable> result = new ArrayList<Runnable>(this.queue);
            this.queue.clear();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long timeoutMillis = unit.toMillis(timeout);
        long finalMillis = System.currentTimeMillis() + timeoutMillis;
        Object object = this.poolLock;
        synchronized (object) {
            while (this.activeCount > 0 || !this.terminated) {
                if (timeoutMillis < 1L) {
                    return false;
                }
                this.poolLock.wait(timeoutMillis);
                timeoutMillis = finalMillis - System.currentTimeMillis();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.checkForTermination();
        ScheduledFutureTask sft = new ScheduledFutureTask(new RunnableWrapper(command), false);
        Set<ScheduledFutureTask> set = this.scheduledTasks;
        synchronized (set) {
            ScheduledFuture<?> future = this.stpe.schedule(sft.getParent(), delay, unit);
            sft.setScheduledFuture(future);
            return sft;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.checkForTermination();
        ScheduledFutureTask sft = new ScheduledFutureTask(new RunnableWrapper(command), true);
        Set<ScheduledFutureTask> set = this.scheduledTasks;
        synchronized (set) {
            ScheduledFuture<?> future = this.stpe.scheduleAtFixedRate(sft.getParent(), initialDelay, period, unit);
            sft.setScheduledFuture(future);
            return sft;
        }
    }

    class ScheduledFutureTask
    extends FutureTask<Void>
    implements ScheduledFuture<Void>,
    PrioritizedRunnable {
        private ScheduledFuture<?> scheduledFuture;
        private boolean periodic;
        private volatile boolean running;
        private PrioritizedRunnable runnable;

        public ScheduledFutureTask(PrioritizedRunnable runnable, boolean periodic) {
            super(runnable, null);
            this.periodic = periodic;
            this.runnable = runnable;
        }

        public void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
            ThreadReuseExecutor.this.scheduledTasks.add(this);
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.scheduledFuture.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.scheduledFuture.compareTo(o);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.scheduledFuture.cancel(false);
            ThreadReuseExecutor.this.scheduledTasks.remove(this);
            return super.cancel(mayInterruptIfRunning);
        }

        public Runnable getParent() {
            return new Runnable(){

                @Override
                public void run() {
                    if (ScheduledFutureTask.this.running || ThreadReuseExecutor.this.terminated) {
                        return;
                    }
                    ScheduledFutureTask.this.running = ScheduledFutureTask.this.periodic;
                    ThreadReuseExecutor.this.executeDirect(ScheduledFutureTask.this);
                }
            };
        }

        @Override
        public void run() {
            if (this.periodic) {
                if (!this.runAndReset()) {
                    this.scheduledFuture.cancel(false);
                    ThreadReuseExecutor.this.scheduledTasks.remove(this);
                }
                this.running = false;
            } else {
                ThreadReuseExecutor.this.scheduledTasks.remove(this);
                super.run();
            }
        }

        @Override
        public long getCreationTime() {
            return this.runnable.getCreationTime();
        }

        @Override
        public int getPriority() {
            return this.runnable.getPriority();
        }

        @Override
        public DQPWorkContext getDqpWorkContext() {
            return this.runnable.getDqpWorkContext();
        }
    }

    static class RunnableWrapper
    implements PrioritizedRunnable {
        Runnable r;
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        long creationTime;
        int priority;

        public RunnableWrapper(Runnable r) {
            if (r instanceof PrioritizedRunnable) {
                PrioritizedRunnable pr = (PrioritizedRunnable)r;
                this.creationTime = pr.getCreationTime();
                this.priority = pr.getPriority();
                this.workContext = pr.getDqpWorkContext();
            } else {
                this.creationTime = System.currentTimeMillis();
                this.priority = Integer.MAX_VALUE;
            }
            this.r = r;
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public void run() {
            this.workContext.runInContext(this.r);
        }

        @Override
        public DQPWorkContext getDqpWorkContext() {
            return this.workContext;
        }
    }

    public static interface PrioritizedRunnable
    extends Runnable {
        public static final int NO_WAIT_PRIORITY = 0;

        public int getPriority();

        public long getCreationTime();

        public DQPWorkContext getDqpWorkContext();
    }
}

