/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.teiid.common.buffer.AutoCleanupUtil;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.CacheEntry;
import org.teiid.common.buffer.CacheKey;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.Serializer;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.BlockByteBuffer;
import org.teiid.common.buffer.impl.BlockInputStream;
import org.teiid.common.buffer.impl.BlockManager;
import org.teiid.common.buffer.impl.BlockOutputStream;
import org.teiid.common.buffer.impl.BlockStore;
import org.teiid.common.buffer.impl.ConcurrentBitSet;
import org.teiid.common.buffer.impl.LrfuEvictionQueue;
import org.teiid.common.buffer.impl.PhysicalInfo;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ExecutorUtils;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;

public class BufferFrontedFileStoreCache
implements Cache<PhysicalInfo>,
StorageManager {
    private static final int DEFAULT_MIN_DEFRAG = 0x4000000;
    private static final byte[] HEADER_SKIP_BUFFER = new byte[16];
    private static final int EVICTION_SCANS = 2;
    public static final int DEFAuLT_MAX_OBJECT_SIZE = 0x800000;
    static final int ADDRESS_BITS = 31;
    static final int SYSTEM_MASK = Integer.MIN_VALUE;
    static final int BYTES_PER_BLOCK_ADDRESS = 4;
    static final int INODE_BYTES = 64;
    static final int LOG_INODE_SIZE = 6;
    static final int DIRECT_POINTERS = 14;
    static final int EMPTY_ADDRESS = -1;
    static final int FREED = -2;
    static final int LOG_BLOCK_SIZE = 13;
    public static final long MAX_ADDRESSABLE_MEMORY = 0x100000000000L;
    static final int BLOCK_SIZE = 8192;
    static final int BLOCK_MASK = 8191;
    static final int ADDRESSES_PER_BLOCK = 2048;
    static final int MAX_INDIRECT = 2062;
    static final int MAX_DOUBLE_INDIRECT = 4196366;
    private StorageManager storageManager;
    private int maxStorageObjectSize = 0x800000;
    private long memoryBufferSpace = 0x4000000L;
    private boolean direct;
    private int maxMemoryBlocks;
    private AtomicLong readAttempts = new AtomicLong();
    LrfuEvictionQueue<PhysicalInfo> memoryBufferEntries = new LrfuEvictionQueue(this.readAttempts);
    private Semaphore memoryWritePermits;
    private ReentrantReadWriteLock memoryEvictionLock = new ReentrantReadWriteLock(true);
    private ReentrantLock freedLock = new ReentrantLock();
    private Condition blocksFreed = this.freedLock.newCondition();
    private int blocks;
    private ConcurrentBitSet blocksInuse;
    private BlockByteBuffer blockByteBuffer;
    private ConcurrentBitSet inodesInuse;
    private BlockByteBuffer inodeByteBuffer;
    private ConcurrentHashMap<Long, Map<Long, PhysicalInfo>> physicalMapping = new ConcurrentHashMap(16, 0.75f, 32);
    private BlockStore[] sizeBasedStores;
    private ExecutorService asynchPool = ExecutorUtils.newFixedThreadPool((int)2, (String)"FileStore Worker");
    private AtomicBoolean defragRunning = new AtomicBoolean();
    private final Runnable defragTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Running defrag"});
                }
                for (int i = 0; i < BufferFrontedFileStoreCache.this.sizeBasedStores.length; ++i) {
                    BlockStore blockStore = BufferFrontedFileStoreCache.this.sizeBasedStores[i];
                    block15: for (int segment = 0; segment < blockStore.stores.length; ++segment) {
                        if (!BufferFrontedFileStoreCache.this.shouldDefrag(blockStore, segment)) continue;
                        try {
                            boolean sleep = false;
                            do {
                                PhysicalInfo info;
                                if (sleep) {
                                    Thread.sleep(100L);
                                }
                                sleep = true;
                                int relativeBlockToMove = blockStore.blocksInUse.compactHighestBitSet(segment);
                                if (!BufferFrontedFileStoreCache.this.shouldDefrag(blockStore, segment)) {
                                    this.truncate(blockStore, segment);
                                    continue block15;
                                }
                                InputStream is = blockStore.stores[segment].createInputStream((long)relativeBlockToMove * blockStore.blockSize, blockStore.blockSize);
                                DataInputStream dis = new DataInputStream(is);
                                Long gid = null;
                                Long oid = null;
                                try {
                                    gid = dis.readLong();
                                    oid = dis.readLong();
                                }
                                catch (IOException e) {
                                    continue;
                                }
                                dis.reset();
                                Map map = (Map)BufferFrontedFileStoreCache.this.physicalMapping.get(gid);
                                if (map == null || (info = (PhysicalInfo)map.get(oid)) == null) continue;
                                int bitIndex = relativeBlockToMove + segment * blockStore.blocksInUse.getBitsPerSegment();
                                PhysicalInfo physicalInfo = info;
                                synchronized (physicalInfo) {
                                    info.await(true, false);
                                    if (info.block == -1) {
                                        continue;
                                    }
                                    if (info.block != bitIndex) {
                                        continue;
                                    }
                                }
                                int newBlock = blockStore.writeToStorageBlock(info, dis);
                                PhysicalInfo physicalInfo2 = info;
                                synchronized (physicalInfo2) {
                                    info.await(true, true);
                                    if (info.block == -1) {
                                        if (newBlock != -1) {
                                            blockStore.blocksInUse.clear(newBlock);
                                        }
                                        continue;
                                    }
                                    info.block = newBlock;
                                    blockStore.blocksInUse.clear(bitIndex);
                                }
                                sleep = false;
                            } while (BufferFrontedFileStoreCache.this.shouldDefrag(blockStore, segment));
                            continue;
                        }
                        catch (IOException e) {
                            LogManager.logWarning((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30022, new Object[0]));
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30046, (Throwable)e);
                        }
                    }
                }
            }
            finally {
                BufferFrontedFileStoreCache.this.defragRunning.set(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void truncate(BlockStore blockStore, int segment) {
            blockStore.locks[segment].writeLock().lock();
            try {
                int endBlock = blockStore.blocksInUse.getHighestBitSet(segment);
                long newLength = (long)(endBlock + 1) * blockStore.blockSize;
                blockStore.stores[segment].setLength(newLength);
            }
            catch (IOException e) {
                LogManager.logWarning((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30023, new Object[0]));
            }
            finally {
                blockStore.locks[segment].writeLock().unlock();
            }
        }
    };
    private AtomicBoolean cleanerRunning = new AtomicBoolean();
    private final Runnable cleaningTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (BufferFrontedFileStoreCache.this.lowBlocks(false) && BufferFrontedFileStoreCache.this.evictFromMemoryBuffer(false) != -1) {
                }
            }
            finally {
                BufferFrontedFileStoreCache.this.cleanerRunning.set(false);
            }
        }
    };
    private int cleaningThreshold;
    private int criticalCleaningThreshold;
    private AtomicLong storageWrites = new AtomicLong();
    private AtomicLong storageReads = new AtomicLong();
    private long minDefrag = 0x4000000L;

    @Override
    public void initialize() throws TeiidComponentException {
        this.storageManager.initialize();
        this.memoryBufferSpace = Math.max(this.memoryBufferSpace, (long)this.maxStorageObjectSize);
        this.blocks = (int)Math.min(Integer.MAX_VALUE, (this.memoryBufferSpace >> 13) * 2048L / 2049L);
        this.inodesInuse = new ConcurrentBitSet(this.blocks + 1, 32);
        this.blocksInuse = new ConcurrentBitSet(this.blocks, 32);
        this.blockByteBuffer = new BlockByteBuffer(30, this.blocks, 13, this.direct);
        this.inodeByteBuffer = new BlockByteBuffer(30, this.blocks + 1, 6, this.direct);
        this.memoryWritePermits = new Semaphore(this.blocks);
        this.maxMemoryBlocks = Math.min(4196366, this.blocks);
        this.maxMemoryBlocks = Math.min(this.maxMemoryBlocks, this.maxStorageObjectSize >> 13 + ((this.maxStorageObjectSize & 0x1FFF) > 0 ? 1 : 0));
        this.cleaningThreshold = Math.min(this.maxMemoryBlocks << 4, this.blocks >> 1);
        this.criticalCleaningThreshold = Math.min(this.maxMemoryBlocks << 2, this.blocks >> 2);
        if (this.maxMemoryBlocks > 14) {
            --this.maxMemoryBlocks;
        }
        if (this.maxMemoryBlocks > 2062) {
            int indirect = this.maxMemoryBlocks - 2062;
            this.maxMemoryBlocks -= indirect / 2048 + (indirect % 2048 > 0 ? 1 : 0) + 1;
        }
        ArrayList<BlockStore> stores = new ArrayList<BlockStore>();
        int size = 8192;
        int files = 32;
        do {
            stores.add(new BlockStore(this.storageManager, size, 30, files));
            size <<= 1;
            if (files <= 1) continue;
            files >>= 1;
        } while (size >> 1 < this.maxStorageObjectSize);
        this.sizeBasedStores = stores.toArray(new BlockStore[stores.size()]);
    }

    boolean lowBlocks(boolean critical) {
        int bitsSet = this.blocksInuse.getBitsSet();
        return bitsSet > 0 && this.blocks - bitsSet < (critical ? this.criticalCleaningThreshold : this.cleaningThreshold) && this.memoryBufferEntries.firstEntry(false) != null;
    }

    InodeBlockManager getBlockManager(long gid, long oid, int inode) {
        return new InodeBlockManager(gid, oid, inode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean add(CacheEntry entry, Serializer s) {
        block54: {
            block55: {
                block52: {
                    block53: {
                        block50: {
                            block51: {
                                block48: {
                                    block49: {
                                        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                                            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"adding object", s.getId(), entry.getId()});
                                        }
                                        newEntry = false;
                                        blockManager = null;
                                        hasPermit = false;
                                        info = null;
                                        success = false;
                                        memoryBlocks = this.maxMemoryBlocks;
                                        map = this.physicalMapping.get(s.getId());
                                        if (map != null) break block48;
                                        var10_12 = true;
                                        if (hasPermit) {
                                            this.memoryWritePermits.release(memoryBlocks);
                                        }
                                        if (info == null) break block49;
                                        var11_14 = info;
                                        // MONITORENTER : var11_14
                                        info.adding = false;
                                        if (!success && blockManager != null) {
                                            info.inode = -1;
                                        }
                                        // MONITOREXIT : var11_14
                                    }
                                    if (success != false) return var10_12;
                                    if (blockManager == null) return var10_12;
                                    blockManager.free(false);
                                    return var10_12;
                                }
                                info = map.get(entry.getId());
                                if (info != null) ** GOTO lbl62
                                var10_13 = map;
                                // MONITORENTER : var10_13
                                info = map.get(entry.getId());
                                if (info != null) ** GOTO lbl61
                                newEntry = true;
                                if (map.containsKey(entry.getId())) break block50;
                                var11_15 = true;
                                // MONITOREXIT : var10_13
                                if (hasPermit) {
                                    this.memoryWritePermits.release(memoryBlocks);
                                }
                                if (info == null) break block51;
                                var12_19 = info;
                                // MONITORENTER : var12_19
                                info.adding = false;
                                if (!success && blockManager != null) {
                                    info.inode = -1;
                                }
                                // MONITOREXIT : var12_19
                            }
                            if (success != false) return var11_15;
                            if (blockManager == null) return var11_15;
                            blockManager.free(false);
                            return var11_15;
                        }
                        info = new PhysicalInfo(s.getId(), entry.getId(), -1, (int)this.readAttempts.get());
                        info.adding = true;
                        map.put((Long)entry.getId(), (PhysicalInfo)info);
lbl61:
                        // 2 sources

                        // MONITOREXIT : var10_13
lbl62:
                        // 2 sources

                        if (newEntry) ** GOTO lbl117
                        var10_13 = info;
                        // MONITORENTER : var10_13
                        if (!info.adding) break block52;
                        var11_16 = false;
                        // MONITOREXIT : var10_13
                        if (hasPermit) {
                            this.memoryWritePermits.release(memoryBlocks);
                        }
                        if (info == null) break block53;
                        var12_20 = info;
                        // MONITORENTER : var12_20
                        info.adding = false;
                        if (!success && blockManager != null) {
                            info.inode = -1;
                        }
                        // MONITOREXIT : var12_20
                    }
                    if (success != false) return var11_16;
                    if (blockManager == null) return var11_16;
                    blockManager.free(false);
                    return var11_16;
                }
                try {
                    if (!info.evicting && info.inode == -1 && this.shouldPlaceInMemoryBuffer(0L, info)) break block54;
                    var11_17 = true;
                    // MONITOREXIT : var10_13
                    if (hasPermit) {
                        this.memoryWritePermits.release(memoryBlocks);
                    }
                    if (info == null) break block55;
                    var12_21 = info;
                }
                catch (Throwable e) {
                    if (e == BlockOutputStream.exceededMax && newEntry || e == PhysicalInfo.sizeChanged) {
                        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Object " + entry.getId() + " changed size since first persistence, keeping the original."});
                        return true;
                    }
                    if (e == BlockOutputStream.exceededMax) {
                        LogManager.logError((String)"org.teiid.BUFFER_MGR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30001, new Object[0]));
                        return true;
                    }
                    LogManager.logError((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30002, new Object[]{entry.getId()}));
                    return true;
                }
                info.adding = false;
                if (!success && blockManager != null) {
                    info.inode = -1;
                }
                // MONITOREXIT : var12_21
            }
            if (success != false) return var11_17;
            if (blockManager == null) return var11_17;
            blockManager.free(false);
            return var11_17;
        }
        try {
            info.adding = true;
            memoryBlocks = info.memoryBlockCount;
            // MONITOREXIT : var10_13
lbl117:
            // 2 sources

            this.checkForLowMemory();
            this.memoryWritePermits.acquire(memoryBlocks);
            hasPermit = true;
            blockManager = this.getBlockManager(s.getId(), entry.getId(), -1);
            bos = new BlockOutputStream(blockManager, memoryBlocks);
            dos = new ObjectOutputStream(bos);
            dos.writeLong(s.getId());
            dos.writeLong(entry.getId());
            dos.writeInt(entry.getSizeEstimate());
            s.serialize(entry.getObject(), dos);
            dos.close();
            var12_22 = map;
            // MONITORENTER : var12_22
            if (this.physicalMapping.containsKey(s.getId()) && map.containsKey(entry.getId())) {
                var13_23 = info;
                // MONITORENTER : var13_23
                info.setSize(bos.getBytesWritten());
                info.inode = blockManager.getInode();
                this.memoryBufferEntries.add(info);
                // MONITOREXIT : var13_23
                success = true;
            }
            // MONITOREXIT : var12_22
            return true;
        }
        catch (Throwable var22_24) {
            throw var22_24;
        }
        finally {
            if (hasPermit) {
                this.memoryWritePermits.release(memoryBlocks);
            }
            if (info != null) {
                map = info;
            }
            if (!success && blockManager != null) {
                blockManager.free(false);
            }
        }
    }

    private void checkForLowMemory() {
        if (!this.cleanerRunning.get() && this.lowBlocks(false) && this.cleanerRunning.compareAndSet(false, true)) {
            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Starting memory buffer cleaner"});
            this.asynchPool.execute(this.cleaningTask);
        }
        if (this.lowBlocks(true)) {
            this.evictFromMemoryBuffer(false);
        }
    }

    @Override
    public PhysicalInfo lockForLoad(Long oid, Serializer<?> serializer) {
        Map<Long, PhysicalInfo> map = this.physicalMapping.get(serializer.getId());
        if (map == null) {
            return null;
        }
        PhysicalInfo info = map.get(oid);
        if (info == null) {
            return null;
        }
        info.lockForLoad();
        return info;
    }

    @Override
    public void unlockForLoad(PhysicalInfo info) {
        if (info == null) {
            return;
        }
        info.unlockForLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public CacheEntry get(PhysicalInfo info, Long oid, WeakReference<? extends Serializer<?>> ref) throws TeiidComponentException {
        CacheEntry cacheEntry;
        int memoryBlocks;
        ReentrantReadWriteLock.WriteLock lock;
        Serializer serializer;
        block25: {
            if (info == null) {
                return null;
            }
            serializer = (Serializer)ref.get();
            if (serializer == null) {
                return null;
            }
            Object var5_5 = null;
            lock = null;
            memoryBlocks = 0;
            PhysicalInfo physicalInfo = info;
            // MONITORENTER : physicalInfo
            if (!$assertionsDisabled) {
                if (info.pinned) throw new AssertionError();
                if (!info.loading) {
                    throw new AssertionError();
                }
            }
            info.await(true, false);
            if (info.inode != -1) {
                info.pinned = true;
                this.memoryBufferEntries.touch(info);
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Getting object at inode", info.inode, serializer.getId(), oid});
                }
                InodeBlockManager manager = this.getBlockManager(serializer.getId(), oid, info.inode);
                BlockInputStream blockInputStream = new BlockInputStream(manager, info.memoryBlockCount);
                break block25;
            }
            if (info.block != -1) {
                info.pinned = true;
                this.memoryBufferEntries.recordAccess(info);
                this.storageReads.incrementAndGet();
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Getting object at block", info.block, info.sizeIndex, serializer.getId(), oid});
                }
                BlockStore blockStore = this.sizeBasedStores[info.sizeIndex];
                int segment = info.block / blockStore.blocksInUse.getBitsPerSegment();
                FileStore fs = blockStore.stores[segment];
                long blockOffset = (long)(info.block % blockStore.blocksInUse.getBitsPerSegment()) * blockStore.blockSize;
                InputStream inputStream = fs.createInputStream(blockOffset, info.memoryBlockCount << 13);
                lock = blockStore.locks[segment].writeLock();
                memoryBlocks = info.memoryBlockCount;
                break block25;
            }
            CacheEntry blockStore = null;
            // MONITOREXIT : physicalInfo
            PhysicalInfo segment = info;
            // MONITORENTER : segment
            info.pinned = false;
            info.notifyAll();
            // MONITOREXIT : segment
            return blockStore;
        }
        try {
            CacheEntry ce;
            void var5_10;
            // MONITOREXIT : physicalInfo
            if (lock != null) {
                void var5_8;
                InputStream inputStream = this.readIntoMemory(info, (InputStream)var5_8, lock, memoryBlocks);
            }
            ObjectInputStream dis = new ObjectInputStream((InputStream)var5_10);
            dis.readFully(HEADER_SKIP_BUFFER);
            int sizeEstimate = dis.readInt();
            cacheEntry = ce = new CacheEntry(new CacheKey(oid, 1L, 1L), sizeEstimate, serializer.deserialize(dis), ref, true);
            PhysicalInfo physicalInfo = info;
        }
        catch (IOException e) {
            try {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30048, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30048, new Object[]{oid}));
                catch (ClassNotFoundException e2) {
                    throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30048, (Throwable)e2, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30048, new Object[]{oid}));
                }
                catch (InterruptedException e3) {
                    throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30049, (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                PhysicalInfo physicalInfo = info;
                // MONITORENTER : physicalInfo
                info.pinned = false;
                info.notifyAll();
                // MONITOREXIT : physicalInfo
                throw throwable;
            }
        }
        // MONITORENTER : physicalInfo
        info.pinned = false;
        info.notifyAll();
        // MONITOREXIT : physicalInfo
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream readIntoMemory(PhysicalInfo info, InputStream is, Lock fileLock, int memoryBlocks) throws InterruptedException, IOException {
        this.checkForLowMemory();
        this.memoryWritePermits.acquire(memoryBlocks);
        InodeBlockManager manager = null;
        boolean success = false;
        boolean locked = false;
        try {
            manager = this.getBlockManager(info.gid, info.getId(), -1);
            for (int i = 0; i < memoryBlocks; ++i) {
                manager.allocateBlock(i);
            }
            fileLock.lock();
            locked = true;
            BlockOutputStream os = new BlockOutputStream(manager, -1);
            int b = -1;
            while ((b = is.read()) != -1) {
                os.write(b);
            }
            fileLock.unlock();
            locked = false;
            PhysicalInfo physicalInfo = info;
            synchronized (physicalInfo) {
                info.inode = manager.getInode();
                this.memoryBufferEntries.add(info);
                is = new BlockInputStream(manager, info.memoryBlockCount);
            }
            success = true;
        }
        finally {
            try {
                if (locked) {
                    fileLock.unlock();
                }
                if (!success && manager != null) {
                    manager.free(false);
                }
            }
            finally {
                this.memoryWritePermits.release(memoryBlocks);
            }
        }
        return is;
    }

    private boolean shouldPlaceInMemoryBuffer(long currentTime, PhysicalInfo info) {
        PhysicalInfo lowest = this.memoryBufferEntries.firstEntry(false);
        CacheKey key = info.getKey();
        return this.blocksInuse.getTotalBits() - this.blocksInuse.getBitsSet() > this.cleaningThreshold + info.memoryBlockCount || lowest != null && lowest.block != -1 && lowest.getKey().getOrderingValue() < (currentTime > 0L ? this.memoryBufferEntries.computeNextOrderingValue(currentTime, key.getLastAccess(), key.getOrderingValue()) : key.getOrderingValue());
    }

    @Override
    public FileStore createFileStore(String name) {
        return this.storageManager.createFileStore(name);
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    @Override
    public void addToCacheGroup(Long gid, Long oid) {
        Map<Long, PhysicalInfo> map = this.physicalMapping.get(gid);
        if (map == null) {
            return;
        }
        map.put(oid, null);
    }

    @Override
    public void createCacheGroup(Long gid) {
        this.physicalMapping.put(gid, Collections.synchronizedMap(new HashMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Long gid, Long id) {
        Map<Long, PhysicalInfo> map = this.physicalMapping.get(gid);
        if (map == null) {
            return false;
        }
        PhysicalInfo info = null;
        boolean result = false;
        Map<Long, PhysicalInfo> map2 = map;
        synchronized (map2) {
            int size = map.size();
            info = map.remove(id);
            result = size != map.size();
        }
        this.free(info, false, false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> removeCacheGroup(Long gid) {
        Map<Long, PhysicalInfo> map = this.physicalMapping.remove(gid);
        if (map == null) {
            return Collections.emptySet();
        }
        Map<Long, PhysicalInfo> map2 = map;
        synchronized (map2) {
            for (Map.Entry<Long, PhysicalInfo> entry : map.entrySet()) {
                this.free(entry.getValue(), false, false);
            }
            return map.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int free(PhysicalInfo info, boolean demote, boolean acquireDataBlock) {
        BlockStore blockStore;
        Object is;
        byte sizeIndex;
        int memoryBlockCount;
        if (info == null) {
            return -1;
        }
        Long oid = info.getId();
        int result = -2;
        InodeBlockManager bm = null;
        int block = -1;
        PhysicalInfo physicalInfo = info;
        synchronized (physicalInfo) {
            if (!demote) {
                info.await(true, true);
                info.evicting = true;
            } else assert (info.evicting);
            block = info.block;
            memoryBlockCount = info.memoryBlockCount;
            sizeIndex = info.sizeIndex;
            if (info.inode != -1) {
                bm = this.getBlockManager(info.gid, oid, info.inode);
            } else if (demote) {
                return -1;
            }
        }
        try {
            if (demote && block == -1) {
                this.storageWrites.getAndIncrement();
                is = new BlockInputStream(bm, memoryBlockCount);
                blockStore = this.sizeBasedStores[sizeIndex];
                block = blockStore.writeToStorageBlock(info, (InputStream)is);
            }
            is = info;
        }
        catch (IOException e) {
            PhysicalInfo physicalInfo2;
            try {
                LogManager.logError((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30016, new Object[]{oid}));
                physicalInfo2 = info;
            }
            catch (Throwable throwable) {
                PhysicalInfo physicalInfo3 = info;
                synchronized (physicalInfo3) {
                    assert (info.evicting);
                    info.await(true, false);
                    info.evicting = false;
                    info.notifyAll();
                    assert (bm == null || info.inode != -1);
                    if (info.inode != -1) {
                        info.inode = -1;
                        this.memoryBufferEntries.remove(info);
                    }
                    if (block != -1) {
                        if (demote) {
                            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Assigning storage data block", block, "of size", this.sizeBasedStores[info.sizeIndex].blockSize});
                            }
                            info.block = block;
                        } else {
                            BlockStore blockStore2 = this.sizeBasedStores[info.sizeIndex];
                            blockStore2.blocksInUse.clear(info.block);
                            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Freed storage data block", info.block, "of size", blockStore2.blockSize});
                            }
                            int segment = info.block / blockStore2.blocksInUse.getBitsPerSegment();
                            if (!this.defragRunning.get() && this.shouldDefrag(blockStore2, segment) && this.defragRunning.compareAndSet(false, true)) {
                                this.asynchPool.execute(this.defragTask);
                            }
                            info.block = -1;
                        }
                    }
                    if (bm != null) {
                        result = bm.free(acquireDataBlock);
                        this.freedLock.lock();
                        try {
                            this.blocksFreed.signalAll();
                        }
                        finally {
                            this.freedLock.unlock();
                        }
                    }
                }
                throw throwable;
            }
            synchronized (physicalInfo2) {
                assert (info.evicting);
                info.await(true, false);
                info.evicting = false;
                info.notifyAll();
                assert (bm == null || info.inode != -1);
                if (info.inode != -1) {
                    info.inode = -1;
                    this.memoryBufferEntries.remove(info);
                }
                if (block != -1) {
                    if (demote) {
                        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Assigning storage data block", block, "of size", this.sizeBasedStores[info.sizeIndex].blockSize});
                        }
                        info.block = block;
                    } else {
                        BlockStore blockStore3 = this.sizeBasedStores[info.sizeIndex];
                        blockStore3.blocksInUse.clear(info.block);
                        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Freed storage data block", info.block, "of size", blockStore3.blockSize});
                        }
                        int segment = info.block / blockStore3.blocksInUse.getBitsPerSegment();
                        if (!this.defragRunning.get() && this.shouldDefrag(blockStore3, segment) && this.defragRunning.compareAndSet(false, true)) {
                            this.asynchPool.execute(this.defragTask);
                        }
                        info.block = -1;
                    }
                }
                if (bm != null) {
                    result = bm.free(acquireDataBlock);
                    this.freedLock.lock();
                    try {
                        this.blocksFreed.signalAll();
                    }
                    finally {
                        this.freedLock.unlock();
                    }
                }
            }
        }
        synchronized (is) {
            assert (info.evicting);
            info.await(true, false);
            info.evicting = false;
            info.notifyAll();
            assert (bm == null || info.inode != -1);
            if (info.inode != -1) {
                info.inode = -1;
                this.memoryBufferEntries.remove(info);
            }
            if (block != -1) {
                if (demote) {
                    if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Assigning storage data block", block, "of size", this.sizeBasedStores[info.sizeIndex].blockSize});
                    }
                    info.block = block;
                } else {
                    blockStore = this.sizeBasedStores[info.sizeIndex];
                    blockStore.blocksInUse.clear(info.block);
                    if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Freed storage data block", info.block, "of size", blockStore.blockSize});
                    }
                    int segment = info.block / blockStore.blocksInUse.getBitsPerSegment();
                    if (!this.defragRunning.get() && this.shouldDefrag(blockStore, segment) && this.defragRunning.compareAndSet(false, true)) {
                        this.asynchPool.execute(this.defragTask);
                    }
                    info.block = -1;
                }
            }
            if (bm != null) {
                result = bm.free(acquireDataBlock);
                this.freedLock.lock();
                try {
                    this.blocksFreed.signalAll();
                }
                finally {
                    this.freedLock.unlock();
                }
            }
        }
        return result;
    }

    boolean shouldDefrag(BlockStore blockStore, int segment) {
        int highestBitSet = blockStore.blocksInUse.getHighestBitSet(segment);
        int bitsSet = blockStore.blocksInUse.getBitsSet(segment);
        highestBitSet = Math.max(bitsSet, Math.max(0, highestBitSet));
        if (highestBitSet == 0) {
            return false;
        }
        int freeBlocks = highestBitSet - bitsSet;
        return freeBlocks > highestBitSet >> 2 && (long)freeBlocks * blockStore.blockSize > this.minDefrag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int evictFromMemoryBuffer(boolean acquire) {
        int next;
        block24: {
            boolean writeLocked = false;
            next = -1;
            try {
                int i;
                block13: for (i = 0; i < 2 && next == -1; ++i) {
                    AutoCleanupUtil.doCleanup();
                    Iterator<PhysicalInfo> iter = this.memoryBufferEntries.getEvictionQueue().iterator();
                    while ((!acquire && this.lowBlocks(false) || acquire && (next = this.blocksInuse.getAndSetNextClearBit()) == -1) && iter.hasNext()) {
                        PhysicalInfo info;
                        PhysicalInfo physicalInfo = info = iter.next();
                        synchronized (physicalInfo) {
                            if (info.inode == -1) {
                                continue;
                            }
                            if (info.pinned || info.evicting) {
                                if (!acquire || i != 1) {
                                    continue;
                                }
                                if (acquire && !writeLocked) {
                                    this.memoryEvictionLock.writeLock().lock();
                                    writeLocked = true;
                                }
                                info.await(true, true);
                                if (info.inode == -1) {
                                    continue;
                                }
                            }
                            info.evicting = true;
                        }
                        next = this.free(info, true, acquire);
                        continue block13;
                    }
                }
                if (!acquire || next != -1) break block24;
                if (!writeLocked) {
                    this.memoryEvictionLock.writeLock().lock();
                    writeLocked = true;
                }
                this.freedLock.lock();
                try {
                    next = this.blocksInuse.getAndSetNextClearBit();
                    if (next != -1) {
                        i = next;
                        return i;
                    }
                    this.blocksFreed.await(120L, TimeUnit.SECONDS);
                }
                finally {
                    this.freedLock.unlock();
                }
                next = this.blocksInuse.getAndSetNextClearBit();
                if (next == -1) {
                    throw new AssertionError((Object)"Could not free space for pending write");
                }
            }
            catch (InterruptedException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30050, (Throwable)e);
            }
            finally {
                if (writeLocked) {
                    this.memoryEvictionLock.writeLock().unlock();
                }
            }
        }
        return next;
    }

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public void setMemoryBufferSpace(long maxBufferSpace) {
        this.memoryBufferSpace = Math.min(maxBufferSpace, 0x100000000000L);
    }

    public int getInodesInUse() {
        return this.inodesInuse.getBitsSet();
    }

    public int getDataBlocksInUse() {
        return this.blocksInuse.getBitsSet();
    }

    public void setMaxStorageObjectSize(int maxStorageBlockSize) {
        this.maxStorageObjectSize = maxStorageBlockSize;
    }

    public long getStorageReads() {
        return this.storageReads.get();
    }

    public long getStorageWrites() {
        return this.storageWrites.get();
    }

    public long getMemoryBufferSpace() {
        return this.memoryBufferSpace;
    }

    public void setMinDefrag(long minDefrag) {
        this.minDefrag = minDefrag;
    }

    public int getMaxMemoryBlocks() {
        return this.maxMemoryBlocks;
    }

    private final class InodeBlockManager
    implements BlockManager {
        private int inode;
        private ByteBuffer inodeBuffer;
        private final long gid;
        private final long oid;
        private int blockSegment;

        InodeBlockManager(long gid, long oid, int inode) {
            this.inode = inode;
            this.gid = gid;
            this.oid = oid;
            this.blockSegment = BufferFrontedFileStoreCache.this.blocksInuse.getNextSegment();
        }

        @Override
        public int getInode() {
            return this.inode;
        }

        @Override
        public ByteBuffer getBlock(int index) {
            int dataBlock = this.getOrUpdateDataBlockIndex(index, -1, Mode.GET);
            return BufferFrontedFileStoreCache.this.blockByteBuffer.getByteBuffer(dataBlock);
        }

        private int getOrUpdateDataBlockIndex(int index, int value, Mode mode) {
            if (index >= 4196366) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30045, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30045, new Object[0]));
            }
            int dataBlock = 0;
            int position = 0;
            ByteBuffer info = this.getInodeBlock();
            if (index >= 2062) {
                position = 60;
                ByteBuffer next = this.updateIndirectBlockInfo(info, index, position, 2062, value, mode);
                if (next != null) {
                    info = next;
                    int indirectAddressBlock = (index - 2062) / 2048;
                    position = info.position() + indirectAddressBlock * 4;
                    if (mode == Mode.ALLOCATE && position + 4 < info.limit()) {
                        info.putInt(position + 4, -1);
                    }
                    if ((next = this.updateIndirectBlockInfo(info, index, position, 2062 + indirectAddressBlock * 2048, value, mode)) != null) {
                        info = next;
                        position = info.position() + (index - 2062) % 2048 * 4;
                    }
                }
            } else if (index >= 14) {
                position = 56;
                ByteBuffer next = this.updateIndirectBlockInfo(info, index, position, 14, value, mode);
                if (next != null) {
                    info = next;
                    position = next.position() + (index - 14) * 4;
                }
            } else {
                position = 4 * index;
            }
            if (mode == Mode.ALLOCATE) {
                dataBlock = this.nextBlock(info, true);
                info.putInt(position, dataBlock);
                if (mode == Mode.ALLOCATE && position + 4 < info.limit()) {
                    info.putInt(position + 4, -1);
                }
            } else {
                dataBlock = info.getInt(position);
                if (mode == Mode.UPDATE) {
                    info.putInt(position, value);
                }
            }
            return dataBlock;
        }

        private ByteBuffer updateIndirectBlockInfo(ByteBuffer buf, int index, int position, int cutOff, int value, Mode mode) {
            int sib_index = buf.getInt(position);
            if (index == cutOff) {
                if (mode == Mode.ALLOCATE) {
                    sib_index = this.nextBlock(buf, false);
                    buf.putInt(position, sib_index);
                } else if (mode == Mode.UPDATE && value == -1) {
                    this.freeDataBlock(sib_index);
                    return null;
                }
            }
            return BufferFrontedFileStoreCache.this.blockByteBuffer.getByteBuffer(sib_index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int nextBlock(ByteBuffer reading, boolean data) {
            int limit = reading.limit();
            int position = reading.position();
            int next = -1;
            BufferFrontedFileStoreCache.this.memoryEvictionLock.readLock().lock();
            boolean readLocked = true;
            try {
                next = BufferFrontedFileStoreCache.this.blocksInuse.getAndSetNextClearBit(this.blockSegment);
                if (next == -1) {
                    BufferFrontedFileStoreCache.this.memoryEvictionLock.readLock().unlock();
                    readLocked = false;
                    next = BufferFrontedFileStoreCache.this.evictFromMemoryBuffer(true);
                }
            }
            finally {
                if (readLocked) {
                    BufferFrontedFileStoreCache.this.memoryEvictionLock.readLock().unlock();
                }
            }
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
                LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Allocating", data ? "data" : "index", "block", next, "to", this.gid, this.oid});
            }
            if (reading.limit() != limit) {
                reading.rewind();
                reading.limit(limit);
                reading.position(position);
            }
            return next;
        }

        @Override
        public void freeBlock(int index) {
            int dataBlock = this.getOrUpdateDataBlockIndex(index, -1, Mode.UPDATE);
            this.freeDataBlock(dataBlock);
        }

        private void freeDataBlock(int dataBlock) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
                LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"freeing data block", dataBlock, "for", this.gid, this.oid});
            }
            BufferFrontedFileStoreCache.this.blocksInuse.clear(dataBlock);
        }

        private ByteBuffer getInodeBlock() {
            if (this.inodeBuffer == null) {
                if (this.inode == -1) {
                    this.inode = BufferFrontedFileStoreCache.this.inodesInuse.getAndSetNextClearBit();
                    if (this.inode == -1) {
                        throw new AssertionError((Object)"Out of inodes");
                    }
                    if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Allocating inode", this.inode, "to", this.gid, this.oid});
                    }
                    ByteBuffer bb = this.getInodeBlock();
                    bb.putInt(-1);
                }
                this.inodeBuffer = BufferFrontedFileStoreCache.this.inodeByteBuffer.getByteBuffer(this.inode).slice();
            }
            return this.inodeBuffer;
        }

        @Override
        public int free(boolean acquire) {
            if (this.inode == -1) {
                return -1;
            }
            ByteBuffer bb = this.getInodeBlock();
            int dataBlockToAcquire = bb.getInt(0);
            int indirectIndexBlock = bb.getInt(56);
            int doublyIndirectIndexBlock = bb.getInt(60);
            boolean freedAll = this.freeBlock(acquire ? 4 : 0, bb, 14 - (acquire ? 1 : 0), true);
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"freeing inode", this.inode, "for", this.gid, this.oid});
            }
            BufferFrontedFileStoreCache.this.inodesInuse.clear(this.inode);
            if (!freedAll || indirectIndexBlock == -1) {
                return acquire ? dataBlockToAcquire : -2;
            }
            freedAll = this.freeIndirectBlock(indirectIndexBlock);
            if (!freedAll || doublyIndirectIndexBlock == -1) {
                return acquire ? dataBlockToAcquire : -2;
            }
            bb = BufferFrontedFileStoreCache.this.blockByteBuffer.getByteBuffer(doublyIndirectIndexBlock).slice();
            this.freeBlock(0, bb, 2048, false);
            this.freeDataBlock(doublyIndirectIndexBlock);
            return acquire ? dataBlockToAcquire : -2;
        }

        private boolean freeIndirectBlock(int indirectIndexBlock) {
            ByteBuffer bb = BufferFrontedFileStoreCache.this.blockByteBuffer.getByteBuffer(indirectIndexBlock);
            boolean freedAll = this.freeBlock(bb.position(), bb, 2048, true);
            this.freeDataBlock(indirectIndexBlock);
            return freedAll;
        }

        private boolean freeBlock(int startPosition, ByteBuffer ib, int numPointers, boolean primary) {
            ib.position(startPosition);
            for (int i = 0; i < numPointers; ++i) {
                int dataBlock = ib.getInt();
                if (dataBlock == -1) {
                    return false;
                }
                if (primary) {
                    this.freeDataBlock(dataBlock);
                    continue;
                }
                this.freeIndirectBlock(dataBlock);
            }
            return true;
        }

        @Override
        public ByteBuffer allocateBlock(int blockNum) {
            int dataBlock = this.getOrUpdateDataBlockIndex(blockNum, -1, Mode.ALLOCATE);
            return BufferFrontedFileStoreCache.this.blockByteBuffer.getByteBuffer(dataBlock);
        }
    }

    private static enum Mode {
        GET,
        UPDATE,
        ALLOCATE;

    }
}

