/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.nio.ByteBuffer;

public class BlockByteBuffer {
    private int blockAddressBits;
    private int segmentAddressBits;
    private int segmentSize;
    private int blockSize;
    private int blockCount;
    private ThreadLocal<ByteBuffer>[] buffers;

    public BlockByteBuffer(int segmentAddressBits, int blockCount, int blockAddressBits, boolean direct) {
        this.segmentAddressBits = segmentAddressBits;
        this.blockAddressBits = blockAddressBits;
        this.blockSize = 1 << blockAddressBits;
        this.segmentSize = 1 << this.segmentAddressBits;
        this.blockCount = blockCount;
        long size = (long)blockCount << blockAddressBits;
        int fullSegments = (int)size >> segmentAddressBits;
        int lastSegmentSize = (int)(size & (long)(this.segmentSize - 1));
        int segments = fullSegments;
        if (lastSegmentSize > 0) {
            ++segments;
        }
        this.buffers = new ThreadLocal[segments];
        for (int i = 0; i < fullSegments; ++i) {
            this.buffers[i] = new ThreadLocalByteBuffer(BlockByteBuffer.allocate(lastSegmentSize, direct));
        }
        if (lastSegmentSize > 0) {
            this.buffers[fullSegments] = new ThreadLocalByteBuffer(BlockByteBuffer.allocate(lastSegmentSize, direct));
        }
    }

    public static ByteBuffer allocate(int size, boolean direct) {
        if (direct) {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(size);
            int longsPerSegment = size >> 3;
            for (int j = 0; j < longsPerSegment; ++j) {
                newBuffer.putLong(0L);
            }
            return newBuffer;
        }
        return ByteBuffer.allocate(size);
    }

    public ByteBuffer getByteBuffer(int block) {
        if (block < 0 || block >= this.blockCount) {
            throw new IndexOutOfBoundsException("Invalid block " + block);
        }
        int segment = block >> this.segmentAddressBits - this.blockAddressBits;
        ByteBuffer bb = this.buffers[segment].get();
        bb.rewind();
        int position = block << this.blockAddressBits & this.segmentSize - 1;
        bb.limit(position + this.blockSize);
        bb.position(position);
        return bb;
    }

    private static final class ThreadLocalByteBuffer
    extends ThreadLocal<ByteBuffer> {
        private final ByteBuffer byteBuffer;

        public ThreadLocalByteBuffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        @Override
        protected ByteBuffer initialValue() {
            return this.byteBuffer.duplicate();
        }
    }
}

