/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.dqp.exception.SourceWarning;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.api.PartialResultsWarning;
import java.sql.SQLWarning;
import java.util.List;

class WarningUtil {
    private WarningUtil() {
    }

    static SQLWarning createWarning(Throwable ex) {
        SourceWarning exception;
        if (ex instanceof SourceWarning && (exception = (SourceWarning)ex).isPartialResultsError()) {
            PartialResultsWarning warning = new PartialResultsWarning(JDBCPlugin.Util.getString("WarningUtil.Failures_occurred"));
            warning.addConnectorFailure(exception.getConnectorBindingName(), MMSQLException.create((Throwable)exception));
            return warning;
        }
        return new SQLWarning(ex);
    }

    static SQLWarning convertWarnings(List<Exception> exceptions) {
        if (exceptions == null || exceptions.size() == 0) {
            return null;
        }
        SQLWarning warning = null;
        for (Exception ex : exceptions) {
            SQLWarning newWarning = WarningUtil.createWarning(ex);
            if (warning == null) {
                warning = newWarning;
                continue;
            }
            warning.setNextWarning(newWarning);
        }
        return warning;
    }
}

