/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.jdbc.AbstractMetadataProvider;
import com.metamatrix.jdbc.JDBCPlugin;
import java.sql.SQLException;
import java.util.Map;

public class StaticMetadataProvider
extends AbstractMetadataProvider {
    private Map[] columnMetadata;
    private int paramCount;

    StaticMetadataProvider() {
    }

    public static StaticMetadataProvider createWithData(Map[] columnMetadata, int paramCount) {
        StaticMetadataProvider provider = null;
        provider = new StaticMetadataProvider();
        provider.setData(columnMetadata);
        provider.setParameterCount(paramCount);
        return provider;
    }

    private void setData(Map[] columnMetadata) {
        this.columnMetadata = columnMetadata;
    }

    private void checkMetadataExists() throws SQLException {
        if (this.columnMetadata == null) {
            throw new SQLException(JDBCPlugin.Util.getString("StaticMetadataProvider.No_metadata"));
        }
    }

    @Override
    public Object getValue(int columnIndex, Integer metadataPropertyKey) throws SQLException {
        this.checkMetadataExists();
        if (columnIndex < 0 || columnIndex >= this.columnMetadata.length) {
            throw new SQLException(JDBCPlugin.Util.getString("StaticMetadataProvider.Invalid_column", new Object[]{columnIndex}));
        }
        Map column = this.columnMetadata[columnIndex];
        return column.get(metadataPropertyKey);
    }

    @Override
    public int getColumnCount() throws SQLException {
        this.checkMetadataExists();
        return this.columnMetadata.length;
    }

    @Override
    public int getParameterCount() {
        return this.paramCount;
    }

    public void setParameterCount(int paramCount) {
        this.paramCount = paramCount;
    }
}

