/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.xa.MMXid;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMXAConnection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class MMXAResource
implements XAResource {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    private MMXAConnection mmConnection;
    private int timeOut;

    public static MMXAResource newInstance(MMXAConnection mmConnection) {
        return new MMXAResource(mmConnection);
    }

    public MMXAResource(MMXAConnection mmConnection) {
        this.mmConnection = mmConnection;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().commitTransaction(mmXid, onePhase);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedCommitTXN", new Object[]{xid, onePhase ? "true" : "false"});
            throw this.handleError(e, logMsg);
        }
    }

    private XAException handleError(Exception e, String logMsg) {
        logger.log(Level.SEVERE, logMsg, e);
        if (e instanceof MMSQLException) {
            Throwable ex = ((MMSQLException)e).getCause();
            if (ex instanceof XAException) {
                return (XAException)ex;
            }
            if (ex instanceof XATransactionException) {
                return ((XATransactionException)ex).getXAException();
            }
        }
        return new XAException(-3);
    }

    @Override
    public void end(Xid xid, int flag) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().endTransaction(mmXid, flag);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedEndTXN", new Object[]{xid, new Integer(flag)});
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().forgetTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedForgetTXN", new Object[]{xid});
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeOut;
    }

    @Override
    public boolean isSameRM(XAResource arg0) throws XAException {
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof MMXAResource)) {
            return false;
        }
        MMXAResource other = (MMXAResource)arg0;
        try {
            return this.getMMConnection().isSameProcess(other.getMMConnection());
        }
        catch (CommunicationException e) {
            throw this.handleError((Exception)((Object)e), JDBCPlugin.Util.getString("MMXAResource.FailedISSameRM"));
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        try {
            return this.getMMConnection().prepareTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedPrepareTXN", new Object[]{xid});
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        try {
            return this.getMMConnection().recoverTransaction(flag);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedRecoverTXN", new Object[]{flag});
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().rollbackTransaction(mmXid);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedRollbackTXN", new Object[]{xid});
            throw this.handleError(e, logMsg);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.timeOut = seconds;
        return true;
    }

    @Override
    public void start(Xid xid, int flag) throws XAException {
        MMXid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().startTransaction(mmXid, flag, this.timeOut);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedStartTXN", new Object[]{xid, new Integer(flag)});
            this.handleError(e, logMsg);
        }
    }

    private MMConnection getMMConnection() throws XAException {
        try {
            return this.mmConnection.getMMConnection();
        }
        catch (SQLException e) {
            throw new XAException(-7);
        }
    }

    private MMXid getMMXid(Xid originalXid) {
        return new MMXid(originalXid);
    }
}

