/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.admin.api.core.Admin;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.client.ServerAdminFactory;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMDriver;
import com.metamatrix.jdbc.MMSQLException;
import java.sql.SQLException;
import java.util.Properties;

public class MMServerConnection
extends MMConnection {
    private static final String SERVER_NAME = "MetaMatrix Enterprise";
    private ServerAdmin serverAdmin;

    public static MMServerConnection newInstance(ServerConnection serverConn, Properties info, String url) {
        return new MMServerConnection(serverConn, info, url);
    }

    public MMServerConnection(ServerConnection serverConn, Properties info, String url) {
        super(serverConn, info, url);
    }

    @Override
    public synchronized Admin getAdminAPI() throws SQLException {
        try {
            if (this.serverAdmin == null) {
                ServerAdminFactory factory = ServerAdminFactory.getInstance();
                this.serverAdmin = factory.createAdmin(this.propInfo);
            }
        }
        catch (Exception e) {
            throw MMSQLException.create(e);
        }
        return this.serverAdmin;
    }

    @Override
    public synchronized void close() throws SQLException {
        super.close();
        if (this.serverAdmin != null) {
            this.serverAdmin.close();
        }
    }

    @Override
    String getDatabaseName() {
        return SERVER_NAME;
    }

    @Override
    public BaseDriver getBaseDriver() {
        return new MMDriver();
    }

    @Override
    public void recycleConnection() {
        super.recycleConnection();
        if (this.serverConn instanceof SocketServerConnection) {
            SocketServerConnection.selectNewServerInstance((Object)this.getDQP());
        }
    }

    @Override
    boolean isSameProcess(MMConnection conn) throws CommunicationException {
        if (conn instanceof MMServerConnection && this.serverConn instanceof SocketServerConnection && conn.serverConn instanceof SocketServerConnection) {
            return SocketServerConnection.isSameInstance((Object)this.getDQP(), (Object)conn.getDQP());
        }
        return false;
    }
}

