/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.types.BlobImpl;
import com.metamatrix.common.types.ClobImpl;
import com.metamatrix.common.types.MMJDBCSQLTypeInfo;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.dqp.client.MetadataResult;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.jdbc.DataTypeTransformer;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.ResultsMetadataWithProvider;
import com.metamatrix.jdbc.StaticMetadataProvider;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class MMPreparedStatement
extends MMStatement
implements PreparedStatement {
    protected String prepareSql;
    private Map<Integer, Object> parameterMap;
    protected List<List<Object>> batchParameterList;
    private ResultSetMetaData metadata;
    private Calendar serverCalendar;

    static MMPreparedStatement newInstance(MMConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new MMPreparedStatement(connection, sql, resultSetType, resultSetConcurrency);
    }

    MMPreparedStatement(MMConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency);
        ArgCheck.isNotNull((Object)sql, (String)JDBCPlugin.Util.getString("MMPreparedStatement.Err_prep_sql"));
        this.prepareSql = sql;
        TimeZone timezone = connection.getServerConnection().getLogonResult().getTimeZone();
        if (timezone != null && !timezone.hasSameRules(this.getDefaultCalendar().getTimeZone())) {
            this.serverCalendar = Calendar.getInstance(timezone);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkStatement();
        if (this.batchParameterList == null) {
            this.batchParameterList = new ArrayList<List<Object>>();
        }
        this.batchParameterList.add(this.getParameterValues());
        this.clearParameters();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkStatement();
        if (this.parameterMap != null) {
            this.parameterMap.clear();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeSql(new String[]{this.prepareSql}, false, null);
        return this.hasResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchParameterList == null || this.batchParameterList.isEmpty()) {
            return new int[0];
        }
        try {
            this.executeSql(new String[]{this.prepareSql}, true, false);
        }
        finally {
            this.batchParameterList.clear();
        }
        return this.updateCounts;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeSql(new String[]{this.prepareSql}, false, true);
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeSql(new String[]{this.prepareSql}, false, false);
        return this.updateCounts[0];
    }

    @Override
    protected RequestMessage createRequestMessage(String[] commands, boolean isBatchedCommand, Boolean requiresResultSet) throws MMSQLException {
        RequestMessage message = super.createRequestMessage(commands, false, requiresResultSet);
        message.setPreparedStatement(true);
        message.setParameterValues(isBatchedCommand ? this.getParameterValuesList() : this.getParameterValues());
        message.setPreparedBatchUpdate(isBatchedCommand);
        return message;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkStatement();
        if (this.metadata == null) {
            if (this.updateCounts != null) {
                return null;
            }
            if (this.resultSet != null) {
                this.metadata = this.resultSet.getMetaData();
            } else {
                MetadataResult results;
                try {
                    results = this.getDQP().getMetadata(this.currentRequestID, this.prepareSql, Boolean.valueOf(this.getExecutionProperty("allowDoubleQuotedVariable")).booleanValue());
                }
                catch (MetaMatrixComponentException e) {
                    throw MMSQLException.create(e);
                }
                catch (MetaMatrixProcessingException e) {
                    throw MMSQLException.create(e);
                }
                if (results.getColumnMetadata() == null) {
                    return null;
                }
                StaticMetadataProvider provider = StaticMetadataProvider.createWithData(results.getColumnMetadata(), results.getParameterCount());
                this.metadata = ResultsMetadataWithProvider.newInstance(provider);
            }
        }
        return this.metadata;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream in, int length) throws SQLException {
        this.setObject(parameterIndex, new ClobImpl(in, Charset.forName("ASCII"), length));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.setObject(parameterIndex, value);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream in, int length) throws SQLException {
        this.setObject(parameterIndex, new BlobImpl(in, length));
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.setObject(parameterIndex, new Boolean(value));
    }

    @Override
    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.setObject(parameterIndex, new Byte(value));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.setObject(parameterIndex, new BlobImpl(bytes));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setObject(parameterIndex, new ClobImpl(reader, length));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.setDate(parameterIndex, value, null);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, x);
            return;
        }
        this.setObject(parameterIndex, TimestampWithTimezone.createDate((java.util.Date)x, (TimeZone)cal.getTimeZone(), (Calendar)this.getDefaultCalendar()));
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.setObject(parameterIndex, new Double(value));
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.setObject(parameterIndex, new Float(value));
    }

    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.setObject(parameterIndex, new Integer(value));
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.setObject(parameterIndex, new Long(value));
    }

    @Override
    public void setNull(int parameterIndex, int jdbcType) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setNull(int parameterIndex, int jdbcType, String typeName) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setObject(int parameterIndex, Object value, int targetJdbcType, int scale) throws SQLException {
        if (value == null) {
            this.setObject(parameterIndex, null);
            return;
        }
        if (targetJdbcType != 3 || targetJdbcType != 2) {
            this.setObject(parameterIndex, value, targetJdbcType);
        } else {
            BigDecimal bigDecimalObject = DataTypeTransformer.getBigDecimal(value);
            bigDecimalObject.setScale(scale);
            this.setObject(parameterIndex, bigDecimalObject);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object value, int targetJdbcType) throws SQLException {
        Object targetObject = null;
        if (value == null) {
            this.setObject(parameterIndex, null);
            return;
        }
        String javaClassName = MMJDBCSQLTypeInfo.getJavaClassName((int)targetJdbcType);
        if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.STRING_CLASS)) {
            targetObject = value.toString();
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.CHAR_CLASS)) {
            targetObject = DataTypeTransformer.getCharacter(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.INTEGER_CLASS)) {
            targetObject = DataTypeTransformer.getInteger(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.BYTE_CLASS)) {
            targetObject = DataTypeTransformer.getByte(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.SHORT_CLASS)) {
            targetObject = DataTypeTransformer.getShort(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.LONG_CLASS)) {
            targetObject = DataTypeTransformer.getLong(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.FLOAT_CLASS)) {
            targetObject = Float.valueOf(DataTypeTransformer.getFloat(value));
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.DOUBLE_CLASS)) {
            targetObject = DataTypeTransformer.getDouble(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.BOOLEAN_CLASS)) {
            targetObject = DataTypeTransformer.getBoolean(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.BIGDECIMAL_CLASS)) {
            targetObject = DataTypeTransformer.getBigDecimal(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.TIMESTAMP_CLASS)) {
            targetObject = DataTypeTransformer.getTimestamp(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.DATE_CLASS)) {
            targetObject = DataTypeTransformer.getDate(value);
        } else if (javaClassName.equalsIgnoreCase(MMJDBCSQLTypeInfo.TIME_CLASS)) {
            targetObject = DataTypeTransformer.getTime(value);
        } else if (javaClassName.equalsIgnoreCase("java.sql.Blob")) {
            targetObject = DataTypeTransformer.getBlob(value);
        } else if (javaClassName.equalsIgnoreCase("java.sql.Clob")) {
            targetObject = DataTypeTransformer.getClob(value);
        } else {
            String msg = JDBCPlugin.Util.getString("MMPreparedStatement.Err_transform_obj");
            throw new MMSQLException(msg);
        }
        this.setObject(parameterIndex, targetObject);
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws SQLException {
        ArgCheck.isPositive((int)parameterIndex, (String)JDBCPlugin.Util.getString("MMPreparedStatement.Invalid_param_index"));
        if (this.parameterMap == null) {
            this.parameterMap = new TreeMap<Integer, Object>();
        }
        if (this.serverCalendar != null && value instanceof java.util.Date) {
            value = TimestampWithTimezone.create((java.util.Date)((java.util.Date)value), (TimeZone)this.getDefaultCalendar().getTimeZone(), (Calendar)this.serverCalendar, value.getClass());
        }
        this.parameterMap.put(new Integer(parameterIndex), value);
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.setObject(parameterIndex, new Short(value));
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        this.setObject(parameterIndex, value);
    }

    @Override
    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.setTime(parameterIndex, value, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, x);
            return;
        }
        this.setObject(parameterIndex, TimestampWithTimezone.createTime((java.util.Date)x, (TimeZone)cal.getTimeZone(), (Calendar)this.getDefaultCalendar()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.setTimestamp(parameterIndex, value, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, x);
            return;
        }
        this.setObject(parameterIndex, TimestampWithTimezone.createTimestamp((java.util.Date)x, (TimeZone)cal.getTimeZone(), (Calendar)this.getDefaultCalendar()));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    List getParameterValuesList() {
        if (this.batchParameterList == null || this.batchParameterList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<List<Object>>(this.batchParameterList);
    }

    List getParameterValues() {
        if (this.parameterMap == null || this.parameterMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<Object>(this.parameterMap.values());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    void setServerCalendar(Calendar serverCalendar) {
        this.serverCalendar = serverCalendar;
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setObject(parameterIndex, xmlObject);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

