/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.xa.MMXid;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMCallableStatement;
import com.metamatrix.jdbc.MMDatabaseMetaData;
import com.metamatrix.jdbc.MMPreparedStatement;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.WrapperImpl;
import com.metamatrix.jdbc.api.Connection;
import com.metamatrix.jdbc.api.DatabaseMetaData;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;

public abstract class MMConnection
extends WrapperImpl
implements Connection {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    private long requestIDGenerator;
    private String url;
    protected Properties propInfo;
    private boolean closed = false;
    private boolean autoCommitFlag = true;
    private Collection<MMStatement> statements = new ArrayList<MMStatement>();
    private DatabaseMetaData dbmm = null;
    private MMXid transactionXid;
    private boolean readOnly = false;
    private boolean disableLocalTransactions = false;
    private ClientSideDQP dqp;
    protected ServerConnection serverConn;

    public MMConnection(ServerConnection serverConn, Properties info, String url) {
        String defaultFetchSize;
        this.serverConn = serverConn;
        this.url = url;
        this.dqp = (ClientSideDQP)serverConn.getService(ClientSideDQP.class);
        String overrideProp = info.getProperty("txnAutoWrap");
        if (overrideProp == null || overrideProp.trim().length() == 0) {
            info.put("txnAutoWrap", "OPTIMISTIC");
        }
        if ((defaultFetchSize = info.getProperty("fetchSize")) != null) {
            info.put("fetchSize", defaultFetchSize);
        } else {
            info.put("fetchSize", "2000");
        }
        String partialResultsMode = info.getProperty("partialResultsMode");
        if (partialResultsMode != null) {
            info.put("partialResultsMode", partialResultsMode);
        } else {
            info.put("partialResultsMode", "FALSE");
        }
        String resultSetCacheMode = info.getProperty("resultSetCacheMode");
        if (resultSetCacheMode != null) {
            info.put("resultSetCacheMode", resultSetCacheMode);
        } else {
            info.put("resultSetCacheMode", "TRUE");
        }
        String allowDblQuotes = info.getProperty("allowDoubleQuotedVariable");
        if (allowDblQuotes != null) {
            info.put("allowDoubleQuotedVariable", allowDblQuotes);
        } else {
            info.put("allowDoubleQuotedVariable", Boolean.FALSE.toString());
        }
        logger.info(JDBCPlugin.Util.getString("MMConnection.Session_success"));
        this.logConnectionProperties(url, info);
        this.propInfo = info;
        this.disableLocalTransactions = Boolean.valueOf(this.propInfo.getProperty("disableLocalTxn"));
    }

    ClientSideDQP getDQP() {
        return this.dqp;
    }

    private void logConnectionProperties(String connUrl, Properties info) {
        StringBuffer modifiedUrl = new StringBuffer();
        if (connUrl != null) {
            int startIndex = connUrl.indexOf("password=");
            if (startIndex != -1) {
                modifiedUrl.append(connUrl.substring(0, startIndex));
                modifiedUrl.append("password=***");
                int endIndex = connUrl.indexOf(";", startIndex + 9);
                if (endIndex != -1) {
                    modifiedUrl.append(";").append(connUrl.substring(endIndex));
                }
            }
            logger.info("Connection Url=" + modifiedUrl);
        }
        if (info != null) {
            Enumeration<Object> enumeration = info.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Object anObj = info.get(key);
                if ("credentials".equalsIgnoreCase(key) || "password".equalsIgnoreCase(key) || "clientToken".equalsIgnoreCase(key)) continue;
                logger.info(key + "=" + anObj);
            }
        }
    }

    String getUrl() {
        return this.url;
    }

    public String getConnectionId() {
        return this.serverConn.getLogonResult().getSessionID().toString();
    }

    long currentRequestId() {
        return this.requestIDGenerator;
    }

    long nextRequestID() {
        return this.requestIDGenerator++;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        SQLException firstException = null;
        if (this.closed) {
            return;
        }
        try {
            try {
                this.closeStatements();
            }
            catch (SQLException se) {
                firstException = se;
            }
            finally {
                this.serverConn.shutdown();
                if (firstException != null) {
                    throw firstException;
                }
            }
        }
        catch (SQLException se) {
            throw MMSQLException.create(se, JDBCPlugin.Util.getString("MMConnection.Err_connection_close", new Object[]{se.getMessage()}));
        }
        finally {
            logger.info(JDBCPlugin.Util.getString("MMConnection.Connection_close_success"));
            this.closed = true;
        }
    }

    void closeStatements() throws SQLException {
        ArrayList<MMStatement> statementsSafe = new ArrayList<MMStatement>(this.statements);
        Iterator statementIter = statementsSafe.iterator();
        SQLException ex = null;
        while (statementIter.hasNext()) {
            Statement statement = (Statement)statementIter.next();
            try {
                statement.close();
            }
            catch (SQLException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw MMSQLException.create(ex, JDBCPlugin.Util.getString("MMConnection.Err_closing_stmts"));
        }
    }

    void closeStatement(Statement statement) {
        this.statements.remove(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        this.checkConnection();
        if (!this.autoCommitFlag) {
            try {
                this.directCommit();
            }
            finally {
                this.beginLocalTxn();
            }
        }
    }

    private void directCommit() throws SQLException {
        try {
            this.dqp.commit();
        }
        catch (XATransactionException e) {
            throw MMSQLException.create(e);
        }
        logger.info(JDBCPlugin.Util.getString("MMConnection.Commit_success"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginLocalTxn() throws SQLException {
        if (this.transactionXid == null) {
            if (this.disableLocalTransactions) {
                this.autoCommitFlag = true;
                return;
            }
            boolean txnStarted = false;
            try {
                try {
                    this.dqp.begin();
                }
                catch (XATransactionException e) {
                    throw MMSQLException.create(e);
                }
                txnStarted = true;
            }
            finally {
                if (!txnStarted) {
                    this.autoCommitFlag = true;
                }
            }
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        MMStatement newStatement = MMStatement.newInstance(this, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    private void validateResultSetType(int resultSetType) throws MMSQLException {
        if (resultSetType == 1005) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Scrollable_type_not_supported", new Object[]{"ResultSet.TYPE_SCROLL_SENSITIVE"});
            throw new MMSQLException(msg);
        }
    }

    private void validateResultSetConcurrency(int resultSetConcurrency) throws MMSQLException {
        if (resultSetConcurrency == 1008) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Concurrency_type_not_supported", new Object[]{"ResultSet.CONCUR_UPDATABLE"});
            throw new MMSQLException(msg);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkConnection();
        return this.autoCommitFlag;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkConnection();
        return null;
    }

    ServerConnection getServerConnection() throws SQLException {
        this.checkConnection();
        return this.serverConn;
    }

    @Override
    String getSchema() throws SQLException {
        this.checkConnection();
        return this.serverConn.getLogonResult().getProductInfo("VirtualDatabaseName");
    }

    String getUserName() throws SQLException {
        this.checkConnection();
        return this.serverConn.getLogonResult().getUserName();
    }

    @Override
    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        this.checkConnection();
        if (this.dbmm == null) {
            this.dbmm = MMDatabaseMetaData.newInstance(this.getBaseDriver(), this);
        }
        return this.dbmm;
    }

    abstract String getDatabaseName();

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 8;
    }

    public Map getTypeMap() throws SQLException {
        this.checkConnection();
        return new HashMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection();
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1004, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        MMCallableStatement newStatement = MMCallableStatement.newInstance(this, sql, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    private void validateSQL(String sql) throws MMSQLException {
        if (sql == null) {
            String msg = JDBCPlugin.Util.getString("MMConnection.SQL_cannot_be_null");
            throw new MMSQLException(msg);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        MMPreparedStatement newStatement = MMPreparedStatement.newInstance(this, sql, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
        this.rollback(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(boolean startTxn) throws SQLException {
        this.checkConnection();
        if (!this.autoCommitFlag) {
            try {
                try {
                    this.dqp.rollback();
                }
                catch (XATransactionException e) {
                    throw MMSQLException.create(e);
                }
                logger.info(JDBCPlugin.Util.getString("MMConnection.Rollback_success"));
            }
            finally {
                if (startTxn) {
                    this.beginLocalTxn();
                } else {
                    this.autoCommitFlag = true;
                }
            }
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkConnection();
        if (autoCommit == this.autoCommitFlag) {
            return;
        }
        this.autoCommitFlag = autoCommit;
        if (autoCommit) {
            this.directCommit();
        } else {
            this.beginLocalTxn();
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.readOnly == readOnly) {
            return;
        }
        if (!this.autoCommitFlag || this.transactionXid != null) {
            throw new MMSQLException(JDBCPlugin.Util.getString("MMStatement.Invalid_During_Transaction", new Object[]{"setReadOnly(" + readOnly + ")"}));
        }
        this.readOnly = readOnly;
    }

    void checkConnection() throws SQLException {
        if (this.closed) {
            throw new MMSQLException(JDBCPlugin.Util.getString("MMConnection.Cant_use_closed_connection"));
        }
    }

    protected void commitTransaction(MMXid arg0, boolean arg1) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        this.autoCommitFlag = true;
        try {
            this.dqp.commit(arg0, arg1);
        }
        catch (XATransactionException e) {
            throw MMSQLException.create(e);
        }
    }

    protected void endTransaction(MMXid arg0, int arg1) throws SQLException {
        this.checkConnection();
        this.autoCommitFlag = true;
        try {
            this.dqp.end(arg0, arg1);
        }
        catch (XATransactionException e) {
            throw MMSQLException.create(e);
        }
    }

    protected void forgetTransaction(MMXid arg0) throws SQLException {
        this.checkConnection();
        try {
            this.dqp.forget(arg0);
        }
        catch (XATransactionException e) {
            throw MMSQLException.create(e);
        }
    }

    protected int prepareTransaction(MMXid arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        try {
            return this.dqp.prepare(arg0);
        }
        catch (XATransactionException e) {
            throw MMSQLException.create(e);
        }
    }

    protected Xid[] recoverTransaction(int arg0) throws SQLException {
        this.checkConnection();
        try {
            return this.dqp.recover(arg0);
        }
        catch (XATransactionException e) {
            throw MMSQLException.create(e);
        }
    }

    protected void rollbackTransaction(MMXid arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        this.autoCommitFlag = true;
        try {
            this.dqp.rollback(arg0);
        }
        catch (XATransactionException e) {
            throw MMSQLException.create(e);
        }
    }

    protected void startTransaction(MMXid arg0, int arg1, int timeout) throws SQLException {
        this.checkConnection();
        try {
            this.dqp.start(arg0, arg1, timeout);
        }
        catch (XATransactionException e) {
            throw MMSQLException.create(e);
        }
        this.transactionXid = arg0;
        this.autoCommitFlag = false;
    }

    protected MMXid getTransactionXid() {
        return this.transactionXid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        Statement statement = null;
        try {
            statement = this.createStatement();
            statement.setQueryTimeout(timeout);
            statement.execute("select 1");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public void recycleConnection() {
        try {
            this.closeStatements();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, JDBCPlugin.Util.getString("MMXAConnection.rolling_back_error"), e);
        }
        try {
            if (!this.getAutoCommit()) {
                logger.warning(JDBCPlugin.Util.getString("MMXAConnection.rolling_back"));
                if (this.getTransactionXid() == null) {
                    this.rollback(false);
                } else {
                    this.rollbackTransaction(this.getTransactionXid());
                }
            }
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, JDBCPlugin.Util.getString("MMXAConnection.rolling_back_error"), e);
        }
    }

    abstract BaseDriver getBaseDriver();

    abstract boolean isSameProcess(MMConnection var1) throws CommunicationException;

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

