/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.lob.LobChunkInputStream;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.common.lob.ReaderInputStream;
import com.metamatrix.common.types.ClobImpl;
import com.metamatrix.common.types.ClobType;
import com.metamatrix.dqp.client.impl.StreamingLobChunckProducer;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.LobSearchUtil;
import com.metamatrix.jdbc.MMSQLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class MMClob
implements Clob {
    private final StreamingLobChunckProducer.Factory lobChunckFactory;
    private final ClobType clob;

    public static Clob newInstance(StreamingLobChunckProducer.Factory lobChunckFactory, ClobType clob) throws SQLException {
        Clob sourceClob;
        if (!Boolean.getBoolean("FORCE_STREAMING") && (sourceClob = clob.getSourceClob()) != null) {
            return sourceClob;
        }
        return new MMClob(lobChunckFactory, clob);
    }

    public MMClob(StreamingLobChunckProducer.Factory lobChunkFactory, ClobType clob) throws SQLException {
        this.lobChunckFactory = lobChunkFactory;
        this.clob = clob;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new ReaderInputStream(this.getCharacterStream(), Charset.forName("US-ASCII"));
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new LobChunkInputStream((LobChunkProducer)this.lobChunckFactory.getLobChunkProducer()).getUTF16Reader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L) {
            Object[] params = new Object[]{new Long(pos)};
            throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.0", params));
        }
        if (pos > this.length()) {
            return null;
        }
        --pos;
        if (length < 0) {
            Object[] params = new Object[]{new Integer(length)};
            throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.1", params));
        }
        if (pos + (long)length > this.length()) {
            length = (int)(this.length() - pos);
        }
        char[] dataCopy = new char[length];
        Reader in = this.getCharacterStream();
        try {
            try {
                in.skip(pos);
                in.read(dataCopy);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw MMSQLException.create(e);
        }
        return new String(dataCopy);
    }

    @Override
    public long length() throws SQLException {
        return this.clob.length();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        if (searchstr == null) {
            return -1L;
        }
        return LobSearchUtil.position(new ClobStreamProvider(searchstr), searchstr.length(), new ClobStreamProvider(this), this.length(), start, 2);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (searchstr == null) {
            return -1L;
        }
        return this.position((Clob)new ClobImpl(searchstr.toCharArray()), start);
    }

    @Override
    public void free() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getCharacterStream(long arg0, long arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OutputStream setAsciiStream(long arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Writer setCharacterStream(long arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setString(long arg0, String arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setString(long arg0, String arg1, int arg2, int arg3) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void truncate(long arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private static final class ClobStreamProvider
    implements LobSearchUtil.StreamProvider {
        private final Clob searchstr;

        private ClobStreamProvider(Clob searchstr) {
            this.searchstr = searchstr;
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            ReaderInputStream ris = new ReaderInputStream(this.searchstr.getCharacterStream(), Charset.forName("UTF-16"));
            try {
                ris.skip(2L);
                return ris;
            }
            catch (IOException e) {
                throw MMSQLException.create(e);
            }
        }
    }
}

