/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.dqp.client.MetadataResult;
import com.metamatrix.dqp.metadata.ResultsMetadataConstants;
import com.metamatrix.jdbc.AbstractMetadataProvider;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.StaticMetadataProvider;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DeferredMetadataProvider
extends AbstractMetadataProvider {
    private StaticMetadataProvider staticProvider;
    private MMStatement statement;
    private long requestID;

    DeferredMetadataProvider() {
    }

    public static DeferredMetadataProvider createWithInitialData(String[] columnNames, String[] columnTypes, MMStatement statement, long requestID) {
        if (columnNames == null || columnTypes == null || columnNames.length != columnTypes.length) {
            Object[] params = new Object[]{StringUtil.toString((Object[])columnNames), StringUtil.toString((Object[])columnTypes)};
            throw new IllegalArgumentException(JDBCPlugin.Util.getString("DeferredMetadataProvider.Invalid_data", params));
        }
        DeferredMetadataProvider provider = null;
        provider = new DeferredMetadataProvider();
        provider.setDeferredLookupAttributes(statement, requestID);
        provider.loadPartialMetadata(columnNames, columnTypes);
        return provider;
    }

    private void setDeferredLookupAttributes(MMStatement statement, long requestID) {
        this.statement = statement;
        this.requestID = requestID;
    }

    private void loadPartialMetadata(String[] columnNames, String[] columnTypes) {
        Map[] columnMetadata = new Map[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            columnMetadata[i] = new HashMap();
            columnMetadata[i].put(ResultsMetadataConstants.ELEMENT_NAME, columnNames[i]);
            columnMetadata[i].put(ResultsMetadataConstants.DATA_TYPE, columnTypes[i]);
        }
        this.staticProvider = StaticMetadataProvider.createWithData(columnMetadata, -1);
    }

    private void loadFullMetadata() throws SQLException {
        MetadataResult results;
        try {
            results = this.statement.getDQP().getMetadata(this.requestID);
        }
        catch (MetaMatrixComponentException e) {
            throw MMSQLException.create(e);
        }
        catch (MetaMatrixProcessingException e) {
            throw MMSQLException.create(e);
        }
        this.staticProvider = StaticMetadataProvider.createWithData(results.getColumnMetadata(), results.getParameterCount());
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.staticProvider.getColumnCount();
    }

    @Override
    public Object getValue(int columnIndex, Integer metadataPropertyKey) throws SQLException {
        Object value = this.staticProvider.getValue(columnIndex, metadataPropertyKey);
        if (value == null) {
            this.loadFullMetadata();
            value = this.staticProvider.getValue(columnIndex, metadataPropertyKey);
        }
        return value;
    }

    @Override
    public int getParameterCount() throws SQLException {
        int count = this.staticProvider.getParameterCount();
        if (count < 0) {
            this.loadFullMetadata();
            count = this.staticProvider.getParameterCount();
        }
        return count;
    }
}

