/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.jdbc.BatchFetcher;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BatchResults {
    private static final int SAVED_BATCHES = 3;
    private ArrayList<Batch> batches = new ArrayList(4);
    private int currentRowNumber;
    private int lastRowNumber = -1;
    private int highestRowNumber;
    private BatchFetcher batchFetcher;
    private int fetchSize;

    public BatchResults(List[] batch, int beginRow, int endRow, boolean isLast, int fetchSize) {
        this.fetchSize = fetchSize;
        this.setBatch(new Batch(batch, beginRow, endRow, isLast));
    }

    public BatchResults(BatchFetcher batchFetcher, int fetchSize, Batch batch) {
        this.batchFetcher = batchFetcher;
        this.fetchSize = fetchSize;
        this.setBatch(batch);
    }

    public List getCurrentRow() throws SQLException {
        if (this.currentRowNumber == 0 || this.lastRowNumber != -1 && this.currentRowNumber > this.lastRowNumber) {
            return null;
        }
        int closestMax = this.currentRowNumber + this.fetchSize - 1;
        int closestMin = Math.max(1, this.currentRowNumber - this.fetchSize + 1);
        for (int i = 0; i < this.batches.size(); ++i) {
            Batch batch = this.batches.get(i);
            if (this.currentRowNumber < batch.getBeginRow()) {
                if (i == 2) continue;
                closestMax = Math.min(batch.getBeginRow(), closestMax);
                continue;
            }
            if (this.currentRowNumber > batch.getEndRow()) {
                if (i == 2) continue;
                closestMin = Math.max(batch.getEndRow(), closestMin);
                continue;
            }
            if (i != 0) {
                this.batches.add(0, this.batches.remove(i));
            }
            return batch.getRow(this.currentRowNumber);
        }
        if (closestMax - this.currentRowNumber >= this.currentRowNumber - closestMin) {
            this.requestBatchAndWait(this.currentRowNumber, closestMax);
        } else {
            this.requestBatchAndWait(this.currentRowNumber, closestMin);
        }
        Batch batch = this.batches.get(0);
        return batch.getRow(this.currentRowNumber);
    }

    private void requestNextBatch() throws SQLException {
        this.requestBatchAndWait(this.highestRowNumber + 1, this.highestRowNumber + this.fetchSize);
    }

    public boolean next() throws SQLException {
        if (this.hasNext()) {
            ++this.currentRowNumber;
            return true;
        }
        if (this.currentRowNumber == this.highestRowNumber) {
            ++this.currentRowNumber;
        }
        return false;
    }

    public boolean hasPrevious() {
        return this.currentRowNumber != 0 && this.currentRowNumber != 1;
    }

    public boolean previous() {
        if (this.hasPrevious()) {
            --this.currentRowNumber;
            return true;
        }
        if (this.currentRowNumber == 1) {
            --this.currentRowNumber;
        }
        return false;
    }

    public void setBatchFetcher(BatchFetcher batchFetcher) {
        this.batchFetcher = batchFetcher;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean absolute(int row) throws SQLException {
        return this.absolute(row, 0);
    }

    public boolean absolute(int row, int offset) throws SQLException {
        if (row == 0) {
            this.currentRowNumber = 0;
            return false;
        }
        if (row > 0) {
            while (row + offset > this.highestRowNumber && this.lastRowNumber == -1) {
                this.requestNextBatch();
            }
            if (row + offset <= this.highestRowNumber) {
                this.currentRowNumber = row;
                return true;
            }
            this.currentRowNumber = this.lastRowNumber + 1 - offset;
            return false;
        }
        row -= offset;
        while (this.lastRowNumber == -1) {
            this.requestNextBatch();
        }
        int positiveRow = this.lastRowNumber + row + 1;
        if (positiveRow <= 0) {
            this.currentRowNumber = 0;
            return false;
        }
        this.currentRowNumber = positiveRow;
        return true;
    }

    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    private void requestBatchAndWait(int beginRow, int endRow) throws SQLException {
        this.setBatch(this.batchFetcher.requestBatch(beginRow, endRow));
    }

    private void setBatch(Batch batch) {
        Assertion.assertTrue((batch.getLength() != 0 || batch.isLast() ? 1 : 0) != 0);
        if (batch.isLast()) {
            this.lastRowNumber = batch.getEndRow();
        }
        this.highestRowNumber = Math.max(batch.getEndRow(), this.highestRowNumber);
        this.batches.add(0, batch);
        if (this.batches.size() > 3) {
            this.batches.remove(3);
        }
    }

    public boolean hasNext() throws SQLException {
        return this.hasNext(1);
    }

    public boolean hasNext(int next) throws SQLException {
        while (this.currentRowNumber + next > this.highestRowNumber && this.lastRowNumber == -1) {
            this.requestNextBatch();
        }
        return this.currentRowNumber + next <= this.highestRowNumber;
    }

    public int getFinalRowNumber() {
        return this.lastRowNumber;
    }

    public int getHighestRowNumber() {
        return this.highestRowNumber;
    }

    static class Batch {
        private List[] batch;
        private int beginRow;
        private int endRow;
        private boolean isLast;

        Batch(List[] batch, int beginRow, int endRow, boolean isLast) {
            this.batch = batch;
            this.beginRow = beginRow;
            this.endRow = endRow;
            this.isLast = isLast;
        }

        int getLength() {
            return this.batch.length;
        }

        List getRow(int index) {
            return this.batch[index - this.beginRow];
        }

        int getBeginRow() {
            return this.beginRow;
        }

        int getEndRow() {
            return this.endRow;
        }

        boolean isLast() {
            return this.isLast;
        }
    }
}

