/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.replication.jboss;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelFactory;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Promise;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.teiid.Replicated;
import org.teiid.logging.LogManager;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.ReplicatedObject;
import org.teiid.replication.jboss.JGroupsInputStream;
import org.teiid.replication.jboss.JGroupsOutputStream;

public class JGroupsObjectReplicator
implements ObjectReplicator,
Serializable {
    private static final long serialVersionUID = -6851804958313095166L;
    private static final String CREATE_STATE = "createState";
    private static final String BUILD_STATE = "buildState";
    private static final String FINISH_STATE = "finishState";
    private transient ChannelFactory channelFactory;
    private String multiplexerStack;
    private String clusterName;
    private String jndiName;
    private transient Executor executor = Executors.newCachedThreadPool();

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getMultiplexerStack() {
        return this.multiplexerStack;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setMultiplexerStack(String multiplexerStack) {
        this.multiplexerStack = multiplexerStack;
    }

    public void start() throws Exception {
        if (this.channelFactory == null) {
            return;
        }
        if (this.jndiName != null) {
            InitialContext ic = new InitialContext();
            org.jboss.util.naming.Util.bind((Context)ic, (String)this.jndiName, (Object)this);
        }
    }

    public void stop() {
        if (this.jndiName != null) {
            try {
                InitialContext ic = new InitialContext();
                org.jboss.util.naming.Util.unbind((Context)ic, (String)this.jndiName);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    public void stop(Object object) {
        if (!Proxy.isProxyClass(object.getClass())) {
            return;
        }
        ReplicatedInvocationHandler handler = (ReplicatedInvocationHandler)Proxy.getInvocationHandler(object);
        Channel c = handler.disp.getChannel();
        handler.disp.stop();
        c.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, S> T replicate(String mux_id, Class<T> iface, final S object, long startTimeout) throws Exception {
        Channel channel = this.channelFactory.createMultiplexerChannel(this.multiplexerStack, mux_id);
        Method[] methods = iface.getMethods();
        HashMap<Method, Short> methodMap = new HashMap<Method, Short>();
        final ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.getAnnotation(Replicated.class) == null) continue;
            methodList.add(method);
            methodMap.put(method, (short)(methodList.size() - 1));
        }
        Method createState = Streaming.class.getMethod(CREATE_STATE, String.class);
        methodList.add(createState);
        methodMap.put(createState, (short)(methodList.size() - 1));
        Method buildState = Streaming.class.getMethod(BUILD_STATE, String.class, byte[].class);
        methodList.add(buildState);
        methodMap.put(buildState, (short)(methodList.size() - 1));
        Method finishState = Streaming.class.getMethod(FINISH_STATE, String.class);
        methodList.add(finishState);
        methodMap.put(finishState, (short)(methodList.size() - 1));
        ReplicatedInvocationHandler proxy = new ReplicatedInvocationHandler(object, methodMap);
        RpcDispatcher disp = new RpcDispatcher(channel, (MessageListener)proxy, (MembershipListener)proxy, object){
            Map<List<?>, JGroupsInputStream> inputStreams;
            {
                super(x0, x1, x2, x3);
                this.inputStreams = new ConcurrentHashMap();
            }

            public Object handle(Message req) {
                Object body = null;
                if (req == null || req.getLength() == 0) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"message or message buffer is null");
                    }
                    return null;
                }
                try {
                    body = this.req_marshaller != null ? this.req_marshaller.objectFromByteBuffer(req.getBuffer(), req.getOffset(), req.getLength()) : req.getObject();
                }
                catch (Throwable e) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"exception marshalling object", e);
                    }
                    return e;
                }
                if (!(body instanceof MethodCall)) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"message does not contain a MethodCall object");
                    }
                    return new IllegalArgumentException("message does not contain a MethodCall object");
                }
                MethodCall method_call = (MethodCall)body;
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("[sender=" + req.getSrc() + "], method_call: " + method_call));
                    }
                    if (method_call.getId() >= methodList.size() - 3) {
                        if (req.getSrc().equals(this.local_addr)) {
                            return null;
                        }
                        Address address = req.getSrc();
                        String stateId = (String)method_call.getArgs()[0];
                        List<Serializable> key = Arrays.asList(stateId, address);
                        JGroupsInputStream is = this.inputStreams.get(key);
                        if (method_call.getId() == methodList.size() - 3) {
                            LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{object, "create state", stateId});
                            if (is != null) {
                                is.receive(null);
                            }
                            is = new JGroupsInputStream();
                            this.inputStreams.put(key, is);
                            JGroupsObjectReplicator.this.executor.execute(new StreamingRunner(object, stateId, is));
                        } else if (method_call.getId() == methodList.size() - 2) {
                            LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{object, "building state", stateId});
                            if (is != null) {
                                is.receive((byte[])method_call.getArgs()[1]);
                            }
                        } else if (method_call.getId() == methodList.size() - 1) {
                            LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{object, "finished state", stateId});
                            if (is != null) {
                                is.receive(null);
                            }
                            this.inputStreams.remove(key);
                        }
                        return null;
                    }
                    Method m = this.method_lookup.findMethod(method_call.getId());
                    if (m == null) {
                        throw new Exception("no method found for " + method_call.getId());
                    }
                    method_call.setMethod(m);
                    return method_call.invoke(this.server_obj);
                }
                catch (Throwable x) {
                    return x;
                }
            }
        };
        proxy.setDisp(disp);
        disp.setMethodLookup(new MethodLookup(){

            public Method findMethod(short id) {
                return (Method)methodList.get(id);
            }
        });
        Object replicatedProxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{iface}, proxy);
        boolean success = false;
        try {
            channel.connect(mux_id);
            if (object instanceof ReplicatedObject) {
                ((ReplicatedObject)object).setLocalAddress((Serializable)channel.getLocalAddress());
                boolean getState = channel.getState(null, startTimeout);
                if (getState) {
                    boolean loaded = (Boolean)proxy.state_promise.getResult(startTimeout);
                    if (loaded) {
                        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{object, "loaded"});
                    } else {
                        LogManager.logWarning((String)"org.teiid.RUNTIME", (String)(object + " load timeout"));
                    }
                } else {
                    LogManager.logInfo((String)"org.teiid.RUNTIME", (String)(object + " first member or timeout exceeded"));
                }
            }
            success = true;
            Object object2 = replicatedProxy;
            return (T)object2;
        }
        finally {
            if (!success) {
                channel.close();
            }
        }
    }

    private static interface Streaming {
        public void createState(String var1);

        public void buildState(String var1, byte[] var2);

        public void finishState(String var1);
    }

    private static final class ReplicatedInvocationHandler<S>
    extends ExtendedReceiverAdapter
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = -2943462899945966103L;
        private final S object;
        private RpcDispatcher disp;
        private final HashMap<Method, Short> methodMap;
        protected Vector<Address> remoteMembers = new Vector();
        protected final transient Promise<Boolean> state_promise = new Promise();

        private ReplicatedInvocationHandler(S object, HashMap<Method, Short> methodMap) {
            this.object = object;
            this.methodMap = methodMap;
        }

        public void setDisp(RpcDispatcher disp) {
            this.disp = disp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Short methodNum = this.methodMap.get(method);
            if (methodNum == null || this.remoteMembers.isEmpty()) {
                Replicated annotation;
                if (methodNum != null && (annotation = method.getAnnotation(Replicated.class)) != null && annotation.remoteOnly()) {
                    return null;
                }
                try {
                    return method.invoke(this.object, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            try {
                Replicated annotation = method.getAnnotation(Replicated.class);
                if (annotation.replicateState()) {
                    Object result = null;
                    try {
                        result = method.invoke(this.object, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                    if (!this.remoteMembers.isEmpty()) {
                        ReplicatedObject ro = (ReplicatedObject)this.object;
                        String stateId = (String)args[0];
                        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "replicating state", stateId});
                        JGroupsOutputStream oStream = new JGroupsOutputStream(this.disp, null, stateId, (short)(this.methodMap.size() - 3));
                        try {
                            ro.getState(stateId, (OutputStream)oStream);
                        }
                        finally {
                            oStream.close();
                        }
                        LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "sent state", stateId});
                    }
                    return result;
                }
                MethodCall call = new MethodCall(methodNum.shortValue(), args);
                Vector<Address> dests = null;
                if (annotation.remoteOnly()) {
                    Vector<Address> stateId = this.remoteMembers;
                    synchronized (stateId) {
                        if (this.remoteMembers.isEmpty()) {
                            return null;
                        }
                        dests = new Vector<Address>(this.remoteMembers);
                    }
                }
                RspList responses = this.disp.callRemoteMethods(dests, call, annotation.asynch() ? 6 : 2, annotation.timeout(), dests != null);
                if (annotation.asynch()) {
                    return null;
                }
                Vector results = responses.getResults();
                if (method.getReturnType() == Boolean.TYPE) {
                    for (Object o : results) {
                        if (Boolean.TRUE.equals(o)) continue;
                        return false;
                    }
                    return true;
                }
                if (method.getReturnType() == Collection.class) {
                    ArrayList result = new ArrayList();
                    for (Object o : results) {
                        result.addAll((Collection)o);
                    }
                    return results;
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(method + " " + args + " failed", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View newView) {
            if (newView.getMembers() != null) {
                Vector<Address> vector = this.remoteMembers;
                synchronized (vector) {
                    this.remoteMembers.removeAll(newView.getMembers());
                    if (this.object instanceof ReplicatedObject && !this.remoteMembers.isEmpty()) {
                        ((ReplicatedObject)this.object).droppedMembers(new HashSet<Address>(this.remoteMembers));
                    }
                    this.remoteMembers.clear();
                    this.remoteMembers.addAll(newView.getMembers());
                    this.remoteMembers.remove(this.disp.getChannel().getLocalAddress());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(InputStream istream) {
            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "loading initial state"});
            try {
                ((ReplicatedObject)this.object).setState(istream);
                this.state_promise.setResult((Object)Boolean.TRUE);
            }
            catch (Exception e) {
                this.state_promise.setResult((Object)Boolean.FALSE);
                LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (String)"error loading initial state");
            }
            finally {
                Util.close((InputStream)istream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(OutputStream ostream) {
            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{this.object, "getting initial state"});
            try {
                ((ReplicatedObject)this.object).getState(ostream);
            }
            catch (Exception e) {
                LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (String)"error gettting initial state");
            }
            finally {
                Util.close((OutputStream)ostream);
            }
        }
    }

    private final class StreamingRunner
    implements Runnable {
        private final Object object;
        private final String stateId;
        private final JGroupsInputStream is;

        private StreamingRunner(Object object, String stateId, JGroupsInputStream is) {
            this.object = object;
            this.stateId = stateId;
            this.is = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ((ReplicatedObject)this.object).setState(this.stateId, (InputStream)this.is);
                LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{"state set " + this.stateId});
            }
            catch (Exception e) {
                LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (String)("error setting state " + this.stateId));
            }
            finally {
                this.is.close();
            }
        }
    }
}

