/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.replication.jboss;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;

public class JGroupsOutputStream
extends OutputStream {
    static final int CHUNK_SIZE = 102400;
    protected final RpcDispatcher disp;
    protected final Vector<Address> dests;
    protected final String stateId;
    protected final short methodOffset;
    private volatile boolean closed = false;
    private final byte[] buffer = new byte[102400];
    private int index = 0;

    public JGroupsOutputStream(RpcDispatcher disp, Vector<Address> dests, String stateId, short methodOffset) {
        this.disp = disp;
        this.dests = dests;
        this.stateId = stateId;
        this.methodOffset = methodOffset;
        disp.callRemoteMethods(this.dests, new MethodCall(methodOffset, new Object[]{stateId}), 6, 0L, dests != null);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        try {
            this.disp.callRemoteMethods(this.dests, new MethodCall((short)(this.methodOffset + 2), new Object[]{this.stateId}), 6, 0L, this.dests != null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        try {
            if (this.index == 0) {
                return;
            }
            this.disp.callRemoteMethods(this.dests, new MethodCall((short)(this.methodOffset + 1), new Object[]{this.stateId, Arrays.copyOf(this.buffer, this.index)}), 6, 0L, this.dests != null);
            this.index = 0;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("output stream is closed");
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.index >= this.buffer.length) {
            this.flush();
        }
        this.buffer[this.index++] = (byte)b;
    }
}

