/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.jboss;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.teiid.cache.jboss.ClusteredTupleBatchCacheLoader;
import org.teiid.cache.jboss.TupleBatchCacheLoaderConfig;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.process.SerializableTupleBatch;

public class TupleBatchCacheLoader
extends ClusteredTupleBatchCacheLoader {
    private BufferManager bufferMgr;
    private CacheLoaderConfig.IndividualCacheLoaderConfig config;

    @Override
    public boolean exists(Fqn fqn) throws Exception {
        String id = fqn.getLastElementAsString();
        int index = id.indexOf(44);
        return index != -1;
    }

    @Override
    public Map<Object, Object> get(Fqn fqn) throws Exception {
        String id = fqn.getLastElementAsString();
        int index = id.indexOf(44);
        if (index != -1) {
            String uuid = id.substring(0, index);
            int row = Integer.parseInt(id.substring(index + 1));
            TupleBuffer tb = this.bufferMgr.getTupleBuffer(uuid);
            if (tb != null) {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                TupleBatch b = tb.getBatch(row);
                map.put(id, new SerializableTupleBatch(b, tb.getTypes()));
                return map;
            }
        }
        return super.get(fqn);
    }

    @Override
    public Set<?> getChildrenNames(Fqn fqn) throws Exception {
        return super.getChildrenNames(fqn);
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    @Override
    public Object put(Fqn fqn, Object key, Object value) throws Exception {
        return super.put(fqn, key, value);
    }

    @Override
    public void remove(Fqn fqn) throws Exception {
        super.remove(fqn);
    }

    @Override
    public Object remove(Fqn fqn, Object key) throws Exception {
        return super.remove(fqn, key);
    }

    @Override
    public void removeData(Fqn fqn) throws Exception {
        super.removeData(fqn);
    }

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig config) {
        if (!(config instanceof TupleBatchCacheLoaderConfig)) {
            throw new TeiidRuntimeException("Wrong Configuration");
        }
        this.config = config;
        TupleBatchCacheLoaderConfig bmc = (TupleBatchCacheLoaderConfig)config;
        this.bufferMgr = bmc.getBufferService().getBufferManager();
        super.setConfig(config);
    }
}

