/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.jboss;

import java.util.HashSet;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.teiid.cache.DefaultCache;
import org.teiid.cache.jboss.JBossCache;

public class ExpirationAwareCache<K, V>
extends JBossCache<K, V> {
    public ExpirationAwareCache(Cache cacheStore, Fqn fqn) {
        super(cacheStore, fqn);
    }

    @Override
    public V get(K key) {
        Node node = this.getRootNode();
        Node child = node.getChild(this.getFqn(key));
        if (child != null) {
            return (V)child.get(key);
        }
        return null;
    }

    private Fqn<String> getFqn(K key) {
        return Fqn.fromString((String)String.valueOf(key.getClass().getSimpleName() + key.hashCode()));
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, null);
    }

    @Override
    public V put(K key, V value, Long ttl) {
        Node node = this.getRootNode();
        Node child = node.addChild(this.getFqn(key));
        long future = DefaultCache.getExpirationTime((long)(this.config.getMaxAgeInSeconds() * 1000), (Long)ttl);
        child.put((Object)"expiration", (Object)future);
        return (V)child.put(key, value);
    }

    @Override
    public V remove(K key) {
        Node node = this.getRootNode();
        Node child = node.getChild(this.getFqn(key));
        if (child != null) {
            return (V)child.remove(key);
        }
        return null;
    }

    @Override
    public void clear() {
        Node node = this.getRootNode();
        node.clearData();
        HashSet nodes = new HashSet(node.getChildren());
        for (Node child : nodes) {
            child.clearData();
            node.removeChild(child.getFqn());
        }
    }

    @Override
    public int size() {
        Node node = this.getRootNode();
        return node.getChildren().size();
    }
}

