/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.jboss;

import java.io.Serializable;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.FIFOAlgorithmConfig;
import org.jboss.cache.eviction.LFUAlgorithmConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.jboss.JBossCache;
import org.teiid.core.TeiidRuntimeException;

public class JBossCacheFactory
implements CacheFactory,
Serializable {
    private transient org.jboss.cache.Cache cacheStore;
    private volatile boolean destroyed = false;

    public void setCacheName(String jmxName) {
        try {
            MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
            ObjectName on = new ObjectName(jmxName);
            CacheJmxWrapperMBean cacheWrapper = MBeanServerInvocationHandler.newProxyInstance(server, on, CacheJmxWrapperMBean.class, false);
            this.cacheStore = cacheWrapper.getCache();
        }
        catch (MalformedObjectNameException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public Cache get(Cache.Type type, CacheConfiguration config) {
        if (!this.destroyed) {
            Node cacheRoot = this.cacheStore.getRoot().addChild(Fqn.fromString((String)"Teiid"));
            Node node = cacheRoot.addChild(Fqn.fromString((String)type.location()));
            Region cacheRegion = this.cacheStore.getRegion(node.getFqn(), true);
            EvictionRegionConfig erc = new EvictionRegionConfig(node.getFqn(), this.buildEvictionAlgorithmConfig(config));
            cacheRegion.setEvictionRegionConfig(erc);
            return new JBossCache(this.cacheStore, node.getFqn());
        }
        throw new TeiidRuntimeException("Cache system has been shutdown");
    }

    private EvictionAlgorithmConfig buildEvictionAlgorithmConfig(CacheConfiguration config) {
        FIFOAlgorithmConfig evictionConfig = null;
        if (config.getPolicy() == CacheConfiguration.Policy.LRU) {
            LRUAlgorithmConfig lru = new LRUAlgorithmConfig();
            lru.setMaxNodes(config.getMaxNodes());
            lru.setMaxAge((long)(config.getMaxAgeInSeconds() * 1000));
            lru.setTimeToLive(-1L);
            evictionConfig = lru;
        } else if (config.getPolicy() == CacheConfiguration.Policy.FIFO) {
            FIFOAlgorithmConfig fifo = new FIFOAlgorithmConfig();
            fifo.setMaxNodes(config.getMaxNodes());
            evictionConfig = fifo;
        } else if (config.getPolicy() == CacheConfiguration.Policy.LFU) {
            LFUAlgorithmConfig lfu = new LFUAlgorithmConfig();
            lfu.setMaxNodes(config.getMaxNodes());
            evictionConfig = lfu;
        }
        return evictionConfig;
    }

    public void destroy() {
        this.destroyed = true;
    }

    public void stop() {
        this.destroy();
    }
}

