/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.teiid.CommandContext;
import org.teiid.UserDefinedAggregate;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.AggregateAttributes;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.Grant;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.NamespaceContainer;
import org.teiid.metadata.Parser;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.VDBResource;
import org.teiid.translator.TypeFacility;

public class MetadataFactory
extends NamespaceContainer {
    private static final long serialVersionUID = 8590341087771685630L;
    private String vdbName;
    private String vdbVersion;
    private Map<String, Datatype> dataTypes;
    private boolean autoCorrectColumnNames = true;
    private String rawMetadata;
    private Properties modelProperties;
    private Schema schema = new Schema();
    private String idPrefix;
    protected int count;
    private transient Parser parser;
    private transient ModelMetaData model;
    private transient Map<String, ? extends VDBResource> vdbResources;
    private Map<String, Grant> grants;

    public MetadataFactory(String vdbName, Object vdbVersion, Map<String, Datatype> runtimeTypes, ModelMetaData model) {
        this(vdbName, vdbVersion, model.getName(), runtimeTypes, model.getProperties(), model.getSchemaText());
        this.model = model;
    }

    public MetadataFactory(String vdbName, Object vdbVersion, String schemaName, Map<String, Datatype> runtimeTypes, Properties modelProperties, String rawMetadata) {
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion.toString();
        this.dataTypes = Collections.unmodifiableMap(runtimeTypes);
        this.schema.setName(schemaName);
        long msb = this.longHash(vdbName, 0L);
        try {
            int val = Integer.parseInt(this.vdbVersion);
            msb = 31L * msb + (long)val;
        }
        catch (NumberFormatException e) {
            msb = 31L * msb + (long)vdbVersion.hashCode();
        }
        msb = this.longHash(schemaName, msb);
        this.idPrefix = "tid:" + MetadataFactory.hex(msb, 12);
        this.setUUID(this.schema);
        if (modelProperties != null) {
            for (Map.Entry<Object, Object> entry : modelProperties.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                this.schema.setProperty(MetadataFactory.resolvePropertyKey(this, (String)entry.getKey()), (String)entry.getValue());
            }
        }
        this.modelProperties = modelProperties;
        this.rawMetadata = rawMetadata;
    }

    private long longHash(String s, long h) {
        if (s == null) {
            return h;
        }
        for (int i = 0; i < s.length(); ++i) {
            h = 31L * h + (long)s.charAt(i);
        }
        return h;
    }

    public static String hex(long val, int hexLength) {
        long hi = 1L << Math.min(63, hexLength * 4);
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    @Deprecated
    public Properties getImportProperties() {
        return this.modelProperties;
    }

    public Properties getModelProperties() {
        return this.modelProperties;
    }

    @Deprecated
    public String getRawMetadata() {
        return this.rawMetadata;
    }

    public Model getModel() {
        return this.model;
    }

    protected void setUUID(AbstractMetadataRecord record) {
        int lsb = 0;
        if (record.getParent() != null) {
            lsb = record.getParent().getUUID().hashCode();
        }
        lsb = 31 * lsb + record.getName().hashCode();
        String uuid = this.idPrefix + "-" + MetadataFactory.hex(lsb, 8) + "-" + MetadataFactory.hex(this.count++, 8);
        record.setUUID(uuid);
    }

    public String getName() {
        return this.schema.getName();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Table addTable(String name) {
        Table table = new Table();
        table.setTableType(Table.Type.Table);
        table.setName(name);
        this.setUUID(table);
        this.schema.addTable(table);
        return table;
    }

    public Column addColumn(String name, String type, ColumnSet<?> table) {
        if (this.autoCorrectColumnNames) {
            name = name.replace('.', '_');
        } else if (name.indexOf(46) != -1) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60008, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60008, new Object[]{table.getFullName(), name}));
        }
        if (table.getColumnByName(name) != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60016, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60016, new Object[]{table.getFullName() + '.' + name}));
        }
        Column column = new Column();
        column.setName(name);
        table.addColumn(column);
        column.setParent(table);
        column.setPosition(table.getColumns().size());
        MetadataFactory.setDataType(type, column, this.dataTypes, false);
        this.setUUID(column);
        return column;
    }

    public Column renameColumn(String oldName, String name, ColumnSet<?> table) {
        if (this.autoCorrectColumnNames) {
            name = name.replace('.', '_');
        } else if (name.indexOf(46) != -1) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60008, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60008, new Object[]{table.getFullName(), name}));
        }
        if (table.getColumnByName(name) != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60016, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60016, new Object[]{table.getFullName() + '.' + name}));
        }
        Column column = table.getColumnByName(oldName);
        table.removeColumn(column);
        column.setName(name);
        table.addColumn(column);
        return column;
    }

    public static Datatype setDataType(String type, BaseColumn column, Map<String, Datatype> dataTypes, boolean allowNull) {
        int arrayDimensions = 0;
        while (DataTypeManager.isArrayType((String)type)) {
            ++arrayDimensions;
            type = type.substring(0, type.length() - 2);
        }
        Datatype datatype = dataTypes.get(type);
        if (!(datatype != null || allowNull && "null".equals(type))) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60009, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60009, new Object[]{type}));
        }
        column.setDatatype(datatype, true, arrayDimensions);
        return datatype;
    }

    public KeyRecord addPrimaryKey(String name, List<String> columnNames, Table table) {
        KeyRecord primaryKey = new KeyRecord(KeyRecord.Type.Primary);
        primaryKey.setParent(table);
        primaryKey.setColumns(new ArrayList<Column>(columnNames.size()));
        primaryKey.setName(name);
        this.setUUID(primaryKey);
        this.assignColumns(columnNames, table, primaryKey);
        table.setPrimaryKey(primaryKey);
        return primaryKey;
    }

    public KeyRecord addAccessPattern(String name, List<String> columnNames, Table table) {
        KeyRecord ap = new KeyRecord(KeyRecord.Type.AccessPattern);
        ap.setParent(table);
        ap.setColumns(new ArrayList<Column>(columnNames.size()));
        ap.setName(name);
        this.setUUID(ap);
        this.assignColumns(columnNames, table, ap);
        table.getAccessPatterns().add(ap);
        return ap;
    }

    public KeyRecord addIndex(String name, boolean nonUnique, List<String> columnNames, Table table) {
        KeyRecord index = new KeyRecord(nonUnique ? KeyRecord.Type.Index : KeyRecord.Type.Unique);
        index.setParent(table);
        index.setColumns(new ArrayList<Column>(columnNames.size()));
        index.setName(name);
        this.assignColumns(columnNames, table, index);
        this.setUUID(index);
        if (nonUnique) {
            table.getIndexes().add(index);
        } else {
            table.getUniqueKeys().add(index);
        }
        return index;
    }

    public KeyRecord addFunctionBasedIndex(String name, List<String> expressions, List<Boolean> nonColumnExpressions, Table table) {
        KeyRecord index = new KeyRecord(KeyRecord.Type.Index);
        index.setParent(table);
        index.setColumns(new ArrayList<Column>(expressions.size()));
        index.setName(name);
        this.setUUID(index);
        boolean functionBased = false;
        for (int i = 0; i < expressions.size(); ++i) {
            String expr = expressions.get(i);
            if (nonColumnExpressions.get(i).booleanValue()) {
                Column c = new Column();
                c.setName(expr);
                c.setNameInSource(expr);
                this.setUUID(c);
                c.setParent(index);
                c.setPosition(i + 1);
                index.getColumns().add(c);
                functionBased = true;
                continue;
            }
            this.assignColumn(table, index, expr);
        }
        if (!functionBased) {
            table.getIndexes().add(index);
        } else {
            table.getFunctionBasedIndexes().add(index);
        }
        return index;
    }

    private void assignColumn(Table table, ColumnSet<?> columns, String columnName) {
        Column column = table.getColumnByName(columnName);
        if (column == null) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60011, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60011, new Object[]{table.getFullName(), columnName}));
        }
        columns.getColumns().add(column);
    }

    public ForeignKey addForiegnKey(String name, List<String> columnNames, String referenceTable, Table table) {
        return this.addForiegnKey(name, columnNames, null, referenceTable, table);
    }

    public ForeignKey addForiegnKey(String name, List<String> columnNames, List<String> referencedColumnNames, String referenceTable, Table table) {
        ForeignKey foreignKey = new ForeignKey();
        foreignKey.setParent(table);
        foreignKey.setColumns(new ArrayList<Column>(columnNames.size()));
        this.assignColumns(columnNames, table, foreignKey);
        foreignKey.setReferenceTableName(referenceTable);
        foreignKey.setReferenceColumns(referencedColumnNames);
        foreignKey.setName(name);
        this.setUUID(foreignKey);
        table.getForeignKeys().add(foreignKey);
        return foreignKey;
    }

    public Procedure addProcedure(String name) {
        Procedure procedure = new Procedure();
        procedure.setName(name);
        this.setUUID(procedure);
        procedure.setParameters(new LinkedList<ProcedureParameter>());
        this.schema.addProcedure(procedure);
        return procedure;
    }

    public ProcedureParameter addProcedureParameter(String name, String type, ProcedureParameter.Type parameterType, Procedure procedure) {
        ProcedureParameter param = new ProcedureParameter();
        param.setName(name);
        this.setUUID(param);
        param.setType(parameterType);
        param.setProcedure(procedure);
        MetadataFactory.setDataType(type, param, this.dataTypes, false);
        if (parameterType == ProcedureParameter.Type.ReturnValue) {
            procedure.getParameters().add(0, param);
            for (int i = 0; i < procedure.getParameters().size(); ++i) {
                procedure.getParameters().get(i).setPosition(i + 1);
            }
        } else {
            procedure.getParameters().add(param);
            param.setPosition(procedure.getParameters().size());
        }
        return param;
    }

    public Column addProcedureResultSetColumn(String name, String type, Procedure procedure) {
        if (procedure.getResultSet() == null) {
            ColumnSet<Procedure> resultSet = new ColumnSet<Procedure>();
            resultSet.setParent(procedure);
            resultSet.setName("RSParam");
            this.setUUID(resultSet);
            procedure.setResultSet(resultSet);
        }
        return this.addColumn(name, type, procedure.getResultSet());
    }

    private void assignColumns(List<String> columnNames, Table table, ColumnSet<?> columns) {
        for (String columnName : columnNames) {
            this.assignColumn(table, columns, columnName);
        }
    }

    public FunctionMethod addFunction(String name) {
        FunctionMethod function = new FunctionMethod();
        function.setName(name);
        this.setUUID(function);
        this.schema.addFunction(function);
        return function;
    }

    public FunctionMethod addFunction(String name, String returnType, String ... paramTypes) {
        FunctionMethod function = FunctionMethod.createFunctionMethod(name, null, null, returnType, paramTypes);
        this.setFunctionMethodTypes(function);
        function.setPushdown(FunctionMethod.PushDown.MUST_PUSHDOWN);
        this.setUUID(function);
        this.schema.addFunction(function);
        return function;
    }

    private void setFunctionMethodTypes(FunctionMethod function) {
        FunctionParameter outputParameter = function.getOutputParameter();
        if (outputParameter != null) {
            MetadataFactory.setDataType(outputParameter.getRuntimeType(), outputParameter, this.dataTypes, outputParameter.getNullType() == BaseColumn.NullType.Nullable);
        }
        for (FunctionParameter param : function.getInputParameters()) {
            MetadataFactory.setDataType(param.getRuntimeType(), param, this.dataTypes, param.getNullType() == BaseColumn.NullType.Nullable);
        }
    }

    public FunctionMethod addFunction(String name, Method method) {
        FunctionMethod func = MetadataFactory.createFunctionFromMethod(name, method);
        this.setFunctionMethodTypes(func);
        this.setUUID(func);
        this.getSchema().addFunction(func);
        return func;
    }

    public static FunctionMethod createFunctionFromMethod(String name, Method method) {
        Class<?> returnTypeClass = method.getReturnType();
        AggregateAttributes aa = null;
        if ((method.getModifiers() & 8) == 0 && UserDefinedAggregate.class.isAssignableFrom(method.getDeclaringClass())) {
            Method m;
            aa = new AggregateAttributes();
            try {
                m = method.getDeclaringClass().getMethod("getResult", CommandContext.class);
            }
            catch (NoSuchMethodException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
            catch (SecurityException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
            returnTypeClass = m.getReturnType();
        }
        if (returnTypeClass.isPrimitive()) {
            returnTypeClass = TypeFacility.convertPrimitiveToObject(returnTypeClass);
        }
        String returnType = DataTypeManager.getDataTypeName(returnTypeClass);
        Class<?>[] params = method.getParameterTypes();
        String[] paramTypes = new String[params.length];
        boolean nullOnNull = false;
        for (int i = 0; i < params.length; ++i) {
            Class<?> clazz = params[i];
            if (clazz.isPrimitive()) {
                nullOnNull = true;
                clazz = TypeFacility.convertPrimitiveToObject(clazz);
            }
            paramTypes[i] = method.isVarArgs() && i == params.length - 1 ? DataTypeManager.getDataTypeName(clazz.getComponentType()) : DataTypeManager.getDataTypeName(clazz);
        }
        if (params.length > 0 && CommandContext.class.isAssignableFrom(params[0])) {
            paramTypes = Arrays.copyOfRange(paramTypes, 1, paramTypes.length);
        }
        FunctionMethod func = FunctionMethod.createFunctionMethod(name, null, null, returnType, paramTypes);
        func.setAggregateAttributes(aa);
        func.setInvocationMethod(method.getName());
        func.setPushdown(FunctionMethod.PushDown.CAN_PUSHDOWN);
        func.setMethod(method);
        func.setInvocationClass(method.getDeclaringClass().getName());
        func.setNullOnNull(nullOnNull);
        if (method.isVarArgs()) {
            func.setVarArgs(method.isVarArgs());
        }
        return func;
    }

    public void setAutoCorrectColumnNames(boolean autoCorrectColumnNames) {
        this.autoCorrectColumnNames = autoCorrectColumnNames;
    }

    public void mergeInto(MetadataStore store) {
        store.addSchema(this.schema);
        store.addDataTypes(this.dataTypes);
        if (this.grants != null) {
            store.addGrants(this.grants.values());
        }
    }

    public MetadataStore asMetadataStore() {
        MetadataStore store = new MetadataStore();
        this.mergeInto(store);
        return store;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Map<String, Datatype> getDataTypes() {
        return this.dataTypes;
    }

    public void correctDatatypes(Map<String, Datatype> dt) {
        this.dataTypes = dt;
        for (Table t : this.schema.getTables().values()) {
            this.correctDataTypes(t.getColumns());
        }
        for (AbstractMetadataRecord p : this.schema.getProcedures().values()) {
            this.correctDataTypes(((Procedure)p).getParameters());
            if (((Procedure)p).getResultSet() == null) continue;
            this.correctDataTypes(((Procedure)p).getResultSet().getColumns());
        }
        for (AbstractMetadataRecord p : this.schema.getFunctions().values()) {
            this.correctDataTypes(((FunctionMethod)p).getInputParameters());
        }
    }

    private void correctDataTypes(List<? extends BaseColumn> cols) {
        if (cols == null) {
            return;
        }
        for (BaseColumn baseColumn : cols) {
            Datatype datatype = baseColumn.getDatatype();
            String name = null;
            name = datatype == null ? baseColumn.getRuntimeType() : datatype.getName();
            Datatype dt = this.dataTypes.get(name);
            if (dt == null) continue;
            baseColumn.setDatatype(dt, false, baseColumn.getArrayDimensions());
        }
    }

    public String getVdbName() {
        return this.vdbName;
    }

    public String getVdbVersion() {
        return this.vdbVersion;
    }

    @Override
    public Map<String, String> getNamespaces() {
        if (this.namespaces == null) {
            return Collections.emptyMap();
        }
        return this.namespaces;
    }

    public void parse(Reader ddl) throws MetadataException {
        this.parser.parseDDL(this, ddl);
        HashSet<FunctionMethod> functions = new HashSet<FunctionMethod>();
        for (FunctionMethod functionMethod : this.getSchema().getFunctions().values()) {
            if (functions.add(functionMethod)) continue;
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60015, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60015, new Object[]{functionMethod.getName()}));
        }
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public void setModel(ModelMetaData model) {
        this.model = model;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Map<String, ? extends VDBResource> getVDBResources() {
        return this.vdbResources;
    }

    public void setVdbResources(Map<String, ? extends VDBResource> vdbResources) {
        this.vdbResources = vdbResources;
    }

    public void addPermission(String role, AbstractMetadataRecord resource, Boolean allowAlter, Boolean allowCreate, Boolean allowRead, Boolean allowUpdate, Boolean allowDelete, Boolean allowExecute, String condition, Boolean constraint) {
        Grant.Permission pmd = new Grant.Permission();
        pmd.setResourceName(resource.getFullName());
        if (resource instanceof Table) {
            pmd.setResourceType(Database.ResourceType.TABLE);
        } else {
            pmd.setResourceType(Database.ResourceType.PROCEDURE);
        }
        pmd.setAllowAlter(allowAlter);
        pmd.setAllowInsert(allowCreate);
        pmd.setAllowDelete(allowDelete);
        pmd.setAllowExecute(allowExecute);
        pmd.setAllowSelect(allowRead);
        pmd.setAllowUpdate(allowUpdate);
        pmd.setCondition(condition, constraint);
        this.addPermission(pmd, role);
    }

    public void addSchemaPermission(String role, Boolean allowAlter, Boolean allowCreate, Boolean allowRead, Boolean allowUpdate, Boolean allowDelete, Boolean allowExecute) {
        Grant.Permission pmd = new Grant.Permission();
        pmd.setResourceName(this.schema.getFullName());
        pmd.setResourceType(Database.ResourceType.SCHEMA);
        pmd.setAllowAlter(allowAlter);
        pmd.setAllowInsert(allowCreate);
        pmd.setAllowDelete(allowDelete);
        pmd.setAllowExecute(allowExecute);
        pmd.setAllowSelect(allowRead);
        pmd.setAllowUpdate(allowUpdate);
        this.addPermission(pmd, role);
    }

    public void addColumnPermission(String role, Column resource, Boolean allowCreate, Boolean allowRead, Boolean allowUpdate, String condition, String mask, Integer order) {
        Grant.Permission pmd = new Grant.Permission();
        pmd.setResourceType(Database.ResourceType.COLUMN);
        String resourceName = null;
        resourceName = resource.getParent() != null && ((ColumnSet)resource.getParent()).getParent() instanceof Procedure ? ((AbstractMetadataRecord)((ColumnSet)resource.getParent()).getParent()).getFullName() + '.' + resource.getName() : resource.getFullName();
        pmd.setResourceName(resourceName);
        pmd.setAllowInsert(allowCreate);
        pmd.setAllowSelect(allowRead);
        pmd.setAllowUpdate(allowUpdate);
        pmd.setCondition(condition, null);
        pmd.setMask(mask);
        pmd.setMaskOrder(order);
        this.addPermission(pmd, role);
    }

    private void addPermission(Grant.Permission pmd, String role) {
        Grant g;
        if (this.grants == null) {
            this.grants = new TreeMap<String, Grant>();
        }
        if ((g = this.grants.get(role)) == null) {
            g = new Grant();
            g.setRole(role);
            this.grants.put(role, g);
        }
        g.addPermission(pmd);
    }

    public void addFunction(FunctionMethod functionMethod) {
        functionMethod.setParent(this.schema);
        this.setUUID(functionMethod);
        for (FunctionParameter param : functionMethod.getInputParameters()) {
            this.setUUID(param);
        }
        this.setUUID(functionMethod.getOutputParameter());
        this.schema.addFunction(functionMethod);
    }
}

