/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.Grant;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.Role;
import org.teiid.metadata.Schema;

public class MetadataStore
implements Serializable {
    private static final long serialVersionUID = -3130247626435324312L;
    protected NavigableMap<String, Schema> schemas = new TreeMap<String, Schema>(String.CASE_INSENSITIVE_ORDER);
    protected List<Schema> schemaList = new ArrayList<Schema>();
    protected NavigableMap<String, Datatype> datatypes = new TreeMap<String, Datatype>(String.CASE_INSENSITIVE_ORDER);
    protected NavigableMap<String, Datatype> unmondifiableDatatypes = Collections.unmodifiableNavigableMap(this.datatypes);
    private Map<String, Grant> grants = new TreeMap<String, Grant>(String.CASE_INSENSITIVE_ORDER);
    protected LinkedHashMap<String, Role> roles = new LinkedHashMap();

    public NavigableMap<String, Schema> getSchemas() {
        return this.schemas;
    }

    public Schema getSchema(String name) {
        return (Schema)this.schemas.get(name);
    }

    public void addSchema(Schema schema) {
        if (this.schemas.put(schema.getName(), schema) != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60012, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60012, new Object[]{schema.getName()}));
        }
        this.schemaList.add(schema);
    }

    public List<Schema> getSchemaList() {
        return this.schemaList;
    }

    public Schema removeSchema(String schemaName) {
        Schema s = (Schema)this.schemas.remove(schemaName);
        if (s != null) {
            this.schemaList.remove(s);
        }
        return s;
    }

    public void addDataTypes(Map<String, Datatype> typeMap) {
        if (typeMap != null) {
            for (Map.Entry<String, Datatype> entry : typeMap.entrySet()) {
                this.addDatatype(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addDatatype(String name, Datatype datatype) {
        if (!this.datatypes.containsKey(name)) {
            this.datatypes.put(name, datatype);
        }
    }

    public NavigableMap<String, Datatype> getDatatypes() {
        return this.unmondifiableDatatypes;
    }

    public NavigableMap<String, Datatype> getDatatypesExcludingAliases() {
        TreeMap<String, Datatype> result = new TreeMap<String, Datatype>();
        for (Map.Entry entry : this.datatypes.entrySet()) {
            if (!((String)entry.getKey()).equals(((Datatype)entry.getValue()).getName())) continue;
            result.put((String)entry.getKey(), (Datatype)entry.getValue());
        }
        return result;
    }

    public void merge(MetadataStore store) {
        if (store != null) {
            for (Schema s : store.getSchemaList()) {
                this.addSchema(s);
            }
            this.addDataTypes(store.getDatatypes());
            this.addGrants(store.grants.values());
            this.roles.putAll(store.roles);
        }
    }

    void addGrants(Collection<Grant> grants) {
        if (grants == null) {
            return;
        }
        for (Grant g : grants) {
            this.addGrant(g);
        }
    }

    void addGrant(Grant grant) {
        if (grant == null) {
            return;
        }
        Grant previous = this.grants.get(grant.getRole());
        if (previous == null) {
            this.grants.put(grant.getRole(), grant);
        } else {
            for (Grant.Permission addPermission : grant.getPermissions()) {
                boolean found = false;
                for (Grant.Permission currentPermission : new ArrayList<Grant.Permission>(previous.getPermissions())) {
                    if (currentPermission.resourceMatches(addPermission)) {
                        found = true;
                        if (addPermission.getMask() != null) {
                            if (currentPermission.getMask() != null) {
                                throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60035, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60035, new Object[]{addPermission.getMask(), currentPermission.getMask()}));
                            }
                            currentPermission.setMask(addPermission.getMask());
                            currentPermission.setMaskOrder(addPermission.getMaskOrder());
                        }
                        if (addPermission.getCondition() != null) {
                            if (currentPermission.getCondition() != null) {
                                throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60036, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60036, new Object[]{addPermission.getMask(), currentPermission.getMask()}));
                            }
                            currentPermission.setCondition(addPermission.getCondition(), addPermission.isConditionAConstraint());
                        }
                        currentPermission.appendPrivileges(addPermission.getPrivileges());
                    }
                    if (currentPermission.getPrivileges().isEmpty() && currentPermission.getRevokePrivileges().isEmpty() && currentPermission.getCondition() == null && currentPermission.getMask() == null) {
                        previous.removePermission(currentPermission);
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                previous.addPermission(addPermission);
            }
            if (previous.getPermissions().isEmpty()) {
                this.grants.remove(grant.getRole());
            }
        }
    }

    public void removeGrant(Grant toRemoveGrant) {
        if (toRemoveGrant == null) {
            return;
        }
        Grant previous = this.grants.get(toRemoveGrant.getRole());
        if (previous == null) {
            this.grants.put(toRemoveGrant.getRole(), toRemoveGrant);
        } else {
            for (Grant.Permission revokePermission : toRemoveGrant.getPermissions()) {
                boolean found = false;
                for (Grant.Permission currentPermission : new ArrayList<Grant.Permission>(previous.getPermissions())) {
                    if (currentPermission.resourceMatches(revokePermission)) {
                        found = true;
                        if (revokePermission.getMask() != null && currentPermission.getMask() != null) {
                            currentPermission.setMask(null);
                            currentPermission.setMaskOrder(null);
                        }
                        if (revokePermission.getCondition() != null && currentPermission.getCondition() != null) {
                            currentPermission.setCondition(null, null);
                        }
                        currentPermission.removePrivileges(revokePermission.getRevokePrivileges());
                    }
                    if (currentPermission.getPrivileges().isEmpty() && currentPermission.getRevokePrivileges().isEmpty() && currentPermission.getCondition() == null && currentPermission.getMask() == null) {
                        previous.removePermission(currentPermission);
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                previous.addPermission(revokePermission);
            }
            if (previous.getPermissions().isEmpty()) {
                this.grants.remove(toRemoveGrant.getRole());
            }
        }
    }

    public Collection<Grant> getGrants() {
        return this.grants.values();
    }

    void addRole(Role role) {
        this.roles.put(role.getName(), role);
    }

    Role getRole(String roleName) {
        return this.roles.get(roleName);
    }

    Collection<Role> getRoles() {
        return this.roles.values();
    }

    Role removeRole(String roleName) {
        return (Role)this.roles.remove(roleName);
    }
}

