/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import org.teiid.connector.DataPlugin;

public interface FileConnection
extends Connection {
    public File getFile(String var1) throws ResourceException;

    public static class Util {
        public static File[] getFiles(String location, FileConnection fc, boolean exceptionIfFileNotFound) throws ResourceException {
            File datafile = fc.getFile(location);
            if (datafile.isDirectory()) {
                return datafile.listFiles();
            }
            if (datafile.exists()) {
                return new File[]{datafile};
            }
            File parentDir = datafile.getParentFile();
            if (parentDir == null || !parentDir.exists()) {
                if (exceptionIfFileNotFound) {
                    throw new ResourceException(DataPlugin.Util.gs("file_not_found", new Object[]{location}));
                }
                return null;
            }
            if (location.contains("*")) {
                location = location.replaceAll("\\\\", "\\\\\\\\");
                location = location.replaceAll("\\?", "\\\\?");
                location = location.replaceAll("\\[", "\\\\[");
                location = location.replaceAll("\\{", "\\\\{");
                final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + location);
                FileFilter fileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && matcher.matches(FileSystems.getDefault().getPath(pathname.getName(), new String[0]));
                    }
                };
                return parentDir.listFiles(fileFilter);
            }
            if (exceptionIfFileNotFound) {
                throw new ResourceException(DataPlugin.Util.gs("file_not_found", new Object[]{location}));
            }
            return null;
        }
    }
}

