/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.DataWrapper;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.Grant;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Role;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Server;

public class Database
extends AbstractMetadataRecord {
    private static final long serialVersionUID = 7595765832848232840L;
    protected MetadataStore store = new MetadataStore();
    protected NavigableMap<String, DataWrapper> wrappers = new TreeMap<String, DataWrapper>(String.CASE_INSENSITIVE_ORDER);
    protected NavigableMap<String, Server> servers = new TreeMap<String, Server>(String.CASE_INSENSITIVE_ORDER);
    protected Map<String, String> namespaces;
    private String version;

    public Database(String dbName) {
        super.setName(dbName);
        this.version = "1";
    }

    public Database(String dbName, String version) {
        super.setName(dbName);
        this.version = version;
    }

    public void addSchema(Schema schema) {
        Schema s = this.store.getSchema(schema.getName());
        if (s != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60021, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60021, new Object[]{schema.getName()}));
        }
        this.store.addSchema(schema);
    }

    public Schema getSchema(String schemaName) {
        return this.store.getSchema(schemaName);
    }

    public List<Schema> getSchemas() {
        return new ArrayList<Schema>(this.store.getSchemaList());
    }

    public Schema removeSchema(String schemaName) {
        Schema s = this.getSchema(schemaName);
        if (s == null) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60024, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60024, new Object[]{schemaName}));
        }
        return this.store.removeSchema(schemaName);
    }

    public MetadataStore getMetadataStore() {
        return this.store;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void addDataWrapper(DataWrapper wrapper) {
        DataWrapper w = (DataWrapper)this.wrappers.get(wrapper.getName());
        if (w != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60022, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60022, new Object[]{wrapper.getName()}));
        }
        this.wrappers.put(wrapper.getName(), wrapper);
    }

    public DataWrapper removeDataWrapper(String wrapperName) {
        DataWrapper wrapper = (DataWrapper)this.wrappers.get(wrapperName);
        if (wrapper == null) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60023, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60023, new Object[]{wrapperName}));
        }
        return (DataWrapper)this.wrappers.remove(wrapperName);
    }

    public DataWrapper getDataWrapper(String wrapperName) {
        return (DataWrapper)this.wrappers.get(wrapperName);
    }

    public List<DataWrapper> getDataWrappers() {
        return new ArrayList<DataWrapper>(this.wrappers.values());
    }

    public void addServer(Server server) {
        Server s = (Server)this.servers.get(server.getName());
        if (s != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60026, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60026, new Object[]{server.getName()}));
        }
        this.servers.put(server.getName(), server);
    }

    public Server removeServer(String serverName) {
        Server server = (Server)this.servers.get(serverName);
        if (server == null) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60027, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60027, new Object[]{serverName}));
        }
        return (Server)this.servers.remove(serverName);
    }

    public Server getServer(String serverName) {
        return (Server)this.servers.get(serverName);
    }

    public List<Server> getServers() {
        return new ArrayList<Server>(this.servers.values());
    }

    public void addNamespace(String prefix, String uri) {
        String validURI;
        if (uri == null || uri.indexOf(125) != -1) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60018, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60018, new Object[]{uri}));
        }
        if (StringUtil.startsWithIgnoreCase((String)prefix, (String)"teiid_") && ((validURI = MetadataFactory.BUILTIN_NAMESPACES.get(prefix)) == null || !uri.equals(validURI))) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60017, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60017, new Object[]{prefix}));
        }
        if (this.namespaces == null) {
            this.namespaces = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.namespaces.put(prefix, uri);
    }

    public String resolveNamespaceInPropertyKey(String key) {
        int index = key.indexOf(58);
        if (index > 0 && index < key.length() - 1) {
            String prefix = key.substring(0, index);
            String uri = MetadataFactory.BUILTIN_NAMESPACES.get(prefix);
            if (uri == null) {
                uri = this.getNamespaces().get(prefix);
            }
            if (uri != null) {
                key = '{' + uri + '}' + key.substring(index + 1, key.length());
            }
        }
        return key;
    }

    public Map<String, String> getNamespaces() {
        if (this.namespaces == null) {
            return Collections.emptyMap();
        }
        return this.namespaces;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Database other = (Database)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public Role getRole(String roleName) {
        return this.store.getRole(roleName);
    }

    public Collection<Role> getRoles() {
        return this.store.getRoles();
    }

    public void addRole(Role role) {
        Role r = this.store.getRole(role.getName());
        if (r != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60028, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60028, new Object[]{role.getName()}));
        }
        this.store.addRole(role);
    }

    public void removeRole(String roleName) {
        Role r = this.store.getRole(roleName);
        if (r == null) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60029, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60029, new Object[]{roleName}));
        }
        for (Grant g : this.store.getGrants()) {
            if (!g.getRole().equalsIgnoreCase(roleName)) continue;
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60030, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60030, new Object[]{roleName, g.getPermissions().iterator().next().getResourceName(), g.getPermissions().iterator().next().getResourceType().name()}));
        }
        this.store.removeRole(roleName);
    }

    public void addGrant(Grant grant) {
        this.store.addGrant(grant);
    }

    public void revokeGrant(Grant grant) {
        this.store.removeGrant(grant);
    }

    public Collection<Grant> getGrants() {
        return this.store.getGrants();
    }

    public static enum ResourceType {
        DATABASE,
        SCHEMA,
        TABLE,
        PROCEDURE,
        FUNCTION,
        COLUMN,
        SERVER,
        DATAWRAPPER,
        PARAMETER,
        ROLE,
        GRANT,
        LANGUAGE;

    }
}

