/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Database;

public class Grant
extends AbstractMetadataRecord {
    private static final long serialVersionUID = 3728259393244582775L;
    protected List<Permission> permissions = new ArrayList<Permission>();
    private String role;

    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public void addPermission(Permission permission) {
        this.permissions.add(permission);
    }

    void removePermission(Permission permission) {
        this.permissions.remove(permission);
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public static class Permission {
        private Database.ResourceType resourceType = null;
        private String resource = null;
        private String mask = null;
        private Integer maskOrder;
        private String condition = null;
        private Boolean isConstraint;
        private EnumSet<Privilege> privileges = EnumSet.noneOf(Privilege.class);
        private EnumSet<Privilege> revokePrivileges = EnumSet.noneOf(Privilege.class);

        public Database.ResourceType getResourceType() {
            if (this.resourceType == null) {
                return Database.ResourceType.DATABASE;
            }
            return this.resourceType;
        }

        public void setResourceType(Database.ResourceType on) {
            this.resourceType = on;
        }

        public String getResourceName() {
            return this.resource;
        }

        public void setResourceName(String resource) {
            this.resource = resource;
        }

        public String getMask() {
            return this.mask;
        }

        public void setMask(String mask) {
            this.mask = mask;
        }

        public Integer getMaskOrder() {
            return this.maskOrder;
        }

        public void setMaskOrder(Integer maskOrder) {
            this.maskOrder = maskOrder;
        }

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition, Boolean isConstraint) {
            this.condition = condition;
            this.isConstraint = isConstraint;
        }

        public Boolean isConditionAConstraint() {
            return this.isConstraint;
        }

        public EnumSet<Privilege> getPrivileges() {
            return this.privileges;
        }

        public EnumSet<Privilege> getRevokePrivileges() {
            return this.revokePrivileges;
        }

        public Boolean hasPrivilege(Privilege allow) {
            if (this.privileges.contains((Object)allow)) {
                return true;
            }
            if (this.revokePrivileges.contains((Object)allow)) {
                return false;
            }
            return null;
        }

        public void setPrivileges(List<Privilege> types) {
            if (types == null || types.isEmpty()) {
                return;
            }
            this.privileges = EnumSet.copyOf(types);
        }

        public void setRevokePrivileges(List<Privilege> types) {
            if (types == null || types.isEmpty()) {
                return;
            }
            this.revokePrivileges = EnumSet.copyOf(types);
        }

        public void appendPrivileges(EnumSet<Privilege> types) {
            if (types == null || types.isEmpty()) {
                return;
            }
            for (Privilege a : types) {
                this.privileges.add(a);
                this.revokePrivileges.remove((Object)a);
            }
        }

        public void removePrivileges(EnumSet<Privilege> types) {
            if (types == null || types.isEmpty()) {
                return;
            }
            for (Privilege a : types) {
                if (this.privileges.remove((Object)a)) continue;
                this.revokePrivileges.add(a);
            }
        }

        private void setAllows(Boolean allow, Privilege privilege) {
            if (allow != null) {
                if (allow.booleanValue()) {
                    this.revokePrivileges.remove((Object)privilege);
                    this.privileges.add(privilege);
                } else if (!this.privileges.remove((Object)privilege)) {
                    this.revokePrivileges.add(privilege);
                }
            }
        }

        public void setAllowSelect(Boolean allow) {
            this.setAllows(allow, Privilege.SELECT);
        }

        public void setAllowAlter(Boolean allow) {
            this.setAllows(allow, Privilege.ALTER);
        }

        public void setAllowInsert(Boolean allow) {
            this.setAllows(allow, Privilege.INSERT);
        }

        public void setAllowDelete(Boolean allow) {
            this.setAllows(allow, Privilege.DELETE);
        }

        public void setAllowExecute(Boolean allow) {
            this.setAllows(allow, Privilege.EXECUTE);
        }

        public void setAllowUpdate(Boolean allow) {
            this.setAllows(allow, Privilege.UPDATE);
        }

        public void setAllowDrop(Boolean allow) {
            this.setAllows(allow, Privilege.DROP);
        }

        public void setAllowUsage(Boolean allow) {
            this.setAllows(allow, Privilege.USAGE);
        }

        public void setAllowAllPrivileges(Boolean allow) {
            this.setAllows(allow, Privilege.ALL_PRIVILEGES);
        }

        public void setAllowTemporyTables(Boolean allow) {
            this.setAllows(allow, Privilege.TEMPORARY_TABLE);
        }

        public boolean resourceMatches(Permission other) {
            if (this.getResourceType() != other.getResourceType()) {
                return false;
            }
            if (this.resource == null && other.resource == null) {
                return true;
            }
            return this.resource != null && other.resource != null && this.resource.equalsIgnoreCase(other.resource);
        }

        public static enum Privilege {
            SELECT,
            INSERT,
            UPDATE,
            DELETE,
            EXECUTE,
            ALTER,
            DROP,
            USAGE,
            ALL_PRIVILEGES("ALL PRIVILEGES"),
            TEMPORARY_TABLE("TEMPORARY TABLE"),
            CREATE;

            private final String toString;

            private Privilege(String toString) {
                this.toString = toString;
            }

            private Privilege() {
                this.toString = this.name();
            }

            public String toString() {
                return this.toString;
            }
        }
    }
}

