/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SQLConstants {
    private static final Set<String> RESERVED_WORDS = SQLConstants.extractFieldNames(Reserved.class);
    private static final Set<String> NON_RESERVED_WORDS = SQLConstants.extractFieldNames(NonReserved.class);

    private static Set<String> extractFieldNames(Class<?> clazz) throws AssertionError {
        Field[] fields;
        HashSet<String> result = new HashSet<String>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.getType() != String.class) continue;
            try {
                if (result.add((String)field.get(null))) continue;
                throw new AssertionError((Object)("Duplicate value for " + field.getName()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static Set<String> getNonReservedWords() {
        return NON_RESERVED_WORDS;
    }

    public static Set<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    private SQLConstants() {
    }

    public static final boolean isReservedWord(String str) {
        if (str == null) {
            return false;
        }
        return RESERVED_WORDS.contains(str.toUpperCase());
    }

    public static interface Reserved {
        public static final String BIGDECIMAL = "BIGDECIMAL";
        public static final String BIGINTEGER = "BIGINTEGER";
        public static final String BREAK = "BREAK";
        public static final String BYTE = "BYTE";
        public static final String CRITERIA = "CRITERIA";
        public static final String ERROR = "ERROR";
        public static final String LIMIT = "LIMIT";
        public static final String LONG = "LONG";
        public static final String LOOP = "LOOP";
        public static final String MAKEDEP = "MAKEDEP";
        public static final String MAKEIND = "MAKEIND";
        public static final String MAKENOTDEP = "MAKENOTDEP";
        public static final String NOCACHE = "NOCACHE";
        public static final String STRING = "STRING";
        public static final String VIRTUAL = "VIRTUAL";
        public static final String WHILE = "WHILE";
        public static final String ADD = "ADD";
        public static final String ANY = "ANY";
        public static final String ALL = "ALL";
        public static final String ALLOCATE = "ALLOCATE";
        public static final String ALTER = "ALTER";
        public static final String AND = "AND";
        public static final String ARE = "ARE";
        public static final String ARRAY = "ARRAY";
        public static final String AS = "AS";
        public static final String ASC = "ASC";
        public static final String ASENSITIVE = "ASENSITIVE";
        public static final String ASYMETRIC = "ASYMETRIC";
        public static final String ATOMIC = "ATOMIC";
        public static final String AUTHORIZATION = "AUTHORIZATION";
        public static final String BEGIN = "BEGIN";
        public static final String BETWEEN = "BETWEEN";
        public static final String BIGINT = "BIGINT";
        public static final String BINARY = "BINARY";
        public static final String BLOB = "BLOB";
        public static final String BOTH = "BOTH";
        public static final String BY = "BY";
        public static final String CALL = "CALL";
        public static final String CALLED = "CALLED";
        public static final String CASE = "CASE";
        public static final String CAST = "CAST";
        public static final String CASCADED = "CASCADED";
        public static final String CHAR = "CHAR";
        public static final String CHARACTER = "CHARACTER";
        public static final String CHECK = "CHECK";
        public static final String CLOB = "CLOB";
        public static final String CLOSE = "CLOSE";
        public static final String COLLATE = "COLLATE";
        public static final String COLUMN = "COLUMN";
        public static final String COMMIT = "COMMIT";
        public static final String CONNECT = "CONNECT";
        public static final String CONVERT = "CONVERT";
        public static final String CONSTRAINT = "CONSTRAINT";
        public static final String CONTINUE = "CONTINUE";
        public static final String CORRESPONDING = "CORRESPONDING";
        public static final String CREATE = "CREATE";
        public static final String CROSS = "CROSS";
        public static final String CURRENT_DATE = "CURRENT_DATE";
        public static final String CURRENT_TIME = "CURRENT_TIME";
        public static final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
        public static final String CURRENT_USER = "CURRENT_USER";
        public static final String CURSOR = "CURSOR";
        public static final String CYCLE = "CYCLE";
        public static final String DATE = "DATE";
        public static final String DAY = "DAY";
        public static final String DEALLOCATE = "DEALLOCATE";
        public static final String DEC = "DEC";
        public static final String DECIMAL = "DECIMAL";
        public static final String DECLARE = "DECLARE";
        public static final String DEFAULT = "DEFAULT";
        public static final String DELETE = "DELETE";
        public static final String DEREF = "DEREF";
        public static final String DESC = "DESC";
        public static final String DESCRIBE = "DESCRIBE";
        public static final String DETERMINISTIC = "DETERMINISTIC";
        public static final String DISCONNECT = "DISCONNECT";
        public static final String DISTINCT = "DISTINCT";
        public static final String DOUBLE = "DOUBLE";
        public static final String DROP = "DROP";
        public static final String DYNAMIC = "DYNAMIC";
        public static final String EACH = "EACH";
        public static final String ELEMENT = "ELEMENT";
        public static final String ELSE = "ELSE";
        public static final String END = "END";
        public static final String ESCAPE = "ESCAPE";
        public static final String EXCEPT = "EXCEPT";
        public static final String EXEC = "EXEC";
        public static final String EXECUTE = "EXECUTE";
        public static final String EXISTS = "EXISTS";
        public static final String EXTERNAL = "EXTERNAL";
        public static final String FALSE = "FALSE";
        public static final String FETCH = "FETCH";
        public static final String FILTER = "FILTER";
        public static final String FLOAT = "FLOAT";
        public static final String FOR = "FOR";
        public static final String FOREIGN = "FOREIGN";
        public static final String FREE = "FREE";
        public static final String FROM = "FROM";
        public static final String FULL = "FULL";
        public static final String FUNCTION = "FUNCTION";
        public static final String GET = "GET";
        public static final String GLOBAL = "GLOBAL";
        public static final String GRANT = "GRANT";
        public static final String GROUP = "GROUP";
        public static final String GROUPING = "GROUPING";
        public static final String HAS = "HAS";
        public static final String HAVING = "HAVING";
        public static final String HOLD = "HOLD";
        public static final String HOUR = "HOUR";
        public static final String IDENTITY = "IDENTITY";
        public static final String INDICATOR = "INDICATOR";
        public static final String IF = "IF";
        public static final String IMMEDIATE = "IMMEDIATE";
        public static final String IN = "IN";
        public static final String INOUT = "INOUT";
        public static final String INNER = "INNER";
        public static final String INPUT = "INPUT";
        public static final String INSENSITIVE = "INSENSITIVE";
        public static final String INSERT = "INSERT";
        public static final String INTEGER = "INTEGER";
        public static final String INTERSECT = "INTERSECT";
        public static final String INTERVAL = "INTERVAL";
        public static final String INT = "INT";
        public static final String INTO = "INTO";
        public static final String IS = "IS";
        public static final String ISOLATION = "ISOLATION";
        public static final String JOIN = "JOIN";
        public static final String LANGUAGE = "LANGUAGE";
        public static final String LARGE = "LARGE";
        public static final String LATERAL = "LATERAL";
        public static final String LEADING = "LEADING";
        public static final String LEAVE = "LEAVE";
        public static final String LEFT = "LEFT";
        public static final String LIKE = "LIKE";
        public static final String LIKE_REGEX = "LIKE_REGEX";
        public static final String LOCAL = "LOCAL";
        public static final String LOCALTIME = "LOCALTIME";
        public static final String LOCALTIMESTAMP = "LOCALTIMESTAMP";
        public static final String MATCH = "MATCH";
        public static final String MEMBER = "MEMBER";
        public static final String MERGE = "MERGE";
        public static final String METHOD = "METHOD";
        public static final String MINUTE = "MINUTE";
        public static final String MODIFIES = "MODIFIES";
        public static final String MODULE = "MODULE";
        public static final String MONTH = "MONTH";
        public static final String MULTISET = "MULTISET";
        public static final String NATIONAL = "NATIONAL";
        public static final String NATURAL = "NATURAL";
        public static final String NCHAR = "NCHAR";
        public static final String NCLOB = "NCLOB";
        public static final String NEW = "NEW";
        public static final String NO = "NO";
        public static final String NONE = "NONE";
        public static final String NOT = "NOT";
        public static final String NULL = "NULL";
        public static final String NUMERIC = "NUMERIC";
        public static final String OBJECT = "OBJECT";
        public static final String OF = "OF";
        public static final String OFFSET = "OFFSET";
        public static final String OLD = "OLD";
        public static final String ON = "ON";
        public static final String ONLY = "ONLY";
        public static final String OPEN = "OPEN";
        public static final String OR = "OR";
        public static final String ORDER = "ORDER";
        public static final String OUT = "OUT";
        public static final String OUTER = "OUTER";
        public static final String OUTPUT = "OUTPUT";
        public static final String OPTION = "OPTION";
        public static final String OPTIONS = "OPTIONS";
        public static final String OVER = "OVER";
        public static final String OVERLAPS = "OVERLAPS";
        public static final String PARAMETER = "PARAMETER";
        public static final String PARTITION = "PARTITION";
        public static final String PRECISION = "PRECISION";
        public static final String PREPARE = "PREPARE";
        public static final String PRIMARY = "PRIMARY";
        public static final String PROCEDURE = "PROCEDURE";
        public static final String RANGE = "RANGE";
        public static final String READS = "READS";
        public static final String REAL = "REAL";
        public static final String RECURSIVE = "RECURSIVE";
        public static final String REFERENCES = "REFERENCES";
        public static final String REFERENCING = "REFERENCING";
        public static final String RELEASE = "RELEASE";
        public static final String RETURN = "RETURN";
        public static final String RETURNS = "RETURNS";
        public static final String REVOKE = "REVOKE";
        public static final String RIGHT = "RIGHT";
        public static final String ROLLBACK = "ROLLBACK";
        public static final String ROLLUP = "ROLLUP";
        public static final String ROW = "ROW";
        public static final String ROWS = "ROWS";
        public static final String SAVEPOINT = "SAVEPOINT";
        public static final String SCROLL = "SCROLL";
        public static final String SEARCH = "SEARCH";
        public static final String SECOND = "SECOND";
        public static final String SELECT = "SELECT";
        public static final String SENSITIVE = "SENSITIVE";
        public static final String SESSION_USER = "SESSION_USER";
        public static final String SET = "SET";
        public static final String SHORT = "SHORT";
        public static final String SIMILAR = "SIMILAR";
        public static final String SMALLINT = "SMALLINT";
        public static final String SOME = "SOME";
        public static final String SPECIFIC = "SPECIFIC";
        public static final String SPECIFICTYPE = "SPECIFICTYPE";
        public static final String SQL = "SQL";
        public static final String SQLEXCEPTION = "SQLEXCEPTION";
        public static final String SQLSTATE = "SQLSTATE";
        public static final String SQLWARNING = "SQLWARNING";
        public static final String SUBMULTILIST = "SUBMULTILIST";
        public static final String START = "START";
        public static final String STATIC = "STATIC";
        public static final String SYMETRIC = "SYMETRIC";
        public static final String SYSTEM = "SYSTEM";
        public static final String SYSTEM_USER = "SYSTEM_USER";
        public static final String TABLE = "TABLE";
        public static final String TEMPORARY = "TEMPORARY";
        public static final String THEN = "THEN";
        public static final String TIME = "TIME";
        public static final String TIMESTAMP = "TIMESTAMP";
        public static final String TIMEZONE_HOUR = "TIMEZONE_HOUR";
        public static final String TIMEZONE_MINUTE = "TIMEZONE_MINUTE";
        public static final String TO = "TO";
        public static final String TREAT = "TREAT";
        public static final String TRAILING = "TRAILING";
        public static final String TRANSLATE = "TRANSLATE";
        public static final String TRANSLATION = "TRANSLATION";
        public static final String TRIGGER = "TRIGGER";
        public static final String TRUE = "TRUE";
        public static final String UNION = "UNION";
        public static final String UNIQUE = "UNIQUE";
        public static final String UNKNOWN = "UNKNOWN";
        public static final String UPDATE = "UPDATE";
        public static final String USER = "USER";
        public static final String USING = "USING";
        public static final String VALUE = "VALUE";
        public static final String VALUES = "VALUES";
        public static final String VARCHAR = "VARCHAR";
        public static final String VARYING = "VARYING";
        public static final String WHEN = "WHEN";
        public static final String WHENEVER = "WHENEVER";
        public static final String WHERE = "WHERE";
        public static final String WINDOW = "WINDOW";
        public static final String WITH = "WITH";
        public static final String WITHIN = "WITHIN";
        public static final String WITHOUT = "WITHOUT";
        public static final String YEAR = "YEAR";
        public static final String ARRAY_AGG = "ARRAY_AGG";
        public static final String XML = "XML";
        public static final String XMLAGG = "XMLAGG";
        public static final String XMLATTRIBUTES = "XMLATTRIBUTES";
        public static final String XMLBINARY = "XMLBINARY";
        public static final String XMLCAST = "XMLCAST";
        public static final String XMLCOMMENT = "XMLCOMMENT";
        public static final String XMLCONCAT = "XMLCONCAT";
        public static final String XMLDOCUMENT = "XMLDOCUMENT";
        public static final String XMLELEMENT = "XMLELEMENT";
        public static final String XMLEXISTS = "XMLEXISTS";
        public static final String XMLFOREST = "XMLFOREST";
        public static final String XMLITERATE = "XMLITERATE";
        public static final String XMLNAMESPACES = "XMLNAMESPACES";
        public static final String XMLPARSE = "XMLPARSE";
        public static final String XMLPI = "XMLPI";
        public static final String XMLQUERY = "XMLQUERY";
        public static final String XMLSERIALIZE = "XMLSERIALIZE";
        public static final String XMLTABLE = "XMLTABLE";
        public static final String XMLTEXT = "XMLTEXT";
        public static final String XMLVALIDATE = "XMLVALIDATE";
        public static final String DATALINK = "DATALINK";
        public static final String DLNEWCOPY = "DLNEWCOPY";
        public static final String DLPREVIOUSCOPY = "DLPREVIOUSCOPY";
        public static final String DLURLCOMPLETE = "DLURLCOMPLETE";
        public static final String DLURLCOMPLETEWRITE = "DLURELCOMPLETEWRITE";
        public static final String DLURLCOMPLETEONLY = "DLURLCOMPLETEONLY";
        public static final String DLURLPATH = "DLURLPATH";
        public static final String DLURLPATHWRITE = "DLURLPATHWRITE";
        public static final String DLURLPATHONLY = "DLURLPATHONLY";
        public static final String DLURLSCHEME = "DLURLSCHEME";
        public static final String DLURLSERVER = "DLURLSEVER";
        public static final String DLVALUE = "DLVALUE";
        public static final String IMPORT = "IMPORT";
    }

    public static interface NonReserved {
        public static final String SQL_TSI_FRAC_SECOND = "SQL_TSI_FRAC_SECOND";
        public static final String SQL_TSI_SECOND = "SQL_TSI_SECOND";
        public static final String SQL_TSI_MINUTE = "SQL_TSI_MINUTE";
        public static final String SQL_TSI_HOUR = "SQL_TSI_HOUR";
        public static final String SQL_TSI_DAY = "SQL_TSI_DAY";
        public static final String SQL_TSI_WEEK = "SQL_TSI_WEEK";
        public static final String SQL_TSI_MONTH = "SQL_TSI_MONTH";
        public static final String SQL_TSI_QUARTER = "SQL_TSI_QUARTER";
        public static final String SQL_TSI_YEAR = "SQL_TSI_YEAR";
        public static final String TIMESTAMPADD = "TIMESTAMPADD";
        public static final String TIMESTAMPDIFF = "TIMESTAMPDIFF";
        public static final String MAX = "MAX";
        public static final String MIN = "MIN";
        public static final String COUNT = "COUNT";
        public static final String AVG = "AVG";
        public static final String SUM = "SUM";
        public static final String WIDTH = "WIDTH";
        public static final String DELIMITER = "DELIMITER";
        public static final String HEADER = "HEADER";
        public static final String QUOTE = "QUOTE";
        public static final String COLUMNS = "COLUMNS";
        public static final String SELECTOR = "SELECTOR";
        public static final String SKIP = "SKIP";
        public static final String ORDINALITY = "ORDINALITY";
        public static final String PASSING = "PASSING";
        public static final String PATH = "PATH";
        public static final String DOCUMENT = "DOCUMENT";
        public static final String CONTENT = "CONTENT";
        public static final String RETURNING = "RETURNING";
        public static final String SEQUENCE = "SEQUENCE";
        public static final String EMPTY = "EMPTY";
        public static final String QUERYSTRING = "QUERYSTRING";
        public static final String WELLFORMED = "WELLFORMED";
        public static final String EVERY = "EVERY";
        public static final String STDDEV_POP = "STDDEV_POP";
        public static final String STDDEV_SAMP = "STDDEV_SAMP";
        public static final String VAR_SAMP = "VAR_SAMP";
        public static final String VAR_POP = "VAR_POP";
        public static final String NULLS = "NULLS";
        public static final String FIRST = "FIRST";
        public static final String LAST = "LAST";
        public static final String KEY = "KEY";
        public static final String SERIAL = "SERIAL";
        public static final String ENCODING = "ENCODING";
        public static final String TEXTAGG = "TEXTAGG";
        public static final String ARRAYTABLE = "ARRAYTABLE";
        public static final String VIEW = "VIEW";
        public static final String INSTEAD = "INSTEAD";
        public static final String ENABLED = "ENABLED";
        public static final String DISABLED = "DISABLED";
        public static final String TRIM = "TRIM";
        public static final String RESULT = "RESULT";
        public static final String OBJECTTABLE = "OBJECTTABLE";
        public static final String VERSION = "VERSION";
        public static final String INCLUDING = "INCLUDING";
        public static final String EXCLUDING = "EXCLUDING";
        public static final String XMLDECLARATION = "XMLDECLARATION";
        public static final String VARIADIC = "VARIADIC";
        public static final String INDEX = "INDEX";
        public static final String EXCEPTION = "EXCEPTION";
        public static final String RAISE = "RAISE";
        public static final String CHAIN = "CHAIN";
        public static final String JSONOBJECT = "JSONOBJECT";
        public static final String AUTO_INCREMENT = "AUTO_INCREMENT";
        public static final String PRESERVE = "PRESERVE";
        public static final String GEOMETRY = "GEOMETRY";
    }

    public static interface Tokens {
        public static final String ALL_COLS = "*";
        public static final String SPACE = " ";
        public static final String COMMA = ",";
        public static final String DOT = ".";
        public static final String QUOTE = "'";
        public static final String EQ = "=";
        public static final String NE = "<>";
        public static final String LT = "<";
        public static final String GT = ">";
        public static final String LE = "<=";
        public static final String GE = ">=";
        public static final String LPAREN = "(";
        public static final String RPAREN = ")";
        public static final String LSBRACE = "[";
        public static final String RSBRACE = "]";
        public static final String COLON = ":";
        public static final String TICK = "'";
        public static final String SEMICOLON = ";";
        public static final String DOUBLE_AMP = "&&";
        public static final String PLUS = "+";
        public static final String MINUS = "-";
        public static final String SLASH = "/";
        public static final String CONCAT = "||";
    }
}

