/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language;

import java.util.List;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.visitor.LanguageObjectVisitor;

public class AggregateFunction
extends Function {
    public static final String COUNT = "COUNT";
    public static final String AVG = "AVG";
    public static final String SUM = "SUM";
    public static final String MIN = "MIN";
    public static final String MAX = "MAX";
    public static final String STDDEV_POP = "STDDEV_POP";
    public static final String STDDEV_SAMP = "STDDEV_SAMP";
    public static final String VAR_SAMP = "VAR_SAMP";
    public static final String VAR_POP = "VAR_POP";
    private String aggName;
    private boolean isDistinct;
    private Expression condition;

    public AggregateFunction(String aggName, boolean isDistinct, List<? extends Expression> params, Class<?> type) {
        super(aggName, params, type);
        this.aggName = aggName;
        this.isDistinct = isDistinct;
    }

    @Override
    public String getName() {
        return this.aggName;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public Expression getExpression() {
        if (this.getParameters().isEmpty()) {
            return null;
        }
        return this.getParameters().get(0);
    }

    @Override
    public void acceptVisitor(LanguageObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setName(String name) {
        this.aggName = name;
    }

    public void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }
}

